/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.sip;

import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.service.ConferenceService;
import com.coraltele.ppdrconference.sip.SIPBuddy;
import com.coraltele.ppdrconference.sip.SIPCall;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pjsip.pjsua2.Account;
import org.pjsip.pjsua2.AccountConfig;
import org.pjsip.pjsua2.BuddyConfig;
import org.pjsip.pjsua2.CallOpParam;
import org.pjsip.pjsua2.OnIncomingCallParam;
import org.pjsip.pjsua2.OnInstantMessageParam;
import org.pjsip.pjsua2.SipRxData;

public class PPDRAccount
extends Account {
    private static final Logger logger = LogManager.getLogger(PPDRAccount.class);
    public AccountConfig cfg;
    public BuddyConfig bcfg;
    public List<SIPBuddy> buddyList = Collections.synchronizedList(new ArrayList());
    public static List<SIPCall> _list = Collections.synchronizedList(new ArrayList());
    CallOpParam prm = new CallOpParam(true);
    public static SIPCall floorCall;

    PPDRAccount(AccountConfig acfg) {
        this.cfg = acfg;
    }

    public SIPBuddy addBuddy(BuddyConfig bc) {
        SIPBuddy myBuddy = new SIPBuddy(bc);
        try {
            myBuddy.create((Account)this, bc);
        }
        catch (Exception var5) {
            myBuddy.delete();
            myBuddy = null;
        }
        if (myBuddy != null) {
            this.buddyList.add(myBuddy);
            bc.setSubscribe(true);
            if (bc.getSubscribe()) {
                try {
                    myBuddy.subscribePresence(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return myBuddy;
    }

    public void delBuddy(SIPBuddy buddy) {
        this.buddyList.remove(buddy);
        buddy.delete();
    }

    public void delBuddy(int value) {
        SIPBuddy myBuddy = (SIPBuddy)this.buddyList.get(value);
        this.buddyList.remove(value);
        myBuddy.delete();
    }

    public void subscribeBuddy(String buddyNumber) {
        try {
            this.bcfg = new BuddyConfig();
            this.bcfg.setUri(buddyNumber);
            this.addBuddy(this.bcfg);
        }
        catch (Exception e) {
            logger.error("Exception subscribeBuddy  error:{}", (Throwable)e);
        }
    }

    public void onIncomingCall(OnIncomingCallParam var1) {
        logger.info("Incoming call received :{} ", (Object)var1.getCallId());
        SipRxData rxData = var1.getRdata();
        String message = rxData.getWholeMsg();
        String[] lines = message.split("\r\n");
        Boolean isDispatcher = false;
        Boolean hasBearer = false;
        Boolean hasSBCCallId = false;
        for (String line : lines) {
            String[] header = line.split(":");
            if (header[0].trim().equals("X-DISPATCHER") && header[1].trim().equals("true")) {
                isDispatcher = true;
                hasBearer = true;
                hasSBCCallId = true;
                break;
            }
            if (header[0].trim().equals("X-Bearer")) {
                hasBearer = true;
            }
            if (!header[0].trim().equals("X-coral_sbc_callid")) continue;
            hasSBCCallId = true;
        }
        SIPCall cMyCall = new SIPCall(this, var1.getCallId(), isDispatcher);
        cMyCall.updateDispatcherFlag(isDispatcher);
        try {
            if (Boolean.TRUE.equals(isDispatcher)) {
                logger.info("EventId={} Caller={} Callee={}", (Object)Constants.EVENT.DISPATCHER_CALL_RECEIVED, (Object)cMyCall.getInfo().getRemoteUri(), (Object)cMyCall.getInfo().getLocalUri());
            } else {
                logger.info("Incoming call received channel: {} callid: {} CallerParty : {} destNum: {}  ", (Object)cMyCall.getInfo().getId(), (Object)cMyCall.getInfo().getCallIdString(), (Object)cMyCall.getInfo().getRemoteUri(), (Object)cMyCall.getInfo().getLocalUri());
            }
        }
        catch (Exception e) {
            logger.error("Error in fetching incoming call data error:", (Throwable)e);
        }
        if (Constants.conferenceService.get() == null || !((ConferenceService)Constants.conferenceService.get()).isSyncDone) {
            CallOpParam prm = new CallOpParam();
            prm.setStatusCode(603);
            try {
                cMyCall.answer(prm);
            }
            catch (Exception e) {
                logger.error("COnference Service Not available", (Throwable)e);
            }
            return;
        }
        if (!hasBearer.booleanValue() || !hasSBCCallId.booleanValue()) {
            logger.info("Incoming call without Bearer or SBC Call ID, rejecting call");
            CallOpParam prm = new CallOpParam();
            prm.setStatusCode(503);
            try {
                cMyCall.answer(prm);
            }
            catch (Exception e) {
                logger.error("Service not available", (Throwable)e);
            }
            return;
        }
        CallOpParam prm = new CallOpParam();
        prm.setStatusCode(200);
        try {
            cMyCall.answer(prm);
            _list.add(cMyCall);
        }
        catch (Exception e) {
            logger.error("Error in answering call", (Throwable)e);
        }
    }

    public void onInstantMessage(OnInstantMessageParam var1) {
        logger.info("======== Incoming pager ======== ");
    }
}

