/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.helper.Constants;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TLSCommunicationService {
    private static final Logger logger = LogManager.getLogger(TLSCommunicationService.class);
    private Boolean isRunning = true;

    public void init() {
        logger.info("TLSCommunicationService starting");
        Security.addProvider((Provider)new BouncyCastleProvider());
        SSLContext sslContext = TLSCommunicationService.createSelfSignedTLSContext();
        if (sslContext == null) {
            logger.error("Error while creating self-signed TLS context. Unable to start TLS server");
            return;
        }
        SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
        try (SSLServerSocket serverSocket = (SSLServerSocket)factory.createServerSocket(Constants.RTCP_LISTEN_PORT);){
            logger.info("TLS 1.3 Server started on port {}", (Object)Constants.RTCP_LISTEN_PORT);
            while (Boolean.TRUE.equals(this.isRunning)) {
                SSLSocket sSLSocket = (SSLSocket)serverSocket.accept();
            }
        }
        catch (IOException e) {
            logger.error("Error while creating TLS server socket", (Throwable)e);
        }
    }

    private static SSLContext createSelfSignedTLSContext() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048);
            KeyPair keyPair = keyGen.generateKeyPair();
            long now = System.currentTimeMillis();
            Date notBefore = new Date(now);
            Date notAfter = new Date(now + 31536000000L);
            X500Name subject = new X500Name("CN=localhost, O=Test Org");
            BigInteger serial = BigInteger.valueOf(now);
            SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
            ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(keyPair.getPrivate());
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(subject, serial, notBefore, notAfter, subject, publicKeyInfo);
            X509CertificateHolder certHolder = certBuilder.build(signer);
            X509Certificate certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(null, null);
            ks.setKeyEntry("server", keyPair.getPrivate(), "eacc85df-aff4-4300-a0cc-97e04def57d1".toCharArray(), new Certificate[]{certificate});
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, "eacc85df-aff4-4300-a0cc-97e04def57d1".toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            logger.error("Error while creating self-signed TLS context", (Throwable)e);
            return null;
        }
    }
}

