/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.entity.ActiveChannel;
import com.coraltele.ppdrconference.entity.Channel;
import com.coraltele.ppdrconference.entity.Participant;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.model.ConferenceParticipant;
import com.coraltele.ppdrconference.model.ConferenceRoom;
import com.coraltele.ppdrconference.model.SIPEvent;
import com.coraltele.ppdrconference.repository.ActiveChannelRepository;
import com.coraltele.ppdrconference.repository.ChannelRepository;
import com.coraltele.ppdrconference.repository.ParticipantsRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlrpc.client.AsyncCallback;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionFactory;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.SendActionCallback;
import org.asteriskjava.manager.action.ConfbridgeKickAction;
import org.asteriskjava.manager.action.ConfbridgeMuteAction;
import org.asteriskjava.manager.action.ConfbridgeUnmuteAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.event.ConfbridgeJoinEvent;
import org.asteriskjava.manager.event.ConfbridgeLeaveEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SIPServer
implements ManagerEventListener {
    private static final Logger logger = LogManager.getLogger(SIPServer.class);
    private ManagerConnection managerConnection;
    private XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
    private XmlRpcClient client = new XmlRpcClient();
    @Autowired
    ParticipantsRepository participantsRepository;
    @Autowired
    ChannelRepository channelRepository;
    @Autowired
    ActiveChannelRepository activeChannelRepository;
    ExecutorService threadPool = Executors.newFixedThreadPool(5);

    public SIPServer() {
        try {
            this.config.setServerURL(new URL("http://127.0.0.1:8089/RPC2"));
            this.config.setBasicUserName("freeswitch");
            this.config.setBasicPassword("works");
            this.client.setConfig((XmlRpcClientConfig)this.config);
        }
        catch (MalformedURLException ex) {
            logger.error("Error in XmlRPCClient() {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    @PostConstruct
    private void init() {
        Constants.sipServer.set(this);
        if (Constants.CONFERENCE_PROVIDER == 3) {
            logger.info("Initiating Asterisk Manager Connection");
            ManagerConnectionFactory factory = new ManagerConnectionFactory("127.0.0.1", 5038, "ppdr", "conference");
            this.managerConnection = factory.createManagerConnection();
            try {
                this.managerConnection.login();
                this.managerConnection.addEventListener((ManagerEventListener)this);
            }
            catch (Exception e) {
                logger.error("Error in SIPServer init() {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public synchronized void executeCommand(String arg0, String arg1, String arg2) {
        try {
            if (arg0.isEmpty()) {
                arg0 = "freeswitch.api";
            }
            logger.info("arg1 : {}, command : {}", (Object)arg1, (Object)arg2);
            if (!arg1.isEmpty() && !arg2.isEmpty()) {
                if (this.client != null) {
                    String resp = (String)this.client.execute(arg0, new Object[]{arg1, arg2});
                    logger.info(resp);
                } else {
                    logger.error("Unable to create Xml Rpc Client");
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error in executeCommand() {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public synchronized void shiftConference(String participant, String conference) {
        logger.info("Shift Conference received from {} in {}", (Object)participant, (Object)conference);
        List channels = this.channelRepository.findByCallerIdNumber(participant);
        if (channels.isEmpty()) {
            logger.info("No Channel found for {}", (Object)participant);
        } else {
            logger.info("Channel found for {} : {}", (Object)participant, (Object)channels.size());
            Channel channel = (Channel)channels.get(0);
            this.executeCommandAndReturnStatus("", "uuid_transfer", String.format("%s conference:%s@default+flags{mute|nomoh} inline", channel.getUuid(), conference));
        }
    }

    public Map<String, Integer> getConferenceMembers(String conference) {
        HashMap<String, Integer> conferenceMembers = new HashMap<String, Integer>();
        String conferenceData = this.executeCommandAndReturnStatus("", "conference", conference + " json_list");
        logger.info("Fetching Conference Members for {}", (Object)conference);
        ObjectMapper mapper = new ObjectMapper();
        try {
            ConferenceRoom[] conferenceRooms;
            for (ConferenceRoom conferenceRoom : conferenceRooms = (ConferenceRoom[])mapper.readValue(conferenceData.getBytes(), ConferenceRoom[].class)) {
                if (!conferenceRoom.getConference_name().equals(conference)) continue;
                for (ConferenceParticipant conferenceParticipant : conferenceRoom.getMembers()) {
                    conferenceMembers.put(conferenceParticipant.getUuid(), conferenceParticipant.getId());
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to fetch conference data from conference server", (Throwable)e);
        }
        return conferenceMembers;
    }

    public synchronized void participantJoinConference(String conference, String participant) {
        if (!Constants.ENABLE_MUTE_CONTROL.booleanValue()) {
            return;
        }
        String conferenceData = this.executeCommandAndReturnStatus("", "conference", conference + " json_list");
        logger.info("Join Session received from {} in {}", (Object)participant, (Object)conference);
        ObjectMapper mapper = new ObjectMapper();
        Integer participantId = 0;
        try {
            ConferenceRoom[] conferenceRooms;
            for (ConferenceRoom conferenceRoom : conferenceRooms = (ConferenceRoom[])mapper.readValue(conferenceData.getBytes(), ConferenceRoom[].class)) {
                if (!conferenceRoom.getConference_name().equals(conference)) continue;
                for (ConferenceParticipant conferenceParticipant : conferenceRoom.getMembers()) {
                    if (!conferenceParticipant.getCaller_id_number().equals(participant) || participantId >= conferenceParticipant.getId()) continue;
                    participantId = conferenceParticipant.getId();
                }
                if (participantId <= 0) continue;
                Optional participantRecord = this.participantsRepository.findById((Object)participant);
                if (participantRecord.isPresent()) {
                    logger.info("Assigned Conference Id {} to {}", (Object)participant, (Object)participantId);
                    ((Participant)participantRecord.get()).setConferenceMemberId(participantId);
                    this.participantsRepository.save((Object)((Participant)participantRecord.get()));
                    logger.info("Processing stale connection of {} in {}", (Object)participant, (Object)conference);
                    for (ConferenceParticipant conferenceParticipant : conferenceRoom.getMembers()) {
                        if (!conferenceParticipant.getCaller_id_number().equals(participant) || conferenceParticipant.getId().equals(participantId)) continue;
                        logger.info("Removing stale connection of {} in {} by id {}", (Object)participant, (Object)conference, (Object)conferenceParticipant.getId());
                        this.executeCommandAsync("", "bgapi", "conference " + conference + " kick " + conferenceParticipant.getId());
                    }
                } else {
                    logger.info("Participant {} not found in Conference {}", (Object)participant, (Object)conference);
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("Unable to fetch conference data from conference server", (Throwable)e);
        }
        if (participantId.equals(0)) {
            logger.info("Unable to assign Conference Id {} in {}", (Object)participant, (Object)conference);
        }
    }

    public synchronized void muteParticipant(String conference, String participant) {
        try {
            if (!Constants.ENABLE_MUTE_CONTROL.booleanValue()) {
                return;
            }
            logger.info("Request received to mute {} in {}", (Object)participant, (Object)conference);
            List participants = this.participantsRepository.findByJoinConference(conference);
            for (Participant conferenceParticipant : participants) {
                if (!conferenceParticipant.getParticipantNo().equals(participant)) continue;
                logger.info("Muting Participant {} in Conference Id {} with id {}", (Object)participant, (Object)conference, (Object)conferenceParticipant.getConferenceMemberId());
                this.executeCommandAsync("", "bgapi", "conference " + conference + " mute " + conferenceParticipant.getConferenceMemberId());
                this.executeCommandAsync("", "bgapi", "conference " + conference + " vmute " + conferenceParticipant.getConferenceMemberId());
            }
        }
        catch (Exception e) {
            logger.error("Unable to fetch conference data from conference server", (Throwable)e);
        }
    }

    public synchronized void unMuteParticipant(String conference, String participant) {
        try {
            if (!Constants.ENABLE_MUTE_CONTROL.booleanValue()) {
                return;
            }
            logger.info("Request received to un-mute {} in {}", (Object)participant, (Object)conference);
            List participants = this.participantsRepository.findByJoinConference(conference);
            for (Participant conferenceParticipant : participants) {
                if (conferenceParticipant.getParticipantNo().equals(participant)) {
                    logger.info("Un Muting Participant {} in Conference Id {} with id {}", (Object)participant, (Object)conference, (Object)conferenceParticipant.getConferenceMemberId());
                    this.executeCommandAsync("", "bgapi", "conference " + conference + " unmute " + conferenceParticipant.getConferenceMemberId());
                    this.executeCommandAsync("", "bgapi", "conference " + conference + " unvmute " + conferenceParticipant.getConferenceMemberId());
                    continue;
                }
                logger.info("Muting Participant {} in Conference Id {} with id {}", (Object)participant, (Object)conference, (Object)conferenceParticipant.getConferenceMemberId());
                this.executeCommandAsync("", "bgapi", "conference " + conference + " mute " + conferenceParticipant.getConferenceMemberId());
                this.executeCommandAsync("", "bgapi", "conference " + conference + " vmute " + conferenceParticipant.getConferenceMemberId());
            }
        }
        catch (Exception e) {
            logger.error("Unable to fetch conference data from conference server", (Throwable)e);
        }
    }

    public synchronized String executeCommandAndReturnStatus(String arg0, String arg1, String arg2) {
        try {
            if (arg0.isEmpty()) {
                arg0 = "freeswitch.api";
            }
            logger.info("arg1 : {}, command : {}", (Object)arg1, (Object)arg2);
            if (!arg1.isEmpty() && !arg2.isEmpty()) {
                if (this.client != null) {
                    String resp = (String)this.client.execute(arg0, new Object[]{arg1, arg2});
                    logger.info(resp);
                    return resp;
                }
                logger.error("Unable to create Xml Rpc Client");
            }
        }
        catch (Exception ex) {
            logger.error("Error in executeCommand() {}", (Object)ex.getMessage(), (Object)ex);
        }
        return "";
    }

    public synchronized void executeCommandAsync(String arg0, String arg1, String arg2) {
        try {
            if (arg0.isEmpty()) {
                arg0 = "freeswitch.api";
            }
            logger.info("arg1 : {}, command : {}", (Object)arg1, (Object)arg2);
            if (!arg1.isEmpty() && !arg2.isEmpty()) {
                if (this.client != null) {
                    this.client.executeAsync(arg0, new Object[]{arg1, arg2}, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                } else {
                    logger.error("Unable to create Xml Rpc Client");
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error in executeCommand() {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void sendActionAsync(ManagerAction action) {
        try {
            this.managerConnection.sendAction(action, (SendActionCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            logger.error("Error sending AMI action: {}", (Object)action.getAction(), (Object)e);
        }
    }

    public static void makeCallBackCall(String command) {
        try {
            logger.info("callback : Executing command : {}", (Object)command);
            try {
                Object[] finalcommand = SIPServer.readFullCommand((String)command);
                logger.info("callback : cmd : " + Arrays.toString(finalcommand));
                Process p = Runtime.getRuntime().exec((String[])finalcommand);
                p.waitFor();
            }
            catch (InterruptedException ie) {
                logger.error("callback : Error in makeCallBackCall(); Error {}", (Object)ie.getMessage());
            }
            catch (Exception ii) {
                logger.error("callback : Error in makeCallBackCall(); Error {}", (Object)ii.getMessage());
            }
        }
        catch (Exception e) {
            logger.error("callback : Exception at makeCallBackCall() : {}", (Object)e.getMessage());
        }
    }

    public static String[] readFullCommand(String cmd) {
        String[] cmd1 = new String[]{"/bin/sh", "-c", cmd};
        return cmd1;
    }

    public void onManagerEvent(ManagerEvent event) {
        logger.debug("Received ManagerEvent: {}", (Object)event);
        SIPEvent sipEvent = new SIPEvent();
        if (event instanceof ConfbridgeJoinEvent) {
            ConfbridgeJoinEvent e = (ConfbridgeJoinEvent)event;
            logger.info("ConfbridgeJoinEvent received for callerId: {}, channel: {}", (Object)e.getCallerIdNum(), (Object)e.getChannel());
            sipEvent.setEventName("ConfbridgeJoinEvent");
            sipEvent.setCallerId(e.getCallerIdNum());
            sipEvent.setChannelId(e.getChannel());
            this.threadPool.submit(() -> this.handleConferenceJoin(sipEvent));
        } else if (event instanceof ConfbridgeLeaveEvent) {
            ConfbridgeLeaveEvent e = (ConfbridgeLeaveEvent)event;
            logger.info("ConfbridgeLeaveEvent received for callerId: {}, channel: {}", (Object)e.getCallerIdNum(), (Object)e.getChannel());
            sipEvent.setEventName("ConfbridgeLeaveEvent");
            sipEvent.setCallerId(e.getCallerIdNum());
            sipEvent.setChannelId(e.getChannel());
            this.threadPool.submit(() -> this.handleConferenceLeft(sipEvent));
        } else {
            logger.info("Unhandled event type: {}", (Object)event.getClass().getSimpleName());
        }
    }

    private void handleConferenceJoin(SIPEvent event) {
        Optional participant = this.participantsRepository.findByParticipantNo(event.getCallerId());
        participant.ifPresent(p -> {
            logger.info("Participant joined voice session : {} {} {}", (Object)p.getParticipantNo(), (Object)p.getJoinConference(), (Object)event.getChannelId());
            p.setChannelId(event.getChannelId());
            this.participantsRepository.save(p);
            this.kickOldDuplicates(p.getJoinConference(), p.getParticipantNo(), p.getChannelId());
            ActiveChannel activeChannel = new ActiveChannel();
            activeChannel.setChannelId(p.getChannelId());
            activeChannel.setParticipantNo(p.getParticipantNo());
            activeChannel.setConferenceNo(p.getJoinConference());
            this.activeChannelRepository.save((Object)activeChannel);
            this.sendActionAsync((ManagerAction)new ConfbridgeMuteAction(p.getJoinConference(), p.getChannelId()));
        });
    }

    private void handleConferenceLeft(SIPEvent event) {
        String leftChannelId = event.getChannelId();
        Optional participant = this.participantsRepository.findByParticipantNo(event.getCallerId());
        participant.ifPresent(p -> {
            String channelId = p.getChannelId();
            if (StringUtils.hasText((String)leftChannelId) && StringUtils.hasText((String)channelId) && channelId.equals(leftChannelId)) {
                logger.info("Participant left voice session : {} {} {} {}", (Object)p.getParticipantNo(), (Object)p.getJoinConference(), (Object)channelId, (Object)leftChannelId);
                p.setChannelId("");
                this.participantsRepository.save(p);
                this.activeChannelRepository.deleteById((Object)channelId);
            } else {
                logger.info("Participant left voice session (duplicate) : {} {} {} {}", (Object)p.getParticipantNo(), (Object)p.getJoinConference(), (Object)channelId, (Object)leftChannelId);
                this.activeChannelRepository.deleteById((Object)channelId);
            }
        });
    }

    public void kickOldDuplicates(String conference, String participantId, String currentChannelId) {
        try {
            logger.info("Kicking old duplicates for conference {} and participant {} with current Channel {}", (Object)conference, (Object)participantId, (Object)currentChannelId);
            List activeChannels = this.activeChannelRepository.findByConferenceNoAndParticipantNo(conference, participantId);
            for (ActiveChannel activeChannel : activeChannels) {
                if (activeChannel.getChannelId().equals(currentChannelId)) continue;
                try {
                    logger.info("Found duplicate channel {} for participant {} in conference {}", (Object)activeChannel.getChannelId(), (Object)participantId, (Object)conference);
                    this.activeChannelRepository.deleteById((Object)activeChannel.getChannelId());
                    this.sendActionAsync((ManagerAction)new ConfbridgeKickAction(conference, activeChannel.getChannelId()));
                }
                catch (Exception e) {
                    logger.error("Error kicking duplicate channel {} for participant {} in conference {}: {}", (Object)activeChannel.getChannelId(), (Object)participantId, (Object)conference, (Object)e.getMessage(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in kickOldDuplicates() for conference {}: {}", (Object)conference, (Object)e.getMessage(), (Object)e);
        }
    }

    public void sfuMuteAll(String groupId) {
        logger.info("Participant stopping voice session : {}", (Object)groupId);
        this.participantsRepository.findByJoinConference(groupId).forEach(p -> {
            logger.info("Participant stopping voice session : {} {} {}", (Object)p.getParticipantNo(), (Object)p.getJoinConference(), (Object)p.getChannelId());
            this.sendActionAsync((ManagerAction)new ConfbridgeMuteAction(groupId, p.getChannelId()));
        });
    }

    public void sfuMute(String groupId, String participantId) {
        this.participantsRepository.findByJoinConference(groupId).forEach(p -> {
            if (p.getParticipantNo().equals(participantId)) {
                logger.info("Participant stopping voice session : {} {} {}", (Object)p.getParticipantNo(), (Object)p.getJoinConference(), (Object)p.getChannelId());
                this.sendActionAsync((ManagerAction)new ConfbridgeMuteAction(groupId, p.getChannelId()));
            }
        });
    }

    public void sfuUnMute(String groupId, String participantId) {
        Optional participant = this.participantsRepository.findByParticipantNo(participantId);
        participant.ifPresent(p -> {
            logger.info("Participant starting voice session : {} {} {}", (Object)p.getParticipantNo(), (Object)p.getJoinConference(), (Object)p.getChannelId());
            this.sendActionAsync((ManagerAction)new ConfbridgeUnmuteAction(groupId, p.getChannelId()));
        });
    }

    public boolean isHavingActiveCall(String groupId, String participantId) {
        logger.info("Checking active call for participant {} in group {}", (Object)participantId, (Object)groupId);
        Optional participant = this.participantsRepository.findByParticipantNo(participantId);
        if (participant.isPresent()) {
            if (((Participant)participant.get()).getJoinConference().equals(groupId) && StringUtils.hasText((String)((Participant)participant.get()).getChannelId())) {
                logger.info("Active call found for participant {} in group {}", (Object)participantId, (Object)groupId);
                return true;
            }
            logger.info("No active call found for participant {} in group {}", (Object)participantId, (Object)groupId);
        } else {
            logger.warn("Participant {} not found in group {}", (Object)participantId, (Object)groupId);
        }
        return false;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

