/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.entity.Conference;
import com.coraltele.ppdrconference.entity.Participant;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.helper.EnqueueTask;
import com.coraltele.ppdrconference.mcx.MCXRTCP;
import com.coraltele.ppdrconference.model.AssignFloorStatus;
import com.coraltele.ppdrconference.model.PTTData;
import com.coraltele.ppdrconference.model.RequestResponse;
import com.coraltele.ppdrconference.model.UserModel;
import com.coraltele.ppdrconference.model.VideoStreamStatus;
import com.coraltele.ppdrconference.ptt.PTTGroup;
import com.coraltele.ppdrconference.repository.ConferenceRepository;
import com.coraltele.ppdrconference.repository.ParticipantsRepository;
import com.coraltele.ppdrconference.service.CallStatusService;
import com.coraltele.ppdrconference.service.ChannelInfo;
import com.coraltele.ppdrconference.service.FloorControlService;
import com.coraltele.ppdrconference.service.PTTEventMonitorService;
import com.coraltele.ppdrconference.service.Telephony;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.DatagramPacket;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RTCPServerService {
    private static final Integer MAX_THREADS = 1;
    private static final Integer MAX_TASKS = 10;
    private ConcurrentLinkedQueue<EnqueueTask> taskQueue = new ConcurrentLinkedQueue();
    private final Lock lock = new ReentrantLock();
    private final Condition newTaskAvailable = this.lock.newCondition();
    private volatile boolean running = true;
    ExecutorService threadPool = Executors.newFixedThreadPool(MAX_THREADS);
    ExecutorService taskPool = Executors.newFixedThreadPool(MAX_TASKS);
    private static final Logger logger = LogManager.getLogger(RTCPServerService.class);
    private final ConcurrentHashMap<String, UserModel> users = new ConcurrentHashMap();
    private final Object updateControlLock = new Object();
    @Autowired
    FloorControlService floorControlService;
    @Autowired
    ParticipantsRepository participantsRepository;
    @Autowired
    ConferenceRepository conferenceRepository;
    @Autowired
    Telephony telephony;
    @Autowired
    PTTEventMonitorService pttEventMonitorService;
    @Autowired
    CallStatusService callStatusService;

    @PostConstruct
    public void init() {
        logger.debug("RTCP Server Service Started");
        Constants.rtcpServerService.set(this);
        List participants = this.participantsRepository.findAll();
        for (Participant participant : participants) {
            logger.info("EventId={} GroupId={} UserId={}", (Object)Constants.EVENT.USER_INIT_EVENT, (Object)participant.getJoinConference(), (Object)participant.getParticipantNo());
            UserModel currentUser = this.initUser(participant.getParticipantNo(), participant.getJoinConference(), participant.getConnectionInterface());
            currentUser.connectionDetails(participant.getConnectedIpAddress(), participant.getPort(), participant.getMode());
        }
        List conferences = this.conferenceRepository.findAll();
        for (Conference conference : conferences) {
            logger.info("EventId={} GroupId={} ControlWith={}", (Object)Constants.EVENT.GROUP_INIT_EVENT, (Object)conference.getConferenceNo(), (Object)conference.getControlWith());
            PTTGroup group = this.pttEventMonitorService.getGroup(conference.getConferenceNo(), Constants.DISCONNECT_DURATION);
            if (group == null) continue;
            logger.info("EventId={} GroupId={} ControlWith={}", (Object)Constants.EVENT.GROUP_INIT_EVENT, (Object)conference.getConferenceNo(), (Object)conference.getControlWith());
            group.recover(conference);
        }
    }

    @Scheduled(fixedRate=5000L)
    public void startHealthCheck() {
        logger.debug("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            threadsStarted = threadsStarted + 1;
            logger.debug("Starting Registration Monitoring");
            this.threadPool.execute(() -> this.executeQueuedTasks());
        }
        logger.debug("{} Threads started", (Object)threadsStarted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse shiftSessionRequestReceived(String userId, String conferenceId, String ipAddress, Integer portNumber, String mode, Integer connectionInterface) {
        RequestResponse returnValue;
        logger.info("EventId={} GroupId={} ParticipantId={} IPAddress={} Port={} Mode={}", (Object)Constants.EVENT.PROCESSING_SHIFT_SESSION, (Object)conferenceId, (Object)userId, (Object)ipAddress, (Object)portNumber, (Object)mode);
        try {
            String correlationId = UUID.randomUUID().toString();
            this.telephony.shiftConference(correlationId, conferenceId, userId, false);
            Optional participantOptional = this.participantsRepository.findByParticipantNo(userId);
            ThreadContext.put((String)"correlationId", (String)correlationId);
            logger.debug("Shift Session Request received for {} {}", (Object)conferenceId, (Object)userId);
            if (participantOptional.isPresent()) {
                returnValue = this.joinSessionRequestReceived(correlationId, userId, conferenceId, ((Participant)participantOptional.get()).getConnectedIpAddress(), ((Participant)participantOptional.get()).getPort(), "", connectionInterface);
            } else {
                returnValue = new RequestResponse();
                returnValue.setStatus(Integer.valueOf(-1));
            }
        }
        catch (Exception e) {
            returnValue = new RequestResponse();
            returnValue.setStatus(Integer.valueOf(-2));
            logger.error("Error in Thread Sleep", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePacketReceived(DatagramPacket packet, Integer connectionInterface) {
        block23: {
            try {
                String correlationId = UUID.randomUUID().toString();
                ThreadContext.put((String)"correlationId", (String)correlationId);
                logger.info("EventId={} IPAddress={} Port={}", (Object)Constants.EVENT.REQUEST_RECEIVED, (Object)packet.getAddress(), (Object)packet.getPort());
                byte[] packetData = packet.getData();
                boolean checkRtcp = (packetData[1] & 0xFF) == 204;
                int bytesRead = packet.getLength();
                if (bytesRead <= 0) break block23;
                if (checkRtcp) {
                    MCXRTCP mcxRTCP = new MCXRTCP(packetData);
                    byte[] appNameBytes = new byte[]{packetData[8], packetData[9], packetData[10], packetData[11]};
                    String appName = new String(appNameBytes);
                    mcxRTCP.getData();
                    String appName2 = mcxRTCP.mcpttData.getAppName();
                    logger.info("EventId={} APPName={} ISAlive={}", (Object)Constants.EVENT.APPLICATION_DECODED, (Object)appName2, (Object)appName2.equals("ALIV"));
                    if ("MCPT".equals(appName)) {
                        String[] userInfo = mcxRTCP.mcpttData.getUserID().split("@");
                        String userId = userInfo[0];
                        String conferenceId = userInfo[1];
                        if (mcxRTCP.mcpttData.getCommonHeader().getPacketType() == 0) {
                            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_AUDIO_FLOOR_REQUEST, (Object)conferenceId, (Object)userId);
                            this.floorControlService.updateParticipantConnectionDetails(correlationId, userId, packet.getAddress().toString().replace("/", ""), Integer.valueOf(packet.getPort()), conferenceId, "", connectionInterface);
                            this.floorControlRequestReceived(correlationId, userId, conferenceId);
                        } else if (mcxRTCP.mcpttData.getCommonHeader().getPacketType() == 4) {
                            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.REQUEST_FOR_AUDIO_FLOOR_RELEASE, (Object)conferenceId, (Object)userId);
                            this.floorReleaseRequestReceived(correlationId, userId, conferenceId);
                        }
                    } else if ("MCPC".equals(appName)) {
                        String[] userInfo = mcxRTCP.mcpttData.getMcpttInvitingStr().split("@");
                        String userId = userInfo[0];
                        String conferenceId = userInfo[1];
                        if (mcxRTCP.mcpttData.getCommonHeader().getPacketType() == 0) {
                            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.REQUEST_FOR_JOIN_SESSION, (Object)conferenceId, (Object)userId);
                            this.joinSessionRequestReceived(correlationId, userId, conferenceId, packet.getAddress().toString().replace("/", ""), Integer.valueOf(packet.getPort()), "", connectionInterface);
                        }
                    } else if ("ALIV".equals(appName2)) {
                        String[] userInfo = mcxRTCP.mcpttData.getCustomData().split("@");
                        String userId = userInfo[0];
                        String packetType = userInfo.length >= 2 ? userInfo[1] : "";
                        logger.info("EventId={} GroupId={} ParticipantId={} PacketType={} UserInfo={}", (Object)Constants.EVENT.REQUEST_FOR_HEARTBEAT, (Object)"HB", (Object)userId, (Object)packetType, (Object)mcxRTCP.mcpttData.getCustomData());
                        this.updateKeepAlive(correlationId, userId, packetType);
                    } else if ("MCV0".equals(appName)) {
                        String[] userInfo = mcxRTCP.mcpttData.getUserID().split("@");
                        String userId = userInfo[0];
                        String conferenceId = userInfo[1];
                        if (mcxRTCP.mcpttData.getCommonHeader().getPacketType() == 0) {
                            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.REQUEST_FOR_VIDEO_FLOOR_ACCESS, (Object)conferenceId, (Object)userId);
                            this.videoControlRequestReceived(correlationId, userId, conferenceId);
                        } else if (mcxRTCP.mcpttData.getCommonHeader().getPacketType() == 2) {
                            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.REQUEST_FOR_VIDEO_FLOOR_RELEASE, (Object)conferenceId, (Object)userId);
                            this.videoReleaseRequestReceived(correlationId, userId, conferenceId);
                        }
                    }
                    logger.debug("Received packet parsed");
                    break block23;
                }
                String packetDataString = new String(packetData);
                logger.debug("Received packet is not containing RTCP Header Fields {}", (Object)packetDataString);
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    PTTData pttData = (PTTData)objectMapper.readValue(packetDataString, PTTData.class);
                    if (!this.processPTTData(pttData, packet, connectionInterface, correlationId, "")) {
                        logger.error("Unknown packet received {}", (Object)packetDataString);
                    }
                }
                catch (Exception e) {
                    logger.error("Error in Thread Sleep", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("Error in Thread Sleep", (Throwable)e);
            }
            finally {
                ThreadContext.remove((String)"correlationId");
            }
        }
    }

    public boolean processPTTData(PTTData pttData, DatagramPacket packet, Integer connectionInterface, String correlationId, String mode) {
        String ipAddress = packet == null ? "" : packet.getAddress().toString().replace("/", "");
        Integer port = packet == null ? 0 : packet.getPort();
        UserModel currentUser = this.getUser(pttData.getUserName());
        Boolean joinSessionDone = false;
        if (currentUser == null) {
            this.joinSessionRequestReceived(correlationId, pttData.getUserName(), pttData.getActiveGroup(), ipAddress, port, mode, connectionInterface);
            joinSessionDone = true;
        } else if (!currentUser.checkConnectionDetails(ipAddress, port, "", connectionInterface)) {
            this.joinSessionRequestReceived(correlationId, pttData.getUserName(), pttData.getActiveGroup(), ipAddress, port, mode, connectionInterface);
            joinSessionDone = true;
        }
        if (pttData.getMessageType().equals("floor-request")) {
            if (Boolean.FALSE.equals(pttData.getGroupCallActive())) {
                this.callStatusService.dropConferenceChannelIfExists(pttData.getUserName());
            }
            this.floorControlRequestReceived(correlationId, pttData.getUserName(), pttData.getActiveGroup());
        } else if (pttData.getMessageType().equals("floor-release")) {
            this.floorReleaseRequestReceived(correlationId, pttData.getUserName(), pttData.getActiveGroup());
        } else if (pttData.getMessageType().equals("health-update")) {
            this.updateKeepAlive(correlationId, pttData.getUserName(), pttData.getMessageType());
        } else if (pttData.getMessageType().equals("join-session")) {
            if (Boolean.FALSE.equals(joinSessionDone)) {
                this.joinSessionRequestReceived(correlationId, pttData.getUserName(), pttData.getActiveGroup(), ipAddress, port, mode, connectionInterface);
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFloor(String userId, String conferenceId) {
        try {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_AUDIO_FLOOR_REQUEST, (Object)conferenceId, (Object)userId);
            String correlationId = UUID.randomUUID().toString();
            ThreadContext.put((String)"correlationId", (String)correlationId);
            this.floorControlRequestReceived(correlationId, userId, conferenceId);
        }
        catch (Exception e) {
            logger.error("Error in Thread Sleep", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestVidFloor(String userId, String conferenceId) {
        try {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_VIDEO_FLOOR_REQUEST, (Object)conferenceId, (Object)userId);
            String correlationId = UUID.randomUUID().toString();
            ThreadContext.put((String)"correlationId", (String)correlationId);
            this.videoControlRequestReceived(correlationId, userId, conferenceId);
        }
        catch (Exception e) {
            logger.error("Error in Thread Sleep", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse requestEnableVideoStream(String userId, String conferenceId) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Integer.valueOf(-1));
        returnValue.setMessage("Unable to process Video Floor request");
        try {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_VIDEO_STREAM_REQUEST, (Object)conferenceId, (Object)userId);
            String correlationId = UUID.randomUUID().toString();
            ThreadContext.put((String)"correlationId", (String)correlationId);
            RequestResponse requestResponse = this.videoStreamStartRequestReceived(correlationId, userId, conferenceId);
            return requestResponse;
        }
        catch (Exception e) {
            logger.error("Error in Thread Sleep", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFloor(String userId, String conferenceId) {
        try {
            String correlationId = UUID.randomUUID().toString();
            ThreadContext.put((String)"correlationId", (String)correlationId);
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_AUDIO_FLOOR_RELEASE, (Object)conferenceId, (Object)userId);
            this.floorReleaseRequestReceived(correlationId, userId, conferenceId);
        }
        catch (Exception e) {
            logger.error("Error in Thread Sleep", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinSessionAnalogue(String userId, String conferenceId) {
        try {
            String correlationId = UUID.randomUUID().toString();
            ThreadContext.put((String)"correlationId", (String)correlationId);
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_JOIN_SESSION_ANALOGUE, (Object)conferenceId, (Object)userId);
            this.joinSessionRequestReceived(correlationId, userId, conferenceId, "", Integer.valueOf(0), "tel", Integer.valueOf(3));
        }
        catch (Exception e) {
            logger.error("Error in Thread Sleep", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinSessionHTTP(String userId, String conferenceId, String clientIP) {
        try {
            String correlationId = UUID.randomUUID().toString();
            ThreadContext.put((String)"correlationId", (String)correlationId);
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_JOIN_SESSION_HTTP, (Object)conferenceId, (Object)userId);
            this.joinSessionRequestReceived(correlationId, userId, conferenceId, clientIP, Integer.valueOf(0), "http", Integer.valueOf(2));
        }
        catch (Exception e) {
            logger.error("Error in Thread Sleep", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinSessionWS(String userId, String conferenceId, String clientIP) {
        try {
            String correlationId = UUID.randomUUID().toString();
            ThreadContext.put((String)"correlationId", (String)correlationId);
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_JOIN_SESSION_HTTP, (Object)conferenceId, (Object)userId);
            this.joinSessionRequestReceived(correlationId, userId, conferenceId, clientIP, Integer.valueOf(0), "WS", Integer.valueOf(2));
        }
        catch (Exception e) {
            logger.error("Error in Thread Sleep", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
    }

    public void joinConference(String correlationId, String conferenceId, List<ChannelInfo> activeParticipants, String sessionId, String activeParticipant, String specificParticipant) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_INITIATE_CALL, (Object)conferenceId, (Object)activeParticipant);
        this.sendRequestToParticipantToJoinConference(correlationId, conferenceId, activeParticipants, sessionId, activeParticipant, specificParticipant);
    }

    public void leaveConference(String correlationId, String conferenceId, String sessionId) {
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.PROCESSING_DISCONNECT_CALL, (Object)conferenceId);
        this.sendRequestToParticipantToLeaveConference(correlationId, conferenceId, sessionId);
    }

    private void enqueueTask(String correlationId, Runnable task) {
        this.taskQueue.offer(new EnqueueTask(task, correlationId));
        this.lock.lock();
        try {
            this.newTaskAvailable.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void executeQueuedTasks() {
        this.lock.lock();
        while (this.running) {
            logger.debug("Waiting for task");
            this.lock.lock();
            try {
                while (this.taskQueue.isEmpty()) {
                    this.newTaskAvailable.await();
                }
                Boolean hasTask = true;
                while (Boolean.TRUE.equals(hasTask)) {
                    EnqueueTask task = (EnqueueTask)this.taskQueue.poll();
                    hasTask = task != null;
                    if (!Boolean.TRUE.equals(hasTask)) continue;
                    this.taskPool.submit(() -> this.executeTask(task));
                }
            }
            catch (InterruptedException e) {
                logger.error("Conference Service Thread Interrupted", (Throwable)e);
                this.lock.unlock();
                Thread.currentThread().interrupt();
                break;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void executeTask(EnqueueTask task) {
        ThreadContext.put((String)"correlationId", (String)task.correlationId);
        try {
            task.runnable.run();
        }
        catch (Exception e) {
            logger.error("Error executing task", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
    }

    private RequestResponse joinSessionRequestReceived(String correlationId, String userId, String conferenceId, String ipAddress, Integer portNumber, String mode, Integer connectionInterface) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("EventId={} GroupId={} ParticipantId={} IPAddress={} Port={} Mode={}", (Object)Constants.EVENT.ENQUEUE_JOIN_SESSION, (Object)conferenceId, (Object)userId, (Object)ipAddress, (Object)portNumber, (Object)mode);
        this.enqueueTask(correlationId, () -> {
            try {
                this.floorControlService.updateParticipantConnectionDetails(correlationId, userId, ipAddress, portNumber, conferenceId, mode, connectionInterface);
                this.floorControlService.updateKeepAlive(userId, "");
                UserModel currentUser = this.initUser(userId, conferenceId, connectionInterface);
                Participant participant = this.floorControlService.getParticipantDetail(userId);
                AtomicBoolean isStreamActive = new AtomicBoolean(false);
                this.conferenceRepository.findById((Object)conferenceId).ifPresent(conference -> {
                    if (StringUtils.hasText((String)conference.getControlWith())) {
                        logger.debug("Conference {} is already in progress", (Object)conferenceId);
                        this.telephony.shiftConference(correlationId, conferenceId, userId, false);
                    }
                    isStreamActive.set(StringUtils.hasText((String)conference.getVideoStreamControlWith()));
                });
                currentUser.joinSession(participant, Boolean.valueOf(isStreamActive.get()));
            }
            catch (Exception e) {
                logger.error("Error in Thread Sleep", (Throwable)e);
            }
        });
        return returnValue;
    }

    private RequestResponse updateKeepAlive(String correlationId, String userId, String packetType) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("EventId={} ParticipantId={} PacketType={}", (Object)Constants.EVENT.ENQUEUE_HEART_BEAT, (Object)userId, (Object)packetType);
        this.enqueueTask(correlationId, () -> {
            try {
                this.floorControlService.updateKeepAlive(userId, packetType);
                UserModel currentUser = this.getUser(userId);
                logger.debug("Keep Alive received for {}", (Object)userId);
                if (currentUser == null) {
                    logger.error("User not found for {}", (Object)userId);
                    return;
                }
                currentUser.healthUpdate();
            }
            catch (Exception e) {
                logger.error("Error in Thread Sleep", (Throwable)e);
            }
        });
        return returnValue;
    }

    private RequestResponse floorControlRequestReceived(String correlationId, String userId, String conferenceId) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.ENQUEUE_AUDIO_FLOOR_REQUEST, (Object)conferenceId, (Object)userId);
        this.enqueueTask(correlationId, () -> {
            try {
                AssignFloorStatus floorStatus = this.floorControlService.assignFloor(correlationId, userId, conferenceId, "audio");
                if (StringUtils.hasText((String)floorStatus.getRevokedFrom())) {
                    this.floorReleaseRequestReceived(correlationId, floorStatus.getRevokedFrom(), conferenceId);
                    floorStatus = this.floorControlService.assignFloor(correlationId, userId, conferenceId, "audio");
                }
                String user = userId + "@" + conferenceId;
                Participant participant = this.floorControlService.getParticipantDetail(userId);
                UserModel currentUser = this.getUser(userId);
                if (currentUser == null) {
                    logger.error("User not found for {}", (Object)userId);
                    return;
                }
                logger.debug("boolean value:{} {} {}", (Object)floorStatus.isAssigned(), (Object)conferenceId, (Object)userId);
                if (Boolean.TRUE.equals(floorStatus.isAssigned())) {
                    currentUser.grantFloor(Boolean.valueOf(false));
                    this.participantsRepository.findByJoinConference(participant.getJoinConference()).forEach(conferenceMember -> {
                        UserModel member;
                        if (!conferenceMember.getParticipantNo().equals(participant.getParticipantNo()) && (member = this.getUser(conferenceMember.getParticipantNo())) != null) {
                            member.updateFloorTaken(Boolean.valueOf(false), user, 1);
                        }
                    });
                } else {
                    currentUser.denyFloor(Boolean.valueOf(false), "");
                    String floorWith = floorStatus.getAssignedTo() + "@" + conferenceId;
                    currentUser.updateFloorTaken(Boolean.valueOf(false), floorWith, 0);
                }
            }
            catch (Exception e) {
                logger.error("Error in Thread Sleep", (Throwable)e);
            }
        });
        return returnValue;
    }

    private RequestResponse forceFloorRelease(String correlationId, String userId, String conferenceId) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.ENQUEUE_FORCE_FLOOR_RELEASE, (Object)conferenceId, (Object)userId);
        this.enqueueTask(correlationId, () -> {
            try {
                String user = userId + "@" + conferenceId;
                logger.debug("Initiating Force release {} {}", (Object)userId, (Object)conferenceId);
                this.floorControlService.releaseFloor(correlationId, userId, conferenceId);
                Participant participant = this.floorControlService.getParticipantDetail(userId);
                this.participantsRepository.findByJoinConference(participant.getJoinConference()).forEach(conferenceMember -> {
                    UserModel member = this.getUser(conferenceMember.getParticipantNo());
                    if (member != null) {
                        member.updateFloorIdle(user, 1);
                    } else {
                        logger.error("User not found for {}", (Object)conferenceMember.getParticipantNo());
                    }
                });
            }
            catch (Exception e) {
                logger.error("Error in Thread Sleep", (Throwable)e);
            }
        });
        return returnValue;
    }

    private RequestResponse floorReleaseRequestReceived(String correlationId, String userId, String conferenceId) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.ENQUEUE_AUDIO_FLOOR_RELEASE, (Object)conferenceId, (Object)userId);
        this.enqueueTask(correlationId, () -> {
            try {
                String user = userId + "@" + conferenceId;
                Boolean allowed = this.floorControlService.releaseFloor(correlationId, userId, conferenceId);
                Participant participant = this.floorControlService.getParticipantDetail(userId);
                UserModel currentUser = this.getUser(userId);
                if (currentUser == null) {
                    return;
                }
                if (Boolean.TRUE.equals(allowed)) {
                    currentUser.releaseFloor(Boolean.valueOf(false));
                    this.participantsRepository.findByJoinConference(participant.getJoinConference()).forEach(conferenceMember -> {
                        if (!conferenceMember.getParticipantNo().equals(participant.getParticipantNo())) {
                            UserModel member = this.getUser(conferenceMember.getParticipantNo());
                            if (member != null) {
                                member.updateFloorIdle(user, 1);
                            } else {
                                logger.error("User not found for {}", (Object)conferenceMember.getParticipantNo());
                            }
                        }
                    });
                } else {
                    currentUser.denyFloor(Boolean.valueOf(false), "releaseDeny@");
                }
            }
            catch (Exception e) {
                logger.error("Error in Thread Sleep", (Throwable)e);
            }
        });
        return returnValue;
    }

    private RequestResponse videoControlRequestReceived(String correlationId, String userId, String conferenceId) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.ENQUEUE_VIDEO_FLOOR_REQUEST, (Object)conferenceId, (Object)userId);
        this.enqueueTask(correlationId, () -> {
            try {
                Boolean allowed = this.floorControlService.assignFloor(correlationId, userId, conferenceId, "video").isAssigned();
                String user = userId + "@" + conferenceId;
                UserModel currentUser = this.getUser(userId);
                if (currentUser == null) {
                    logger.error("User not found for {}", (Object)userId);
                    return;
                }
                Participant participant = this.floorControlService.getParticipantDetail(userId);
                if (Boolean.TRUE.equals(allowed)) {
                    currentUser.grantFloor(Boolean.valueOf(true));
                } else {
                    currentUser.denyFloor(Boolean.valueOf(true), "");
                }
                if (Boolean.TRUE.equals(allowed)) {
                    logger.debug("boolean value:{} {} {}", (Object)allowed, (Object)participant.getJoinConference(), (Object)userId);
                    this.participantsRepository.findByJoinConference(participant.getJoinConference()).forEach(conferenceMember -> {
                        UserModel member = this.getUser(conferenceMember.getParticipantNo());
                        if (member != null) {
                            logger.debug("Sending message to Floor Taken Message  {}", (Object)conferenceMember.getParticipantNo());
                            member.updateFloorTaken(Boolean.valueOf(true), user, 1);
                        } else {
                            logger.error("User not found for {}", (Object)conferenceMember.getParticipantNo());
                        }
                    });
                }
            }
            catch (Exception e) {
                logger.error("Error in Thread Sleep", (Throwable)e);
            }
        });
        return returnValue;
    }

    private RequestResponse videoStreamStartRequestReceived(String correlationId, String userId, String conferenceId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_VIDEO_STREAM_START, (Object)conferenceId, (Object)userId);
        RequestResponse returnValue = this.floorControlService.updateParticipantVideoStreamStatus(correlationId, userId, conferenceId, Boolean.valueOf(true));
        return returnValue;
    }

    private RequestResponse videoStreamStopRequestReceived(String correlationId, String userId, String conferenceId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_VIDEO_STREAM_STOP, (Object)conferenceId, (Object)userId);
        RequestResponse returnValue = this.floorControlService.updateParticipantVideoStreamStatus(correlationId, userId, conferenceId, Boolean.valueOf(false));
        return returnValue;
    }

    private RequestResponse videoReleaseRequestReceived(String correlationId, String userId, String conferenceId) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.ENQUEUE_VIDEO_FLOOR_RELEASE, (Object)conferenceId, (Object)userId);
        this.enqueueTask(correlationId, () -> {
            try {
                String user = userId + "@" + conferenceId;
                Boolean allowed = this.floorControlService.releaseFloor(correlationId, userId, conferenceId);
                UserModel currentUser = this.getUser(userId);
                if (currentUser == null) {
                    logger.error("User not found for {}", (Object)userId);
                    return;
                }
                Participant participant = this.floorControlService.getParticipantDetail(userId);
                if (Boolean.TRUE.equals(allowed)) {
                    currentUser.releaseFloor(Boolean.valueOf(true));
                    this.participantsRepository.findByJoinConference(participant.getJoinConference()).forEach(conferenceMember -> {
                        if (!conferenceMember.getParticipantNo().equals(participant.getParticipantNo())) {
                            UserModel member = this.getUser(conferenceMember.getParticipantNo());
                            if (member != null) {
                                member.updateFloorIdle(user, 1);
                            } else {
                                logger.error("User not found for {}", (Object)conferenceMember.getParticipantNo());
                            }
                        }
                    });
                } else {
                    currentUser.denyFloor(Boolean.valueOf(false), "releaseDeny@");
                }
            }
            catch (Exception e) {
                logger.error("Error in Thread Sleep", (Throwable)e);
            }
        });
        return returnValue;
    }

    public void sendNotificationToUserToJoinConference(String correlationId, String sessionId, String userId) {
        this.enqueueTask(correlationId, () -> {
            try {
                UserModel currentUser = this.getUser(userId);
                if (currentUser == null) {
                    logger.error("User not found for {}", (Object)userId);
                    return;
                }
                currentUser.joinConference(sessionId, userId);
            }
            catch (Exception e) {
                logger.error("Error on sendNotificationToUserToJoinConference for corelationId: {} for user: {} ", (Object)correlationId, (Object)userId, (Object)e);
            }
        });
    }

    private void sendRequestToParticipantToJoinConference(String corelationId, String conferenceId, List<ChannelInfo> activeParticipants, String sessionId, String activeParticipant, String specificParticipant) {
        logger.info("EventId={} GroupId={} ParticipantId={} SpecificParticipant={}", (Object)Constants.EVENT.ENQUEUE_INITIATE_CALL, (Object)conferenceId, (Object)activeParticipant, (Object)specificParticipant);
        Optional conference = this.conferenceRepository.findById((Object)conferenceId);
        if (conference.isPresent()) {
            if (((Conference)conference.get()).getAccessType().equals("video")) {
                logger.error("EventId={} GroupId={} ParticipantId={} Cause=VideoPTT", (Object)Constants.EVENT.ENQUEUE_INITIATE_CALL, (Object)conferenceId, (Object)activeParticipant);
                return;
            }
        } else {
            logger.error("EventId={} GroupId={} ParticipantId={} Cause=ConferenceNotFound", (Object)Constants.EVENT.ENQUEUE_INITIATE_CALL, (Object)conferenceId, (Object)activeParticipant);
            return;
        }
        this.enqueueTask(corelationId, () -> {
            try {
                List participants = this.participantsRepository.findByJoinConference(conferenceId);
                for (Participant participant : participants) {
                    if (!participant.getParticipantNo().equals(specificParticipant) && StringUtils.hasText((String)specificParticipant)) continue;
                    if (Boolean.FALSE.equals(this.isInCall(participant, activeParticipants, conferenceId))) {
                        logger.debug("Participant {} is not in call, send MCPC - Connect", (Object)participant.getParticipantNo());
                        UserModel currentUser = this.getUser(participant.getParticipantNo());
                        if (currentUser == null) {
                            logger.error("User not found for {}", (Object)participant.getParticipantNo());
                            continue;
                        }
                        currentUser.joinConference(sessionId, activeParticipant);
                        continue;
                    }
                    logger.debug("Participant {} is already in call", (Object)participant.getParticipantNo());
                }
            }
            catch (Exception e) {
                logger.error("Error on sendRequestToParticipantToJoinConference for corelationId: {} for participant: {} ", (Object)corelationId, (Object)activeParticipant, (Object)e);
            }
        });
    }

    private void sendRequestToParticipantToLeaveConference(String correlationId, String conferenceId, String sessionId) {
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.ENQUEUE_DISCONNECT_CALL, (Object)conferenceId);
        this.enqueueTask(correlationId, () -> {
            try {
                this.conferenceRepository.findById((Object)conferenceId).ifPresent(conference -> {
                    conference.reset();
                    this.conferenceRepository.save(conference);
                });
                this.floorControlService.releaseFloor(correlationId, conferenceId, conferenceId);
                List participants = this.participantsRepository.findByJoinConference(conferenceId);
                for (Participant participant : participants) {
                    logger.debug("Participant {} send MCPC - Disconnect", (Object)participant.getParticipantNo());
                    UserModel currentUser = this.getUser(participant.getParticipantNo());
                    if (currentUser != null) {
                        String user = participant.getParticipantNo() + "@" + conferenceId;
                        currentUser.leaveConference(sessionId, participant);
                        currentUser.updateFloorIdle(user, 1);
                        continue;
                    }
                    logger.error("User not found for {}", (Object)participant.getParticipantNo());
                }
            }
            catch (Exception e) {
                logger.error("Error on sendRequestToParticipantToLeaveConference for corelationId: {} ", (Object)correlationId, (Object)e);
            }
        });
    }

    private UserModel getUser(String participantNumber) {
        if (this.users.containsKey(participantNumber)) {
            return (UserModel)this.users.get(participantNumber);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserModel initUser(String participantNumber, String conferenceId, Integer connectionInterface) {
        if (this.users.containsKey(participantNumber)) {
            UserModel user = (UserModel)this.users.get(participantNumber);
            user.updateConference(conferenceId);
            if (connectionInterface == null) {
                connectionInterface = 0;
            }
            user.updateConnectionInterface(connectionInterface);
            return user;
        }
        Object object = this.updateControlLock;
        synchronized (object) {
            UserModel user = new UserModel(participantNumber);
            user.updateConference(conferenceId);
            this.users.put(participantNumber, user);
            return user;
        }
    }

    private Boolean isInCall(Participant participant, List<ChannelInfo> activeParticipants, String groupId) {
        if (Constants.CONFERENCE_PROVIDER == 1) {
            for (ChannelInfo channelInfo : activeParticipants) {
                if (!participant.getParticipantNo().equals(channelInfo.getRemotePartyNumber())) continue;
                logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PARTICIPANT_ALREADY_IN_CALL, (Object)groupId, (Object)participant.getParticipantNo());
                return true;
            }
        } else {
            return StringUtils.hasText((String)participant.getChannelId());
        }
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PARTICIPANT_NOT_IN_CALL, (Object)groupId, (Object)participant.getParticipantNo());
        return false;
    }

    public void broadcastNotification(String corelationId, String conferenceId, String[] activeParticipants, String sessionId, String activeParticipant, String type, String messageFile) {
        try {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_BROADCAST_VOICE_MESSAGE, (Object)conferenceId, (Object)activeParticipant);
            logger.debug("Broadcast notification initiating for corelationId:{} conferenceId: {} sessionID: {} activeParticipant: {} type: {} activeParticipants: {}", (Object)corelationId, (Object)conferenceId, (Object)sessionId, (Object)activeParticipant, (Object)type, (Object)Arrays.toString(activeParticipants));
            this.sendRequestToListenToBroadcast(corelationId, conferenceId, activeParticipants, sessionId, activeParticipant, type, messageFile);
        }
        catch (Exception e) {
            logger.error("Error on broadcastNotification for corelationId: {} for participant: {} ", (Object)corelationId, (Object)activeParticipant, (Object)e);
        }
    }

    public void broadcastTextMessage(String[] recipients, String messageSentBy, String type, String message) {
        String corelationId = UUID.randomUUID().toString();
        logger.info("EventId={} TextMessage={}", (Object)Constants.EVENT.PROCESSING_BROADCAST_TEXT_MESSAGE, (Object)message);
        try {
            logger.debug("Broadcast text message initiating for corelationId:{} messageSentBy: {} type: {} message: {} recipients: {}", (Object)corelationId, (Object)messageSentBy, (Object)type, (Object)message, (Object)Arrays.toString(recipients));
            this.sendTextMessage(corelationId, recipients, messageSentBy, type, message);
        }
        catch (Exception e) {
            logger.error("Error on broadcastTextMessage for corelationId: {} for participant: {} ", (Object)corelationId, (Object)recipients, (Object)e);
        }
    }

    private void sendRequestToListenToBroadcast(String corelationId, String broadcastDialNumber, String[] broadcastRecipients, String sessionId, String broadcastSourceNumber, String broadcastType, String messageFile) {
        List<String> broadcastParticipants = Arrays.asList(broadcastRecipients);
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.ENQUEUE_BROADCAST_VOICE_MESSAGE, (Object)broadcastDialNumber, (Object)broadcastSourceNumber);
        this.enqueueTask(corelationId, () -> {
            try {
                for (String broadcastParticipant : broadcastParticipants) {
                    Optional participant = this.participantsRepository.findByParticipantNo(broadcastParticipant);
                    if (!participant.isPresent()) continue;
                    logger.debug("sendRequestToListenToBroadcast on Participant {} is not in call, send MCPC - Connect", (Object)((Participant)participant.get()).getParticipantNo());
                    UserModel currentUser = this.getUser(((Participant)participant.get()).getParticipantNo());
                    if (currentUser != null) {
                        String user = ((Participant)participant.get()).getParticipantNo() + "@" + broadcastDialNumber;
                        currentUser.sendVoiceMessage(broadcastSourceNumber, broadcastType, user, sessionId, messageFile);
                        continue;
                    }
                    logger.error("User not found for {}", (Object)((Participant)participant.get()).getParticipantNo());
                }
            }
            catch (Exception e) {
                logger.error("Error on sendRequestToListenToBroadcast for corelationId: {} for participant: {} ", (Object)corelationId, (Object)broadcastSourceNumber, (Object)e);
            }
        });
    }

    private void sendTextMessage(String corelationId, String[] messageRecipients, String messageSentBy, String messageType, String message) {
        logger.info("EventId={} TextMessage={} Recipients={}", (Object)Constants.EVENT.ENQUEUE_BROADCAST_TEXT_MESSAGE, (Object)message, (Object)messageRecipients);
        List<String> broadcastParticipants = Arrays.asList(messageRecipients);
        this.enqueueTask(corelationId, () -> {
            try {
                for (String broadcastParticipant : broadcastParticipants) {
                    Optional participant = this.participantsRepository.findByParticipantNo(broadcastParticipant);
                    if (!participant.isPresent()) continue;
                    logger.debug("sendRequestToListenToBroadcast on Participant {} is not in call, send MCPC - Connect", (Object)((Participant)participant.get()).getParticipantNo());
                    UserModel currentUser = this.getUser(((Participant)participant.get()).getParticipantNo());
                    if (currentUser != null) {
                        currentUser.sendTextMessage(corelationId, messageSentBy, messageType, message, (Participant)participant.get());
                        continue;
                    }
                    logger.error("User not found for {}", (Object)((Participant)participant.get()).getParticipantNo());
                }
            }
            catch (Exception e) {
                logger.error("Error on sendRequestToListenToBroadcast for corelationId: {} for participant: {} ", (Object)corelationId, (Object)messageSentBy, (Object)e);
            }
        });
    }

    public void updateInCall(String corelationId, String participantNumber, String callGroup) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.ENQUEUE_CALL_ACTIVE, (Object)callGroup, (Object)participantNumber);
        this.enqueueTask(corelationId, () -> {
            try {
                UserModel user = this.getUser(participantNumber);
                if (user != null) {
                    user.updateState(Integer.valueOf(2));
                    this.participantsRepository.updateCallJoin(participantNumber, Long.valueOf(Instant.now().getEpochSecond()));
                } else {
                    logger.error("User not found for {}", (Object)participantNumber);
                }
            }
            catch (Exception e) {
                logger.error("Error on updateInCall for corelationId: {} for participant: {} ", (Object)corelationId, (Object)participantNumber, (Object)e);
            }
        });
    }

    public void callEnded(String corelationId, String participantNumber, String callGroup) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.ENQUEUE_CALL_DISCONNECTED, (Object)callGroup, (Object)participantNumber);
        this.enqueueTask(corelationId, () -> {
            try {
                UserModel user = this.getUser(participantNumber);
                if (user != null) {
                    user.updateState(Integer.valueOf(0));
                    this.participantsRepository.updateCallExit(participantNumber, Long.valueOf(Instant.now().getEpochSecond()));
                } else {
                    logger.error("User not found for {}", (Object)participantNumber);
                }
            }
            catch (Exception e) {
                logger.error("Error on callEnded for corelationId: {} for participant: {} ", (Object)corelationId, (Object)participantNumber, (Object)e);
            }
        });
    }

    public void sendFloorTaken(String conferenceId, String userId) {
        String corelationId = UUID.randomUUID().toString();
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.ENQUEUE_FLOOR_TAKEN_UPDATE, (Object)conferenceId, (Object)userId);
        this.enqueueTask(corelationId, () -> {
            try {
                String user = userId + "@" + conferenceId;
                this.participantsRepository.findByJoinConference(conferenceId).forEach(conferenceMember -> {
                    UserModel currentUser = this.getUser(conferenceMember.getParticipantNo());
                    if (currentUser != null) {
                        currentUser.updateFloorTaken(Boolean.valueOf(false), user, 0);
                    } else {
                        logger.error("User not found for {}", (Object)conferenceMember.getParticipantNo());
                    }
                });
            }
            catch (Exception e) {
                logger.error("Error on sendFloorTaken for corelationId: {} for participant: {} ", (Object)corelationId, (Object)userId, (Object)e);
            }
        });
    }

    public void sendFloorIdle(String conferenceId) {
        String corelationId = UUID.randomUUID().toString();
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.ENQUEUE_FLOOR_IDLE_UPDATE, (Object)conferenceId);
        this.enqueueTask(corelationId, () -> {
            try {
                this.participantsRepository.findByJoinConference(conferenceId).forEach(conferenceMember -> {
                    UserModel currentUser = this.getUser(conferenceMember.getParticipantNo());
                    if (currentUser != null) {
                        String user = conferenceMember.getParticipantNo() + "@" + conferenceId;
                        currentUser.updateFloorIdle(user, 1);
                    } else {
                        logger.error("User not found for {}", (Object)conferenceMember.getParticipantNo());
                    }
                });
            }
            catch (Exception e) {
                logger.error("Error on sendFloorIdle for corelationId: {} ", (Object)corelationId, (Object)e);
            }
        });
    }

    public void sendMissingParticipant(String conferenceId, String participantNo) {
        String corelationId = UUID.randomUUID().toString();
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.ENQUEUE_MISSING_PARTICIPANT_UPDATE, (Object)conferenceId);
        this.enqueueTask(corelationId, () -> {
            try {
                UserModel currentUser = this.getUser(participantNo);
                if (currentUser != null) {
                    String user = participantNo + "@" + conferenceId;
                    currentUser.updateFloorIdle(user, 9);
                } else {
                    logger.error("User not found for {}", (Object)participantNo);
                }
            }
            catch (Exception e) {
                logger.error("Error on sendFloorIdle for corelationId: {} ", (Object)corelationId, (Object)e);
            }
        });
    }

    public void updateGroupStreamStatus(VideoStreamStatus videoStreamStatus) {
        this.floorControlService.updateGroupStreamStatus(videoStreamStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse requestCloseVideoStream(String userId, String conferenceId) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Integer.valueOf(-1));
        returnValue.setMessage("Unable to process Video Floor request");
        try {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.PROCESSING_VIDEO_STREAM_REQUEST, (Object)conferenceId, (Object)userId);
            String correlationId = UUID.randomUUID().toString();
            ThreadContext.put((String)"correlationId", (String)correlationId);
            RequestResponse requestResponse = this.videoStreamStopRequestReceived(correlationId, userId, conferenceId);
            return requestResponse;
        }
        catch (Exception e) {
            logger.error("Error in Thread Sleep", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
        return returnValue;
    }

    public void joinSessionDynamic(String conferenceId, String clintIP) {
        List<String> userIds = Arrays.asList(((Conference)this.conferenceRepository.findById((Object)conferenceId).get()).getParticipants().split(","));
        for (String userId : userIds) {
            this.joinSessionWS(userId.trim(), conferenceId, "");
        }
    }
}

