/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.model.DataToSend;
import com.coraltele.ppdrconference.service.RTCPServerService;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class RTCPCommunicationService {
    private static final Logger logger = LogManager.getLogger(RTCPCommunicationService.class);
    public static AtomicReference<DatagramSocket> lanListeningSocket = new AtomicReference();
    public static AtomicReference<DatagramSocket> wanListeningSocket = new AtomicReference();
    private static final Integer MAX_THREADS = 1;
    private static final Integer MAX_TASKS = 1;
    private static final Integer MAX_READ_THREADS = 1;
    private static int BUFFER_SIZE = 1500;
    private ConcurrentLinkedQueue<DataToSend> taskQueue = new ConcurrentLinkedQueue();
    private final Lock lock = new ReentrantLock();
    private final Condition newTaskAvailable = this.lock.newCondition();
    private volatile boolean running = true;
    ExecutorService localReadThreadPool = Executors.newFixedThreadPool(MAX_READ_THREADS);
    ExecutorService publicReadThreadPool = Executors.newFixedThreadPool(MAX_READ_THREADS);
    ExecutorService threadPool = Executors.newFixedThreadPool(MAX_THREADS);
    ExecutorService taskPool = Executors.newFixedThreadPool(MAX_TASKS);
    @Autowired
    private RTCPServerService rtcpServerService;

    @PostConstruct
    public void init() {
        logger.debug("RTCP Communication Service Started");
        Constants.rtcpCommunicationService.set(this);
    }

    @Scheduled(fixedRate=5000L)
    public void startHealthCheck() {
        Integer n;
        logger.debug("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            n = threadsStarted;
            threadsStarted = threadsStarted + 1;
            logger.debug("Starting RTCP Communication Thread for sending packets");
            this.threadPool.execute(() -> this.executeQueuedTasks());
        }
        logger.debug("{} Threads started", (Object)threadsStarted);
        threadsStarted = 0;
        while (((ThreadPoolExecutor)this.localReadThreadPool).getActiveCount() < MAX_READ_THREADS) {
            n = threadsStarted;
            threadsStarted = threadsStarted + 1;
            logger.debug("Starting RTCP Communication Thread for receiving packets for LAN interface");
            this.localReadThreadPool.execute(() -> this.receivePacketsFromLAN());
        }
        logger.debug("LAN {} Read Threads started", (Object)threadsStarted);
        if (!Constants.WAN_RTCP_LISTEN_IP.equals("0.0.0.0")) {
            threadsStarted = 0;
            while (((ThreadPoolExecutor)this.publicReadThreadPool).getActiveCount() < MAX_READ_THREADS) {
                n = threadsStarted;
                threadsStarted = threadsStarted + 1;
                logger.debug("Starting RTCP Communication Thread for receiving packets for WAN interface");
                this.publicReadThreadPool.execute(() -> this.receivePacketsFromWAN());
            }
            logger.debug("WAN {} Read Threads started", (Object)threadsStarted);
        }
    }

    public void sendPacket(DatagramPacket packetToSend, Integer connectionInterface) {
        this.lock.lock();
        try {
            this.taskQueue.add(new DataToSend(packetToSend, connectionInterface));
            this.newTaskAvailable.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void receivePacketsFromLAN() {
        while (Boolean.TRUE.equals(this.running)) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            InetAddress sourceIp = null;
            if (!Constants.LISTENER_IP.equals("0.0.0.0")) {
                try {
                    sourceIp = InetAddress.getByName(Constants.LISTENER_IP);
                    logger.info("Starting RTCP Listener on LAN-IP {}", (Object)Constants.LISTENER_IP);
                }
                catch (UnknownHostException e) {
                    logger.error("Error while getting source LAN-IP {}", (Object)Constants.LISTENER_IP, (Object)e);
                }
            }
            try {
                DatagramSocket socket = sourceIp == null ? new DatagramSocket(Constants.RTCP_LISTEN_PORT) : new DatagramSocket(Constants.RTCP_LISTEN_PORT, sourceIp);
                try {
                    lanListeningSocket.set(socket);
                    while (Boolean.TRUE.equals(this.running)) {
                        byte[] receivedPacket = new byte[BUFFER_SIZE];
                        DatagramPacket packet = new DatagramPacket(receivedPacket, receivedPacket.length);
                        socket.receive(packet);
                        logger.debug("Packet Received {}", (Object)packet);
                        Thread clientThread = new Thread(() -> this.rtcpServerService.handlePacketReceived(packet, Integer.valueOf(0)));
                        clientThread.start();
                    }
                }
                finally {
                    if (socket == null) continue;
                    socket.close();
                }
            }
            catch (IOException e) {
                logger.error("Critical Error while running thread. Restarting the RTCP Listener ", (Throwable)e);
            }
        }
    }

    private void receivePacketsFromWAN() {
        while (Boolean.TRUE.equals(this.running)) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            InetAddress sourceIp = null;
            if (!Constants.WAN_RTCP_LISTEN_IP.equals("0.0.0.0")) {
                try {
                    sourceIp = InetAddress.getByName(Constants.WAN_RTCP_LISTEN_IP);
                    logger.info("Starting RTCP Listener on WAN-IP {}", (Object)Constants.WAN_RTCP_LISTEN_IP);
                }
                catch (UnknownHostException e) {
                    logger.error("Error while getting source WAN-IP {}", (Object)Constants.WAN_RTCP_LISTEN_IP, (Object)e);
                }
            }
            try {
                DatagramSocket socket = sourceIp == null ? new DatagramSocket(Constants.RTCP_LISTEN_PORT) : new DatagramSocket(Constants.RTCP_LISTEN_PORT, sourceIp);
                try {
                    wanListeningSocket.set(socket);
                    while (Boolean.TRUE.equals(this.running)) {
                        byte[] receivedPacket = new byte[BUFFER_SIZE];
                        DatagramPacket packet = new DatagramPacket(receivedPacket, receivedPacket.length);
                        socket.receive(packet);
                        logger.debug("Packet Received {}", (Object)packet);
                        Thread clientThread = new Thread(() -> this.rtcpServerService.handlePacketReceived(packet, Integer.valueOf(1)));
                        clientThread.start();
                    }
                }
                finally {
                    if (socket == null) continue;
                    socket.close();
                }
            }
            catch (IOException e) {
                logger.error("Critical Error while running thread. Restarting the RTCP Listener ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueuedTasks() {
        while (this.running) {
            logger.debug("Waiting for task");
            this.lock.lock();
            try {
                while (this.taskQueue.isEmpty()) {
                    this.newTaskAvailable.await();
                }
                Boolean hasTask = true;
                while (Boolean.TRUE.equals(hasTask)) {
                    DataToSend task = (DataToSend)this.taskQueue.poll();
                    hasTask = task != null;
                    if (!Boolean.TRUE.equals(hasTask)) continue;
                    try {
                        if (task.getConnectionInterface().equals(0)) {
                            ((DatagramSocket)lanListeningSocket.get()).send(task.getPacket());
                            continue;
                        }
                        ((DatagramSocket)wanListeningSocket.get()).send(task.getPacket());
                    }
                    catch (IOException e) {
                        logger.error("Error sending packet", (Throwable)e);
                    }
                }
            }
            catch (InterruptedException e) {
                logger.error("Participant Service Thread Interrupted", (Throwable)e);
                this.lock.unlock();
                Thread.currentThread().interrupt();
                break;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

