/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.helper.EnqueueTask;
import com.coraltele.ppdrconference.ptt.PTTExternalChannel;
import com.coraltele.ppdrconference.ptt.PTTExternalServerMuxType1;
import com.coraltele.ppdrconference.ptt.PTTExternalServerMuxType2;
import com.coraltele.ppdrconference.ptt.PTTGroup;
import com.coraltele.ppdrconference.ptt.PTTLocalMux;
import com.coraltele.ppdrconference.service.ChannelInfo;
import com.coraltele.ppdrconference.service.FloorControlHistoryService;
import com.coraltele.ppdrconference.service.SIPServer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class PTTEventMonitorService {
    private static final Integer MAX_THREADS = 1;
    private static final Integer MAX_TASKS = 10;
    private ConcurrentLinkedQueue<EnqueueTask> taskQueue = new ConcurrentLinkedQueue();
    private final Lock lock = new ReentrantLock();
    private final Condition newTaskAvailable = this.lock.newCondition();
    private volatile boolean running = true;
    private static final Logger logger = LogManager.getLogger(PTTEventMonitorService.class);
    private final ConcurrentHashMap<String, PTTGroup> eventGroups = new ConcurrentHashMap();
    private final Object updateLockObject = new Object();
    private final String instanceId = UUID.randomUUID().toString();
    ExecutorService threadPool = Executors.newFixedThreadPool(MAX_THREADS);
    ExecutorService taskPool = Executors.newFixedThreadPool(MAX_TASKS);
    @Autowired
    SIPServer sipServer;
    @Autowired
    FloorControlHistoryService floorControlHistoryService;

    @Scheduled(fixedRate=5000L)
    public void startHealthCheck() {
        logger.debug("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            threadsStarted = threadsStarted + 1;
            logger.debug("Starting Registration Monitoring");
            this.threadPool.execute(() -> this.executeQueuedTasks());
        }
        logger.debug("{} Threads started", (Object)threadsStarted);
    }

    public void triggerEvent(String correlationId, String groupId, int eventType, long timeoutPeriod, String participantId, boolean isPTTTaken) {
        logger.info("EventId={} GroupId={} ParticipantId={} PTTTaken={} EventType={}", (Object)Constants.EVENT.MONITOR_EVENT, (Object)groupId, (Object)participantId, (Object)isPTTTaken, (Object)eventType);
        this.enqueueTask(correlationId, () -> {
            logger.debug("{} Triggering event. Event Type {}", (Object)this.instanceId, (Object)eventType);
            if (!this.eventGroups.containsKey(groupId)) {
                PTTGroup group = this.addGroup(groupId, timeoutPeriod);
                this.handleEvent(correlationId, group, eventType, participantId, isPTTTaken);
                logger.debug("{} Event group with ID {} added successfully.", (Object)this.instanceId, (Object)groupId);
            } else {
                logger.debug("{} Event group with ID {} already exists.", (Object)this.instanceId, (Object)groupId);
                PTTGroup group = (PTTGroup)this.eventGroups.get(groupId);
                if (group != null) {
                    logger.debug("{} Event group with ID {} already exists. Triggering event. Event Type {}", (Object)this.instanceId, (Object)groupId, (Object)eventType);
                    this.handleEvent(correlationId, group, eventType, participantId, isPTTTaken);
                } else {
                    logger.error("{} Unexpected error. Event group with ID {} does not exist.", (Object)this.instanceId, (Object)groupId);
                }
            }
        });
    }

    public void addGroupParticipant(String correlationId, String groupId, long timeoutPeriod, String participantId, ChannelInfo channelInfo) {
        this.enqueueTask(correlationId, () -> {
            logger.info("EventId={} GroupId={} ParticipantId={} ChannelInfo={}", (Object)Constants.EVENT.MONITOR_ADD_PARTICIPANT, (Object)groupId, (Object)participantId, (Object)channelInfo);
            PTTGroup group = (PTTGroup)this.eventGroups.get(groupId);
            if (group == null) {
                logger.debug("{} Group {} does not exist. Adding participant {}", (Object)this.instanceId, (Object)groupId, (Object)participantId);
                group = this.addGroup(groupId, timeoutPeriod);
            }
            group.addParticipant(correlationId, participantId, channelInfo);
        });
    }

    public void updateGroupMedia(String correlationId, String groupId) {
        this.enqueueTask(correlationId, () -> {
            logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.GROUP_MEDIA_UPDATE, (Object)groupId);
            PTTGroup group = (PTTGroup)this.eventGroups.get(groupId);
            if (group == null) {
                logger.debug("{} Group {} does not exist. Ignoring Media Update", (Object)this.instanceId, (Object)groupId);
            }
            group.updateMediaTransmission(correlationId);
        });
    }

    public void removeGroupParticipant(String correlationId, String groupId, long timeoutPeriod, String participantId) {
        this.enqueueTask(correlationId, () -> {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.MONITOR_REMOVE_PARTICIPANT, (Object)groupId, (Object)participantId);
            PTTGroup group = (PTTGroup)this.eventGroups.get(groupId);
            if (group == null) {
                logger.debug("{} Group {} does not exist. Removing participant {}", (Object)this.instanceId, (Object)groupId, (Object)participantId);
                group = this.addGroup(groupId, timeoutPeriod);
            }
            group.removeParticipant(participantId);
        });
    }

    public PTTGroup getGroup(String groupId, long timeoutPeriod) {
        if (!this.eventGroups.containsKey(groupId)) {
            this.addGroup(groupId, timeoutPeriod);
        }
        return (PTTGroup)this.eventGroups.get(groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PTTGroup addGroup(String groupId, long timeoutPeriod) {
        Object object = this.updateLockObject;
        synchronized (object) {
            for (String iterable_element : this.eventGroups.keySet()) {
                logger.debug("{} Group {} - new Group {}", (Object)this.instanceId, (Object)iterable_element, (Object)groupId);
            }
            if (this.eventGroups.containsKey(groupId)) {
                logger.error("{} Group {} already exists", (Object)this.instanceId, (Object)groupId);
                return (PTTGroup)this.eventGroups.get(groupId);
            }
            logger.debug("{} Adding group {} Conference Mode {}", (Object)this.instanceId, (Object)groupId, (Object)Constants.CONFERENCE_PROVIDER);
            Object group = null;
            group = Constants.CONFERENCE_PROVIDER == 2 ? new PTTExternalServerMuxType1(this.floorControlHistoryService, this.sipServer, groupId, timeoutPeriod, Boolean.valueOf(false)) : (Constants.CONFERENCE_PROVIDER == 3 ? new PTTExternalServerMuxType2(this.floorControlHistoryService, this.sipServer, groupId, timeoutPeriod, Boolean.valueOf(false)) : (Constants.CONFERENCE_PROVIDER == 4 ? new PTTExternalChannel(this.floorControlHistoryService, this.sipServer, groupId, timeoutPeriod, Boolean.valueOf(false)) : new PTTLocalMux(this.floorControlHistoryService, this.sipServer, groupId, timeoutPeriod, Boolean.valueOf(false))));
            this.eventGroups.put(groupId, group);
            return group;
        }
    }

    private void handleEvent(String correlationId, PTTGroup newGroupId, int eventType, String participantId, boolean isPTTTaken) {
        logger.info("EventId={} GroupId={} ParticipantId={} EventType={} PTTTaken={}", (Object)Constants.EVENT.MONITOR_REMOVE_PARTICIPANT, (Object)newGroupId, (Object)participantId, (Object)eventType, (Object)isPTTTaken);
        switch (eventType) {
            case 0: {
                if (!isPTTTaken) {
                    newGroupId.onEventTriggered(Boolean.valueOf(false));
                }
                newGroupId.stopMediaTransmission(correlationId, participantId);
                break;
            }
            case 1: {
                newGroupId.onEventTriggered(Boolean.valueOf(true));
                newGroupId.startMediaTransmission(correlationId, participantId);
                break;
            }
            case 2: {
                this.eventGroups.values().forEach(oldGroup -> {
                    if (!oldGroup.getGroupId().equals(newGroupId.getGroupId())) {
                        logger.info("EventId={}, GroupId={} NewGroup={} ParticipantId={}", (Object)Constants.EVENT.SHIFT_CONFERENCE, (Object)oldGroup.getGroupId(), (Object)newGroupId.getGroupId(), (Object)participantId);
                        oldGroup.participantShifted(participantId);
                    }
                });
                newGroupId.checkSessions(correlationId, participantId);
                break;
            }
            case 3: {
                newGroupId.checkSessions(correlationId, participantId);
                break;
            }
            case 4: {
                newGroupId.checkFloor(participantId);
                break;
            }
            default: {
                logger.error("{} Invalid event type: {}", (Object)this.instanceId, (Object)eventType);
            }
        }
    }

    private void enqueueTask(String correlationId, Runnable task) {
        this.taskQueue.offer(new EnqueueTask(task, correlationId));
        this.lock.lock();
        try {
            this.newTaskAvailable.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void executeQueuedTasks() {
        this.lock.lock();
        while (this.running) {
            logger.debug("Waiting for task");
            this.lock.lock();
            try {
                while (this.taskQueue.isEmpty()) {
                    this.newTaskAvailable.await();
                }
                Boolean hasTask = true;
                while (Boolean.TRUE.equals(hasTask)) {
                    EnqueueTask task = (EnqueueTask)this.taskQueue.poll();
                    hasTask = task != null;
                    if (!Boolean.TRUE.equals(hasTask)) continue;
                    this.taskPool.submit(() -> this.executeTask(task));
                }
            }
            catch (InterruptedException e) {
                logger.error("Conference Service Thread Interrupted", (Throwable)e);
                this.lock.unlock();
                Thread.currentThread().interrupt();
                break;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void executeTask(EnqueueTask task) {
        ThreadContext.put((String)"correlationId", (String)task.correlationId);
        try {
            task.runnable.run();
        }
        catch (Exception e) {
            logger.error("Error executing task", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
    }
}

