/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.entity.Conference;
import com.coraltele.ppdrconference.entity.Participant;
import com.coraltele.ppdrconference.entity.VIPMaster;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.model.AssignFloorStatus;
import com.coraltele.ppdrconference.model.RequestResponse;
import com.coraltele.ppdrconference.model.VideoStreamStatus;
import com.coraltele.ppdrconference.ptt.PTTGroup;
import com.coraltele.ppdrconference.repository.ConferenceRepository;
import com.coraltele.ppdrconference.repository.ParticipantsRepository;
import com.coraltele.ppdrconference.repository.VIPMasterRepository;
import com.coraltele.ppdrconference.service.FloorControlHistoryService;
import com.coraltele.ppdrconference.service.PTTEventMonitorService;
import com.coraltele.ppdrconference.service.Telephony;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FloorControlService {
    @Autowired
    private ConferenceRepository conferenceRepository;
    @Autowired
    private ParticipantsRepository participantRepository;
    @Autowired
    private Telephony telephony;
    @Autowired
    private VIPMasterRepository vipMasterRepository;
    @Autowired
    PTTEventMonitorService pttEventMonitorService;
    @Autowired
    FloorControlHistoryService floorControlHistoryService;
    private static final Logger logger = LogManager.getLogger(FloorControlService.class);

    public Participant getParticipantDetail(String userId) {
        Participant returnValue = null;
        try {
            Optional participantValue = this.participantRepository.findById((Object)userId);
            if (participantValue.isPresent()) {
                returnValue = (Participant)participantValue.get();
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving participant details for {}", (Object)userId, (Object)e);
        }
        return returnValue;
    }

    public List<Conference> getConferenceList() {
        return this.conferenceRepository.findAll();
    }

    public List<Conference> getConferenceStatus(String conferenceNumber) {
        return this.conferenceRepository.findByConferenceNo(conferenceNumber);
    }

    public List<Participant> getParticipantList(String conferenceId) {
        return this.participantRepository.findByJoinConference(conferenceId);
    }

    public Conference getConferenceDetail(String conferenceId) {
        Conference returnValue = null;
        try {
            Optional conferenceValue = this.conferenceRepository.findById((Object)conferenceId);
            if (conferenceValue.isPresent()) {
                returnValue = (Conference)conferenceValue.get();
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving conference details for {}", (Object)conferenceId, (Object)e);
        }
        return returnValue;
    }

    public AssignFloorStatus assignFloor(String correlationId, String userId, String conferenceId, String accessType) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.FLOOR_ASSIGN_REQUEST, (Object)conferenceId, (Object)userId);
        String accessSessionId = UUID.randomUUID().toString();
        AssignFloorStatus returnValue = new AssignFloorStatus(false, "", "");
        PTTGroup group = this.pttEventMonitorService.getGroup(conferenceId, Constants.DISCONNECT_DURATION);
        if (group == null) {
            logger.error("{} => assignFloor PTTGroup {} not found", (Object)accessSessionId, (Object)conferenceId);
            return returnValue;
        }
        logger.debug("{} => assignFloor- Group Lock Requested {} Participants {}", (Object)accessSessionId, (Object)conferenceId, (Object)userId);
        returnValue = group.assignFloor(correlationId, userId, conferenceId, accessType);
        return returnValue;
    }

    public boolean releaseFloor(String correlationId, String userId, String conferenceId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.FLOOR_RELEASE_REQUEST, (Object)conferenceId, (Object)userId);
        boolean returnValue = false;
        Optional participantValue = this.participantRepository.findById((Object)userId);
        if (participantValue.isPresent() && StringUtils.hasText((String)((Participant)participantValue.get()).getJoinConference())) {
            logger.debug("releaseFloor- Participant {} is already in conference {} : Skipping request for {}", (Object)userId, (Object)((Participant)participantValue.get()).getJoinConference(), (Object)conferenceId);
            conferenceId = ((Participant)participantValue.get()).getJoinConference();
        }
        try {
            Optional conferenceValue = this.conferenceRepository.findById((Object)conferenceId);
            if (conferenceValue.isPresent() && ((Conference)conferenceValue.get()).getControlWith() != null && ((Conference)conferenceValue.get()).getControlWith().equals(userId)) {
                Long currentEpoch = Instant.now().getEpochSecond();
                ((Conference)conferenceValue.get()).setControlWith(null);
                ((Conference)conferenceValue.get()).setSessionId(null);
                ((Conference)conferenceValue.get()).setControlAccessLevel(Integer.valueOf(0));
                ((Conference)conferenceValue.get()).setAccessType("");
                ((Conference)conferenceValue.get()).setFloorTakenEpoch(Long.valueOf(0L));
                ((Conference)conferenceValue.get()).setFloorReleaseEpoch(currentEpoch);
                ((Conference)conferenceValue.get()).setFloorTakenHeartBeatEpoch(Long.valueOf(0L));
                ((Conference)conferenceValue.get()).setCallStartedEpoch(currentEpoch);
                this.conferenceRepository.save((Object)((Conference)conferenceValue.get()));
                this.telephony.muteParticipant(correlationId, conferenceId, userId, StringUtils.hasText((String)((Conference)conferenceValue.get()).getControlWith()));
                returnValue = true;
            } else {
                logger.debug("Unable to release floor for user id {} in conference {} ", (Object)userId, (Object)conferenceId);
            }
        }
        catch (Exception e) {
            logger.error("Error in Unable to release floor to {} for conference {}", (Object)userId, (Object)conferenceId, (Object)e);
        }
        return returnValue;
    }

    public boolean updateParticipantConnectionDetails(String correlationId, String userId, String ipAddress, Integer port, String conferenceId, String mode, Integer connectionInterface) {
        logger.info("EventId={} GroupId={} ParticipantId={} IPAddress={} Port={} Mode={}", (Object)Constants.EVENT.FLOOR_UPDATE_CONNECTION_DETAILS, (Object)conferenceId, (Object)userId, (Object)ipAddress, (Object)port, (Object)mode);
        boolean returnValue = false;
        Optional participantValue = this.participantRepository.findById((Object)userId);
        if (participantValue.isPresent()) {
            if (!((Participant)participantValue.get()).getMode().equals(mode)) {
                logger.info("Participant {} mode changed from {} to {}, removing the existing participant connection info", (Object)userId, (Object)((Participant)participantValue.get()).getMode(), (Object)mode);
            } else if (!StringUtils.hasText((String)mode)) {
                logger.info("RTCP Mode being used by {}, validating connection details", (Object)userId);
                if (((Participant)participantValue.get()).getConnectedIpAddress().equals(ipAddress) && ((Participant)participantValue.get()).getPort().equals(port) && ((Participant)participantValue.get()).getJoinConference().equals(conferenceId)) {
                    logger.debug("Participant {} already connected with ip {} and port {} to conference {}", (Object)userId, (Object)ipAddress, (Object)port, (Object)conferenceId);
                    this.participantRepository.findByConnectedIpAddressAndPortOrderByKeepAliveEpochDesc(ipAddress, port).forEach(participant -> {
                        if (!participant.getParticipantNo().equals(userId)) {
                            logger.debug("Removing participant {} with ip {} and port {} from conference {}", (Object)participant.getParticipantNo(), (Object)participant.getConnectedIpAddress(), (Object)participant.getPort(), (Object)participant.getJoinConference());
                            this.participantRepository.deleteById((Object)participant.getParticipantNo());
                        }
                    });
                } else {
                    logger.debug("Participant {} already connected with different ip {} and port {} to conference {}", (Object)userId, (Object)((Participant)participantValue.get()).getConnectedIpAddress(), (Object)((Participant)participantValue.get()).getPort(), (Object)((Participant)participantValue.get()).getJoinConference());
                    this.participantRepository.deleteById((Object)userId);
                }
            }
        }
        logger.debug("Participant {} joined conference {} from ip {}:{}", (Object)userId, (Object)conferenceId, (Object)ipAddress, (Object)port);
        try {
            Optional conference = this.conferenceRepository.findById((Object)conferenceId);
            if (!conference.isPresent()) {
                Conference dataToSave = new Conference();
                dataToSave.setConferenceNo(conferenceId);
                dataToSave.setConferenceStatus("");
                dataToSave.setControlWith(null);
                dataToSave.setControlAccessLevel(Integer.valueOf(0));
                dataToSave.setAccessType("");
                this.conferenceRepository.save((Object)dataToSave);
            }
            Optional vipMasterValue = this.vipMasterRepository.findById((Object)userId);
            Integer accessLevel = 0;
            if (vipMasterValue.isPresent() && StringUtils.hasText((String)((VIPMaster)vipMasterValue.get()).getRank())) {
                accessLevel = Integer.parseInt(((VIPMaster)vipMasterValue.get()).getRank());
            }
            if (participantValue.isPresent()) {
                ((Participant)participantValue.get()).setConnectedIpAddress(ipAddress);
                ((Participant)participantValue.get()).setPort(port);
                ((Participant)participantValue.get()).setJoinConference(conferenceId);
                ((Participant)participantValue.get()).setMode(mode);
                ((Participant)participantValue.get()).setAccessLevel(accessLevel);
                ((Participant)participantValue.get()).setConnectionInterface(connectionInterface);
                this.participantRepository.save((Object)((Participant)participantValue.get()));
                logger.debug("Participant {} joined conference {} with access level {}", (Object)userId, (Object)conferenceId, (Object)((Participant)participantValue.get()).getAccessLevel());
            } else {
                Participant dataToSave = new Participant();
                dataToSave.setParticipantNo(userId);
                dataToSave.setConnectedIpAddress(ipAddress);
                dataToSave.setPort(port);
                dataToSave.setJoinConference(conferenceId);
                dataToSave.setMode(mode);
                dataToSave.setAccessLevel(accessLevel);
                dataToSave.setConnectionInterface(connectionInterface);
                this.participantRepository.save((Object)dataToSave);
                logger.debug("Participant {} joined conference {} with access level {}", (Object)userId, (Object)conferenceId, (Object)dataToSave.getAccessLevel());
            }
            this.telephony.participantJoinConference(correlationId, conferenceId, userId);
        }
        catch (Exception e) {
            logger.error("Unable to save connection details of participant {} ", (Object)userId, (Object)e);
        }
        return returnValue;
    }

    public boolean updateKeepAlive(String userId, String packetType) {
        boolean returnValue = false;
        logger.info("EventId={} ParticipantId={}", (Object)Constants.EVENT.FLOOR_HEART_BEAT, (Object)userId);
        try {
            Optional participantValue = this.participantRepository.findById((Object)userId);
            if (participantValue.isPresent()) {
                ((Participant)participantValue.get()).setKeepAliveEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                this.participantRepository.save((Object)((Participant)participantValue.get()));
                if (packetType.equals("IHF")) {
                    logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.I_HAVE_FLOOR_RECEIVED, (Object)((Participant)participantValue.get()).getJoinConference(), (Object)userId);
                    this.telephony.haveTheFloorUpdate("", ((Participant)participantValue.get()).getJoinConference(), userId, true);
                }
                logger.debug("Send keep alive message to client: {} ", (Object)userId);
            }
        }
        catch (Exception e) {
            logger.error("Unable to Send keep alive message to client: {} ", (Object)userId, (Object)e);
        }
        return returnValue;
    }

    public Participant getParticipantFromIP(String clientIP) {
        List participants = this.participantRepository.findByConnectedIpAddressOrderByKeepAliveEpochDesc(clientIP);
        if (participants.isEmpty()) {
            return null;
        }
        return (Participant)participants.get(0);
    }

    public void updateGroupStreamStatus(VideoStreamStatus videoStreamStatus) {
        Boolean isStarted = videoStreamStatus.getStatus().equalsIgnoreCase("Started");
        Long currentEpoch = Instant.now().getEpochSecond();
        if (isStarted.booleanValue()) {
            String videoStreamSessionId = UUID.randomUUID().toString();
            this.conferenceRepository.updateGroupStreamStatus(videoStreamStatus.getConferenceNo(), videoStreamStatus.getVideoStreamBy(), videoStreamStatus.getStreamId(), videoStreamStatus.getStatus().equalsIgnoreCase("Stopped") ? "" : videoStreamStatus.getStatus(), currentEpoch, videoStreamSessionId);
            logger.info("EventId={} Received updateGroupStreamStatus: {} ", (Object)Constants.EVENT.API_UPDATE_GROUP_STREAM_STATUS, (Object)videoStreamStatus);
            Conference conference = this.getConferenceDetail(videoStreamStatus.getConferenceNo());
            this.floorControlHistoryService.startRecordingVideoAsync(conference, videoStreamSessionId);
        } else {
            Conference conference = this.getConferenceDetail(videoStreamStatus.getConferenceNo());
            String videoStreamControlWith = conference.getVideoStreamControlWith();
            this.floorControlHistoryService.generateFloorControlHistoryVideo(conference, currentEpoch);
            this.conferenceRepository.updateGroupStreamStatus(videoStreamStatus.getConferenceNo(), "", "", "", Long.valueOf(0L), "");
            PTTGroup group = this.pttEventMonitorService.getGroup(videoStreamStatus.getConferenceNo(), Constants.DISCONNECT_DURATION);
            if (group != null) {
                group.updateVideoStreamStatus("", videoStreamControlWith, videoStreamStatus.getConferenceNo(), Boolean.valueOf(false));
            }
            logger.info("EventId={} Received updateGroupStreamStatus: {} ", (Object)Constants.EVENT.API_UPDATE_GROUP_STREAM_STATUS, (Object)videoStreamStatus);
        }
    }

    public RequestResponse updateParticipantVideoStreamStatus(String correlationId, String userId, String conferenceId, Boolean controlStatus) {
        PTTGroup group = this.pttEventMonitorService.getGroup(conferenceId, Constants.DISCONNECT_DURATION);
        if (group == null) {
            RequestResponse returnValue = new RequestResponse();
            logger.error("{} => assignFloor PTTGroup {} not found", (Object)correlationId, (Object)conferenceId);
            returnValue.setStatus(Integer.valueOf(-2));
            returnValue.setMessage("PTT Group not found");
            return returnValue;
        }
        return group.updateVideoStreamStatus(correlationId, userId, conferenceId, controlStatus);
    }

    public Conference createConference(Conference conference) {
        conference.setSessionId(UUID.randomUUID().toString());
        Conference tempConf = (Conference)this.conferenceRepository.save((Object)conference);
        return tempConf;
    }

    public List<String> getParticipantListFromString(String participants) {
        if (participants == null || participants.trim().isEmpty()) {
            return List.of();
        }
        return Arrays.stream(participants.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }
}

