/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.model;

import com.coraltele.ppdrconference.entity.Participant;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.helper.MCXHelper;
import com.coraltele.ppdrconference.model.PTTData;
import com.coraltele.ppdrconference.model.RTCPPacket;
import com.coraltele.ppdrconference.service.CallStatusService;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserModel {
    private static final Logger logger = LogManager.getLogger(UserModel.class);
    private String participantId;
    private volatile Integer participantState;
    private volatile Integer participantMessageState;
    private volatile String conferenceId;
    private volatile String sessionId;
    private volatile Integer connectionPort;
    private volatile String connectedIpAddress;
    private volatile String connectedMode;
    private volatile Integer connectionInterface;
    private final Object updateControlLock = new Object();

    public UserModel(String participantId) {
        this.participantId = participantId;
        this.participantState = 0;
        this.participantMessageState = 0;
        this.conferenceId = "";
        this.sessionId = "";
        this.connectionPort = 0;
        this.connectedIpAddress = "";
        this.connectedMode = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionDetails(String connectedIpAddress, Integer connectionPort, String connectedMode) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} UserId={} ConnectedIPAddress={} ConnectionPort={} ConnectedMode={} ", (Object)Constants.EVENT.USER_INIT_EVENT, (Object)this.conferenceId, (Object)this.participantId, (Object)connectedIpAddress, (Object)connectionPort, (Object)connectedMode);
            this.connectedIpAddress = connectedIpAddress;
            this.connectionPort = connectionPort;
            this.connectedMode = connectedMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnectionDetails(String connectedIpAddress, Integer connectionPort, String connectedMode, Integer connectionInterface) {
        Object object = this.updateControlLock;
        synchronized (object) {
            return this.connectedIpAddress.equals(connectedIpAddress) && this.connectionPort.equals(connectionPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(Integer state) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} ParticipantId={} State={} SessionId={}", (Object)Constants.EVENT.USER_STATE_CHANGE, (Object)this.participantId, (Object)state, (Object)this.sessionId);
            this.participantState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConference(String conferenceId) {
        if (!this.conferenceId.equals(conferenceId)) {
            Object object = this.updateControlLock;
            synchronized (object) {
                this.participantState = 0;
                this.participantMessageState = 0;
                logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.USER_JOIN_GROUP, (Object)conferenceId, (Object)this.participantId);
                this.conferenceId = conferenceId;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectionInterface(Integer connectionInterface) {
        Object object = this.updateControlLock;
        synchronized (object) {
            this.participantState = 0;
            this.participantMessageState = 0;
            logger.info("EventId={} GroupId={} ParticipantId={} ConnectionInterface={}", (Object)Constants.EVENT.USER_CONNECTION_INTERFACE_CHANGE, (Object)this.conferenceId, (Object)this.participantId, (Object)connectionInterface);
            this.connectionInterface = connectionInterface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinConference(String sessionId, String activeParticipant) {
        Object object = this.updateControlLock;
        synchronized (object) {
            if (Constants.CONFERENCE_PROVIDER == 1) {
                String user = this.participantId + "@" + this.conferenceId;
                logger.info("EventId={} GroupId={} ParticipantId={} ActiveParticipant={}", (Object)Constants.EVENT.USER_INITIATE_GROUP_CALL, (Object)this.participantId, (Object)this.conferenceId, (Object)activeParticipant);
                if (sessionId.equals(this.sessionId) && (this.participantState == 1 || this.participantState == 2)) {
                    logger.error("EventId={} GroupId={} ParticipantId={} Cause={}", (Object)Constants.EVENT.USER_INITIATE_GROUP_CALL, (Object)this.conferenceId, (Object)this.participantId, (Object)Constants.CAUSE.CALL_IN_PROGRESS);
                    return;
                }
                this.participantState = 1;
                if (Boolean.TRUE.equals(Constants.ENABLE_MCX_SIGNALING)) {
                    RTCPPacket joinConference = new RTCPPacket(0, "MCPC", this.getSSRC(), 1, user, "VIPs", 'B', "fAValues", 0, 10, 2, 5, 3, 4, "queuedUsersValues", 1, 10, "queuedUsersIDValues", 12, 3, 6, user, 1, 100, 0, sessionId, this.conferenceId, 0, "Warning field", 1, activeParticipant, "PckMessageKey", 1, "temporaryId", activeParticipant);
                    this.sendPacket(joinConference);
                } else {
                    PTTData pttData = new PTTData("conference-connect", activeParticipant);
                    this.sendJSONPacket(pttData);
                }
            } else if (Constants.CONFERENCE_PROVIDER == 2) {
                if (Constants.callStatusService.get() != null) {
                    logger.info("EventId={} GroupId={} ParticipantId={} ActiveParticipant={}", (Object)Constants.EVENT.USER_INITIATE_GROUP_CALL, (Object)this.participantId, (Object)this.conferenceId, (Object)activeParticipant);
                    ((CallStatusService)Constants.callStatusService.get()).joinConference(activeParticipant, this.conferenceId, this.participantId);
                } else {
                    logger.warn("EventId={} GroupId={} ParticipantId={} ActiveParticipant={} Cause=ConferenceServiceNotAvailable", (Object)Constants.EVENT.USER_INITIATE_GROUP_CALL, (Object)this.participantId, (Object)this.conferenceId, (Object)activeParticipant);
                }
            } else if (Constants.CONFERENCE_PROVIDER == 3) {
                logger.warn("EventId={} GroupId={} ParticipantId={} ActiveParticipant={} Cause=ConferenceServiceNotAvailable", (Object)Constants.EVENT.USER_INITIATE_GROUP_CALL, (Object)this.participantId, (Object)this.conferenceId, (Object)activeParticipant);
                PTTData pttData = new PTTData("conference-connect", activeParticipant);
                this.sendJSONPacket(pttData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveConference(String sessionId, Participant participant) {
        Object object = this.updateControlLock;
        synchronized (object) {
            this.participantState = 0;
            logger.info("EventId={} GroupId={} ParticipantId={} SessionId={}", (Object)Constants.EVENT.USER_LEAVE_CONFERENCE, (Object)this.conferenceId, (Object)this.participantId, (Object)sessionId);
            String user = participant.getParticipantNo() + "@" + this.conferenceId;
            if (Boolean.TRUE.equals(Constants.ENABLE_MCX_SIGNALING)) {
                RTCPPacket leaveConference = new RTCPPacket(1, "MCPC", this.getSSRC(), 1, user, "VIPs", 'B', "fAValues", 0, 10, 2, 5, 3, 4, "queuedUsersValues", 1, 10, "queuedUsersIDValues", 12, 3, 6, user, 1, 100, 0, sessionId, this.conferenceId, 0, "Warning field", 1, "", "PckMessageKey", 1, "temporaryId", "");
                this.sendPacket(leaveConference);
            } else {
                PTTData pttData = new PTTData("conference-disconnect", "");
                this.sendJSONPacket(pttData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTextMessage(String sessionId, String messageSentBy, String messageType, String message, Participant participant) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={} SessionId={}", (Object)Constants.EVENT.USER_SEND_TEXT_MESSAGE, (Object)this.conferenceId, (Object)this.participantId, (Object)sessionId);
            this.participantMessageState = 5;
            String user = participant.getParticipantNo() + "@" + this.conferenceId;
            if (Boolean.TRUE.equals(Constants.ENABLE_MCX_SIGNALING)) {
                RTCPPacket textMessage = new RTCPPacket(4, "MCPC", this.getSSRC(), 1, user, messageType, 'B', "fAValues", 0, 10, 0, 5, 3, 4, "queuedUsersValues", 1, 10, "queuedUsersIDValues", 12, 3, 6, user, 1, 100, 0, sessionId, messageType + "@" + messageSentBy, 0, message, 1, messageSentBy, "PckMessageKey", 1, "temporaryId", messageSentBy);
                this.sendPacket(textMessage);
            } else {
                PTTData pttData = new PTTData("broadcast-text-message", message, messageSentBy);
                this.sendJSONPacket(pttData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinSession(Participant participant, Boolean isStreamActive) {
        Object object = this.updateControlLock;
        synchronized (object) {
            this.connectedIpAddress = participant.getConnectedIpAddress();
            this.connectionPort = participant.getPort();
            this.connectedMode = participant.getMode();
            this.conferenceId = participant.getJoinConference();
            this.participantState = 0;
            this.participantMessageState = 0;
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.USER_JOIN_GROUP_NOTIFICATION, (Object)this.conferenceId, (Object)this.participantId);
            String user = this.participantId + "@" + this.conferenceId;
            if (Boolean.TRUE.equals(Constants.ENABLE_MCX_SIGNALING)) {
                RTCPPacket joinSessionRequestResponse = new RTCPPacket(2, "MCPC", this.getSSRC(), 1, user, "VIPs", 'B', "fAValues", 0, 10, 2, 5, 3, 4, "queuedUsersValues", 1, 10, "queuedUsersIDValues", 12, 3, 6, user, 1, 100, 0, "mcpttSessionID", "mcpttGroupId", 0, "Warning field", 1, user, "PckMessageKey", 1, "temporaryId", user);
                this.sendPacket(joinSessionRequestResponse);
            } else {
                PTTData pttData = new PTTData("conference-join-ack", "");
                pttData.setActiveGroup(this.conferenceId);
                pttData.setIsStreamActive(isStreamActive);
                this.sendJSONPacket(pttData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFloorTaken(Boolean isVideo, String user, int messageType) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={} FloorTakenBy={}", (Object)Constants.EVENT.USER_FLOOR_TAKEN, (Object)this.conferenceId, (Object)this.participantId, (Object)user);
            if (Boolean.TRUE.equals(Constants.ENABLE_MCX_SIGNALING)) {
                RTCPPacket floorTakenResponse = new RTCPPacket(Boolean.TRUE.equals(isVideo) ? 2 : 2, Boolean.TRUE.equals(isVideo) ? "MCV1" : "MCPT", this.getSSRC(), 1, user, "VIPs", 'B', "fAValues", 0, 10, 2, 5, 3, 4, "queuedUsersValues", 1, 10, "queuedUsersIDValues", 12, 3, 6, user, messageType, 100, 0, "mcpttSessionID", "mcpttGroupId", 0, "Warning field", 1, user, "PckMessageKey", 1, "temporaryId", user);
                this.sendPacket(floorTakenResponse);
            } else {
                PTTData pttData = new PTTData("floor-taken", user);
                this.sendJSONPacket(pttData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantFloor(Boolean isVideo) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.USER_GRANT_FLOOR, (Object)this.conferenceId, (Object)this.participantId);
            String user = this.participantId + "@" + this.conferenceId;
            if (Boolean.TRUE.equals(Constants.ENABLE_MCX_SIGNALING)) {
                RTCPPacket floorControlRequestResponse = new RTCPPacket(Boolean.TRUE.equals(isVideo) ? 0 : 1, Boolean.TRUE.equals(isVideo) ? "MCV1" : "MCPT", this.getSSRC(), 1, user, "VIPs", 'B', "fAValues", 0, 10, 2, 5, 3, 4, "queuedUsersValues", 1, 10, "queuedUsersIDValues", 12, 3, 6, user, 1, 100, 0, "mcpttSessionID", "mcpttGroupId", 0, "Warning field", 1, user, "PckMessageKey", 1, "temporaryId", user);
                this.sendPacket(floorControlRequestResponse);
            } else {
                PTTData pttData = new PTTData("floor-granted", "");
                this.sendJSONPacket(pttData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void denyFloor(Boolean isVideo, String userInfo) {
        Object object = this.updateControlLock;
        synchronized (object) {
            String user;
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.USER_DENY_FLOOR, (Object)this.conferenceId, (Object)this.participantId);
            String string = user = userInfo.isEmpty() ? this.participantId + "@" + this.conferenceId : userInfo;
            if (Boolean.TRUE.equals(Constants.ENABLE_MCX_SIGNALING)) {
                RTCPPacket floorControlRequestResponse = new RTCPPacket(Boolean.TRUE.equals(isVideo) ? 1 : 3, Boolean.TRUE.equals(isVideo) ? "MCV1" : "MCPT", this.getSSRC(), 1, user, "VIPs", 'B', "fAValues", 0, 10, 2, 5, 3, 4, "queuedUsersValues", 1, 10, "queuedUsersIDValues", 12, 3, 6, user, 1, 100, 0, "mcpttSessionID", "mcpttGroupId", 0, "Warning field", 1, user, "PckMessageKey", 1, "temporaryId", user);
                this.sendPacket(floorControlRequestResponse);
            } else {
                PTTData pttData = new PTTData("floor-deny", "");
                this.sendJSONPacket(pttData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFloorIdle(String user, int messageType) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={} MessageType={}", (Object)Constants.EVENT.USER_FLOOR_IDLE, (Object)this.conferenceId, (Object)this.participantId, (Object)messageType);
            if (Boolean.TRUE.equals(Constants.ENABLE_MCX_SIGNALING)) {
                RTCPPacket floorIdleResponse = new RTCPPacket(5, "MCPT", this.getSSRC(), 1, user, "VIPs", 'B', "fAValues", 0, 10, 2, 5, 3, 4, "queuedUsersValues", 1, 10, "queuedUsersIDValues", 12, messageType, 6, user, 1, 100, 0, "mcpttSessionID", "mcpttGroupId", 0, "Warning field", 1, user, "PckMessageKey", 1, "temporaryId", user);
                this.sendPacket(floorIdleResponse);
            } else {
                PTTData pttData = new PTTData("floor-idle", "");
                this.sendJSONPacket(pttData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFloor(Boolean isVideo) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.USER_RELEASE_FLOOR, (Object)this.conferenceId, (Object)this.participantId);
            String userInfo = this.participantId + "@" + this.conferenceId;
            if (Boolean.TRUE.equals(Constants.ENABLE_MCX_SIGNALING)) {
                RTCPPacket floorReleaseRequestResponse = new RTCPPacket(Boolean.TRUE.equals(isVideo) ? 4 : 10, Boolean.TRUE.equals(isVideo) ? "MCV2" : "MCPT", this.getSSRC(), 1, userInfo, "VIPs", 'B', "fAValues", 0, 10, 2, 5, 3, 4, "queuedUsersValues", 1, 10, "queuedUsersIDValues", 12, 3, 6, userInfo, 1, 100, 0, "mcpttSessionID", "mcpttGroupId", 0, "Warning field", 1, userInfo, "PckMessageKey", 1, "temporaryId", userInfo);
                this.sendPacket(floorReleaseRequestResponse);
            } else {
                PTTData pttData = new PTTData("floor-release-ack", "");
                this.sendJSONPacket(pttData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendVoiceMessage(String broadcastSourceNumber, String broadcastType, String user, String broadcastSessionId, String messageFile) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.USER_SEND_VOICE_MESSAGE, (Object)this.conferenceId, (Object)this.participantId);
            if (Boolean.TRUE.equals(Constants.ENABLE_MCX_SIGNALING)) {
                RTCPPacket joinSessionRequestResponse = new RTCPPacket(3, "MCPC", this.getSSRC(), 1, user, broadcastType, 'B', "fAValues", 0, 10, 0, 5, 3, 4, "queuedUsersValues", 1, 10, "queuedUsersIDValues", 12, 3, 6, user, 1, 100, 0, broadcastSessionId, broadcastType + "@" + broadcastSourceNumber, 0, "Warning field", 1, broadcastSourceNumber, "PckMessageKey", 1, "temporaryId", broadcastSourceNumber);
                this.sendPacket(joinSessionRequestResponse);
            } else {
                PTTData pttData = new PTTData("broadcast-voice-message", broadcastType, broadcastSourceNumber);
                pttData.setMessageSubType(messageFile);
                this.sendJSONPacket(pttData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void healthUpdate() {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.HEALTH_UPDATE_RECEIVED, (Object)this.conferenceId, (Object)this.participantId);
            if (Boolean.TRUE.equals(Constants.ENABLE_MCX_SIGNALING)) {
                logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.HEALTH_UPDATE_RECEIVED, (Object)this.conferenceId, (Object)this.participantId);
            } else {
                PTTData pttData = new PTTData("health-update-ack", "");
                this.sendJSONPacket(pttData);
            }
        }
    }

    private void sendPacket(RTCPPacket packetToSend) {
        try {
            MCXHelper.sendRTCPPacket((RTCPPacket)packetToSend, (String)this.connectedIpAddress, (Integer)this.connectionPort, (String)this.participantId, (String)this.connectedMode, (Integer)(this.connectionInterface == null ? 0 : this.connectionInterface));
        }
        catch (IOException e) {
            logger.error("Error sending RTCPPacket", (Throwable)e);
        }
    }

    private void sendJSONPacket(PTTData pttData) {
        try {
            pttData.setTimestamp(Long.valueOf(Instant.now().toEpochMilli()));
            pttData.setUserName(this.participantId);
            pttData.setActiveGroup(this.conferenceId);
            pttData.setDestinationIP(this.connectedIpAddress);
            pttData.setDestinationPort(this.connectionPort);
            if (this.connectedMode.equals("WS")) {
                logger.info("Sending JSON packet over Web Socket to user : {} => {}", (Object)pttData.getUserName(), (Object)pttData);
                MCXHelper.sendJSONPacketOverWebSocket((PTTData)pttData, (String)this.connectedIpAddress, (Integer)this.connectionPort, (String)this.participantId, (String)this.connectedMode, (Integer)(this.connectionInterface == null ? 0 : this.connectionInterface));
            } else {
                logger.info("Sending JSON packet over RTCP to user : {} => {}", (Object)pttData.getUserName(), (Object)pttData);
                MCXHelper.sendJSONPacket((PTTData)pttData, (String)this.connectedIpAddress, (Integer)this.connectionPort, (String)this.participantId, (String)this.connectedMode, (Integer)(this.connectionInterface == null ? 0 : this.connectionInterface));
            }
        }
        catch (Exception e) {
            logger.error("Error sending JSONPacket", (Throwable)e);
        }
    }

    private int getSSRC() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime startOfDay = now.toLocalDate().atStartOfDay();
        long millisSinceStartOfDay = Duration.between(startOfDay, now).toMillis();
        return (int)millisSinceStartOfDay;
    }
}

