/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx.mcvideo;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class TransmissionArbitrationTaken {
    private static final Logger logger = LogManager.getLogger(TransmissionArbitrationTaken.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCV1";

    private byte setHeader() {
        int mcptType = 2;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)mcptType;
        return (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        return new byte[]{rtcpLengthByte1, rtcpLengthByte2};
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        return new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
    }

    private static byte[] setGrantedPartyIdentity(String grantedPartyIdentityStr) {
        int requestPartyIdentityID = 4;
        int origLen = grantedPartyIdentityStr.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                grantedPartyIdentityStr = grantedPartyIdentityStr + "\u0000";
            }
        }
        byte[] grantedPartyIdeStrData = grantedPartyIdentityStr.getBytes();
        byte[] grantedPartyField = new byte[2 + origLen];
        grantedPartyField[0] = (byte)requestPartyIdentityID;
        grantedPartyField[1] = (byte)origLen;
        System.arraycopy(grantedPartyIdeStrData, 0, grantedPartyField, 2, grantedPartyIdeStrData.length);
        return grantedPartyField;
    }

    private static byte[] setPermissionToReqField(int permissionRequestTransmissionValue) {
        int permissionRequestTransmissionID = 5;
        int permissionRequestTransmissionLength = 2;
        byte[] permissionRequestTransmissionField = new byte[]{(byte)permissionRequestTransmissionID, (byte)permissionRequestTransmissionLength, (byte)(permissionRequestTransmissionValue >> 8 & 0xFF), (byte)(permissionRequestTransmissionValue & 0xFF)};
        return permissionRequestTransmissionField;
    }

    private static byte[] setMessageSeqField(int messageSequenceValue) {
        int messageSequenceFieldID = 8;
        int messageSequenceLength = 2;
        byte messageIDByte = (byte)(messageSequenceFieldID & 0xFF);
        byte messageLengthByte = (byte)(messageSequenceLength & 0xFF);
        byte messageTypeByte1 = (byte)(messageSequenceValue >> 8 & 0xFF);
        byte messageSpareByte2 = (byte)(messageSequenceValue & 0xFF);
        return new byte[]{messageIDByte, messageLengthByte, messageTypeByte1, messageSpareByte2};
    }

    private byte[] setTransmissionIndicatorIDField(char transmissionIndicatorValueChar) {
        int transmissionIndicatorValue;
        int transmissionIndicatorFieldId = 13;
        int transmissionIndicatorLength = 2;
        if (transmissionIndicatorValueChar == 'A') {
            transmissionIndicatorValue = 32768;
        } else if (transmissionIndicatorValueChar == 'B') {
            transmissionIndicatorValue = 16384;
        } else if (transmissionIndicatorValueChar == 'C') {
            transmissionIndicatorValue = 8192;
        } else if (transmissionIndicatorValueChar == 'D') {
            transmissionIndicatorValue = 4096;
        } else if (transmissionIndicatorValueChar == 'E') {
            transmissionIndicatorValue = 2048;
        } else {
            throw new IllegalArgumentException("Invalid transmission indicator value");
        }
        byte[] transmissionIndicatorValueData = new byte[]{(byte)(transmissionIndicatorValue >> 8 & 0xFF), (byte)transmissionIndicatorValue};
        byte[] transmissionIndicator = new byte[2 + transmissionIndicatorValueData.length];
        transmissionIndicator[0] = (byte)(transmissionIndicatorFieldId & 0xFF);
        transmissionIndicator[1] = (byte)(transmissionIndicatorLength & 0xFF);
        System.arraycopy(transmissionIndicatorValueData, 0, transmissionIndicator, 2, transmissionIndicatorValueData.length);
        return transmissionIndicator;
    }

    public static byte[] setGrantedParticipantTransmissionField(int grantedParticipantTransmissionValue) {
        int ssrcFieldId = 14;
        int ssrcLength = 6;
        int ssrcSpare = 0;
        byte[] ssrcOfGrantedParticipant = new byte[]{(byte)(ssrcFieldId & 0xFF), (byte)(ssrcLength & 0xFF), (byte)(grantedParticipantTransmissionValue >> 24 & 0xFF), (byte)(grantedParticipantTransmissionValue >> 16 & 0xFF), (byte)(grantedParticipantTransmissionValue >> 8 & 0xFF), (byte)(grantedParticipantTransmissionValue & 0xFF), (byte)(ssrcSpare & 0xFF), (byte)(ssrcSpare & 0xFF)};
        return ssrcOfGrantedParticipant;
    }

    public byte[] send(int ssrcValue, String grantedPartyIdentityStr, int permissionRequestTransmissionValue, int messageSequenceValue, char transmissionIndicatorBit, int grantedParticipantTransmissionValue) {
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] appData = "MCV1".getBytes();
        byte[] grantedPartyField = TransmissionArbitrationTaken.setGrantedPartyIdentity((String)grantedPartyIdentityStr);
        byte[] permissionField = TransmissionArbitrationTaken.setPermissionToReqField((int)permissionRequestTransmissionValue);
        byte[] messageSequenceField = TransmissionArbitrationTaken.setMessageSeqField((int)messageSequenceValue);
        byte[] transmissionIndicatorField = this.setTransmissionIndicatorIDField(transmissionIndicatorBit);
        byte[] ssrcOfParticipant = TransmissionArbitrationTaken.setGrantedParticipantTransmissionField((int)grantedParticipantTransmissionValue);
        int totalRtcpLength = (8 + grantedPartyField.length + permissionField.length + messageSequenceField.length + transmissionIndicatorField.length + ssrcOfParticipant.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + grantedPartyField.length + permissionField.length + messageSequenceField.length + transmissionIndicatorField.length + ssrcOfParticipant.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(grantedPartyField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, grantedPartyField.length);
        System.arraycopy(permissionField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + grantedPartyField.length, permissionField.length);
        System.arraycopy(messageSequenceField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + grantedPartyField.length + permissionField.length, messageSequenceField.length);
        System.arraycopy(transmissionIndicatorField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + grantedPartyField.length + permissionField.length + messageSequenceField.length, transmissionIndicatorField.length);
        System.arraycopy(ssrcOfParticipant, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + grantedPartyField.length + permissionField.length + messageSequenceField.length + transmissionIndicatorField.length, ssrcOfParticipant.length);
        logger.debug("RTCP packet sent");
        return packet;
    }
}

