/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class McptFloorRequest {
    private static final Logger logger = LogManager.getLogger(McptFloorRequest.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCPT";

    private byte setHeader() {
        boolean mcptType = false;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcptType ? 1 : 0);
        return (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        return new byte[]{rtcpLengthByte1, rtcpLengthByte2};
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        return new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
    }

    private byte[] setFloorPriorityField(int floorValue) {
        int floorID = 0;
        int floorLength = 2;
        boolean spare = false;
        byte floorIDByte = (byte)(floorID & 0xFF);
        byte floorLengthByte = (byte)(floorLength & 0xFF);
        byte floorValueByte = (byte)(floorValue & 0xFF);
        byte spareByte = (byte)(spare ? 1 : 0);
        return new byte[]{floorIDByte, floorLengthByte, floorValueByte, spareByte};
    }

    private byte[] setUserIDField(String userIDString) {
        int userID = 6;
        int origLen = userIDString.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                userIDString = userIDString + "\u0000";
            }
        }
        byte[] userIdStrData = userIDString.getBytes();
        byte[] userFieldID = new byte[2 + origLen];
        userFieldID[0] = (byte)userID;
        userFieldID[1] = (byte)origLen;
        System.arraycopy(userIdStrData, 0, userFieldID, 2, userIdStrData.length);
        return userFieldID;
    }

    private byte[] setTrackInfoField(String participantTypeValue) {
        int trackInfoID = 11;
        boolean queueingCap = true;
        int participantTypeLen = participantTypeValue.length();
        if (participantTypeLen % 4 != 0) {
            int paddingLength = 4 - participantTypeValue.length() % 4;
            for (int i = 0; i < paddingLength; ++i) {
                participantTypeValue = participantTypeValue + "\u0000";
            }
            participantTypeLen += paddingLength;
        }
        int trackInfoLength = participantTypeLen + 6;
        byte[] participantTypeValueData = participantTypeValue.getBytes();
        byte[] trackInfo = new byte[2 + trackInfoLength];
        trackInfo[0] = (byte)trackInfoID;
        trackInfo[1] = (byte)trackInfoLength;
        trackInfo[2] = (byte)(queueingCap ? 1 : 0);
        trackInfo[3] = (byte)participantTypeLen;
        System.arraycopy(participantTypeValueData, 0, trackInfo, 4, participantTypeValueData.length);
        return trackInfo;
    }

    private byte[] setFloorIndicatorIDField(char floorIndicatorValueChar) {
        int floorIndicatorValue;
        int floorIndicatorFieldId = 13;
        int floorIndicatorLength = 2;
        if (floorIndicatorValueChar == 'A') {
            floorIndicatorValue = 32768;
        } else if (floorIndicatorValueChar == 'B') {
            floorIndicatorValue = 16384;
        } else if (floorIndicatorValueChar == 'C') {
            floorIndicatorValue = 8192;
        } else if (floorIndicatorValueChar == 'D') {
            floorIndicatorValue = 4096;
        } else if (floorIndicatorValueChar == 'E') {
            floorIndicatorValue = 2048;
        } else if (floorIndicatorValueChar == 'F') {
            floorIndicatorValue = 1024;
        } else if (floorIndicatorValueChar == 'G') {
            floorIndicatorValue = 512;
        } else if (floorIndicatorValueChar == 'H') {
            floorIndicatorValue = 256;
        } else if (floorIndicatorValueChar == 'I') {
            floorIndicatorValue = 128;
        } else {
            throw new IllegalArgumentException("Invalid floor indicator value");
        }
        byte[] floorIndicatorValueData = new byte[]{(byte)(floorIndicatorValue >> 8 & 0xFF), (byte)floorIndicatorValue};
        byte[] floorIndicator = new byte[2 + floorIndicatorValueData.length];
        floorIndicator[0] = (byte)(floorIndicatorFieldId & 0xFF);
        floorIndicator[1] = (byte)(floorIndicatorLength & 0xFF);
        System.arraycopy(floorIndicatorValueData, 0, floorIndicator, 2, floorIndicatorValueData.length);
        return floorIndicator;
    }

    private byte[] setFunctionAliasIDField(String funAliasValue) {
        int funAliasFieldId = 17;
        int origLen = funAliasValue.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                funAliasValue = funAliasValue + "\u0000";
            }
        }
        byte[] functionalAliasData = funAliasValue.getBytes();
        byte[] FunctionalAlias = new byte[2 + origLen];
        FunctionalAlias[0] = (byte)funAliasFieldId;
        FunctionalAlias[1] = (byte)origLen;
        System.arraycopy(functionalAliasData, 0, FunctionalAlias, 2, functionalAliasData.length);
        return FunctionalAlias;
    }

    private byte[] setLocationField(int locationType) {
        int locationID = 19;
        int locationLength = 2;
        int locationValue = 0;
        byte locationIDByte = (byte)(locationID & 0xFF);
        byte locationLengthByte = (byte)(locationLength & 0xFF);
        byte locationTypeByte = (byte)(locationType & 0xFF);
        byte locationValueByte = (byte)(locationValue & 0xFF);
        return new byte[]{locationIDByte, locationLengthByte, locationTypeByte, locationValueByte};
    }

    public byte[] send(int ssrcValue, int floorValue, String userIdStrData, String participantTypeValue, char floorIndicatorBit, String functionalAliasValue, int locationType) {
        byte[] appData = name.getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] floorPriorityField = this.setFloorPriorityField(floorValue);
        byte[] userField = this.setUserIDField(userIdStrData);
        byte[] trackField = this.setTrackInfoField(participantTypeValue);
        byte[] floorIndicator = this.setFloorIndicatorIDField(floorIndicatorBit);
        byte[] functionalAliasField = this.setFunctionAliasIDField(functionalAliasValue);
        byte[] locationField = this.setLocationField(locationType);
        int totalRtcpLength = (8 + floorPriorityField.length + userField.length + trackField.length + floorIndicator.length + functionalAliasField.length + locationField.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + floorPriorityField.length + userField.length + trackField.length + floorIndicator.length + functionalAliasField.length + locationField.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(floorPriorityField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, floorPriorityField.length);
        System.arraycopy(userField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + floorPriorityField.length, userField.length);
        System.arraycopy(trackField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + floorPriorityField.length + userField.length, trackField.length);
        System.arraycopy(floorIndicator, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + floorPriorityField.length + userField.length + trackField.length, floorIndicator.length);
        System.arraycopy(functionalAliasField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + floorPriorityField.length + userField.length + trackField.length + floorIndicator.length, functionalAliasField.length);
        System.arraycopy(locationField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + floorPriorityField.length + userField.length + trackField.length + floorIndicator.length + functionalAliasField.length, locationField.length);
        logger.debug("RTCP packet sent");
        return packet;
    }
}

