/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class McptFloorQueuePositionRequest {
    private static final Logger logger = LogManager.getLogger(McptFloorQueuePositionRequest.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCPT";

    private byte setHeader() {
        int mcptType = 8;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcptType & 0x1F);
        byte returnValue = (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
        return returnValue;
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        byte[] returnValue = new byte[]{rtcpLengthByte1, rtcpLengthByte2};
        return returnValue;
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        byte[] returnValue = new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
        return returnValue;
    }

    private byte[] setUserIDField(String userIDString) {
        int userID = 6;
        int origLen = userIDString.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                userIDString = userIDString + "\u0000";
            }
        }
        byte[] userIdStrData = userIDString.getBytes();
        byte[] userFieldID = new byte[2 + origLen];
        userFieldID[0] = (byte)userID;
        userFieldID[1] = (byte)origLen;
        System.arraycopy(userIdStrData, 0, userFieldID, 2, userIdStrData.length);
        return userFieldID;
    }

    private byte[] setTrackInfoField(String participantTypeValue) {
        int trackInfoID = 11;
        boolean queueingCap = true;
        int participantTypeLen = participantTypeValue.length();
        if (participantTypeLen % 4 != 0) {
            int paddingLength = 4 - participantTypeValue.length() % 4;
            for (int i = 0; i < paddingLength; ++i) {
                participantTypeValue = participantTypeValue + "\u0000";
            }
            participantTypeLen += paddingLength;
        }
        int trackInfoLength = participantTypeLen + 6;
        byte[] participantTypeValueData = participantTypeValue.getBytes();
        byte[] trackInfo = new byte[2 + trackInfoLength];
        trackInfo[0] = (byte)trackInfoID;
        trackInfo[1] = (byte)trackInfoLength;
        trackInfo[2] = (byte)(queueingCap ? 1 : 0);
        trackInfo[3] = (byte)participantTypeLen;
        System.arraycopy(participantTypeValueData, 0, trackInfo, 4, participantTypeValueData.length);
        return trackInfo;
    }

    public byte[] send(int ssrcValue, String userIdStrData, String participantTypeValue) {
        byte[] appData = name.getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] userField = this.setUserIDField(userIdStrData);
        byte[] trackField = this.setTrackInfoField(participantTypeValue);
        int totalRtcpLength = (8 + userField.length + trackField.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + userField.length + trackField.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(userField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, userField.length);
        System.arraycopy(trackField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + userField.length, trackField.length);
        logger.debug("RTCP Packet Sent");
        return packet;
    }
}

