/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class McptFloorQueuePositionInfo {
    private static final Logger logger = LogManager.getLogger(McptFloorQueuePositionInfo.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCPT";

    private byte setHeader() {
        int mcptType = 9;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcptType & 0x1F);
        byte returnValue = (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
        return returnValue;
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        byte[] returnValue = new byte[]{rtcpLengthByte1, rtcpLengthByte2};
        return returnValue;
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        byte[] returnValue = new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
        return returnValue;
    }

    private byte[] setUserIDField(String userIDString) {
        int userID = 6;
        int origLen = userIDString.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                userIDString = userIDString + "\u0000";
            }
        }
        byte[] userIdStrData = userIDString.getBytes();
        byte[] userFieldID = new byte[2 + origLen];
        userFieldID[0] = (byte)userID;
        userFieldID[1] = (byte)origLen;
        System.arraycopy(userIdStrData, 0, userFieldID, 2, userIdStrData.length);
        return userFieldID;
    }

    private byte[] setFloorPriorityField(int floorValue) {
        int floorID = 0;
        int floorLength = 2;
        boolean spare = false;
        byte floorIDByte = (byte)(floorID & 0xFF);
        byte floorLengthByte = (byte)(floorLength & 0xFF);
        byte floorValueByte = (byte)(floorValue & 0xFF);
        byte spareByte = (byte)(spare ? 1 : 0);
        return new byte[]{floorIDByte, floorLengthByte, floorValueByte, spareByte};
    }

    public byte[] setQueuedUserField(String queuedUsersValue) {
        int queuedUserFieldID = 9;
        int origLen = queuedUsersValue.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                queuedUsersValue = queuedUsersValue + "\u0000";
            }
        }
        byte[] queuedUsersStrData = queuedUsersValue.getBytes();
        byte[] queuedUserFieldData = new byte[2 + origLen];
        queuedUserFieldData[0] = (byte)queuedUserFieldID;
        queuedUserFieldData[1] = (byte)origLen;
        System.arraycopy(queuedUsersStrData, 0, queuedUserFieldData, 2, queuedUsersStrData.length);
        return queuedUserFieldData;
    }

    public byte[] setQueueInfoField(int queuePosiInfo, int queuePriLevel) {
        int queueInfoFieldID = 3;
        int queueInfoLength = 2;
        byte[] queueInfoField = new byte[]{(byte)queueInfoFieldID, (byte)queueInfoLength, (byte)queuePosiInfo, (byte)queuePriLevel};
        return queueInfoField;
    }

    private byte[] setTrackInfoField(String participantTypeValue) {
        int trackInfoID = 11;
        boolean queueingCap = true;
        int participantTypeLen = participantTypeValue.length();
        if (participantTypeLen % 4 != 0) {
            int paddingLength = 4 - participantTypeValue.length() % 4;
            for (int i = 0; i < paddingLength; ++i) {
                participantTypeValue = participantTypeValue + "\u0000";
            }
            participantTypeLen += paddingLength;
        }
        int trackInfoLength = participantTypeLen + 6;
        byte[] participantTypeValueData = participantTypeValue.getBytes();
        byte[] trackInfo = new byte[2 + trackInfoLength];
        trackInfo[0] = (byte)trackInfoID;
        trackInfo[1] = (byte)trackInfoLength;
        trackInfo[2] = (byte)(queueingCap ? 1 : 0);
        trackInfo[3] = (byte)participantTypeLen;
        System.arraycopy(participantTypeValueData, 0, trackInfo, 4, participantTypeValueData.length);
        return trackInfo;
    }

    private byte[] setFloorIndicatorIDField(char floorIndicatorValueChar) {
        int floorIndicatorValue;
        int floorIndicatorFieldId = 13;
        int floorIndicatorLength = 2;
        if (floorIndicatorValueChar == 'A') {
            floorIndicatorValue = 32768;
        } else if (floorIndicatorValueChar == 'B') {
            floorIndicatorValue = 16384;
        } else if (floorIndicatorValueChar == 'C') {
            floorIndicatorValue = 8192;
        } else if (floorIndicatorValueChar == 'D') {
            floorIndicatorValue = 4096;
        } else if (floorIndicatorValueChar == 'E') {
            floorIndicatorValue = 2048;
        } else if (floorIndicatorValueChar == 'F') {
            floorIndicatorValue = 1024;
        } else if (floorIndicatorValueChar == 'G') {
            floorIndicatorValue = 512;
        } else if (floorIndicatorValueChar == 'H') {
            floorIndicatorValue = 256;
        } else if (floorIndicatorValueChar == 'I') {
            floorIndicatorValue = 128;
        } else {
            throw new IllegalArgumentException("Invalid floor indicator value");
        }
        byte[] floorIndicatorValueData = new byte[]{(byte)(floorIndicatorValue >> 8 & 0xFF), (byte)floorIndicatorValue};
        byte[] floorIndicator = new byte[2 + floorIndicatorValueData.length];
        floorIndicator[0] = (byte)(floorIndicatorFieldId & 0xFF);
        floorIndicator[1] = (byte)(floorIndicatorLength & 0xFF);
        System.arraycopy(floorIndicatorValueData, 0, floorIndicator, 2, floorIndicatorValueData.length);
        return floorIndicator;
    }

    public byte[] send(int ssrcValue, String userIdStrData, int floorIdValue, String queuedUsersValue, int queuePosiInfo, int queuePriLevel, String participantTypeValue, char floorIndicatorBit) {
        byte[] appData = name.getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] userField = this.setUserIDField(userIdStrData);
        byte[] floorPriorityField = this.setFloorPriorityField(floorIdValue);
        byte[] queuedUsersField = this.setQueuedUserField(queuedUsersValue);
        byte[] queueInfoField = this.setQueueInfoField(queuePosiInfo, queuePriLevel);
        byte[] trackField = this.setTrackInfoField(participantTypeValue);
        byte[] floorIndicator = this.setFloorIndicatorIDField(floorIndicatorBit);
        int totalRtcpLength = (8 + userField.length + floorPriorityField.length + queuedUsersField.length + queueInfoField.length + trackField.length + floorIndicator.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + userField.length + floorPriorityField.length + queuedUsersField.length + queueInfoField.length + trackField.length + floorIndicator.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(userField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, userField.length);
        System.arraycopy(floorPriorityField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + userField.length, floorPriorityField.length);
        System.arraycopy(queuedUsersField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + userField.length + floorPriorityField.length, queuedUsersField.length);
        System.arraycopy(queueInfoField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + userField.length + floorPriorityField.length + queuedUsersField.length, queueInfoField.length);
        System.arraycopy(trackField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + userField.length + floorPriorityField.length + queuedUsersField.length + queueInfoField.length, trackField.length);
        System.arraycopy(floorIndicator, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + userField.length + floorPriorityField.length + queuedUsersField.length + queueInfoField.length + trackField.length, floorIndicator.length);
        logger.debug("RTCP Packet Sent");
        return packet;
    }
}

