/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import com.coraltele.ppdrconference.mcx.McptFloorRelease;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class McptFloorGranted {
    private static final Logger logger = LogManager.getLogger(McptFloorRelease.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCPT";

    private byte setHeader() {
        int mcptType = 1;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcptType & 0x1F);
        logger.debug("Common Header Values: {}, {}, {}", (Object)rtcpVersionByte, (Object)paddingByte, (Object)mcptTypeByte);
        byte returnValue = (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
        return returnValue;
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        logger.debug("Total RTCP Length:{},{}", (Object)rtcpLengthByte1, (Object)rtcpLengthByte2);
        byte[] returnValue = new byte[]{rtcpLengthByte1, rtcpLengthByte2};
        return returnValue;
    }

    private byte[] setByteSSRCName(int ssrc) {
        logger.debug("ssrc#########:{}", (Object)ssrc);
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        byte[] returnValue = new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
        return returnValue;
    }

    public byte[] setDurationField(int durationValue) {
        boolean durationFieldID = true;
        int durationLength = 2;
        byte[] durationField = new byte[]{(byte)(durationFieldID ? 1 : 0), (byte)durationLength, (byte)(durationValue >> 8 & 0xFF), (byte)(durationValue & 0xFF)};
        return durationField;
    }

    public byte[] setSSRCIDField(int ssrcValue) {
        int ssrcFieldId = 14;
        int ssrcLength = 6;
        int ssrcSpare = 0;
        byte[] ssrcOfParticipant = new byte[]{(byte)(ssrcFieldId & 0xFF), (byte)(ssrcLength & 0xFF), (byte)(ssrcValue >> 24 & 0xFF), (byte)(ssrcValue >> 16 & 0xFF), (byte)(ssrcValue >> 8 & 0xFF), (byte)(ssrcValue & 0xFF), (byte)(ssrcSpare & 0xFF), (byte)(ssrcSpare & 0xFF)};
        return ssrcOfParticipant;
    }

    private byte[] setFloorPriorityField(int floorValue) {
        int floorID = 0;
        int floorLength = 2;
        boolean spare = false;
        byte floorIDByte = (byte)(floorID & 0xFF);
        byte floorLengthByte = (byte)(floorLength & 0xFF);
        byte floorValueByte = (byte)(floorValue & 0xFF);
        byte spareByte = (byte)(spare ? 1 : 0);
        return new byte[]{floorIDByte, floorLengthByte, floorValueByte, spareByte};
    }

    private byte[] setUserIDField(String userIDString) {
        int userID = 6;
        int origLen = userIDString.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                userIDString = userIDString + "\u0000";
            }
        }
        byte[] userIdStrData = userIDString.getBytes();
        byte[] userFieldID = new byte[2 + origLen];
        userFieldID[0] = (byte)userID;
        userFieldID[1] = (byte)origLen;
        System.arraycopy(userIdStrData, 0, userFieldID, 2, userIdStrData.length);
        return userFieldID;
    }

    public byte[] setQueueSizeField(int queueSizeValue) {
        int queueSizeFieldID = 7;
        int queueSizeLength = 2;
        byte[] queueSize = new byte[]{(byte)queueSizeFieldID, (byte)queueSizeLength, (byte)(queueSizeValue >> 8 & 0xFF), (byte)(queueSizeValue & 0xFF)};
        return queueSize;
    }

    public byte[] setQueueSSRCField(int ssrcValue) {
        int ssrcFieldId = 14;
        int ssrcLength = 6;
        int ssrcSpare = 0;
        byte[] ssrcOfParticipant = new byte[]{(byte)(ssrcFieldId & 0xFF), (byte)(ssrcLength & 0xFF), (byte)(ssrcValue >> 24 & 0xFF), (byte)(ssrcValue >> 16 & 0xFF), (byte)(ssrcValue >> 8 & 0xFF), (byte)(ssrcValue & 0xFF), (byte)(ssrcSpare >> 8 & 0xFF), (byte)(ssrcSpare & 0xFF)};
        return ssrcOfParticipant;
    }

    public byte[] setQueuedUserField(String queuedUsersValue) {
        int queuedUserFieldID = 9;
        int origLen = queuedUsersValue.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                queuedUsersValue = queuedUsersValue + "\u0000";
            }
        }
        byte[] queuedUsersStrData = queuedUsersValue.getBytes();
        byte[] queuedUserFieldData = new byte[2 + origLen];
        queuedUserFieldData[0] = (byte)queuedUserFieldID;
        queuedUserFieldData[1] = (byte)origLen;
        System.arraycopy(queuedUsersStrData, 0, queuedUserFieldData, 2, queuedUsersStrData.length);
        return queuedUserFieldData;
    }

    public byte[] setQueueInfoField(int queuePosiInfo, int queuePriLevel) {
        int queueInfoFieldID = 3;
        int queueInfoLength = 2;
        byte[] queueInfoField = new byte[]{(byte)queueInfoFieldID, (byte)queueInfoLength, (byte)queuePosiInfo, (byte)queuePriLevel};
        return queueInfoField;
    }

    private byte[] setTrackInfoField(String participantTypeValue) {
        int trackInfoID = 11;
        boolean queueingCap = true;
        int participantTypeLen = participantTypeValue.length();
        if (participantTypeLen % 4 != 0) {
            int paddingLength = 4 - participantTypeValue.length() % 4;
            for (int i = 0; i < paddingLength; ++i) {
                participantTypeValue = participantTypeValue + "\u0000";
            }
            participantTypeLen += paddingLength;
        }
        int trackInfoLength = participantTypeLen + 6;
        byte[] participantTypeValueData = participantTypeValue.getBytes();
        byte[] trackInfo = new byte[2 + trackInfoLength];
        trackInfo[0] = (byte)trackInfoID;
        trackInfo[1] = (byte)trackInfoLength;
        trackInfo[2] = (byte)(queueingCap ? 1 : 0);
        trackInfo[3] = (byte)participantTypeLen;
        System.arraycopy(participantTypeValueData, 0, trackInfo, 4, participantTypeValueData.length);
        return trackInfo;
    }

    private byte[] setFloorIndicatorIDField(char floorIndicatorValueChar) {
        int floorIndicatorValue;
        int floorIndicatorFieldId = 13;
        int floorIndicatorLength = 2;
        if (floorIndicatorValueChar == 'A') {
            floorIndicatorValue = 32768;
        } else if (floorIndicatorValueChar == 'B') {
            floorIndicatorValue = 16384;
        } else if (floorIndicatorValueChar == 'C') {
            floorIndicatorValue = 8192;
        } else if (floorIndicatorValueChar == 'D') {
            floorIndicatorValue = 4096;
        } else if (floorIndicatorValueChar == 'E') {
            floorIndicatorValue = 2048;
        } else if (floorIndicatorValueChar == 'F') {
            floorIndicatorValue = 1024;
        } else if (floorIndicatorValueChar == 'G') {
            floorIndicatorValue = 512;
        } else if (floorIndicatorValueChar == 'H') {
            floorIndicatorValue = 256;
        } else if (floorIndicatorValueChar == 'I') {
            floorIndicatorValue = 128;
        } else {
            throw new IllegalArgumentException("Invalid floor indicator value");
        }
        byte[] floorIndicatorValueData = new byte[]{(byte)(floorIndicatorValue >> 8 & 0xFF), (byte)floorIndicatorValue};
        byte[] floorIndicator = new byte[2 + floorIndicatorValueData.length];
        floorIndicator[0] = (byte)(floorIndicatorFieldId & 0xFF);
        floorIndicator[1] = (byte)(floorIndicatorLength & 0xFF);
        System.arraycopy(floorIndicatorValueData, 0, floorIndicator, 2, floorIndicatorValueData.length);
        return floorIndicator;
    }

    public byte[] send(int ssrcValue, int durationValue, int ssrcIdValue, int floorValue, String userIdStrData, int queueSizeValue, int queuedSsrcValue, String queuedUsersValue, int queuePosiInfo, int queuePriLevel, String participantTypeValue, char floorIndicatorBit) {
        byte[] appData = name.getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] durationField = this.setDurationField(durationValue);
        byte[] ssrcIDField = this.setSSRCIDField(ssrcIdValue);
        byte[] floorPriorityField = this.setFloorPriorityField(floorValue);
        byte[] userField = this.setUserIDField(userIdStrData);
        byte[] queueSizeField = this.setQueueSizeField(queueSizeValue);
        byte[] queuedSSRCField = this.setQueueSSRCField(queuedSsrcValue);
        byte[] queuedUsersField = this.setQueuedUserField(queuedUsersValue);
        byte[] queueInfoField = this.setQueueInfoField(queuePosiInfo, queuePriLevel);
        byte[] trackField = this.setTrackInfoField(participantTypeValue);
        byte[] floorIndicator = this.setFloorIndicatorIDField(floorIndicatorBit);
        int totalRtcpLength = (8 + durationField.length + ssrcIDField.length + floorPriorityField.length + userField.length + trackField.length + queueSizeField.length + queuedSSRCField.length + queuedUsersField.length + queueInfoField.length + floorIndicator.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + durationField.length + ssrcIDField.length + floorPriorityField.length + userField.length + trackField.length + queueSizeField.length + queuedSSRCField.length + queuedUsersField.length + queueInfoField.length + floorIndicator.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(durationField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, durationField.length);
        System.arraycopy(ssrcIDField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length, ssrcIDField.length);
        System.arraycopy(floorPriorityField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length, floorPriorityField.length);
        System.arraycopy(userField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + floorPriorityField.length, userField.length);
        System.arraycopy(queueSizeField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + floorPriorityField.length + userField.length, queueSizeField.length);
        System.arraycopy(queuedSSRCField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + floorPriorityField.length + userField.length + queueSizeField.length, queuedSSRCField.length);
        System.arraycopy(queuedUsersField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + floorPriorityField.length + userField.length + queueSizeField.length + queuedSSRCField.length, queuedUsersField.length);
        System.arraycopy(queueInfoField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + floorPriorityField.length + userField.length + queueSizeField.length + queuedSSRCField.length + queuedUsersField.length, queueInfoField.length);
        System.arraycopy(trackField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + floorPriorityField.length + userField.length + queueSizeField.length + queuedSSRCField.length + queuedUsersField.length + queueInfoField.length, trackField.length);
        System.arraycopy(floorIndicator, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + floorPriorityField.length + userField.length + queueSizeField.length + queuedSSRCField.length + queuedUsersField.length + queueInfoField.length + trackField.length, floorIndicator.length);
        logger.debug("RTCP packet sent:{}", (Object)packet);
        return packet;
    }
}

