/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import com.coraltele.ppdrconference.mcx.McptFloorDeny;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class McptFloorAck {
    private static final Logger logger = LogManager.getLogger(McptFloorDeny.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCPT";

    private byte setHeader() {
        int mcptType = 10;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcptType & 0x1F);
        byte returnValue = (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
        return returnValue;
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        byte[] returnValue = new byte[]{rtcpLengthByte1, rtcpLengthByte2};
        return returnValue;
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        byte[] returnValue = new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
        return returnValue;
    }

    private byte[] setMessageField(int messageTypeValue) {
        int messageTypeId = 12;
        int messageTypeLength = 2;
        int messageSpare = 0;
        byte messageIDByte = (byte)(messageTypeId & 0xFF);
        byte messageLengthByte = (byte)(messageTypeLength & 0xFF);
        byte messageTypeByte = (byte)(messageTypeValue & 0xFF);
        byte messageSpareByte = (byte)(messageSpare & 0xFF);
        return new byte[]{messageIDByte, messageLengthByte, messageTypeByte, messageSpareByte};
    }

    private byte[] setSourceField(int sourceValue) {
        int sourceId = 10;
        int sourceLength = 2;
        byte sourceIDByte = (byte)(sourceId & 0xFF);
        byte sourceLengthByte = (byte)(sourceLength & 0xFF);
        byte sourceValueByte1 = (byte)(sourceValue >> 8 & 0xFF);
        byte sourceValueByte2 = (byte)(sourceValue & 0xFF);
        return new byte[]{sourceIDByte, sourceLengthByte, sourceValueByte1, sourceValueByte2};
    }

    private byte[] setTrackInfoField(String participantTypeValue) {
        int trackInfoID = 11;
        boolean queueingCap = false;
        int participantTypeLen = participantTypeValue.length();
        if (participantTypeLen % 4 != 0) {
            int paddingLength = 4 - participantTypeValue.length() % 4;
            for (int i = 0; i < paddingLength; ++i) {
                participantTypeValue = participantTypeValue + "\u0000";
            }
            participantTypeLen += paddingLength;
        }
        int trackInfoLength = participantTypeLen + 6;
        byte[] participantTypeValueData = participantTypeValue.getBytes();
        byte[] trackInfo = new byte[2 + trackInfoLength];
        trackInfo[0] = (byte)trackInfoID;
        trackInfo[1] = (byte)trackInfoLength;
        trackInfo[2] = (byte)(queueingCap ? 1 : 0);
        trackInfo[3] = (byte)participantTypeLen;
        System.arraycopy(participantTypeValueData, 0, trackInfo, 4, participantTypeValueData.length);
        return trackInfo;
    }

    private byte[] setLocationField(int locationType) {
        int locationID = 19;
        int locationLength = 2;
        int locationValue = 234;
        byte[] locationField = new byte[]{(byte)locationID, (byte)locationLength, (byte)locationType, (byte)(locationValue & 0xFF)};
        return locationField;
    }

    public byte[] send(int ssrcValue, int messageTypeValue, int sourceValue, String participantTypeValue, int locationType) {
        byte[] appData = name.getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] messageField = this.setMessageField(messageTypeValue);
        byte[] sourceFieldID = this.setSourceField(sourceValue);
        byte[] trackInfoField = this.setTrackInfoField(participantTypeValue);
        byte[] locationField = this.setLocationField(locationType);
        int totalRtcpLength = (8 + messageField.length + sourceFieldID.length + trackInfoField.length + locationField.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + messageField.length + sourceFieldID.length + trackInfoField.length + locationField.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(messageField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, messageField.length);
        System.arraycopy(sourceFieldID, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + messageField.length, sourceFieldID.length);
        System.arraycopy(trackInfoField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + messageField.length + sourceFieldID.length, trackInfoField.length);
        System.arraycopy(locationField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + messageField.length + sourceFieldID.length + trackInfoField.length, locationField.length);
        logger.debug("RTCP packet sent");
        return packet;
    }
}

