/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import com.coraltele.ppdrconference.mcx.MCPCBroadcastConnect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class MCPCBroadcastTextMessage {
    private static final Logger logger = LogManager.getLogger(MCPCBroadcastConnect.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCPC";

    private byte setHeader() {
        int mcptType = 4;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcptType & 0x1F);
        byte returnValue = (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
        return returnValue;
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        byte[] returnValue = new byte[]{rtcpLengthByte1, rtcpLengthByte2};
        return returnValue;
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        byte[] returnValue = new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
        return returnValue;
    }

    private static byte[] setMCPTTMediaStream(int mediaControlChannelValue) {
        boolean mediaStreamID = false;
        int mediaStreamLength = 2;
        int mediaStreamValue = 5;
        byte[] mediaStreamField = new byte[]{(byte)(mediaStreamID ? 1 : 0), (byte)mediaStreamLength, (byte)mediaStreamValue, (byte)mediaControlChannelValue};
        return mediaStreamField;
    }

    private static byte[] setMCPTTSessionField(String mcpttSessionIDStr) {
        boolean McpttSessionID = true;
        boolean sessionType = true;
        int origLen = mcpttSessionIDStr.length();
        if (origLen % 4 == 0) {
            mcpttSessionIDStr = mcpttSessionIDStr + "\u0000";
            origLen = mcpttSessionIDStr.length();
        } else if (origLen % 4 != 1) {
            int remainder = origLen % 4;
            int paddingLength = remainder + 1;
            for (int i = 0; i < paddingLength; ++i) {
                mcpttSessionIDStr = mcpttSessionIDStr + "\u0000";
            }
            origLen = mcpttSessionIDStr.length();
        }
        int mcpttSessionIDLength = origLen + 1;
        byte[] mcpttSessionIdStrData = mcpttSessionIDStr.getBytes();
        byte[] mcpttSessionFieldID = new byte[2 + mcpttSessionIDLength];
        mcpttSessionFieldID[0] = (byte)(McpttSessionID ? 1 : 0);
        mcpttSessionFieldID[1] = (byte)mcpttSessionIDLength;
        mcpttSessionFieldID[2] = (byte)(sessionType ? 1 : 0);
        System.arraycopy(mcpttSessionIdStrData, 0, mcpttSessionFieldID, 3, mcpttSessionIdStrData.length);
        return mcpttSessionFieldID;
    }

    private static byte[] setMCPTTWarning(String warningText) {
        int warningID = 2;
        int origLen = warningText.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                warningText = warningText + "\u0000";
            }
        }
        byte[] warningTextData = warningText.getBytes();
        byte[] warningField = new byte[2 + origLen];
        warningField[0] = (byte)warningID;
        warningField[1] = (byte)origLen;
        System.arraycopy(warningTextData, 0, warningField, 2, warningTextData.length);
        return warningField;
    }

    private static byte[] setMCPTTGroupIdentity(String mcpttGroupIDStr) {
        int McpttGroupID = 3;
        int origLen = mcpttGroupIDStr.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                mcpttGroupIDStr = mcpttGroupIDStr + "\u0000";
            }
        }
        byte[] mcpttGroupIDStrData = mcpttGroupIDStr.getBytes();
        byte[] mcpttGroupField = new byte[2 + origLen];
        mcpttGroupField[0] = (byte)McpttGroupID;
        mcpttGroupField[1] = (byte)origLen;
        System.arraycopy(mcpttGroupIDStrData, 0, mcpttGroupField, 2, mcpttGroupIDStrData.length);
        return mcpttGroupField;
    }

    private static byte[] setMCPTTAnswer(int answerState) {
        int answerStateID = 4;
        int answerStateLength = 2;
        byte[] answerStateField = new byte[]{(byte)answerStateID, (byte)answerStateLength, (byte)(answerState >> 8 & 0xFF), (byte)(answerState & 0xFF)};
        return answerStateField;
    }

    private static byte[] setMCPTTInvite(String invitingMcpttUserID) {
        int invitingMcpttID = 5;
        int origLen = invitingMcpttUserID.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                invitingMcpttUserID = invitingMcpttUserID + "\u0000";
            }
        }
        byte[] invitingMcpttData = invitingMcpttUserID.getBytes();
        byte[] invitingMcpttField = new byte[2 + origLen];
        invitingMcpttField[0] = (byte)invitingMcpttID;
        invitingMcpttField[1] = (byte)origLen;
        System.arraycopy(invitingMcpttData, 0, invitingMcpttField, 2, invitingMcpttData.length);
        return invitingMcpttField;
    }

    public byte[] send(int ssrcValue, String mcpttSessionIDStr, String mcpttGroupIDStr, int mediaControlChannelValue, String warningText, int answerState, String invitingMcpttUserID, String pckIMessageKey) {
        byte[] appData = "MCPC".getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] mcpttSessionField = MCPCBroadcastTextMessage.setMCPTTSessionField((String)mcpttSessionIDStr);
        byte[] mcpttGroupField = MCPCBroadcastTextMessage.setMCPTTGroupIdentity((String)mcpttGroupIDStr);
        byte[] mcpttMediaStreamField = MCPCBroadcastTextMessage.setMCPTTMediaStream((int)mediaControlChannelValue);
        byte[] warningTextField = MCPCBroadcastTextMessage.setMCPTTWarning((String)warningText);
        byte[] answerField = MCPCBroadcastTextMessage.setMCPTTAnswer((int)answerState);
        byte[] invitingUserField = MCPCBroadcastTextMessage.setMCPTTInvite((String)invitingMcpttUserID);
        int totalRtcpLength = (8 + mcpttSessionField.length + mcpttGroupField.length + mcpttMediaStreamField.length + warningTextField.length + answerField.length + invitingUserField.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + mcpttSessionField.length + mcpttGroupField.length + mcpttMediaStreamField.length + warningTextField.length + answerField.length + invitingUserField.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(mcpttSessionField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, mcpttSessionField.length);
        System.arraycopy(mcpttGroupField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + mcpttSessionField.length, mcpttGroupField.length);
        System.arraycopy(mcpttMediaStreamField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + mcpttSessionField.length + mcpttGroupField.length, mcpttMediaStreamField.length);
        System.arraycopy(warningTextField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + mcpttSessionField.length + mcpttGroupField.length + mcpttMediaStreamField.length, warningTextField.length);
        System.arraycopy(answerField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + mcpttSessionField.length + mcpttGroupField.length + mcpttMediaStreamField.length + warningTextField.length, answerField.length);
        System.arraycopy(invitingUserField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + mcpttSessionField.length + mcpttGroupField.length + mcpttMediaStreamField.length + warningTextField.length + answerField.length, invitingUserField.length);
        logger.debug("RTCP packet sent");
        return packet;
    }
}

