/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MCMCAppPagingMessage {
    private static final Logger logger = LogManager.getLogger(MCMCAppPagingMessage.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCMC";

    private byte setHeader() {
        int mcptType = 2;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcptType & 0x1F);
        byte returnValue = (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
        return returnValue;
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        byte[] returnValue = new byte[]{rtcpLengthByte1, rtcpLengthByte2};
        return returnValue;
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        byte[] returnValue = new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
        return returnValue;
    }

    private byte[] setMCPTTGroupIdentity(String mcpttGroupSipURIStr) {
        int McpttGroupID = 2;
        int origLen = mcpttGroupSipURIStr.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                mcpttGroupSipURIStr = mcpttGroupSipURIStr + "\u0000";
            }
        }
        byte[] mcpttGroupStrData = mcpttGroupSipURIStr.getBytes();
        byte[] mcpttGroupField = new byte[2 + origLen];
        mcpttGroupField[0] = (byte)McpttGroupID;
        mcpttGroupField[1] = (byte)origLen;
        System.arraycopy(mcpttGroupStrData, 0, mcpttGroupField, 2, mcpttGroupStrData.length);
        return mcpttGroupField;
    }

    public byte[] send(int ssrcValue, String mcpttGroupSipURIStrValue) {
        byte[] appData = name.getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] mcpttGroupIdField = this.setMCPTTGroupIdentity(mcpttGroupSipURIStrValue);
        int totalRtcpLength = (8 + mcpttGroupIdField.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + mcpttGroupIdField.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(mcpttGroupIdField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, mcpttGroupIdField.length);
        logger.debug("RTCP packet sent");
        return packet;
    }
}

