/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class MBMSMapBearer {
    private static final Logger logger = LogManager.getLogger(MBMSMapBearer.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCMC";

    private static byte setHeader() {
        int mcptType = 0;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcptType & 0x1F);
        byte returnValue = (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
        return returnValue;
    }

    private static byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        byte[] returnValue = new byte[]{rtcpLengthByte1, rtcpLengthByte2};
        return returnValue;
    }

    private static byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        byte[] returnValue = new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
        return returnValue;
    }

    private static byte[] setMCPTTGroupIdentity(String mcpttGroupURIStr) {
        int McpttGroupID = 3;
        int origLen = mcpttGroupURIStr.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                mcpttGroupURIStr = mcpttGroupURIStr + "\u0000";
            }
        }
        byte[] mcpttGroupStrData = mcpttGroupURIStr.getBytes();
        byte[] mcpttGroupField = new byte[2 + origLen];
        mcpttGroupField[0] = (byte)McpttGroupID;
        mcpttGroupField[1] = (byte)origLen;
        System.arraycopy(mcpttGroupStrData, 0, mcpttGroupField, 2, mcpttGroupStrData.length);
        return mcpttGroupField;
    }

    private static byte[] setTmgiValue(String tmgiStr) {
        boolean tmgiID = true;
        int origLen = tmgiStr.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                tmgiStr = tmgiStr + "\u0000";
            }
        }
        byte[] tmgiIdStrData = tmgiStr.getBytes();
        byte[] tmgiFieldID = new byte[2 + origLen];
        tmgiFieldID[0] = (byte)(tmgiID ? 1 : 0);
        tmgiFieldID[1] = (byte)origLen;
        System.arraycopy(tmgiIdStrData, 0, tmgiFieldID, 2, tmgiIdStrData.length);
        return tmgiFieldID;
    }

    private static byte[] setMBMSSubChannel(int floorLineNumber) {
        int mbmsSubChannelId = 0;
        int mbmsSubChannelLength = 2;
        int audioLineNumber = 1;
        int ipVersion = 0;
        int spare = 0;
        int FloorControlPortNumber = 5001;
        int mediaPortNumber = 2001;
        String ipAddress = "127.0.0.10";
        String[] ipParts = ipAddress.split("\\.");
        byte mbmsSubChannelIDByte = (byte)(mbmsSubChannelId & 0xFF);
        byte mbmsSubChannelLengthByte = (byte)(mbmsSubChannelLength & 0xFF);
        byte audioLineNumberByte = (byte)(audioLineNumber << 4 & 0xF0);
        byte floorLineNumberByte = (byte)(floorLineNumber & 0xF);
        byte ipVersionByte = (byte)(ipVersion << 4 & 0x80);
        byte spareByte = (byte)(spare & 0xF);
        if (floorLineNumber > 0) {
            byte[] mbmsSubChannelField = new byte[]{mbmsSubChannelIDByte, mbmsSubChannelLengthByte, (byte)(audioLineNumberByte | floorLineNumberByte), (byte)(ipVersionByte | spareByte), (byte)(FloorControlPortNumber >> 24 & 0xFF), (byte)(FloorControlPortNumber >> 16 & 0xFF), (byte)(FloorControlPortNumber >> 8 & 0xFF), (byte)(FloorControlPortNumber & 0xFF), (byte)(mediaPortNumber >> 24 & 0xFF), (byte)(mediaPortNumber >> 16 & 0xFF), (byte)(mediaPortNumber >> 8 & 0xFF), (byte)(mediaPortNumber & 0xFF), (byte)Integer.parseInt(ipParts[0]), (byte)Integer.parseInt(ipParts[1]), (byte)Integer.parseInt(ipParts[2]), (byte)Integer.parseInt(ipParts[3])};
            return mbmsSubChannelField;
        }
        byte[] mbmsSubChannelField = new byte[]{mbmsSubChannelIDByte, mbmsSubChannelLengthByte, (byte)(audioLineNumberByte | floorLineNumberByte), (byte)(ipVersionByte | spareByte), (byte)(mediaPortNumber >> 24 & 0xFF), (byte)(mediaPortNumber >> 16 & 0xFF), (byte)(mediaPortNumber >> 8 & 0xFF), (byte)(mediaPortNumber & 0xFF), (byte)Integer.parseInt(ipParts[0]), (byte)Integer.parseInt(ipParts[1]), (byte)Integer.parseInt(ipParts[2]), (byte)Integer.parseInt(ipParts[3])};
        return mbmsSubChannelField;
    }

    public byte[] send(int ssrcValue, String mcpttGroupStrValue, String tmgiStrValue, int floorLineNumber) {
        byte[] appData = "MCMC".getBytes();
        byte[] sSRCField = MBMSMapBearer.setByteSSRCName((int)ssrcValue);
        byte[] mcpttGroupField = MBMSMapBearer.setMCPTTGroupIdentity((String)mcpttGroupStrValue);
        byte[] mcmcTMGIField = MBMSMapBearer.setTmgiValue((String)tmgiStrValue);
        byte[] mbmsSubChannelField = MBMSMapBearer.setMBMSSubChannel((int)floorLineNumber);
        int totalRtcpLength = (8 + mcpttGroupField.length + mcmcTMGIField.length + mbmsSubChannelField.length) / 4;
        byte[] rtcpLength = MBMSMapBearer.setByteTotalLength((int)totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + mcpttGroupField.length + mcmcTMGIField.length + mbmsSubChannelField.length];
        packet[0] = MBMSMapBearer.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(mcpttGroupField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, mcpttGroupField.length);
        System.arraycopy(mcmcTMGIField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + mcpttGroupField.length, mcmcTMGIField.length);
        System.arraycopy(mbmsSubChannelField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + mcpttGroupField.length + mcmcTMGIField.length, mbmsSubChannelField.length);
        logger.debug("RTCP packet sent");
        return packet;
    }
}

