/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeartbeatOk {
    private static final Logger logger = LogManager.getLogger(HeartbeatOk.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "ALIV";

    private byte setHeader() {
        int mcptType = 1;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcptType & 0x1F);
        byte returnValue = (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
        return returnValue;
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        byte[] returnValue = new byte[]{rtcpLengthByte1, rtcpLengthByte2};
        return returnValue;
    }

    private byte[] setByteSSRCName() {
        int ssrc = 8982;
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        byte[] returnValue = new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
        return returnValue;
    }

    private byte[] setOkField(String cuString) {
        Random random = new Random();
        int randomNumber = random.nextInt();
        String customValue = cuString + randomNumber;
        boolean customID = false;
        int origLen = customValue.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                customValue = customValue + "\u0000";
            }
        }
        byte[] customData = customValue.getBytes();
        byte[] customDataField = new byte[2 + origLen];
        customDataField[0] = (byte)(customID ? 1 : 0);
        customDataField[1] = (byte)origLen;
        System.arraycopy(customData, 0, customDataField, 2, customData.length);
        return customDataField;
    }

    public byte[] send(String customString) {
        byte[] appData = name.getBytes();
        byte[] sSRCField = this.setByteSSRCName();
        byte[] okDataField = this.setOkField(customString);
        int totalRtcpLength = (8 + okDataField.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + okDataField.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(okDataField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, okDataField.length);
        logger.debug("RTCP packet sent");
        return packet;
    }
}

