/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.helper;

import com.coraltele.ppdrconference.service.FloorControlHistoryService;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class MediaSessionManager {
    private static final Logger logger = LogManager.getLogger(MediaSessionManager.class);
    private final String groupId;
    private final FloorControlHistoryService floorControlHistoryService;
    private String sessionId;
    private String currentParticipantId;
    private Long sessionStartTime = 0L;
    private Long lastTransmissionStartTime = 0L;
    private Long lastTransmissionStopTime = 0L;
    private boolean hasActiveTransmission;

    public MediaSessionManager(FloorControlHistoryService floorControlHistoryService, String groupId) {
        this.floorControlHistoryService = floorControlHistoryService;
        this.groupId = groupId;
    }

    public String startTransmission(String participantId) {
        long currentTime = Instant.now().getEpochSecond();
        if (!StringUtils.hasText((String)this.sessionId)) {
            this.sessionId = UUID.randomUUID().toString();
            this.currentParticipantId = participantId;
            this.sessionStartTime = currentTime;
            logger.info("New media session started - GroupId={} TransmissionId={} Participant={}", (Object)this.groupId, (Object)this.sessionId, (Object)participantId);
            this.floorControlHistoryService.startRecordingAudioAsync(this.groupId, this.sessionId);
        }
        this.lastTransmissionStartTime = currentTime;
        this.hasActiveTransmission = true;
        logger.info("Media transmission started - GroupId={} TransmissionId={} Participant={} SessionDuration={}", (Object)this.groupId, (Object)this.sessionId, (Object)participantId, (Object)this.getSessionDuration());
        return this.sessionId;
    }

    public void stopTransmission(String participantId) {
        if (!StringUtils.hasText((String)this.sessionId)) {
            logger.warn("Stop transmission called but no active session - GroupId={} Participant={}", (Object)this.groupId, (Object)participantId);
            return;
        }
        this.lastTransmissionStopTime = Instant.now().getEpochSecond();
        this.hasActiveTransmission = false;
        Duration transmissionDuration = Duration.ofMillis(this.lastTransmissionStopTime - this.lastTransmissionStartTime);
        logger.info("Media transmission stopped - GroupId={} TransmissionId={} Participant={} TransmissionDuration={} SessionDuration={}", (Object)this.groupId, (Object)this.sessionId, (Object)participantId, (Object)transmissionDuration, (Object)this.getSessionDuration());
    }

    public void completeSession() {
        if (!StringUtils.hasText((String)this.sessionId)) {
            return;
        }
        long currentTime = Instant.now().getEpochSecond();
        long totalDuration = this.getSessionDuration();
        logger.info("Media session completed - GroupId={} TransmissionId={} Participant={} TotalDuration={}", (Object)this.groupId, (Object)this.sessionId, (Object)this.currentParticipantId, (Object)totalDuration);
        this.floorControlHistoryService.generatePTTCallHistory(this.groupId, this.sessionId, this.currentParticipantId, this.sessionStartTime.longValue(), currentTime);
        this.sessionId = "";
        this.currentParticipantId = "";
        this.sessionStartTime = 0L;
        this.lastTransmissionStartTime = 0L;
        this.lastTransmissionStopTime = 0L;
        this.hasActiveTransmission = false;
    }

    public boolean hasActiveSession() {
        return StringUtils.hasText((String)this.sessionId);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getCurrentParticipantId() {
        return this.currentParticipantId;
    }

    public boolean hasActiveTransmission() {
        return this.hasActiveTransmission;
    }

    public long getSessionDuration() {
        if (this.sessionStartTime == 0L) {
            return 0L;
        }
        return Instant.now().getEpochSecond() - this.sessionStartTime;
    }

    public long getTimeSinceLastStop() {
        if (this.lastTransmissionStopTime == 0L) {
            return 0L;
        }
        return Instant.now().getEpochSecond() - this.lastTransmissionStopTime;
    }

    public long getSessionStartTime() {
        return this.sessionStartTime;
    }

    public long getLastTransmissionStartTime() {
        return this.lastTransmissionStartTime;
    }

    public long getLastTransmissionStopTime() {
        return this.lastTransmissionStopTime;
    }
}

