/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.controller;

import com.coraltele.ppdrconference.model.PTTData;
import com.coraltele.ppdrconference.service.RTCPServerService;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.stereotype.Controller;

@Controller
public class WebsocketIncomingMessageController {
    private static final Logger logger = LogManager.getLogger(WebsocketIncomingMessageController.class);
    private final ExecutorService executor = Executors.newFixedThreadPool(4);
    @Autowired
    RTCPServerService rtcpServerService;

    @MessageMapping(value={"/ptt-message"})
    public void receiveCoordinates(PTTData data) {
        String correlationId = UUID.randomUUID().toString();
        this.executor.submit(() -> {
            logger.info("PTT Request received: {} from user: {}", (Object)data, (Object)data.getUserName());
            this.rtcpServerService.processPTTData(data, null, Integer.valueOf(2), correlationId, "WS");
        });
    }
}

