/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.config;

import com.coraltele.ppdrconference.helper.JwtUtil;
import com.coraltele.ppdrconference.model.RequestResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class StompConnectChannelInterceptor
implements ChannelInterceptor {
    @Autowired
    private JwtUtil jwtUtil;

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        StompHeaderAccessor accessor = StompHeaderAccessor.wrap(message);
        if (StompCommand.CONNECT.equals((Object)accessor.getCommand())) {
            List authorizationHeaderValues = accessor.getNativeHeader("Authorization");
            if (authorizationHeaderValues != null && !authorizationHeaderValues.isEmpty()) {
                String authorizationHeader = (String)authorizationHeaderValues.get(0);
                if (!StringUtils.hasLength((String)authorizationHeader) || !this.isValid(authorizationHeader)) {
                    throw new AccessDeniedException("Access Denied: Invalid Credentials");
                }
            } else {
                throw new AccessDeniedException("Access Denied: No Authorization details provided");
            }
        }
        return message;
    }

    private boolean isValid(String headerValue) {
        String[] authHeaderValues = headerValue.split(" ");
        if (authHeaderValues.length == 2) {
            RequestResponse jwtResponse = this.jwtUtil.authenticate(authHeaderValues[0], authHeaderValues[1], "");
            return jwtResponse.getStatus() == 0;
        }
        return false;
    }
}

