/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DatabaseInitialize {
    private static final Logger logger = LogManager.getLogger(DatabaseInitialize.class);
    @Value(value="${spring.datasource.url}")
    private String dataSourceURL;
    @Value(value="${spring.datasource.driver-class-name}")
    private String dataSourceDriver;
    @Value(value="${spring.datasource.username}")
    private String dataSourceUserName;
    @Value(value="${spring.datasource.password}")
    private String dataSourceUserPassword;
    @Value(value="${spring.datasource.hikari.maximum-pool-size}")
    private int maximumPoolSize;
    @Value(value="${spring.datasource.hikari.minimum-idle}")
    private int minimumIdle;
    @Value(value="${spring.datasource.hikari.idle-timeout}")
    private int idleTimeOut;
    @Value(value="${spring.datasource.hikari.connection-timeout}")
    private int connectionTimeout;
    @Value(value="${spring.datasource.hikari.max-lifetime}")
    private int maxLifeTime;

    @Bean
    public DataSource getDataSource() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(this.dataSourceURL);
        config.setUsername(this.dataSourceUserName);
        config.setPassword(this.dataSourceUserPassword);
        config.setDriverClassName(this.dataSourceDriver);
        config.setMaximumPoolSize(this.maximumPoolSize);
        config.setMinimumIdle(this.minimumIdle);
        config.setIdleTimeout((long)this.idleTimeOut);
        config.setConnectionTimeout((long)this.connectionTimeout);
        config.setMaxLifetime((long)this.maxLifeTime);
        config.setConnectionTestQuery("select 1");
        HikariDataSource dataSource = new HikariDataSource(config);
        this.createTable((DataSource)dataSource);
        return dataSource;
    }

    public void createTable(DataSource dataSource) {
        if (dataSource == null) {
            logger.info("Create Table data source null");
        } else {
            logger.info("Create Table");
        }
    }
}

