/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.ws;

import com.coraltele.ppdrconference.model.EventNotification;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.messaging.simp.SimpMessagingTemplate;

public class MessagingHelper {
    private static final Logger logger = LogManager.getLogger(MessagingHelper.class);
    private static SimpMessagingTemplate simpMessagingTemplate;

    private MessagingHelper() {
    }

    public static SimpMessagingTemplate getMessagingTemplate() {
        return simpMessagingTemplate;
    }

    public static void setMessagingTemplate(SimpMessagingTemplate messagingTemplate) {
        simpMessagingTemplate = messagingTemplate;
    }

    public static boolean sendEvent(EventNotification dataToSend) {
        boolean returnValue = false;
        try {
            String topic = dataToSend.getEventDestination();
            ObjectMapper objectMapper = new ObjectMapper();
            String message = objectMapper.writeValueAsString((Object)dataToSend);
            logger.info("Sending message to {} => {}", (Object)dataToSend.getEventDestination(), (Object)message);
            simpMessagingTemplate.convertAndSend((Object)String.format("/app/v2/messaging/topic/%s", topic), (Object)message);
            returnValue = true;
        }
        catch (JsonProcessingException e) {
            logger.error("Error in sendEvent() for sending message to {} => {}", (Object)dataToSend.getEventDestination(), (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }
}

