/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.sip;

import com.coraltele.ppdrconference.condition.EnableConferenceServer;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.service.ConferenceService;
import com.coraltele.ppdrconference.sip.AccountConfiguration;
import com.coraltele.ppdrconference.sip.PPDRAccount;
import com.coraltele.ppdrconference.sip.SIPLogWriter;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pjsip.pjsua2.AccountConfig;
import org.pjsip.pjsua2.AudioMediaRecorder;
import org.pjsip.pjsua2.CodecOpusConfig;
import org.pjsip.pjsua2.Endpoint;
import org.pjsip.pjsua2.EpConfig;
import org.pjsip.pjsua2.IpChangeParam;
import org.pjsip.pjsua2.LogConfig;
import org.pjsip.pjsua2.LogWriter;
import org.pjsip.pjsua2.MediaConfig;
import org.pjsip.pjsua2.RtcpFbCap;
import org.pjsip.pjsua2.StringVector;
import org.pjsip.pjsua2.TransportConfig;
import org.pjsip.pjsua2.UaConfig;
import org.pjsip.pjsua2.pjsua2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableConferenceServer.class})
public class PPDRApp
extends pjsua2 {
    private static final Logger logger = LogManager.getLogger(PPDRApp.class);
    public static Endpoint ep = new Endpoint();
    public ArrayList<PPDRAccount> accList = new ArrayList();
    private ArrayList<AccountConfiguration> accCfgs = new ArrayList();
    private EpConfig epConfig = new EpConfig();
    private TransportConfig sipTpConfig = new TransportConfig();
    private SIPLogWriter logWriter;
    private PPDRAccount account;
    private static AudioMediaRecorder audioMediaRecorder;
    public volatile UaConfig uaConfiguration = null;
    @Autowired
    ConferenceService conferenceService;

    public static void checkThread(String name) {
        logger.info("Thread is registered audio {}", (Object)name);
        if (!ep.libIsThreadRegistered()) {
            try {
                ep.libRegisterThread(name);
                logger.info("Thread is registered {}", (Object)name);
            }
            catch (Exception e) {
                logger.error("Error in registering thread {}", (Object)name);
            }
        }
    }

    public void registerThread(String name) {
        logger.info("Thread is registered audio {}", (Object)name);
        if (!ep.libIsThreadRegistered()) {
            try {
                ep.libRegisterThread(name);
                logger.info("Thread is registered {}", (Object)name);
            }
            catch (Exception e) {
                logger.error("Error in registering thread {}", (Object)name);
            }
        }
    }

    @PostConstruct
    public void init() {
        Constants.ppdrApp.set(this);
        Constants.conferenceService.set(this.conferenceService);
        logger.info("Initializing PPDRApp");
        try {
            ep.libCreate();
        }
        catch (Exception e) {
            logger.error("Error creating endpoint: ", (Throwable)e);
            return;
        }
        this.sipTpConfig.setPort((long)Constants.LISTENER_PORT);
        this.epConfig.getLogConfig().setLevel((long)Constants.SIP_LOG_LEVEL);
        this.epConfig.getLogConfig().setConsoleLevel((long)Constants.SIP_LOG_LEVEL);
        LogConfig log_cfg = this.epConfig.getLogConfig();
        this.logWriter = new SIPLogWriter();
        log_cfg.setWriter((LogWriter)this.logWriter);
        this.uaConfiguration = this.epConfig.getUaConfig();
        this.uaConfiguration.setUserAgent("Coral MCX PPDR Conference " + ep.libVersion().getFull());
        this.uaConfiguration.setMaxCalls((long)Constants.MAX_CALLS);
        logger.info("Maximum supported calls : " + this.uaConfiguration.getMaxCalls());
        this.uaConfiguration.setThreadCnt((long)Constants.CONFERENCE_THREADS.intValue());
        this.uaConfiguration.setMainThreadOnly(false);
        try {
            ep.libInit(this.epConfig);
            ep.audDevManager().setNullDev();
        }
        catch (Exception e) {
            return;
        }
        MediaConfig mcfg = this.epConfig.getMedConfig();
        mcfg.setNoVad(true);
        mcfg.setEcOptions(388L);
        mcfg.setClockRate(48000L);
        mcfg.setChannelCount(2L);
        mcfg.setAudioFramePtime(20L);
        try {
            ep.transportCreate(1, this.sipTpConfig);
        }
        catch (Exception e) {
            logger.error("Error creating UDP transport: ", (Throwable)e);
        }
        try {
            ep.transportCreate(2, this.sipTpConfig);
        }
        catch (Exception e) {
            logger.error("Error creating TCP transport: ", (Throwable)e);
        }
        try {
            CodecOpusConfig opusConfig = ep.getCodecOpusConfig();
            opusConfig.setBit_rate(96000L);
            opusConfig.setSample_rate(48000L);
            opusConfig.setComplexity(8L);
            opusConfig.setChannel_cnt(2L);
            ep.setCodecOpusConfig(opusConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.sipTpConfig.setPort((long)Constants.LISTENER_SSL_PORT);
            ep.transportCreate(3, this.sipTpConfig);
        }
        catch (Exception e) {
            logger.error("Error creating TLS transport: ", (Throwable)e);
        }
        AccountConfig accCfg = new AccountConfig();
        accCfg.setIdUri("sip:" + Constants.LISTENER_IP);
        StringVector proxies = accCfg.getSipConfig().getProxies();
        proxies.add("sip:" + Constants.LISTENER_IP + ":" + Constants.LISTENER_PORT);
        accCfg.getVideoConfig().setAutoTransmitOutgoing(true);
        accCfg.getVideoConfig().setAutoShowIncoming(true);
        accCfg.getRegConfig().setTimeoutSec(60L);
        accCfg.getRegConfig().setRetryIntervalSec(60L);
        RtcpFbCap nack = new RtcpFbCap();
        nack.setCodecId("*");
        nack.setType(1);
        nack.setParam("");
        accCfg.getMediaConfig().getRtcpFbConfig().getCaps().add(nack);
        accCfg.getMediaConfig().setRtcpMuxEnabled(true);
        accCfg.getMediaConfig().getRtcpFbConfig().setDontUseAvpf(false);
        this.account = this.addAcc(accCfg);
        try {
            ep.libStart();
        }
        catch (Exception e) {
            logger.error("Error starting endpoint: ", (Throwable)e);
        }
    }

    public PPDRAccount addAcc(AccountConfig var1) {
        PPDRAccount acc = new PPDRAccount(var1);
        try {
            acc.create(var1);
        }
        catch (Exception var4) {
            logger.error("error while adding account", (Throwable)var4);
            acc = null;
            return null;
        }
        this.accList.add(acc);
        return acc;
    }

    public void delAcc(PPDRAccount acc) {
        this.accList.remove(acc);
    }

    public void handleNetworkChange() {
        try {
            logger.info("Network change detected");
            IpChangeParam ip = new IpChangeParam();
            ep.handleIpChange(ip);
        }
        catch (Exception e) {
            logger.error("Error handling network change: ", (Throwable)e);
        }
    }

    public void deinit() {
        Runtime.getRuntime().gc();
        try {
            ep.libDestroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ep.delete();
        ep = null;
    }
}

