/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.bootstrap.UsersDbConfiguration;
import com.coraltele.ppdrconference.helper.UserRowMapper;
import com.coraltele.ppdrconference.model.AuthUser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    private static final Logger logger = LogManager.getLogger(UserService.class);
    private final UsersDbConfiguration usersDbConfiguration = new UsersDbConfiguration();
    private final JdbcTemplate jdbcTemplate = this.usersDbConfiguration.usersJdbcTemplate();

    public String retrieveUser(String ipAddress, String apiKey) {
        try {
            String sql = "select username, ipaddress, key_value FROM m_user WHERE key_value = ?";
            AuthUser user = (AuthUser)this.jdbcTemplate.queryForObject(sql, (RowMapper)new UserRowMapper(), new Object[]{apiKey});
            if (user != null && user.getIpAddress() != null) {
                if (ipAddress.equals(user.getIpAddress()) || "all-ip".equals(user.getIpAddress())) {
                    logger.info("User authenticated successfully: {} from IP: {}", (Object)user.getUsername(), (Object)ipAddress);
                    return user.getUsername();
                }
                logger.warn("IP address mismatch for user: {} - Expected: {}, Actual: {}", (Object)user.getUsername(), (Object)user.getIpAddress(), (Object)ipAddress);
                return null;
            }
            logger.warn("User found but IP address is null for API key: {}", (Object)apiKey);
            return null;
        }
        catch (EmptyResultDataAccessException e) {
            logger.warn("No user found with API key: {}", (Object)apiKey);
            return null;
        }
        catch (Exception e) {
            logger.error("Error retrieving user with API key: {} - Error: {}", (Object)apiKey, (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

