/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.service.PTTEventMonitorService;
import com.coraltele.ppdrconference.service.SIPServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Telephony {
    private static final Logger logger = LogManager.getLogger(Telephony.class);
    @Autowired
    SIPServer sipServer;
    @Autowired
    PTTEventMonitorService pttEventMonitorService;

    public void unMuteParticipant(String correlationId, String conferenceId, String participantId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.MEDIA_CONTROL_UN_MUTE, (Object)conferenceId, (Object)participantId);
        this.pttEventMonitorService.triggerEvent(correlationId, conferenceId, 1, Constants.DISCONNECT_DURATION, participantId, true);
    }

    public void muteParticipant(String correlationId, String conferenceId, String participantId, boolean isPTTTaken) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.MEDIA_CONTROL_MUTE, (Object)conferenceId, (Object)participantId);
        this.pttEventMonitorService.triggerEvent(conferenceId, conferenceId, 0, Constants.DISCONNECT_DURATION, participantId, isPTTTaken);
    }

    public void participantJoinConference(String correlationId, String conferenceId, String participantId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.MEDIA_CONTROL_JOIN_GROUP, (Object)conferenceId, (Object)participantId);
        this.pttEventMonitorService.triggerEvent(correlationId, conferenceId, 2, Constants.DISCONNECT_DURATION, participantId, false);
    }

    public void shiftConference(String correlationId, String conferenceId, String participantId, boolean isPTTTaken) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.MEDIA_CONTROL_CHANGE_GROUP, (Object)conferenceId, (Object)participantId);
        this.pttEventMonitorService.triggerEvent(correlationId, conferenceId, 2, Constants.DISCONNECT_DURATION, participantId, isPTTTaken);
    }

    public void syncParticipants(String correlationId, String conferenceId, String participantId, boolean isPTTTaken) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.MEDIA_CONTROL_CHECK_MEDIA_SESSION, (Object)conferenceId, (Object)participantId);
        this.pttEventMonitorService.triggerEvent(correlationId, conferenceId, 3, Constants.DISCONNECT_DURATION, participantId, isPTTTaken);
    }

    public void haveTheFloorUpdate(String correlationId, String conferenceId, String participantId, boolean isPTTTaken) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.MEDIA_CONTROL_CHECK_MEDIA_SESSION, (Object)conferenceId, (Object)participantId);
        this.pttEventMonitorService.triggerEvent(correlationId, conferenceId, 4, Constants.DISCONNECT_DURATION, participantId, isPTTTaken);
    }
}

