/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.condition.EnableSimulation;
import com.coraltele.ppdrconference.entity.Conference;
import com.coraltele.ppdrconference.entity.Participant;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.repository.ConferenceRepository;
import com.coraltele.ppdrconference.repository.ParticipantsRepository;
import com.coraltele.ppdrconference.service.RTCPServerService;
import com.coraltele.ppdrconference.service.Telephony;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Conditional(value={EnableSimulation.class})
public class SimulationService {
    private static final Logger logger = LogManager.getLogger(SimulationService.class);
    private static final Integer MAX_THREADS = 10;
    @Autowired
    ConferenceRepository conferenceRepository;
    @Autowired
    ParticipantsRepository participantsRepository;
    @Autowired
    Telephony telephony;
    @Autowired
    RTCPServerService rtcpServerService;
    private Random random = new Random();
    ExecutorService threadPool = Executors.newFixedThreadPool(MAX_THREADS);

    @PostConstruct
    public void init() {
        logger.info("Simulation Service is enabled");
    }

    @Scheduled(fixedRate=5000L)
    private void simulateConferences() {
        if (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            logger.info("Maximum Threads : {}, Active Thread {}, Looking for Idle Conferences ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
            ArrayList idleConference = new ArrayList();
            ArrayList pttPendingConference = new ArrayList();
            Long currentEpoch = Instant.now().getEpochSecond();
            this.conferenceRepository.findByEnableSimulation(Boolean.valueOf(true)).forEach(conference -> {
                Long nextPTTEpoch = conference.getNextPTTEpoch() == null ? 0L : conference.getNextPTTEpoch();
                if (nextPTTEpoch == 0L) {
                    idleConference.add(conference);
                } else if (currentEpoch >= nextPTTEpoch) {
                    pttPendingConference.add(conference);
                }
            });
            if (!idleConference.isEmpty()) {
                Integer randomConference = this.getRandomNumber(0, idleConference.size() - 1);
                Long nextPTTEpoch = (long)this.getRandomNumber(10, 20).intValue() + Instant.now().getEpochSecond();
                String conferenceId = ((Conference)idleConference.get(randomConference)).getConferenceNo();
                String forceParticipantId = ((Conference)idleConference.get(randomConference)).getAssignSimulatedFloorTo();
                ((Conference)idleConference.get(randomConference)).setNextPTTEpoch(nextPTTEpoch);
                this.conferenceRepository.save((Object)((Conference)idleConference.get(randomConference)));
                logger.info("Starting Conference Monitoring");
                this.threadPool.execute(() -> this.initiateGroupCall(conferenceId, forceParticipantId));
            } else {
                logger.info("No Idle Conferences found, Looking for Active Conferences");
            }
            for (Conference pttConference : pttPendingConference) {
                Long nextPTTEpoch = (long)this.getRandomNumber(10, 60).intValue() + Instant.now().getEpochSecond();
                String conferenceId = pttConference.getConferenceNo();
                String forceParticipantId = pttConference.getAssignSimulatedFloorTo();
                pttConference.setNextPTTEpoch(nextPTTEpoch);
                this.conferenceRepository.save((Object)pttConference);
                this.threadPool.execute(() -> this.initiateGroupCall(conferenceId, forceParticipantId));
            }
        }
        logger.info("Conference Threads started {}", (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
    }

    private void initiateGroupCall(String conferenceId, String forceParticipantId) {
        logger.info("EventId={} GroupId={} Force to ParticipantId={} ", (Object)Constants.EVENT.SIMULATION_INITIATE_GROUP_CALL, (Object)conferenceId, (Object)forceParticipantId);
        String participantNo = StringUtils.hasText((String)forceParticipantId) ? forceParticipantId : "";
        List participants = this.participantsRepository.findByJoinConference(conferenceId);
        if (!StringUtils.hasText((String)participantNo)) {
            Integer randomParticipant = this.getRandomNumber(0, participants.size() - 1);
            participantNo = ((Participant)participants.get(randomParticipant)).getParticipantNo();
        }
        String finalParticipantNo = participantNo;
        String correlationId = UUID.randomUUID().toString();
        participants.forEach(participant -> {
            Integer randomCount = this.getRandomNumber(5, 100);
            if (randomCount % 2 == 0) {
                logger.info("EventId={} GroupId={} ParticipantId={} EventUUID={}", (Object)Constants.EVENT.SIMULATION_CALL_PARTICIPANT, (Object)conferenceId, (Object)participant.getParticipantNo(), (Object)correlationId);
                this.telephony.syncParticipants(correlationId, conferenceId, participant.getParticipantNo(), true);
            }
            if (participant.getParticipantNo().equals(finalParticipantNo)) {
                this.generatePTT(conferenceId, finalParticipantNo);
            }
        });
    }

    private void generatePTT(String conferenceId, String participantNo) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.SIMULATION_ASSIGN_FLOOR, (Object)conferenceId, (Object)participantNo);
        this.rtcpServerService.requestFloor(participantNo, conferenceId);
        Integer randomTime = this.getRandomNumber(5, 15);
        try {
            Thread.sleep((long)randomTime.intValue() * 1000L);
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.SIMULATION_RELEASE_FLOOR, (Object)conferenceId, (Object)participantNo);
            this.rtcpServerService.releaseFloor(participantNo, conferenceId);
        }
        catch (InterruptedException e) {
            logger.error("Error in generating PTT", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private synchronized Integer getRandomNumber(int min, int max) {
        return this.random.nextInt(max - min + 1) + min;
    }
}

