/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.helper.EnqueueTask;
import com.coraltele.ppdrconference.service.ChannelInfo;
import com.coraltele.ppdrconference.service.PTTEventMonitorService;
import com.coraltele.ppdrconference.service.RTCPServerService;
import com.coraltele.ppdrconference.sip.PPDRApp;
import com.coraltele.ppdrconference.sip.SIPCall;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.pjsip.pjsua2.AudioMedia;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ConferenceService {
    private static final Integer MAX_THREADS = 1;
    private static final Integer MAX_TASKS = 10;
    private ConcurrentLinkedQueue<EnqueueTask> taskQueue = new ConcurrentLinkedQueue();
    private final Lock lock = new ReentrantLock();
    private final Condition newTaskAvailable = this.lock.newCondition();
    private volatile boolean running = true;
    ExecutorService threadPool = Executors.newFixedThreadPool(MAX_THREADS);
    ExecutorService taskPool = Executors.newFixedThreadPool(MAX_TASKS);
    private static final Logger logger = LogManager.getLogger(ConferenceService.class);
    @Autowired
    PTTEventMonitorService pttEventMonitorService;
    @Autowired
    RTCPServerService rtcpServerService;
    private CopyOnWriteArrayList<ChannelInfo> callInfo = new CopyOnWriteArrayList();
    public volatile boolean isSyncDone = false;

    @Scheduled(fixedRate=5000L)
    public void startHealthCheck() throws InterruptedException {
        logger.debug("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        if (!this.isSyncDone) {
            if (Constants.ppdrApp.get() == null) {
                logger.debug("PPDR App Configuration is null, waiting for configuration to be loaded");
                return;
            }
            while ((long)this.callInfo.size() < ((PPDRApp)Constants.ppdrApp.get()).uaConfiguration.getMaxCalls()) {
                this.callInfo.add(new ChannelInfo());
            }
            this.isSyncDone = true;
            logger.debug("Conference Channel Info Initialized {}", (Object)this.callInfo.size());
        }
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            threadsStarted = threadsStarted + 1;
            logger.debug("Starting Conference Thread");
            this.threadPool.execute(() -> this.executeQueuedTasks());
        }
        logger.debug("{} Conference Threads started", (Object)threadsStarted);
    }

    public void startCall(SIPCall sipCall, String callGroup, Integer id, String callId, String callType, String callDirection, String remotePartyNumber, String remotePartyName, Boolean hasVideo, Integer callState, Boolean isDispatcher) {
        logger.info("EventId={} GroupId={} ParticipantId={} ChannelNumber={} CallId={}", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)callGroup, (Object)remotePartyNumber, (Object)id, (Object)callId);
        ChannelInfo channelInfo = (ChannelInfo)this.callInfo.get(id);
        channelInfo.startCall(sipCall, callGroup, callId, callType, callDirection, remotePartyNumber, remotePartyName, hasVideo, callState, isDispatcher);
    }

    public void updateCallState(Integer id, Integer callState) {
        ChannelInfo channelInfo = (ChannelInfo)this.callInfo.get(id);
        logger.info("EventId={} GroupId={} ParticipantId={} ChannelNumber={} CallId={} CallState={}", (Object)Constants.EVENT.CONFERENCE_UPDATE_CALL, (Object)channelInfo.getCallGroup(), (Object)channelInfo.getRemotePartyNumber(), (Object)id, (Object)channelInfo.getCallId(), (Object)callState);
        channelInfo.setCallState(callState);
    }

    public void answerCall(Integer id, Integer callState) {
        ChannelInfo channelInfo = (ChannelInfo)this.callInfo.get(id);
        logger.info("EventId={} GroupId={} ParticipantId={} ChannelNumber={} CallId={} CallState={}", (Object)Constants.EVENT.CONFERENCE_ANSWER_CALL, (Object)channelInfo.getCallGroup(), (Object)channelInfo.getRemotePartyNumber(), (Object)id, (Object)channelInfo.getCallId(), (Object)callState);
        channelInfo.answerCall();
        String corelationId = UUID.randomUUID().toString();
        this.pttEventMonitorService.addGroupParticipant(corelationId, channelInfo.getCallGroup(), Constants.DISCONNECT_DURATION, channelInfo.getRemotePartyNumber(), channelInfo);
        this.rtcpServerService.updateInCall(corelationId, channelInfo.getRemotePartyNumber(), channelInfo.getCallGroup());
    }

    public void updateAudioMedia(Integer id, AudioMedia audioMedia, Boolean isReinvite) {
        ChannelInfo channelInfo = (ChannelInfo)this.callInfo.get(id);
        logger.info("EventId={} GroupId={} ParticipantId={} ChannelNumber={} CallId={}", (Object)Constants.EVENT.CONFERENCE_UPDATE_AUDIO_MEDIA, (Object)channelInfo.getCallGroup(), (Object)channelInfo.getRemotePartyNumber(), (Object)id, (Object)channelInfo.getCallId());
        channelInfo.updateAudioMedia(audioMedia);
        if (isReinvite.booleanValue()) {
            String correlationId = UUID.randomUUID().toString();
            String callGroup = channelInfo.getCallGroup();
            this.pttEventMonitorService.updateGroupMedia(correlationId, callGroup);
        }
    }

    public void disconnectChannel(int id) {
        ChannelInfo channelInfo = (ChannelInfo)this.callInfo.get(id);
        String callGroup = channelInfo.getCallGroup();
        String remotePartyNumber = channelInfo.getRemotePartyNumber();
        logger.info("EventId={} GroupId={} ParticipantId={} ChannelNumber={} CallId={}", (Object)Constants.EVENT.CONFERENCE_DISCONNECT_CALL, (Object)channelInfo.getCallGroup(), (Object)channelInfo.getRemotePartyNumber(), (Object)id, (Object)channelInfo.getCallId());
        channelInfo.disconnect();
        if (StringUtils.hasText((String)callGroup) && StringUtils.hasText((String)remotePartyNumber)) {
            String corelationId = UUID.randomUUID().toString();
            logger.debug("CorelationId : {} nullifying channel for call group {} remote party {}", (Object)corelationId, (Object)callGroup, (Object)remotePartyNumber);
            this.pttEventMonitorService.removeGroupParticipant(corelationId, callGroup, Constants.DISCONNECT_DURATION, remotePartyNumber);
            this.rtcpServerService.callEnded(corelationId, remotePartyNumber, callGroup);
        } else {
            logger.debug("Unable to process disconnect call for channel {}", (Object)id);
        }
    }

    public void enqueueTask(String correlationId, Runnable task) {
        this.taskQueue.offer(new EnqueueTask(task, correlationId));
        this.lock.lock();
        try {
            this.newTaskAvailable.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void joinConference(String participantId, String conferenceId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.CONFERENCE_DTMF_JOIN_CONFERENCE, (Object)conferenceId, (Object)participantId);
        this.rtcpServerService.joinSessionAnalogue(participantId, conferenceId);
    }

    public void requestPTT(String participantId, String conferenceId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.CONFERENCE_DTMF_REQUEST_PTT, (Object)conferenceId, (Object)participantId);
        this.rtcpServerService.requestFloor(participantId, conferenceId);
    }

    public void releasePTT(String participantId, String conferenceId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.CONFERENCE_DTMF_RELEASE_PTT, (Object)conferenceId, (Object)participantId);
        this.rtcpServerService.releaseFloor(participantId, conferenceId);
    }

    private void executeQueuedTasks() {
        this.lock.lock();
        while (this.running) {
            logger.debug("Waiting for task");
            this.lock.lock();
            try {
                while (this.taskQueue.isEmpty()) {
                    this.newTaskAvailable.await();
                }
                Boolean hasTask = true;
                while (Boolean.TRUE.equals(hasTask)) {
                    EnqueueTask task = (EnqueueTask)this.taskQueue.poll();
                    hasTask = task != null;
                    if (!Boolean.TRUE.equals(hasTask)) continue;
                    this.taskPool.submit(() -> this.executeTask(task));
                }
            }
            catch (InterruptedException e) {
                logger.error("Conference Service Thread Interrupted", (Throwable)e);
                this.lock.unlock();
                Thread.currentThread().interrupt();
                break;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void executeTask(EnqueueTask task) {
        PPDRApp.checkThread((String)("PJ-" + Thread.currentThread().getName()));
        ThreadContext.put((String)"correlationId", (String)task.correlationId);
        try {
            task.runnable.run();
        }
        catch (Exception e) {
            logger.error("Error executing task", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
    }
}

