/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.entity.Channel;
import com.coraltele.ppdrconference.entity.Conference;
import com.coraltele.ppdrconference.entity.DispatcherChannel;
import com.coraltele.ppdrconference.entity.Extension;
import com.coraltele.ppdrconference.entity.ExtensionRule;
import com.coraltele.ppdrconference.entity.Participant;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.model.AssignFloorStatus;
import com.coraltele.ppdrconference.model.ConferenceStatus;
import com.coraltele.ppdrconference.model.ParticipantExtensionModel;
import com.coraltele.ppdrconference.model.RequestResponse;
import com.coraltele.ppdrconference.repository.ChannelRepository;
import com.coraltele.ppdrconference.repository.ConferenceRepository;
import com.coraltele.ppdrconference.repository.DispatcherChannelRepository;
import com.coraltele.ppdrconference.repository.ExtensionRepository;
import com.coraltele.ppdrconference.repository.ExtensionRuleRepository;
import com.coraltele.ppdrconference.repository.MissingParticipantsRepository;
import com.coraltele.ppdrconference.repository.ParticipantsRepository;
import com.coraltele.ppdrconference.service.FloorControlHistoryService;
import com.coraltele.ppdrconference.service.SIPServer;
import com.coraltele.ppdrconference.service.Telephony;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CallStatusService {
    private static final Logger logger = LogManager.getLogger(CallStatusService.class);
    @Autowired
    ConferenceRepository conferenceRepository;
    @Autowired
    ChannelRepository channelRepository;
    @Autowired
    ParticipantsRepository participantRepository;
    @Autowired
    DispatcherChannelRepository dispatcherChannelRepository;
    @Autowired
    Telephony telephony;
    @Autowired
    SIPServer sipServer;
    @Autowired
    ExtensionRepository extensionRepository;
    @Autowired
    MissingParticipantsRepository missingParticipantsRepository;
    @Autowired
    FloorControlHistoryService floorControlHistoryService;
    @Autowired
    ExtensionRuleRepository extensionRuleRepository;

    @PostConstruct
    public void init() {
        logger.info("EventId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_STARTED);
        Constants.callStatusService.set(this);
    }

    public ConferenceStatus getCallStatus(String groupId) {
        ConferenceStatus returnValue = new ConferenceStatus();
        try {
            returnValue.setConference(this.conferenceRepository.findById((Object)groupId));
        }
        catch (Exception e) {
            logger.error("EventId={} Group={}", (Object)Constants.ERROR.UNABLE_TO_FETCH_CONFERENCE_STATUS, (Object)groupId, (Object)e);
        }
        try {
            returnValue.setActiveCalls(this.channelRepository.findByApplicationAndApplicationNumberAndParticipantType("conference", groupId, "Participant"));
        }
        catch (Exception e) {
            returnValue.setActiveCalls(new ArrayList());
            logger.error("EventId={} Group={}", (Object)Constants.ERROR.UNABLE_TO_FETCH_CHANNEL, (Object)groupId, (Object)e);
        }
        try {
            returnValue.setDispatcherChannels(this.dispatcherChannelRepository.findByJoinConference(groupId));
        }
        catch (Exception e) {
            returnValue.setDispatcherChannels(new ArrayList());
            logger.error("EventId={} Group={}", (Object)Constants.ERROR.UNABLE_TO_FETCH_DISPATCHER_CHANNEL, (Object)groupId, (Object)e);
        }
        try {
            returnValue.setMissingParticipants(this.missingParticipantsRepository.findByJoinConference(groupId));
        }
        catch (Exception e) {
            returnValue.setMissingParticipants(new ArrayList());
            logger.error("EventId={} Group={}", (Object)Constants.ERROR.UNABLE_TO_FETCH_MISSING_PARTICIPANTS, (Object)groupId, (Object)e);
        }
        return returnValue;
    }

    public void updateFloorSync(String groupId) {
        Optional conference = this.conferenceRepository.findById((Object)groupId);
        if (conference.isPresent()) {
            ((Conference)conference.get()).setFloorTakenHeartBeatEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            this.conferenceRepository.save((Object)((Conference)conference.get()));
        }
    }

    public void deleteConferenceChannels(String groupId) {
        this.channelRepository.deleteByGroupId(groupId);
        ArrayList<String> dispatcherChannelIds = new ArrayList<String>();
        List dispatcherChannels = this.dispatcherChannelRepository.findByJoinConference(groupId);
        for (DispatcherChannel dispatcherChannel : dispatcherChannels) {
            dispatcherChannelIds.add(dispatcherChannel.getUuid());
        }
        for (String uuid : dispatcherChannelIds) {
            this.channelRepository.deleteByUUID(uuid);
        }
    }

    public AssignFloorStatus assignFloor(String correlationId, String userId, String conferenceId, String accessType) {
        AssignFloorStatus returnValue = new AssignFloorStatus(false, "", "");
        try {
            String accessSessionId = UUID.randomUUID().toString();
            Optional participantValue = this.participantRepository.findById((Object)userId);
            Optional extensionRuleValue = this.extensionRuleRepository.findByParticipantNo(userId);
            if (participantValue.isPresent() && StringUtils.hasText((String)((Participant)participantValue.get()).getJoinConference())) {
                logger.debug("{} => assignFloor- Participant {} is already in conference {} : Skipping request for {}", (Object)accessSessionId, (Object)userId, (Object)((Participant)participantValue.get()).getJoinConference(), (Object)conferenceId);
                conferenceId = ((Participant)participantValue.get()).getJoinConference();
            }
            Optional conferenceValue = this.conferenceRepository.findById((Object)conferenceId);
            logger.debug("{} => assignFloor- Request for {} in conference {}", (Object)accessSessionId, (Object)userId, (Object)conferenceId);
            if (participantValue.isPresent()) {
                Integer requestAccessLevel = extensionRuleValue.isPresent() ? ((ExtensionRule)extensionRuleValue.get()).getEffectiveRank() : 0;
                logger.debug("{} => assignFloor- Request for {} in conference {} with access level {}", (Object)accessSessionId, (Object)userId, (Object)conferenceId, (Object)requestAccessLevel);
                if (conferenceValue.isPresent()) {
                    logger.debug("{} => assignFloor- Request for {} in conference {} with control with {} and access level {}", (Object)accessSessionId, (Object)userId, (Object)conferenceId, (Object)((Conference)conferenceValue.get()).getControlWith(), (Object)((Conference)conferenceValue.get()).getControlAccessLevel());
                    if (!StringUtils.hasText((String)((Conference)conferenceValue.get()).getControlWith()) || ((Conference)conferenceValue.get()).getControlWith().equals(userId)) {
                        logger.debug("{} => assignFloor- Request for {} in conference {} with control with {} and access level {}", (Object)accessSessionId, (Object)userId, (Object)conferenceId, (Object)((Conference)conferenceValue.get()).getControlWith(), (Object)((Conference)conferenceValue.get()).getControlAccessLevel());
                        ((Conference)conferenceValue.get()).setControlWith(userId);
                        ((Conference)conferenceValue.get()).setControlAccessLevel(requestAccessLevel);
                        ((Conference)conferenceValue.get()).setAccessType(accessType);
                        ((Conference)conferenceValue.get()).setSessionId(accessSessionId);
                        Long currentEpoch = Instant.now().getEpochSecond();
                        ((Conference)conferenceValue.get()).setFloorTakenEpoch(currentEpoch);
                        ((Conference)conferenceValue.get()).setFloorReleaseEpoch(Long.valueOf(0L));
                        ((Conference)conferenceValue.get()).setFloorTakenHeartBeatEpoch(currentEpoch);
                        ((Conference)conferenceValue.get()).setCallStartedEpoch(currentEpoch);
                        logger.debug("{} => assignFloor- Request for {} in conference {} with control with {} and access level {}", (Object)accessSessionId, (Object)userId, (Object)conferenceId, (Object)((Conference)conferenceValue.get()).getControlWith(), (Object)((Conference)conferenceValue.get()).getControlAccessLevel());
                        this.conferenceRepository.save((Object)((Conference)conferenceValue.get()));
                        logger.debug("{} => assignFloor- Request for {} in conference {} with control with {} and access level {}", (Object)accessSessionId, (Object)userId, (Object)conferenceId, (Object)((Conference)conferenceValue.get()).getControlWith(), (Object)((Conference)conferenceValue.get()).getControlAccessLevel());
                        this.telephony.unMuteParticipant(correlationId, conferenceId, userId);
                        logger.debug("{} => assignFloor- Request for {} in conference {} with control with {} and access level {}", (Object)accessSessionId, (Object)userId, (Object)conferenceId, (Object)((Conference)conferenceValue.get()).getControlWith(), (Object)((Conference)conferenceValue.get()).getControlAccessLevel());
                        returnValue.setAssigned(true);
                    } else {
                        logger.debug("{} => assignFloor- Request for {} in conference {} with control with {} and access level {}", (Object)accessSessionId, (Object)userId, (Object)conferenceId, (Object)((Conference)conferenceValue.get()).getControlWith(), (Object)((Conference)conferenceValue.get()).getControlAccessLevel());
                        Integer currentAccessLevel = ((Conference)conferenceValue.get()).getControlAccessLevel();
                        returnValue.setAssignedTo(((Conference)conferenceValue.get()).getControlWith());
                        if (currentAccessLevel == null) {
                            currentAccessLevel = 0;
                        }
                        logger.debug("Control With the user {} having access level {}, request from user {} having access level {}", (Object)((Conference)conferenceValue.get()).getControlWith(), (Object)((Conference)conferenceValue.get()).getControlAccessLevel(), (Object)userId, (Object)requestAccessLevel);
                        if (requestAccessLevel > currentAccessLevel) {
                            returnValue.setRevokedFrom(((Conference)conferenceValue.get()).getControlWith());
                            logger.debug("Floor Release for {} to be triggered", (Object)((Conference)conferenceValue.get()).getControlAccessLevel());
                        }
                        logger.debug("{} => assignFloor- Request for {} in conference {} with control with {} and access level {}", (Object)accessSessionId, (Object)userId, (Object)conferenceId, (Object)((Conference)conferenceValue.get()).getControlWith(), (Object)((Conference)conferenceValue.get()).getControlAccessLevel());
                        this.telephony.syncParticipants(correlationId, conferenceId, userId, false);
                        logger.debug("{} => assignFloor- Request for {} in conference {} with control with {} and access level {}", (Object)accessSessionId, (Object)userId, (Object)conferenceId, (Object)((Conference)conferenceValue.get()).getControlWith(), (Object)((Conference)conferenceValue.get()).getControlAccessLevel());
                    }
                }
            } else {
                logger.debug("Floor Request Received for group {} by {} but user {} does not exist", (Object)conferenceId, (Object)userId, (Object)userId);
            }
        }
        catch (Exception e) {
            logger.error("Error in Unable to assign floor to {} for conference {}", (Object)userId, (Object)conferenceId, (Object)e);
        }
        return returnValue;
    }

    public void updateDispatcherCallJoinEpoch(String groupId, String dispatcherParticipantId, long dispatcherCallJoinEpoch) {
        Optional conference = this.conferenceRepository.findById((Object)groupId);
        if (conference.isPresent()) {
            ((Conference)conference.get()).setDispatcherParticipantId(dispatcherParticipantId);
            ((Conference)conference.get()).setCallStartedEpoch(Long.valueOf(dispatcherCallJoinEpoch));
            ((Conference)conference.get()).setDispatcherJoinEpoch(Long.valueOf(dispatcherCallJoinEpoch));
            ((Conference)conference.get()).setIsDispatcherInCall(Boolean.valueOf(true));
            this.conferenceRepository.save((Object)((Conference)conference.get()));
        }
    }

    public void updateDispatcherLeftTheCall(String groupId) {
        Optional conference = this.conferenceRepository.findById((Object)groupId);
        if (conference.isPresent()) {
            ((Conference)conference.get()).setDispatcherJoinEpoch(Long.valueOf(0L));
            ((Conference)conference.get()).setIsDispatcherInCall(Boolean.valueOf(false));
            if (!StringUtils.hasText((String)((Conference)conference.get()).getControlWith())) {
                ((Conference)conference.get()).setFloorReleaseEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            }
            this.conferenceRepository.save((Object)((Conference)conference.get()));
        }
    }

    public void joinConference(String activeParticipant, String conferenceId, String participantId) {
        String participantName = activeParticipant;
        String conferenceParameters = "";
        ParticipantExtensionModel participantExtensionModel = this.getParticipantExtensionDetails(participantId);
        if (participantExtensionModel.getExtensionSubType().isEmpty() || participantExtensionModel.getExtensionSubType().equals("voip")) {
            participantName = activeParticipant.equals(participantId) ? "YOU" : participantExtensionModel.getDesignation();
            if (Boolean.TRUE.equals(Constants.ENABLE_MUTE_CONTROL != false && !activeParticipant.equals(participantId))) {
                conferenceParameters = "+flags{mute}";
            }
            String cmd = "originate {sip_h_X-call_Type=group,sip_h_X-control_with=" + activeParticipant + "-" + participantName + ",origination_uuid=" + UUID.randomUUID().toString() + ",ignore_early_media=true,origination_caller_id_number=" + conferenceId + ",absolute_codec_string='" + Constants.MEDIA_MUX_SERVER_CODEC + "',origination_caller_id_name=" + conferenceId + "}" + Constants.DIAL_STRING.replace("#participantId", participantId) + " &conference(" + conferenceId + "@" + Constants.MEDIA_MUX_SERVER_CONFERENCE_PROFILE + conferenceParameters + ")";
            logger.info("EventId={} Participant={} Conference={} OriginateCommand={}", (Object)Constants.EVENT.ORIGINATE_COMMAND, (Object)participantId, (Object)conferenceId, (Object)cmd);
            this.sipServer.executeCommandAsync("", "bgapi", cmd);
        } else {
            logger.info("EventId={} Participant={} Conference={} OriginateCommand={}, ExtensionSubType={}", (Object)Constants.EVENT.ORIGINATE_COMMAND, (Object)participantId, (Object)conferenceId, (Object)"Participant is not VoIP", (Object)participantExtensionModel.getExtensionSubType());
        }
    }

    public void stopMediaTransmission(String groupId, Boolean isDispatcher, String dispatcherParticipantId) {
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.STOP_MEDIA_TRANSMISSION_ON_SIP_SERVER, (Object)groupId);
        String status = "idle-IDLE";
        String enableMuteControl = Constants.ENABLE_MUTE_CONTROL != false ? "yes" : "no";
        List groupChannels = this.channelRepository.findByApplicationAndApplicationNumberAndParticipantType("conference", groupId, "Participant");
        Map conferenceMembers = this.sipServer.getConferenceMembers(groupId);
        if (Boolean.TRUE.equals(isDispatcher)) {
            status = dispatcherParticipantId + "-" + this.getParticipantExtensionDetails(dispatcherParticipantId).getDesignation();
        }
        String muteStatus = "mute";
        for (Channel channel : groupChannels) {
            if (Constants.DISCONNECT_WHEN_IDLE.booleanValue()) {
                logger.info("EventId={} Participant={} Conference={} OriginateCommand={}", (Object)Constants.EVENT.ORIGINATE_COMMAND, (Object)channel.getInitialCallerIdNumber(), (Object)groupId, (Object)("uuid_kill " + channel.getUuid()));
                this.sipServer.executeCommandAsync("", "bgapi", "uuid_kill " + channel.getUuid());
                continue;
            }
            Integer memberId = (Integer)conferenceMembers.get(channel.getUuid());
            ParticipantExtensionModel participantExtensionModel = this.getParticipantExtensionDetails(channel.getInitialCallerIdNumber());
            if (memberId == null) {
                memberId = -1;
            }
            String cmd = "luarun " + Constants.PPDR_SESSION_CONTROL_FILE + " " + channel.getUuid() + " " + status + " " + enableMuteControl + " " + groupId + " " + memberId + " " + (Boolean.TRUE.equals(participantExtensionModel.getDisableMuteControl()) ? "unmute" : muteStatus);
            logger.info("EventId={} Participant={} Conference={} OriginateCommand={}", (Object)Constants.EVENT.ORIGINATE_COMMAND, (Object)channel.getInitialCallerIdNumber(), (Object)groupId, (Object)cmd);
            this.sipServer.executeCommandAsync("", "bgapi", cmd);
        }
    }

    public void startMediaTransmission(String groupId, String participantId) {
        logger.info("EventId={} GroupId={} participantId={}", (Object)Constants.EVENT.START_MEDIA_TRANSMISSION_ON_SIP_SERVER, (Object)groupId, (Object)participantId);
        String enableMuteControl = Constants.ENABLE_MUTE_CONTROL != false ? "yes" : "no";
        List groupChannels = this.channelRepository.findByApplicationAndApplicationNumberAndParticipantType("conference", groupId, "Participant");
        ParticipantExtensionModel participantExtensionModel = this.getParticipantExtensionDetails(participantId);
        String participantName = participantExtensionModel.getDesignation();
        Map conferenceMembers = this.sipServer.getConferenceMembers(groupId);
        for (Channel channel : groupChannels) {
            String initialDestinationNumber = StringUtils.hasText((String)channel.getCallerIdNumber()) ? channel.getCallerIdNumber() : "";
            Integer memberId = (Integer)conferenceMembers.get(channel.getUuid());
            if (memberId == null) {
                memberId = -1;
            }
            String cmd = "luarun " + Constants.PPDR_SESSION_CONTROL_FILE + " " + channel.getUuid() + " " + participantId + "-" + (initialDestinationNumber.equals(participantId) ? "YOU" : participantName) + " " + enableMuteControl + " " + groupId + " " + memberId + " " + (initialDestinationNumber.equals(participantId) || Boolean.TRUE.equals(participantExtensionModel.getDisableMuteControl()) ? "unmute" : "mute");
            logger.info("EventId={} Participant={} Conference={} OriginateCommand={}", (Object)Constants.EVENT.ORIGINATE_COMMAND, (Object)channel.getInitialCallerIdNumber(), (Object)groupId, (Object)cmd);
            this.sipServer.executeCommandAsync("", "bgapi", cmd);
        }
    }

    public ParticipantExtensionModel getParticipantExtensionDetails(String extensionNumber) {
        List extensions = this.extensionRepository.findByExtensionNumber(extensionNumber);
        if (extensions != null && !extensions.isEmpty()) {
            String designation = ((Extension)extensions.get(0)).getDesignation();
            String model = ((Extension)extensions.get(0)).getParticipantType();
            if (model == null) {
                model = "";
            }
            designation = StringUtils.hasText((String)designation) ? designation : extensionNumber;
            designation = designation.replace(" ", "_");
            return new ParticipantExtensionModel(designation, StringUtils.hasText((String)((Extension)extensions.get(0)).getExtensionSubType()) ? ((Extension)extensions.get(0)).getExtensionSubType() : "", Boolean.valueOf(model.equalsIgnoreCase("uhf/vhf")));
        }
        return new ParticipantExtensionModel(extensionNumber, "", Boolean.valueOf(false));
    }

    public void dropConferenceChannelIfExists(String subscriber) {
        logger.info("EventId={} Channel={}", (Object)Constants.EVENT.DROP_CHANNEL_IF_EXISTS, (Object)subscriber);
        ArrayList uuids = new ArrayList();
        this.channelRepository.findByCallerIdNumber(subscriber).forEach(channel -> {
            if (channel.getApplication().equals("conference")) {
                uuids.add(channel.getUuid());
            }
        });
        for (String uuid : uuids) {
            logger.info("EventId={} Channel={}", (Object)Constants.EVENT.DROP_CHANNEL, (Object)uuid);
            this.sipServer.executeCommandAsync("", "bgapi", "uuid_kill " + uuid);
        }
    }

    public RequestResponse updateVideoStreamControlStatus(String correlationId, String userId, String conferenceId, Boolean controlStatus) {
        RequestResponse returnValue = new RequestResponse();
        try {
            logger.info("EventId={} UserId={} ConferenceId={}", (Object)Constants.EVENT.UPDATE_VIDEO_STREAM_STATUS_REQUEST_RECEIVED, (Object)userId, (Object)conferenceId);
            Optional extensionRuleValue = this.extensionRuleRepository.findByParticipantNo(userId);
            if (!extensionRuleValue.isPresent()) {
                logger.info("EventId={} UserId={} ConferenceId={} - No Extension Rule found", (Object)Constants.EVENT.UPDATE_VIDEO_STREAM_STATUS_REQUEST_RECEIVED, (Object)userId, (Object)conferenceId);
                returnValue.setStatus(Integer.valueOf(-1));
                returnValue.setMessage("No Extension Rule found for participant");
                return returnValue;
            }
            if (controlStatus.booleanValue() && !((ExtensionRule)extensionRuleValue.get()).getH264Support().booleanValue()) {
                logger.info("EventId={} UserId={} ConferenceId={} - Participant not allowed to start video stream", (Object)Constants.EVENT.UPDATE_VIDEO_STREAM_STATUS_REQUEST_RECEIVED, (Object)userId, (Object)conferenceId);
                returnValue.setStatus(Integer.valueOf(-1));
                returnValue.setMessage("Participant not allowed to start video stream");
                return returnValue;
            }
            Optional participantValue = this.participantRepository.findById((Object)userId);
            Optional conferenceValue = this.conferenceRepository.findById((Object)conferenceId);
            if (!participantValue.isPresent() || !StringUtils.hasText((String)((Participant)participantValue.get()).getJoinConference())) {
                returnValue.setStatus(Integer.valueOf(-1));
                returnValue.setMessage("Participant not in conference");
                return returnValue;
            }
            logger.debug("updateVideoStreamStatus- Participant {} is already in conference {}", (Object)userId, (Object)((Participant)participantValue.get()).getJoinConference());
            conferenceId = ((Participant)participantValue.get()).getJoinConference();
            if (!conferenceValue.isPresent()) {
                returnValue.setStatus(Integer.valueOf(-1));
                returnValue.setMessage("Conference does not exist");
                return returnValue;
            }
            Conference conference = (Conference)conferenceValue.get();
            if (controlStatus.booleanValue()) {
                logger.info("EventId={} UserId={} ConferenceId={}", (Object)Constants.EVENT.PROCESSING_VIDEO_STREAM_START, (Object)userId, (Object)conferenceId);
                if (StringUtils.hasText((String)conference.getVideoStreamControlWith())) {
                    returnValue.setStatus(Integer.valueOf(-1));
                    returnValue.setMessage("Video Stream already active by " + conference.getVideoStreamControlWith());
                    return returnValue;
                }
                this.conferenceRepository.updateGroupStreamControlStatus(conferenceId, userId, Long.valueOf(Instant.now().getEpochSecond()));
            } else {
                logger.info("EventId={} UserId={} ConferenceId={}", (Object)Constants.EVENT.PROCESSING_VIDEO_STREAM_STOP, (Object)userId, (Object)conferenceId);
                if (!StringUtils.hasText((String)conference.getVideoStreamControlWith()) || !conference.getVideoStreamControlWith().equals(userId)) {
                    returnValue.setStatus(Integer.valueOf(-1));
                    returnValue.setMessage("Unable to stop Video Stream not controlled by " + userId + ", stream is controlled by " + conference.getVideoStreamControlWith());
                    return returnValue;
                }
                this.conferenceRepository.updateGroupStreamControlStatus(conferenceId, "", Long.valueOf(0L));
            }
            returnValue.setStatus(Integer.valueOf(0));
        }
        catch (Exception e) {
            logger.error("Error in Unable to update video stream status for {} for conference {}", (Object)userId, (Object)conferenceId, (Object)e);
            returnValue.setStatus(Integer.valueOf(-1));
            returnValue.setMessage(e.getMessage());
        }
        return returnValue;
    }
}

