/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.ptt;

import com.coraltele.ppdrconference.entity.Channel;
import com.coraltele.ppdrconference.entity.Conference;
import com.coraltele.ppdrconference.entity.DispatcherChannel;
import com.coraltele.ppdrconference.entity.MissingParticipant;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.model.ConferenceStatus;
import com.coraltele.ppdrconference.ptt.PTTGroup;
import com.coraltele.ppdrconference.service.CallStatusService;
import com.coraltele.ppdrconference.service.ChannelInfo;
import com.coraltele.ppdrconference.service.FloorControlHistoryService;
import com.coraltele.ppdrconference.service.RTCPServerService;
import com.coraltele.ppdrconference.service.SIPServer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class PTTExternalServerMuxType1
extends PTTGroup {
    private static final Logger logger = LogManager.getLogger(PTTExternalServerMuxType1.class);

    public PTTExternalServerMuxType1(FloorControlHistoryService floorControlHistoryService, SIPServer sipServer, String groupId, long timeoutPeriod, Boolean timerPaused) {
        super(floorControlHistoryService, sipServer, groupId, timeoutPeriod, timerPaused);
        logger.debug("PTTExternalServerMuxType1 created with groupId: {}", (Object)groupId);
        this.startMonitoring();
    }

    public synchronized void checkFloor(String participantId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.I_HAVE_FLOOR_UPDATE, (Object)this.groupId, (Object)participantId);
        ConferenceStatus conferenceStatus = this.getCallStatus();
        if (conferenceStatus == null) {
            logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_NO_CONFERENCE_OBJECT, (Object)this.groupId);
            return;
        }
        if (!conferenceStatus.getConference().isPresent()) {
            logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_NO_CONFERENCE_DETAILS, (Object)this.groupId);
            return;
        }
        Conference conference = (Conference)conferenceStatus.getConference().get();
        if (StringUtils.hasText((String)conference.getControlWith()) && conference.getControlWith().equals(participantId)) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.I_HAVE_FLOOR_SYNCED, (Object)this.groupId, (Object)participantId);
            if (Constants.callStatusService.get() != null) {
                ((CallStatusService)Constants.callStatusService.get()).updateFloorSync(this.groupId);
            }
        } else {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.I_HAVE_FLOOR_NOT_SYNCED, (Object)this.groupId, (Object)participantId);
        }
    }

    public void onEventTriggered(Boolean timerPaused) {
        logger.info("EventId={} GroupId={} TimerPaused={}", (Object)Constants.EVENT.GROUP_TIMER_EVENT, (Object)this.groupId, (Object)timerPaused);
    }

    public void addParticipant(String correlationId, String participantId, ChannelInfo channelInfo) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_ADDING_PARTICIPANT, (Object)this.groupId, (Object)participantId);
    }

    public void participantShifted(String participantId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_PARTICIPANT_SHIFTED, (Object)this.groupId, (Object)participantId);
    }

    public void removeParticipant(String participantId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_REMOVE_PARTICIPANT, (Object)this.groupId, (Object)participantId);
    }

    public void checkSessions(String correlationId, String participantId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_EVENT_CHECK_PARTICIPANT_SESSION, (Object)this.groupId, (Object)participantId);
        this.sendRequestToParticipantToJoinConference(correlationId, participantId);
    }

    public void checkSessionsDispatcher(String correlationId, String participantId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_EVENT_CHECK_PARTICIPANT_SESSION_DISPATCHER, (Object)this.groupId, (Object)participantId);
    }

    public void startMediaTransmission(String correlationId, String participantId) {
        logger.info("EventId={} GroupId={} ParticipantId={} Cause={}", (Object)Constants.EVENT.GROUP_START_MEDIA_TRANSMISSION, (Object)this.groupId, (Object)participantId, (Object)Constants.CAUSE.FLOOR_ASSIGNED);
        this.sendRequestToParticipantToJoinConference(correlationId, "");
        if (Constants.rtcpServerService.get() != null) {
            ConferenceStatus conferenceStatus = this.getCallStatus();
            if (conferenceStatus == null) {
                logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_NO_CONFERENCE_OBJECT, (Object)this.groupId);
                return;
            }
            if (!conferenceStatus.getConference().isPresent()) {
                logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_NO_CONFERENCE_DETAILS, (Object)this.groupId);
                return;
            }
            Conference conference = (Conference)conferenceStatus.getConference().get();
            if (!StringUtils.hasText((String)conference.getControlWith()) && !this.isDispatcherInCall) {
                logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.FLOOR_NOT_ASSIGNED, (Object)this.groupId);
                return;
            }
            ((CallStatusService)Constants.callStatusService.get()).startMediaTransmission(this.groupId, conference.getControlWith());
        }
    }

    public void stopMediaTransmission(String correlationId, String participantId) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_STOP_MEDIA_TRANSMISSION, (Object)this.groupId, (Object)participantId);
        if (Constants.rtcpServerService.get() != null) {
            ConferenceStatus conferenceStatus = this.getCallStatus();
            if (conferenceStatus == null) {
                logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_NO_CONFERENCE_OBJECT, (Object)this.groupId);
                return;
            }
            if (!conferenceStatus.getConference().isPresent()) {
                logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_NO_CONFERENCE_DETAILS, (Object)this.groupId);
                return;
            }
            Conference conference = (Conference)conferenceStatus.getConference().get();
            ((CallStatusService)Constants.callStatusService.get()).stopMediaTransmission(this.groupId, Boolean.valueOf(this.isDispatcherInCall), this.dispatcherParticipantId);
        }
    }

    private void startMonitoring() {
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.GROUP_INITIATED, (Object)this.groupId);
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                long currentTime = Instant.now().getEpochSecond();
                logger.debug("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_TIMER_VALIDATION, (Object)this.groupId, (Object)this.activeParticipantId);
                ConferenceStatus conferenceStatus = this.getCallStatus();
                if (conferenceStatus == null) {
                    logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_NO_CONFERENCE_OBJECT, (Object)this.groupId);
                    return;
                }
                if (!conferenceStatus.getConference().isPresent()) {
                    logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_NO_CONFERENCE_DETAILS, (Object)this.groupId);
                    return;
                }
                Conference conference = (Conference)conferenceStatus.getConference().get();
                this.checkIsDispatcher(conferenceStatus);
                ++this.registrationCheck;
                if (conference.getCallStartedEpoch() > 0L) {
                    this.transmitFloorStatus(conference);
                    this.checkTimeout(conferenceStatus, conference, currentTime);
                }
            }
            catch (Exception e) {
                logger.error("EventId={} GroupId={} Exception={}", (Object)Constants.EVENT.GROUP_TIMER_VALIDATION, (Object)this.groupId, (Object)e);
            }
        }, 0L, 2L, TimeUnit.SECONDS);
    }

    private void sendMessageToMissingParticipants(ConferenceStatus conferenceStatus) {
        if (conferenceStatus.getMissingParticipants().isEmpty()) {
            return;
        }
        for (MissingParticipant missingParticipant : conferenceStatus.getMissingParticipants()) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_MISSING_PARTICIPANT, (Object)this.groupId, (Object)missingParticipant.getParticipantNo());
            if (Constants.rtcpServerService.get() == null) continue;
            ((RTCPServerService)Constants.rtcpServerService.get()).sendMissingParticipant(this.groupId, missingParticipant.getParticipantNo());
        }
    }

    private void checkIsDispatcher(ConferenceStatus conferenceStatus) {
        if (conferenceStatus.getDispatcherChannels().isEmpty()) {
            if (this.isDispatcherInCall) {
                logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_TIMER_DISPATCHER_LEFT_THE_CALL, (Object)this.groupId, (Object)this.dispatcherParticipantId);
                if (Constants.callStatusService.get() != null) {
                    ((CallStatusService)Constants.callStatusService.get()).updateDispatcherLeftTheCall(this.groupId);
                }
            }
            this.isDispatcherInCall = false;
            this.dispatcherCallJoinEpoch = 0L;
            this.dispatcherParticipantId = "";
        } else {
            this.dispatcherParticipantId = ((DispatcherChannel)conferenceStatus.getDispatcherChannels().get(0)).getParticipantNo();
            if (!this.isDispatcherInCall) {
                logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_TIMER_JOINED_THE_CALL, (Object)this.groupId, (Object)this.dispatcherParticipantId);
                this.dispatcherCallJoinEpoch = Instant.now().getEpochSecond();
                this.isDispatcherInCall = true;
                this.sendRequestToParticipantToJoinConference(UUID.randomUUID().toString(), "");
                if (Constants.callStatusService.get() != null) {
                    ((CallStatusService)Constants.callStatusService.get()).updateDispatcherCallJoinEpoch(this.groupId, this.dispatcherParticipantId, this.dispatcherCallJoinEpoch);
                }
            }
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_TIMER_DISPATCHER_IN_CALL, (Object)this.groupId, (Object)this.dispatcherParticipantId);
        }
    }

    private void transmitFloorStatus(Conference conference) {
        if (StringUtils.hasText((String)conference.getControlWith())) {
            ((RTCPServerService)Constants.rtcpServerService.get()).sendFloorTaken(this.groupId, conference.getControlWith());
        } else if (this.isDispatcherInCall) {
            ((RTCPServerService)Constants.rtcpServerService.get()).sendFloorTaken(this.groupId, this.dispatcherParticipantId);
        } else {
            ((RTCPServerService)Constants.rtcpServerService.get()).sendFloorIdle(this.groupId);
        }
    }

    private void checkTimeout(ConferenceStatus conferenceStatus, Conference conference, long currentTime) {
        Boolean isTimeOut = false;
        if (this.isDispatcherInCall && currentTime - this.dispatcherCallJoinEpoch <= Constants.MAX_PTT_DURATION) {
            logger.info("EventId={} GroupId={} ParticipantId={} CurrentTime={} CallStartedEpoch={}", (Object)Constants.EVENT.GROUP_TIMER_MAX_CALL_DURATION_IGNORED_FOR_DISPATCHER, (Object)this.groupId, (Object)this.dispatcherParticipantId, (Object)currentTime, (Object)conference.getCallStartedEpoch());
            return;
        }
        if (StringUtils.hasText((String)conference.getControlWith()) && currentTime - conference.getCallStartedEpoch() >= Constants.MAX_PTT_DURATION) {
            logger.info("EventId={} GroupId={} ParticipantId={} CurrentTime={} CallStartedEpoch={}", (Object)Constants.EVENT.GROUP_TIMER_EXPIRED_MAX_CALL_DURATION, (Object)this.groupId, (Object)this.activeParticipantId, (Object)currentTime, (Object)conference.getCallStartedEpoch());
            isTimeOut = true;
        }
        if (!StringUtils.hasText((String)conference.getControlWith()) && currentTime - conference.getFloorReleaseEpoch() > this.timeoutPeriod) {
            logger.info("EventId={} GroupId={} ParticipantId={} CurrentTime={} FloorReleaseEpoch={}", (Object)Constants.EVENT.GROUP_TIMER_EXPIRED_PTT_WAIT_DURATION, (Object)this.groupId, (Object)this.activeParticipantId, (Object)currentTime, (Object)conference.getFloorReleaseEpoch());
            isTimeOut = true;
        }
        if (Boolean.TRUE.equals(Constants.ENFORCE_HEALTH_PACKET_TIMER) && StringUtils.hasText((String)conference.getControlWith()) && currentTime - conference.getFloorTakenHeartBeatEpoch() >= this.timeoutPeriod) {
            logger.info("EventId={} GroupId={} ParticipantId={} CurrentTime={} CallStartedEpoch={}", (Object)Constants.EVENT.GROUP_TIMER_EXPIRED_HEARTBEAT_NOT_RECEIVED, (Object)this.groupId, (Object)this.activeParticipantId, (Object)currentTime, (Object)conference.getCallStartedEpoch());
            isTimeOut = true;
        }
        if (conferenceStatus.getActiveCalls().isEmpty() && conferenceStatus.getDispatcherChannels().isEmpty()) {
            this.errorCount = this.errorCount + 1;
            if (this.errorCount >= 3) {
                logger.warn("EventId={} GroupId={} ParticipantId={} CurrentTime={} CallStartedEpoch={}", (Object)Constants.EVENT.GROUP_TIMER_CALL_IN_PROGRESS_NO_PARTICIPANT, (Object)this.groupId, (Object)this.activeParticipantId, (Object)currentTime, (Object)conference.getCallStartedEpoch());
                isTimeOut = true;
            }
        }
        if (Boolean.TRUE.equals(isTimeOut)) {
            this.errorCount = 0;
            this.onTimeout();
        }
    }

    private void onTimeout() {
        logger.info("EventId={} GroupId={} Starting call disconnect", (Object)Constants.EVENT.GROUP_EVENT_TIMEOUT, (Object)this.groupId);
        this.sendRequestToParticipantToLeaveConference("Group ID : " + this.groupId);
    }

    private void sendRequestToParticipantToJoinConference(String correlationId, String specificParticipant) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_JOIN_CONFERENCE, (Object)this.groupId, (Object)specificParticipant);
        if (Boolean.FALSE.equals(Constants.ENABLE_INVITE_FROM_SERVER)) {
            logger.info("EventId={} GroupId={} ParticipantId={} Cause={}", (Object)Constants.EVENT.GROUP_JOIN_CONFERENCE, (Object)this.groupId, (Object)specificParticipant, (Object)Constants.CAUSE.INVITE_FROM_SERVER_DISABLED);
            return;
        }
        if (Constants.rtcpServerService.get() != null) {
            ConferenceStatus conferenceStatus = this.getCallStatus();
            if (conferenceStatus == null) {
                logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_NO_CONFERENCE_OBJECT, (Object)this.groupId);
                return;
            }
            if (!conferenceStatus.getConference().isPresent()) {
                logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_NO_CONFERENCE_DETAILS, (Object)this.groupId);
                return;
            }
            Conference conference = (Conference)conferenceStatus.getConference().get();
            if (!StringUtils.hasText((String)conference.getControlWith()) && !this.isDispatcherInCall) {
                logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.FLOOR_NOT_ASSIGNED, (Object)this.groupId);
                return;
            }
            ArrayList<ChannelInfo> channelInfoList = new ArrayList<ChannelInfo>();
            for (Channel channel : conferenceStatus.getActiveCalls()) {
                ChannelInfo channelInfo = new ChannelInfo();
                channelInfo.setRemotePartyNumber(channel.getCallerIdNumber());
                channelInfo.setRemotePartyName(channel.getCallerIdNumber());
                channelInfo.setExtensionSubType(channel.getExtensionSubType());
                channelInfoList.add(channelInfo);
            }
            ((RTCPServerService)Constants.rtcpServerService.get()).joinConference(correlationId, this.groupId, channelInfoList, this.activeSessionId, this.isDispatcherInCall ? this.dispatcherParticipantId : conference.getControlWith(), specificParticipant);
        }
    }

    private void sendRequestToParticipantToLeaveConference(String correlationId) {
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.GROUP_LEAVE_CONFERENCE, (Object)this.groupId);
        if (Constants.rtcpServerService.get() != null) {
            ((RTCPServerService)Constants.rtcpServerService.get()).leaveConference(correlationId, this.groupId, this.activeSessionId);
            this.sipServer.executeCommandAsync("", "conference", " " + this.groupId + " hup all");
            ConferenceStatus conferenceStatus = this.getCallStatus();
            if (conferenceStatus == null) {
                logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_NO_CONFERENCE_OBJECT, (Object)this.groupId);
                return;
            }
            if (Constants.callStatusService.get() != null) {
                ((CallStatusService)Constants.callStatusService.get()).deleteConferenceChannels(this.groupId);
            }
        }
    }

    private ConferenceStatus getCallStatus() {
        ConferenceStatus returnValue = null;
        if (Constants.callStatusService.get() == null) {
            logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_STATUS_SERVICE_WAITING_TO_START, (Object)this.groupId);
        } else {
            returnValue = ((CallStatusService)Constants.callStatusService.get()).getCallStatus(this.groupId);
        }
        return returnValue;
    }

    public void updateMediaTransmission(String correlationId) {
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.GROUP_MEDIA_UPDATE, (Object)this.groupId);
    }
}

