/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.ptt;

import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.helper.MediaSessionManager;
import com.coraltele.ppdrconference.ptt.PTTGroup;
import com.coraltele.ppdrconference.service.ChannelInfo;
import com.coraltele.ppdrconference.service.FloorControlHistoryService;
import com.coraltele.ppdrconference.service.RTCPServerService;
import com.coraltele.ppdrconference.service.SIPServer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class PTTExternalChannel
extends PTTGroup {
    private static final Logger logger = LogManager.getLogger(PTTExternalChannel.class);
    private final MediaSessionManager sessionManager;

    public PTTExternalChannel(FloorControlHistoryService floorControlHistoryService, SIPServer sipServer, String groupId, long timeoutPeriod, Boolean timerPaused) {
        super(floorControlHistoryService, sipServer, groupId, timeoutPeriod, timerPaused);
        this.sessionManager = new MediaSessionManager(floorControlHistoryService, groupId);
        this.startMonitoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFloor(String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            if (StringUtils.hasText((String)this.activeParticipantId) && this.activeParticipantId.equals(participantId)) {
                logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.I_HAVE_FLOOR_UPDATE, (Object)this.groupId, (Object)participantId);
                this.haveFloorUpdate = System.currentTimeMillis();
            }
        }
    }

    public void onEventTriggered(Boolean timerPaused) {
        logger.info("EventId={} GroupId={} TimerPaused={}", (Object)Constants.EVENT.GROUP_TIMER_EVENT, (Object)this.groupId, (Object)timerPaused);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipant(String correlationId, String participantId, ChannelInfo channelInfo) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_ADDING_PARTICIPANT, (Object)this.groupId, (Object)participantId);
            this.lastEventTimestamp = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void participantShifted(String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_PARTICIPANT_SHIFTED, (Object)this.groupId, (Object)participantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipant(String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_REMOVE_PARTICIPANT, (Object)this.groupId, (Object)participantId);
            if (!this.participants.containsKey(participantId)) {
                logger.error("EventId={} GroupId={} ParticipantId={} Cause={}", (Object)Constants.EVENT.GROUP_REMOVE_PARTICIPANT, (Object)this.groupId, (Object)participantId, (Object)Constants.CAUSE.PARTICIPANT_NOT_PRESENT);
                return;
            }
            this.participants.remove(participantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSessions(String correlationId, String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_EVENT_CHECK_PARTICIPANT_SESSION, (Object)this.groupId, (Object)participantId);
            logger.info("EventId={} GroupId={} ParticipantId={}, Ignoring the call", (Object)Constants.EVENT.GROUP_JOIN_CONFERENCE, (Object)this.groupId, (Object)participantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSessionsDispatcher(String correlationId, String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_EVENT_CHECK_PARTICIPANT_SESSION_DISPATCHER, (Object)this.groupId, (Object)participantId);
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_JOIN_CONFERENCE, (Object)this.groupId, (Object)"");
            if (Constants.rtcpServerService.get() != null) {
                ArrayList channelInfoList = new ArrayList(this.participants.values());
                ((RTCPServerService)Constants.rtcpServerService.get()).joinConference(correlationId, this.groupId, channelInfoList, this.activeSessionId, participantId, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMediaTransmission(String correlationId, String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            this.callStartedOn = System.currentTimeMillis();
            this.activeParticipantId = participantId;
            this.haveFloorUpdate = this.callStartedOn;
            String transmissionId = this.sessionManager.startTransmission(participantId);
            this.sendRequestToParticipantToJoinConference(correlationId, "");
            logger.info("EventId={} GroupId={} ParticipantId={} TransmissionId={} SessionParticipant={} Cause={}", (Object)Constants.EVENT.GROUP_START_MEDIA_TRANSMISSION, (Object)this.groupId, (Object)participantId, (Object)transmissionId, (Object)this.sessionManager.getCurrentParticipantId(), (Object)Constants.CAUSE.FLOOR_ASSIGNED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMediaTransmission(String correlationId, String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            this.lastEventTimestamp = System.currentTimeMillis();
            this.activeParticipantId = "";
            this.haveFloorUpdate = 0L;
            this.sessionManager.stopTransmission(participantId);
            logger.info("EventId={} GroupId={} ParticipantId={} TransmissionId={} SessionParticipant={}", (Object)Constants.EVENT.GROUP_STOP_MEDIA_TRANSMISSION, (Object)this.groupId, (Object)participantId, (Object)this.sessionManager.getSessionId(), (Object)this.sessionManager.getCurrentParticipantId());
        }
    }

    private void startMonitoring() {
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.GROUP_INITIATED, (Object)this.groupId);
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                long currentTime = Instant.now().getEpochSecond();
                logger.debug("EventId={} GroupId={} ParticipantId={} HasActiveSession={} HasActiveTransmission={} LastTransmissionStartTime={} LastTransmissionStopTime={} CurrentTime={}", (Object)Constants.EVENT.GROUP_MONITORING, (Object)this.groupId, (Object)this.activeParticipantId, (Object)this.sessionManager.hasActiveSession(), (Object)this.sessionManager.hasActiveTransmission(), (Object)this.sessionManager.getLastTransmissionStartTime(), (Object)this.sessionManager.getLastTransmissionStopTime(), (Object)currentTime);
                if (Boolean.TRUE.equals(Constants.ENFORCE_HEALTH_PACKET_TIMER != false && StringUtils.hasText((String)this.activeParticipantId)) && currentTime - this.haveFloorUpdate > Constants.MAX_WAIT_HEALTH_PACKET) {
                    logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.I_HAVE_FLOOR_TIMEOUT, (Object)this.groupId, (Object)this.activeParticipantId);
                    this.disconnectCall();
                }
                if (this.sessionManager.hasActiveSession()) {
                    if (this.sessionManager.hasActiveTransmission()) {
                        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_TIMER_PAUSED, (Object)this.groupId, (Object)this.activeParticipantId);
                        if (currentTime - this.sessionManager.getLastTransmissionStartTime() >= Constants.MAX_PTT_DURATION) {
                            if (StringUtils.hasText((String)this.activeParticipantId)) {
                                ((RTCPServerService)Constants.rtcpServerService.get()).releaseFloor(this.activeParticipantId, this.groupId);
                            }
                        } else if (StringUtils.hasText((String)this.activeParticipantId)) {
                            ((RTCPServerService)Constants.rtcpServerService.get()).sendFloorTaken(this.groupId, this.activeParticipantId);
                        }
                        return;
                    }
                    if (currentTime - this.sessionManager.getLastTransmissionStopTime() >= this.timeoutPeriod) {
                        this.sessionManager.completeSession();
                        this.onTimeout();
                    }
                }
            }
            catch (Exception e) {
                logger.error("GroupId={} Error in monitoring task: {}", (Object)this.groupId, (Object)e.getMessage(), (Object)e);
            }
        }, 0L, 2L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectCall() {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_TIMEOUT, (Object)this.groupId);
            this.onEventTriggered(Boolean.valueOf(false));
            this.callStartedOn = 0L;
            this.onTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTimeout() {
        logger.info("EventId={} GroupId={} Starting call disconnect", (Object)Constants.EVENT.GROUP_EVENT_TIMEOUT, (Object)this.groupId);
        Object object = this.updateControlLock;
        synchronized (object) {
            if (this.sessionManager.hasActiveSession()) {
                this.sessionManager.completeSession();
            }
            this.sendRequestToParticipantToLeaveConference("Group ID : " + this.groupId);
            this.activeParticipantId = "";
        }
    }

    private void sendRequestToParticipantToJoinConference(String correlationId, String specificParticipant) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_JOIN_CONFERENCE, (Object)this.groupId, (Object)specificParticipant);
        if (Constants.rtcpServerService.get() != null) {
            ArrayList channelInfoList = new ArrayList(this.participants.values());
            ((RTCPServerService)Constants.rtcpServerService.get()).joinConference(correlationId, this.groupId, channelInfoList, this.activeSessionId, this.activeParticipantId, specificParticipant);
        }
    }

    private void sendRequestToParticipantToLeaveConference(String correlationId) {
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.GROUP_LEAVE_CONFERENCE, (Object)this.groupId);
        if (Constants.rtcpServerService.get() != null) {
            ((RTCPServerService)Constants.rtcpServerService.get()).leaveConference(correlationId, this.groupId, this.activeSessionId);
        }
    }

    public void updateMediaTransmission(String correlationId) {
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.GROUP_MEDIA_UPDATE, (Object)this.groupId);
    }
}

