/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx.mcvideo;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransmissionRequest {
    private static final Logger logger = LogManager.getLogger(TransmissionRequest.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCV0";

    private byte setHeader() {
        boolean mcvType = false;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcvType ? 1 : 0);
        return (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        return new byte[]{rtcpLengthByte1, rtcpLengthByte2};
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        return new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
    }

    private byte[] setTransmissionPriorityField(int transmissionPriorityValue) {
        int transmissionPriorityID = 0;
        int transmissionPriorityLength = 2;
        boolean spare = false;
        byte transmissionIDByte = (byte)(transmissionPriorityID & 0xFF);
        byte transmissionLengthByte = (byte)(transmissionPriorityLength & 0xFF);
        byte transmissionValueByte = (byte)(transmissionPriorityValue & 0xFF);
        byte spareByte = (byte)(spare ? 1 : 0);
        return new byte[]{transmissionIDByte, transmissionLengthByte, transmissionValueByte, spareByte};
    }

    private byte[] setUserIDField(String userIDString) {
        int userID = 6;
        int origLen = userIDString.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                userIDString = userIDString + "\u0000";
            }
        }
        byte[] userIdStrData = userIDString.getBytes();
        byte[] userFieldID = new byte[2 + origLen];
        userFieldID[0] = (byte)userID;
        userFieldID[1] = (byte)origLen;
        System.arraycopy(userIdStrData, 0, userFieldID, 2, userIdStrData.length);
        return userFieldID;
    }

    private byte[] setTransmissionIndicatorIDField(char transmissionIndicatorValueChar) {
        int transmissionIndicatorValue;
        int transmissionIndicatorFieldId = 13;
        int transmissionIndicatorLength = 2;
        if (transmissionIndicatorValueChar == 'A') {
            transmissionIndicatorValue = 32768;
        } else if (transmissionIndicatorValueChar == 'B') {
            transmissionIndicatorValue = 16384;
        } else if (transmissionIndicatorValueChar == 'C') {
            transmissionIndicatorValue = 8192;
        } else if (transmissionIndicatorValueChar == 'D') {
            transmissionIndicatorValue = 4096;
        } else if (transmissionIndicatorValueChar == 'E') {
            transmissionIndicatorValue = 2048;
        } else {
            throw new IllegalArgumentException("Invalid floor indicator value");
        }
        byte[] transmissionIndicatorValueData = new byte[]{(byte)(transmissionIndicatorValue >> 8 & 0xFF), (byte)transmissionIndicatorValue};
        byte[] transmissionIndicator = new byte[2 + transmissionIndicatorValueData.length];
        transmissionIndicator[0] = (byte)(transmissionIndicatorFieldId & 0xFF);
        transmissionIndicator[1] = (byte)(transmissionIndicatorLength & 0xFF);
        System.arraycopy(transmissionIndicatorValueData, 0, transmissionIndicator, 2, transmissionIndicatorValueData.length);
        return transmissionIndicator;
    }

    public byte[] send(int ssrcValue, int transmissionPriorityVal, String userIDVal, char transmissionIndicatorVal) {
        byte[] appData = name.getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] transmissionPriorityField = this.setTransmissionPriorityField(transmissionPriorityVal);
        byte[] userField = this.setUserIDField(userIDVal);
        byte[] transmissionIndicator = this.setTransmissionIndicatorIDField(transmissionIndicatorVal);
        int totalRtcpLength = (8 + transmissionPriorityField.length + userField.length + transmissionIndicator.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + transmissionPriorityField.length + userField.length + transmissionIndicator.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(transmissionPriorityField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, transmissionPriorityField.length);
        System.arraycopy(userField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + transmissionPriorityField.length, userField.length);
        System.arraycopy(transmissionIndicator, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + transmissionPriorityField.length + userField.length, transmissionIndicator.length);
        logger.debug("RTCP packet sent");
        return packet;
    }
}

