/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx.mcvideo;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransmissionGranted {
    private static final Logger logger = LogManager.getLogger(TransmissionGranted.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCV1";

    private byte setHeader() {
        boolean mcvType = false;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcvType ? 1 : 0);
        return (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        return new byte[]{rtcpLengthByte1, rtcpLengthByte2};
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        return new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
    }

    public byte[] setDurationField(int durationValue) {
        boolean durationFieldID = true;
        int durationLength = 2;
        byte[] durationField = new byte[]{(byte)(durationFieldID ? 1 : 0), (byte)durationLength, (byte)(durationValue >> 8 & 0xFF), (byte)(durationValue & 0xFF)};
        return durationField;
    }

    public byte[] setSSRCIDField(int ssrcValue) {
        int ssrcFieldId = 14;
        int ssrcLength = 6;
        int ssrcSpare = 0;
        byte[] ssrcOfParticipant = new byte[]{(byte)(ssrcFieldId & 0xFF), (byte)(ssrcLength & 0xFF), (byte)(ssrcValue >> 24 & 0xFF), (byte)(ssrcValue >> 16 & 0xFF), (byte)(ssrcValue >> 8 & 0xFF), (byte)(ssrcValue & 0xFF), (byte)(ssrcSpare & 0xFF), (byte)(ssrcSpare & 0xFF)};
        return ssrcOfParticipant;
    }

    private byte[] setTransmissionPriorityField(int transmissionPriorityValue) {
        int transmissionPriorityID = 0;
        int transmissionPriorityLength = 2;
        boolean spare = false;
        byte transmissionIDByte = (byte)(transmissionPriorityID & 0xFF);
        byte transmissionLengthByte = (byte)(transmissionPriorityLength & 0xFF);
        byte transmissionValueByte = (byte)(transmissionPriorityValue & 0xFF);
        byte spareByte = (byte)(spare ? 1 : 0);
        return new byte[]{transmissionIDByte, transmissionLengthByte, transmissionValueByte, spareByte};
    }

    private byte[] setUserIDField(String userIDString) {
        int userID = 6;
        int origLen = userIDString.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                userIDString = userIDString + "\u0000";
            }
        }
        byte[] userIdStrData = userIDString.getBytes();
        byte[] userFieldID = new byte[2 + origLen];
        userFieldID[0] = (byte)userID;
        userFieldID[1] = (byte)origLen;
        System.arraycopy(userIdStrData, 0, userFieldID, 2, userIdStrData.length);
        return userFieldID;
    }

    public byte[] setQueueSizeField(int queueSizeValue) {
        int queueSizeFieldID = 7;
        int queueSizeLength = 2;
        byte[] queueSize = new byte[]{(byte)queueSizeFieldID, (byte)queueSizeLength, (byte)(queueSizeValue >> 8 & 0xFF), (byte)(queueSizeValue & 0xFF)};
        return queueSize;
    }

    public byte[] setQueueSSRCField(int ssrcValue) {
        int ssrcFieldId = 14;
        int ssrcLength = 6;
        int ssrcSpare = 0;
        byte[] ssrcOfParticipant = new byte[]{(byte)(ssrcFieldId & 0xFF), (byte)(ssrcLength & 0xFF), (byte)(ssrcValue >> 24 & 0xFF), (byte)(ssrcValue >> 16 & 0xFF), (byte)(ssrcValue >> 8 & 0xFF), (byte)(ssrcValue & 0xFF), (byte)(ssrcSpare >> 8 & 0xFF), (byte)(ssrcSpare & 0xFF)};
        return ssrcOfParticipant;
    }

    public byte[] setQueuedUserField(String queuedUsersValue) {
        int queuedUserFieldID = 9;
        int origLen = queuedUsersValue.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                queuedUsersValue = queuedUsersValue + "\u0000";
            }
        }
        byte[] queuedUsersStrData = queuedUsersValue.getBytes();
        byte[] queuedUserFieldData = new byte[2 + origLen];
        queuedUserFieldData[0] = (byte)queuedUserFieldID;
        queuedUserFieldData[1] = (byte)origLen;
        System.arraycopy(queuedUsersStrData, 0, queuedUserFieldData, 2, queuedUsersStrData.length);
        return queuedUserFieldData;
    }

    public byte[] setQueueInfoField(int queuePosiInfo, int queuePriLevel) {
        int queueInfoFieldID = 3;
        int queueInfoLength = 2;
        byte[] queueInfoField = new byte[]{(byte)queueInfoFieldID, (byte)queueInfoLength, (byte)queuePosiInfo, (byte)queuePriLevel};
        return queueInfoField;
    }

    private byte[] setTransmissionIndicatorIDField(char transmissionIndicatorValueChar) {
        int transmissionIndicatorValue;
        int transmissionIndicatorFieldId = 13;
        int transmissionIndicatorLength = 2;
        if (transmissionIndicatorValueChar == 'A') {
            transmissionIndicatorValue = 32768;
        } else if (transmissionIndicatorValueChar == 'B') {
            transmissionIndicatorValue = 16384;
        } else if (transmissionIndicatorValueChar == 'C') {
            transmissionIndicatorValue = 8192;
        } else if (transmissionIndicatorValueChar == 'D') {
            transmissionIndicatorValue = 4096;
        } else if (transmissionIndicatorValueChar == 'E') {
            transmissionIndicatorValue = 2048;
        } else {
            throw new IllegalArgumentException("Invalid transmission indicator value");
        }
        byte[] transmissionIndicatorValueData = new byte[]{(byte)(transmissionIndicatorValue >> 8 & 0xFF), (byte)transmissionIndicatorValue};
        byte[] transmissionIndicator = new byte[2 + transmissionIndicatorValueData.length];
        transmissionIndicator[0] = (byte)(transmissionIndicatorFieldId & 0xFF);
        transmissionIndicator[1] = (byte)(transmissionIndicatorLength & 0xFF);
        System.arraycopy(transmissionIndicatorValueData, 0, transmissionIndicator, 2, transmissionIndicatorValueData.length);
        return transmissionIndicator;
    }

    public byte[] send(int ssrcValue, int durationValue, int ssrcIdValue, int transmissionValue, String userIdStrData, int queueSizeValue, int queuedSsrcValue, String queuedUsersValue, int queuePosiInfo, int queuePriLevel, char transmissionIndicatorBit) {
        byte[] appData = name.getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] durationField = this.setDurationField(durationValue);
        byte[] ssrcIDField = this.setSSRCIDField(ssrcIdValue);
        byte[] transmissionPriorityField = this.setTransmissionPriorityField(transmissionValue);
        byte[] userField = this.setUserIDField(userIdStrData);
        byte[] queueSizeField = this.setQueueSizeField(queueSizeValue);
        byte[] queuedSSRCField = this.setQueueSSRCField(queuedSsrcValue);
        byte[] queuedUsersField = this.setQueuedUserField(queuedUsersValue);
        byte[] queueInfoField = this.setQueueInfoField(queuePosiInfo, queuePriLevel);
        byte[] transmissionIndicator = this.setTransmissionIndicatorIDField(transmissionIndicatorBit);
        int totalRtcpLength = (8 + durationField.length + ssrcIDField.length + transmissionPriorityField.length + userField.length + queueSizeField.length + queuedSSRCField.length + queuedUsersField.length + queueInfoField.length + transmissionIndicator.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + durationField.length + ssrcIDField.length + transmissionPriorityField.length + userField.length + queueSizeField.length + queuedSSRCField.length + queuedUsersField.length + queueInfoField.length + transmissionIndicator.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(durationField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, durationField.length);
        System.arraycopy(ssrcIDField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length, ssrcIDField.length);
        System.arraycopy(transmissionPriorityField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length, transmissionPriorityField.length);
        System.arraycopy(userField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + transmissionPriorityField.length, userField.length);
        System.arraycopy(queueSizeField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + transmissionPriorityField.length + userField.length, queueSizeField.length);
        System.arraycopy(queuedSSRCField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + transmissionPriorityField.length + userField.length + queueSizeField.length, queuedSSRCField.length);
        System.arraycopy(queuedUsersField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + transmissionPriorityField.length + userField.length + queueSizeField.length + queuedSSRCField.length, queuedUsersField.length);
        System.arraycopy(queueInfoField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + transmissionPriorityField.length + userField.length + queueSizeField.length + queuedSSRCField.length + queuedUsersField.length, queueInfoField.length);
        System.arraycopy(transmissionIndicator, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + durationField.length + ssrcIDField.length + transmissionPriorityField.length + userField.length + queueSizeField.length + queuedSSRCField.length + queuedUsersField.length + queueInfoField.length, transmissionIndicator.length);
        logger.debug("RTCP packet sent");
        return packet;
    }
}

