/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroupDynamicDataNotifymessage {
    private static final Logger logger = LogManager.getLogger(GroupDynamicDataNotifymessage.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCNC";

    private byte setHeader() {
        int mcptType = 0;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcptType & 0x1F);
        byte returnValue = (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
        return returnValue;
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        byte[] returnValue = new byte[]{rtcpLengthByte1, rtcpLengthByte2};
        return returnValue;
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        byte[] returnValue = new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
        return returnValue;
    }

    private byte[] setStatusField(int statusValue) {
        int statusID = 0;
        int statusLength = 2;
        byte statusIDByte = (byte)(statusID & 0xFF);
        byte statusLengthByte = (byte)(statusLength & 0xFF);
        byte statusValueByte1 = (byte)(statusValue >> 8 & 0xFF);
        byte statusValueByte2 = (byte)(statusValue & 0xFF);
        return new byte[]{statusIDByte, statusLengthByte, statusValueByte1, statusValueByte2};
    }

    private byte[] setStatusChangingMCPTTUserId(String statusChangingMCPTTUserStr) {
        boolean statusChangingMCPTTUserIdID = true;
        int origLen = statusChangingMCPTTUserStr.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                statusChangingMCPTTUserStr = statusChangingMCPTTUserStr + "\u0000";
            }
        }
        byte[] statusChangingMCPTTUserStrData = statusChangingMCPTTUserStr.getBytes();
        byte[] statusChangingUserField = new byte[2 + origLen];
        statusChangingUserField[0] = (byte)(statusChangingMCPTTUserIdID ? 1 : 0);
        statusChangingUserField[1] = (byte)origLen;
        System.arraycopy(statusChangingMCPTTUserStrData, 0, statusChangingUserField, 2, statusChangingMCPTTUserStrData.length);
        return statusChangingUserField;
    }

    private byte[] setGroupCallOngoingField(int groupCallOngoingValue) {
        int groupCallOngoingID = 2;
        int groupCallOngoingLength = 1;
        int spare = 0;
        byte groupCallOngoingIDByte = (byte)(groupCallOngoingID & 0xFF);
        byte groupCallOngoingLengthByte = (byte)(groupCallOngoingLength & 0xFF);
        byte groupCallOngoingValueByte = (byte)(groupCallOngoingValue & 0xFF);
        byte spareByte = (byte)(spare & 0xFF);
        return new byte[]{groupCallOngoingIDByte, groupCallOngoingLengthByte, groupCallOngoingValueByte, spareByte};
    }

    private byte[] setGroupBroadcastAlias(String groupBroadCastStr) {
        int groupBroadCastID = 3;
        int origLen = groupBroadCastStr.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                groupBroadCastStr = groupBroadCastStr + "\u0000";
            }
        }
        byte[] groupBroadCastStrData = groupBroadCastStr.getBytes();
        byte[] groupBroadCastAliasField = new byte[2 + origLen];
        groupBroadCastAliasField[0] = (byte)groupBroadCastID;
        groupBroadCastAliasField[1] = (byte)origLen;
        System.arraycopy(groupBroadCastStrData, 0, groupBroadCastAliasField, 2, groupBroadCastStrData.length);
        return groupBroadCastAliasField;
    }

    private byte[] setGroupRejoinAlias(String groupRejoinStr) {
        int groupRejoinID = 4;
        int origLen = groupRejoinStr.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                groupRejoinStr = groupRejoinStr + "\u0000";
            }
        }
        byte[] groupRejoinStrData = groupRejoinStr.getBytes();
        byte[] groupRejoinAliasField = new byte[2 + origLen];
        groupRejoinAliasField[0] = (byte)groupRejoinID;
        groupRejoinAliasField[1] = (byte)origLen;
        System.arraycopy(groupRejoinStrData, 0, groupRejoinAliasField, 2, groupRejoinStrData.length);
        return groupRejoinAliasField;
    }

    public byte[] send(int ssrcValue, int statusVal, String statusChangingStrValue, int groupCallOngoingValue, String groupBroadcastStrValue, String groupRejoinStrValue) {
        byte[] appData = name.getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] statusField = this.setStatusField(statusVal);
        byte[] statusChangingField = this.setStatusChangingMCPTTUserId(statusChangingStrValue);
        byte[] groupCallOngoingField = this.setGroupCallOngoingField(groupCallOngoingValue);
        byte[] groupBroadCastAliasField = this.setGroupBroadcastAlias(groupBroadcastStrValue);
        byte[] groupRejoinAliasField = this.setGroupRejoinAlias(groupRejoinStrValue);
        int totalRtcpLength = (8 + statusField.length + statusChangingField.length + groupCallOngoingField.length + groupBroadCastAliasField.length + groupRejoinAliasField.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + statusField.length + statusChangingField.length + groupCallOngoingField.length + groupBroadCastAliasField.length + groupRejoinAliasField.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(statusField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, statusField.length);
        System.arraycopy(statusChangingField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + statusField.length, statusChangingField.length);
        System.arraycopy(groupCallOngoingField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + statusField.length + statusChangingField.length, groupCallOngoingField.length);
        System.arraycopy(groupBroadCastAliasField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + statusField.length + statusChangingField.length + groupCallOngoingField.length, groupBroadCastAliasField.length);
        System.arraycopy(groupRejoinAliasField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + statusField.length + statusChangingField.length + groupCallOngoingField.length + groupBroadCastAliasField.length, groupRejoinAliasField.length);
        logger.debug("RTCP packet sent");
        return packet;
    }
}

