/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.helper;

import com.coraltele.ppdrconference.config.JwtUserDetailConfiguration;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.model.RequestResponse;
import com.coraltele.ppdrconference.service.UserService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cglib.core.internal.Function;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class JwtUtil {
    private static final Logger logger = LogManager.getLogger(JwtUtil.class);
    private String secret;
    private int jwtExpirationInMs;
    @Autowired
    private JwtUserDetailConfiguration jwtUserDetailConfiguration;
    @Autowired
    private UserService userService;

    @Value(value="${jwt.secret}")
    public void setSecret(String secret) {
        this.secret = secret + "-3be8dd5f-c66b-4b3c-88f5-b2d36c9238dd";
        this.secret = Base64.getEncoder().encodeToString(this.secret.getBytes());
    }

    @Value(value="${jwt.expiration}")
    public void setJwtExpirationInMs(int jwtExpiration) {
        this.jwtExpirationInMs = jwtExpiration * 1000;
    }

    private Claims getAllClaimsFromToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
    }

    public <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.getAllClaimsFromToken(token);
        return (T)claimsResolver.apply((Object)claims);
    }

    public String getUsernameFromToken(String token) {
        return (String)this.getClaimFromToken(token, Claims::getSubject);
    }

    private String doGenerateToken(Map<String, Object> claims, String subject) {
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + (long)this.jwtExpirationInMs)).signWith(SignatureAlgorithm.HS512, this.secret).compact();
    }

    public String generateToken(UserDetails userDetails) {
        HashMap claims = new HashMap();
        return this.doGenerateToken(claims, userDetails.getUsername());
    }

    public boolean validateToken(String authToken) {
        try {
            Jws claims = Jwts.parser().setSigningKey(this.secret).parseClaimsJws(authToken);
            return true;
        }
        catch (MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException ex) {
            throw new BadCredentialsException("INVALID_CREDENTIALS", ex);
        }
        catch (ExpiredJwtException ex) {
            throw ex;
        }
    }

    public Date getExpirationDateFromToken(String token) {
        return (Date)this.getClaimFromToken(token, Claims::getExpiration);
    }

    public RequestResponse authenticate(String tokenType, String jwtToken, String ipAddress) {
        RequestResponse returnValue = new RequestResponse();
        if (tokenType.equals("Bearer")) {
            if (this.validateToken(jwtToken)) {
                UserDetails userDetails = this.jwtUserDetailConfiguration.loadUserByUsername(this.getUsernameFromToken(jwtToken));
                UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePasswordAuthenticationToken);
                logger.debug("User authenticated successfully with JWT token");
                returnValue.setStatus(Integer.valueOf(0));
                return returnValue;
            }
            logger.warn("Invalid JWT Token provided in the Authorization header");
            returnValue.setMessage("Invalid JWT Token provided in the Authorization header");
            returnValue.setStatus(Integer.valueOf(401));
            return returnValue;
        }
        if (tokenType.equals("Opaque")) {
            String userIpAddress = ipAddress;
            String userInputKey = jwtToken;
            String userName = this.userService.retrieveUser(userIpAddress, userInputKey);
            if (userName != null && !userName.isEmpty()) {
                UserDetails userDetails = this.jwtUserDetailConfiguration.loadUserByUsername(userName);
                UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePasswordAuthenticationToken);
                logger.info("User authenticated successfully with API key from IP address(Opaque): {}", (Object)userIpAddress);
                returnValue.setStatus(Integer.valueOf(0));
                return returnValue;
            }
            logger.warn("Invalid API key provided in the Authorization header from IP address(Opaque): {}", (Object)userIpAddress);
            returnValue.setStatus(Integer.valueOf(401));
            returnValue.setMessage("Invalid API key provided in the Authorization header from IP address:" + userIpAddress);
            return returnValue;
        }
        if (tokenType.equals("Cluster")) {
            String userName;
            String userInputKey = jwtToken;
            String userIpAddress = ipAddress;
            String string = userName = StringUtils.hasLength((String)Constants.CLUSTER_KEY) && userInputKey.equals(Constants.CLUSTER_KEY) && Constants.NODE_IP_LIST.containsKey(userIpAddress) ? "admin" : null;
            if (userName != null && !userName.isEmpty()) {
                UserDetails userDetails = this.jwtUserDetailConfiguration.loadUserByUsername(userName);
                UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePasswordAuthenticationToken);
                logger.debug("User authenticated successfully with API key for Cluster from IP address(Cluster): {}", (Object)userIpAddress);
                returnValue.setStatus(Integer.valueOf(0));
                return returnValue;
            }
            logger.warn("Invalid API key provided in the Authorization header from IP address(Cluster): {}", (Object)userIpAddress);
            returnValue.setMessage("Invalid API key provided in the Authorization header from IP address:" + userIpAddress);
            returnValue.setStatus(Integer.valueOf(401));
            return returnValue;
        }
        logger.warn("Invalid Authorization header value");
        returnValue.setMessage("Invalid Authorization header value");
        returnValue.setStatus(Integer.valueOf(401));
        return returnValue;
    }
}

