/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.controller;

import com.coraltele.ppdrconference.entity.Participant;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.helper.HTTPHelper;
import com.coraltele.ppdrconference.model.RequestResponse;
import com.coraltele.ppdrconference.service.FloorControlService;
import com.coraltele.ppdrconference.service.RTCPServerService;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/floor"})
@RestController
public class FloorController {
    private static final Logger logger = LogManager.getLogger(FloorController.class);
    @Autowired
    RTCPServerService rtcpServerService;
    @Autowired
    FloorControlService floorControlService;

    @GetMapping(value={"/conferenceList"})
    public ResponseEntity<RequestResponse> conferenceList() {
        try {
            logger.info("EventId={} Fetch Conference List", (Object)Constants.EVENT.API_FETCH_CONFERENCE_LIST);
            RequestResponse returnValue = new RequestResponse();
            returnValue.setData((Object)this.floorControlService.getConferenceList());
            if (returnValue.getStatus() == 0) {
                return ResponseEntity.ok((Object)returnValue);
            }
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("Unable to fetch conference list {}", (Object)returnValue.getStatus(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/conferenceStatus/{conferenceId}"})
    public ResponseEntity<RequestResponse> conferenceStatus(@PathVariable(value="conferenceId") String conferenceId) {
        try {
            logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.API_CONFERENCE_STATUS, (Object)conferenceId);
            RequestResponse returnValue = new RequestResponse();
            returnValue.setData((Object)this.floorControlService.getConferenceDetail(conferenceId));
            if (returnValue.getStatus() == 0) {
                return ResponseEntity.ok((Object)returnValue);
            }
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("Unable to fetch conference list {}", (Object)returnValue.getStatus(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/participantList/{conferenceId}"})
    public ResponseEntity<RequestResponse> participantList(@PathVariable(value="conferenceId") String conferenceId) {
        try {
            logger.info("EventId={} Fetch Participants List for GroupId={}", (Object)Constants.EVENT.API_PARTICIPANT_LIST, (Object)conferenceId);
            RequestResponse returnValue = new RequestResponse();
            returnValue.setData((Object)this.floorControlService.getParticipantList(conferenceId));
            if (returnValue.getStatus() == 0) {
                return ResponseEntity.ok((Object)returnValue);
            }
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("Unable to fetch participant list {}", (Object)returnValue.getStatus(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/join/{conferenceId}/{userId}/{accessLevel}"})
    public ResponseEntity<RequestResponse> joinConference(HttpServletRequest request, @PathVariable(value="conferenceId") String conferenceId, @PathVariable(value="userId") String userId, @PathVariable(value="accessLevel") String accessLevel) {
        try {
            String clientIP = HTTPHelper.getRequestIp((HttpServletRequest)request);
            RequestResponse returnValue = new RequestResponse();
            logger.info("EventId={} ConferenceId={} UserId={} AccessLevel={}", (Object)Constants.EVENT.API_JOIN_SESSION_REQUEST_RECEIVED, (Object)conferenceId, (Object)userId, (Object)accessLevel);
            this.rtcpServerService.joinSessionHTTP(userId, conferenceId, clientIP);
            if (returnValue.getStatus() == 0) {
                return ResponseEntity.ok((Object)returnValue);
            }
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("where input data is wrong!! {}", (Object)returnValue.getStatus(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/shift/{conferenceId}/{userId}/{accessLevel}"})
    public ResponseEntity<RequestResponse> shiftConference(HttpServletRequest request, @PathVariable(value="conferenceId") String conferenceId, @PathVariable(value="userId") String userId, @PathVariable(value="accessLevel") String accessLevel) {
        try {
            logger.info("EventId={} ConferenceId={} UserId={} AccessLevel={}", (Object)Constants.EVENT.API_SHIFT_TO_CONFERENCE, (Object)conferenceId, (Object)userId, (Object)accessLevel);
            String clientIP = HTTPHelper.getRequestIp((HttpServletRequest)request);
            RequestResponse returnValue = new RequestResponse();
            this.rtcpServerService.shiftSessionRequestReceived(userId, conferenceId, clientIP, Integer.valueOf(0), "http", Integer.valueOf(2));
            if (returnValue.getStatus() == 0) {
                return ResponseEntity.ok((Object)returnValue);
            }
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("where input data is wrong!! {}", (Object)returnValue.getStatus(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/request/{conferenceId}/{userId}"})
    public ResponseEntity<RequestResponse> requestFloor(@PathVariable(value="conferenceId") String conferenceId, @PathVariable(value="userId") String userId) {
        try {
            logger.info("EventId={} Request Floor for ConferenceId={} UserId={}", (Object)Constants.EVENT.API_AUDIO_FLOOR_ACCESS_REQUEST_RECEIVED, (Object)conferenceId, (Object)userId);
            RequestResponse returnValue = new RequestResponse();
            this.rtcpServerService.requestFloor(userId, conferenceId);
            if (returnValue.getStatus() == 0) {
                return ResponseEntity.ok((Object)returnValue);
            }
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("where input data is wrong!! {}", (Object)returnValue.getStatus(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/request-video-stream/{conferenceId}/{userId}"})
    public ResponseEntity<RequestResponse> requestVideoStream(@PathVariable(value="conferenceId") String conferenceId, @PathVariable(value="userId") String userId) {
        try {
            logger.info("EventId={} Request Enable Video Stream for ConferenceId={} UserId={}", (Object)Constants.EVENT.API_ENABLE_VIDEO_STREAM_REQUEST_RECEIVED, (Object)conferenceId, (Object)userId);
            RequestResponse returnValue = this.rtcpServerService.requestEnableVideoStream(userId, conferenceId);
            if (returnValue.getStatus() == 0) {
                return ResponseEntity.ok((Object)returnValue);
            }
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("where input data is wrong!! {}", (Object)returnValue.getStatus(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/close-video-stream/{conferenceId}/{userId}"})
    public ResponseEntity<RequestResponse> closeVideoStream(@PathVariable(value="conferenceId") String conferenceId, @PathVariable(value="userId") String userId) {
        try {
            logger.info("EventId={} Request Close Video Stream for ConferenceId={} UserId={}", (Object)Constants.EVENT.API_CLOSE_VIDEO_STREAM_REQUEST_RECEIVED, (Object)conferenceId, (Object)userId);
            RequestResponse returnValue = this.rtcpServerService.requestCloseVideoStream(userId, conferenceId);
            if (returnValue.getStatus() == 0) {
                return ResponseEntity.ok((Object)returnValue);
            }
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("where input data is wrong!! {}", (Object)returnValue.getStatus(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/request-video/{conferenceId}/{userId}"})
    public ResponseEntity<RequestResponse> requestVideoFloor(@PathVariable(value="conferenceId") String conferenceId, @PathVariable(value="userId") String userId) {
        try {
            logger.info("EventId={} Request Video Floor for ConferenceId={} UserId={}", (Object)Constants.EVENT.API_VIDEO_FLOOR_ACCESS_REQUEST_RECEIVED, (Object)conferenceId, (Object)userId);
            RequestResponse returnValue = new RequestResponse();
            this.rtcpServerService.requestVidFloor(userId, conferenceId);
            if (returnValue.getStatus() == 0) {
                return ResponseEntity.ok((Object)returnValue);
            }
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("where input data is wrong!! {}", (Object)returnValue.getStatus(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/release/{conferenceId}/{userId}"})
    public ResponseEntity<RequestResponse> releaseFloor(@PathVariable(value="conferenceId") String conferenceId, @PathVariable(value="userId") String userId) {
        try {
            logger.info("EventId={} Release Floor for ConferenceId={} UserId={}", (Object)Constants.EVENT.API_AUDIO_FLOOR_ACCESS_RELEASED, (Object)conferenceId, (Object)userId);
            RequestResponse returnValue = new RequestResponse();
            this.rtcpServerService.releaseFloor(userId, conferenceId);
            if (returnValue.getStatus() == 0) {
                return ResponseEntity.ok((Object)returnValue);
            }
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("where input data is wrong!! {}", (Object)returnValue.getStatus(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/requestPTT"})
    public ResponseEntity<RequestResponse> requestFloorPTT(HttpServletRequest request) {
        try {
            logger.info("EventId={} PTT Floor Request", (Object)Constants.EVENT.API_REQUEST_PTT_FLOOR);
            String clientIP = HTTPHelper.getRequestIp((HttpServletRequest)request);
            RequestResponse returnValue = new RequestResponse();
            Participant participant = this.floorControlService.getParticipantFromIP(clientIP);
            logger.info("EventId={} PTT Floor Request from ClientIP={}", (Object)Constants.EVENT.API_REQUEST_PTT_FLOOR, (Object)clientIP);
            if (participant != null) {
                this.rtcpServerService.requestFloor(participant.getParticipantNo(), participant.getJoinConference());
            } else {
                returnValue.setStatus(Integer.valueOf(-1));
                returnValue.setMessage("Unable to find participant for IP : " + clientIP);
            }
            if (returnValue.getStatus() == 0) {
                return ResponseEntity.ok((Object)returnValue);
            }
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("where input data is wrong!! {}", (Object)returnValue.getStatus(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/releasePTT"})
    public ResponseEntity<RequestResponse> releaseFloorPTT(HttpServletRequest request) {
        try {
            logger.info("EventId={} PTT Floor Release", (Object)Constants.EVENT.API_RELEASE_PTT_FLOOR);
            String clientIP = HTTPHelper.getRequestIp((HttpServletRequest)request);
            RequestResponse returnValue = new RequestResponse();
            Participant participant = this.floorControlService.getParticipantFromIP(clientIP);
            logger.info("EventId={} PTT Floor Release by ClientIP={}", (Object)Constants.EVENT.API_RELEASE_PTT_FLOOR, (Object)clientIP);
            if (participant != null) {
                this.rtcpServerService.releaseFloor(participant.getParticipantNo(), participant.getJoinConference());
            } else {
                returnValue.setStatus(Integer.valueOf(-1));
                returnValue.setMessage("Unable to find participant for IP : " + clientIP);
            }
            if (returnValue.getStatus() == 0) {
                return ResponseEntity.ok((Object)returnValue);
            }
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("where input data is wrong!! {}", (Object)returnValue.getStatus(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }
}

