/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.controller;

import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.helper.HTTPHelper;
import com.coraltele.ppdrconference.model.DynamicConferenceRequest;
import com.coraltele.ppdrconference.model.DynamicConferenceResponse;
import com.coraltele.ppdrconference.model.RequestResponse;
import com.coraltele.ppdrconference.service.DynamicConferenceService;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/conference"})
@RestController
public class DynamicConferenceController {
    private static final Logger logger = LogManager.getLogger(DynamicConferenceController.class);
    @Autowired
    private DynamicConferenceService dynamicConferenceService;

    @PostMapping(value={"/connect"})
    public ResponseEntity<RequestResponse> connectToConference(@RequestBody DynamicConferenceRequest request, HttpServletRequest httpRequest) {
        try {
            String clientIp = HTTPHelper.getRequestIp((HttpServletRequest)httpRequest);
            logger.info("EventId={} Dynamic Conference Connection Request - ConferenceNo={}, ParticipantNo={}, ClientIP={}", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)request.getConferenceNo(), (Object)request.getParticipantNo(), (Object)clientIp);
            DynamicConferenceResponse response = this.dynamicConferenceService.connectParticipantToConference(request);
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Integer.valueOf(0));
            returnValue.setData((Object)response);
            if ("FAILED".equals(response.getConnectionStatus())) {
                returnValue.setStatus(Integer.valueOf(-1));
                return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
            }
            logger.info("EventId={} Dynamic Conference Connection Successful - ParticipantNo={}", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)request.getParticipantNo());
            return ResponseEntity.ok((Object)returnValue);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("EventId={} Error in dynamic conference connection", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/connect-bulk"})
    public ResponseEntity<RequestResponse> connectMultipleToConference(@RequestBody DynamicConferenceRequest[] requests, HttpServletRequest httpRequest) {
        try {
            String clientIp = HTTPHelper.getRequestIp((HttpServletRequest)httpRequest);
            logger.info("EventId={} Bulk Dynamic Conference Connection Request - Count={}, ClientIP={}", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)requests.length, (Object)clientIp);
            DynamicConferenceResponse[] responses = new DynamicConferenceResponse[requests.length];
            for (int i = 0; i < requests.length; ++i) {
                responses[i] = this.dynamicConferenceService.connectParticipantToConference(requests[i]);
            }
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Integer.valueOf(0));
            returnValue.setData((Object)responses);
            logger.info("EventId={} Bulk Dynamic Conference Connection Completed - Count={}", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)requests.length);
            return ResponseEntity.ok((Object)returnValue);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("EventId={} Error in bulk dynamic conference connection", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @DeleteMapping(value={"/disconnect/{participantNo}/{conferenceNo}"})
    public ResponseEntity<RequestResponse> disconnectFromConference(@PathVariable String participantNo, @PathVariable String conferenceNo, HttpServletRequest httpRequest) {
        try {
            String clientIp = HTTPHelper.getRequestIp((HttpServletRequest)httpRequest);
            logger.info("EventId={} Disconnect Request - ParticipantNo={}, ConferenceNo={}, ClientIP={}", (Object)Constants.EVENT.CONFERENCE_UPDATE_CALL, (Object)participantNo, (Object)conferenceNo, (Object)clientIp);
            boolean success = this.dynamicConferenceService.disconnectParticipantFromConference(participantNo, conferenceNo);
            RequestResponse returnValue = new RequestResponse();
            if (success) {
                returnValue.setStatus(Integer.valueOf(0));
                returnValue.setMessage("Participant disconnected successfully");
                logger.info("EventId={} Disconnect Successful - ParticipantNo={}", (Object)Constants.EVENT.CONFERENCE_UPDATE_CALL, (Object)participantNo);
                return ResponseEntity.ok((Object)returnValue);
            }
            returnValue.setStatus(Integer.valueOf(-1));
            returnValue.setMessage("Failed to disconnect participant");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("EventId={} Error in disconnect request", (Object)Constants.EVENT.CONFERENCE_UPDATE_CALL, (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

