/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.config;

import com.coraltele.ppdrconference.config.StompConnectChannelInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfig
implements WebSocketMessageBrokerConfigurer {
    @Autowired
    StompConnectChannelInterceptor stompConnectChannelInterceptor;

    @Bean
    public ThreadPoolTaskExecutor clientInboundExecutor() {
        ThreadPoolTaskExecutor ex = new ThreadPoolTaskExecutor();
        ex.setThreadNamePrefix("ws-in-");
        ex.setCorePoolSize(Math.max(4, Runtime.getRuntime().availableProcessors()));
        ex.setMaxPoolSize(ex.getCorePoolSize() * 2);
        ex.setQueueCapacity(10000);
        ex.setKeepAliveSeconds(30);
        ex.initialize();
        return ex;
    }

    @Bean
    public ThreadPoolTaskExecutor clientOutboundExecutor() {
        ThreadPoolTaskExecutor ex = new ThreadPoolTaskExecutor();
        ex.setThreadNamePrefix("ws-out-");
        ex.setCorePoolSize(Math.max(4, Runtime.getRuntime().availableProcessors()));
        ex.setMaxPoolSize(ex.getCorePoolSize() * 2);
        ex.setQueueCapacity(20000);
        ex.setKeepAliveSeconds(30);
        ex.initialize();
        return ex;
    }

    @Bean
    public ThreadPoolTaskScheduler wsScheduler() {
        ThreadPoolTaskScheduler s = new ThreadPoolTaskScheduler();
        s.setPoolSize(2);
        s.setThreadNamePrefix("ws-hb-");
        s.initialize();
        return s;
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.interceptors(new ChannelInterceptor[]{this.stompConnectChannelInterceptor});
        registration.taskExecutor(this.clientInboundExecutor());
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableSimpleBroker(new String[]{"/app/v2/messaging/topic"}).setHeartbeatValue(new long[]{10000L, 10000L}).setTaskScheduler((TaskScheduler)this.wsScheduler());
        config.setApplicationDestinationPrefixes(new String[]{"/app/v2/messaging/app"});
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/app/v2/messaging/messages"}).setAllowedOriginPatterns(new String[]{"*"});
        registry.addEndpoint(new String[]{"/app/v2/messaging/messages"}).setAllowedOriginPatterns(new String[]{"*"}).withSockJS();
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.taskExecutor(this.clientOutboundExecutor());
    }
}

