/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference;

import com.coraltele.ppdrconference.helper.Constants;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EnableScheduling
public class Application {
    private static final Logger logger = LogManager.getLogger(Application.class);
    private static String configurationHead = "PPDR-CONFERENCE";
    private static Integer defaultListener = 0;
    private static Integer defaultListenerSSL = 0;
    private static Integer defaultLogLevel = 4;
    private static long defaultDisconnectDuration = 5L;
    private static long defaultMaxPTTDuration = 60L;
    private static int defaultMaxCalls = 32;
    private static int defaultMaxWaitHealthPacket = 6;
    private static String clusterConfiguration = "/etc/default/coral";

    public static void main(String[] args) {
        try {
            String activeProfile = System.getProperty("spring.profiles.active", System.getenv("SPRING_PROFILES_ACTIVE"));
            logger.info("EventId={} Active profiles={}", (Object)Constants.EVENT.APP_SERVER_STARTING, (Object)activeProfile);
            Properties properties = Application.loadPropertiesForProfile((String)activeProfile);
            clusterConfiguration = properties.getProperty("default.config", "/etc/default/coral");
            ClassPathResource resource = new ClassPathResource("application.properties");
            Properties props = PropertiesLoaderUtils.loadProperties((Resource)resource);
            defaultListener = Integer.parseInt(props.getProperty("app.port"));
            defaultListenerSSL = Integer.parseInt(props.getProperty("app.portSSL"));
        }
        catch (IOException e) {
            logger.error("EventId={} Unable to read property file", (Object)Constants.EVENT.APP_SERVER_STARTING, (Object)e);
        }
        Application.readProperties();
        SpringApplication.run(Application.class, (String[])args);
        Application.logProperties();
    }

    private static void readProperties() {
        try {
            Ini ini = new Ini(new File(clusterConfiguration));
            IniPreferences configuration = new IniPreferences(ini);
            Constants.ENABLE_LOCALHOST = configuration.node("CLUSTER").getBoolean("ENABLE-LOCALHOST", false);
            Constants.DOMAIN = configuration.node("CLUSTER").get("DOMAIN", "");
            Constants.CLUSTER_KEY = configuration.node("CLUSTER").get("CLUSTER-KEY", "");
            Constants.LISTENER_IP = configuration.node(configurationHead).get("LISTEN-IP", "0.0.0.0");
            Constants.LISTENER_PORT = configuration.node(configurationHead).getInt("LISTEN-PORT", defaultListener);
            Constants.LISTENER_SSL_PORT = configuration.node(configurationHead).getInt("LISTEN-SSL-PORT", defaultListenerSSL);
            Constants.SIP_LOG_LEVEL = configuration.node(configurationHead).getInt("SIP-LOG-LEVEL", defaultLogLevel);
            Constants.LAN_RTCP_LISTEN_IP = configuration.node(configurationHead).get("LISTEN-IP", "0.0.0.0");
            Constants.WAN_RTCP_LISTEN_IP = configuration.node(configurationHead).get("WAN-RTCP-LISTEN-IP", "0.0.0.0");
            Constants.RTCP_LISTEN_PORT = configuration.node(configurationHead).getInt("RTCP-LISTEN-PORT", 8976);
            Constants.CONFERENCE_PROVIDER = configuration.node(configurationHead).getInt("CONFERENCE-PROVIDER", 1);
            Constants.DISCONNECT_DURATION = configuration.node(configurationHead).getLong("DISCONNECT-DURATION", defaultDisconnectDuration);
            Constants.MAX_PTT_DURATION = configuration.node(configurationHead).getLong("MAX-PTT-DURATION", defaultMaxPTTDuration);
            Constants.ENABLE_SIMULATION = configuration.node(configurationHead).getBoolean("ENABLE-SIMULATION", false);
            Constants.CONFERENCE_THREADS = configuration.node(configurationHead).getInt("CONFERENCE-THREADS", 1);
            Constants.MAX_CALLS = configuration.node(configurationHead).getInt("MAX-CALLS", defaultMaxCalls);
            Constants.MAX_WAIT_HEALTH_PACKET = configuration.node(configurationHead).getInt("MAX-WAIT-HEALTH-PACKET", defaultMaxWaitHealthPacket);
            Constants.ENFORCE_HEALTH_PACKET_TIMER = configuration.node(configurationHead).getBoolean("ENFORCE-HEALTH-PACKET-TIMER", false);
            Constants.MEDIA_MUX_SERVER_IP = configuration.node(configurationHead).get("MEDIA-MUX-SERVER-IP", "");
            Constants.MEDIA_MUX_SERVER_PORT = configuration.node(configurationHead).get("MEDIA-MUX-SERVER-PORT", "");
            Constants.MEDIA_MUX_SERVER_CODEC = configuration.node(configurationHead).get("MEDIA-MUX-SERVER-CODEC", "");
            Constants.MEDIA_MUX_SERVER_PROFILE = configuration.node(configurationHead).get("MEDIA-MUX-SERVER-PROFILE", "");
            Constants.MEDIA_MUX_SERVER_CONFERENCE_PROFILE = configuration.node(configurationHead).get("MEDIA-MUX-SERVER-CONFERENCE-PROFILE", "");
            Constants.ENABLE_MUTE_CONTROL = configuration.node(configurationHead).getBoolean("ENABLE-MUTE-CONTROL", false);
            Constants.MEDIA_MUX_SERVER_TRANSPORT = configuration.node(configurationHead).get("MEDIA-MUX-SERVER-TRANSPORT", "");
            Constants.DISCONNECT_WHEN_IDLE = configuration.node(configurationHead).getBoolean("DISCONNECT-WHEN-IDLE", false);
            Constants.ENABLE_MCX_SIGNALING = configuration.node(configurationHead).getBoolean("ENABLE-MCX-SIGNALING", false);
            Constants.ENABLE_INVITE_FROM_SERVER = configuration.node(configurationHead).getBoolean("ENABLE-INVITE-FROM-SERVER", false);
            Constants.RECORDING_SERVER_URL_STRING = configuration.node(configurationHead).get("RECORDING-SERVER-URL", "");
        }
        catch (IOException e) {
            logger.error("Unable to read property file", (Throwable)e);
        }
        catch (Exception e1) {
            logger.error("Unable to read properties from the configuration file", (Throwable)e1);
        }
        Constants.NODE_IP_LIST.put("127.0.0.1", "127.0.0.1");
        Constants.NODE_IP_LIST.put("0:0:0:0:0:0:0:1", "0:0:0:0:0:0:0:1");
        if (Constants.LISTENER_IP == null || Constants.LISTENER_IP.isEmpty()) {
            Constants.LISTENER_IP = "0.0.0.0";
        }
        if (Constants.WAN_RTCP_LISTEN_IP == null || Constants.WAN_RTCP_LISTEN_IP.isEmpty()) {
            Constants.WAN_RTCP_LISTEN_IP = "0.0.0.0";
        }
        if (Constants.LISTENER_PORT == 0) {
            Constants.LISTENER_PORT = defaultListener;
        }
        if (Constants.LISTENER_SSL_PORT == 0) {
            Constants.LISTENER_SSL_PORT = defaultListenerSSL;
        }
        if (Constants.SIP_LOG_LEVEL == 0) {
            Constants.SIP_LOG_LEVEL = defaultLogLevel;
        }
        if (Constants.LAN_RTCP_LISTEN_IP == null || Constants.LAN_RTCP_LISTEN_IP.isEmpty()) {
            Constants.LAN_RTCP_LISTEN_IP = "0.0.0.0";
        }
        if (Constants.RTCP_LISTEN_PORT == 0) {
            Constants.RTCP_LISTEN_PORT = 8976;
        }
        if (Constants.CONFERENCE_PROVIDER == 0) {
            Constants.CONFERENCE_PROVIDER = 1;
        }
        if (Constants.DISCONNECT_DURATION == 0L) {
            Constants.DISCONNECT_DURATION = defaultDisconnectDuration;
        }
        if (Constants.MAX_PTT_DURATION == 0L) {
            Constants.MAX_PTT_DURATION = defaultMaxPTTDuration;
        }
        if (Constants.CONFERENCE_THREADS == 0) {
            Constants.CONFERENCE_THREADS = 1;
        }
        if (Constants.MAX_CALLS == 0) {
            Constants.MAX_CALLS = defaultMaxCalls;
        }
        if (Constants.MAX_WAIT_HEALTH_PACKET == 0L) {
            Constants.MAX_WAIT_HEALTH_PACKET = defaultMaxWaitHealthPacket;
        }
        Constants.DIAL_STRING = Constants.MEDIA_MUX_SERVER_IP == null || Constants.MEDIA_MUX_SERVER_IP.isEmpty() ? "user/#participantId" : "sofia/" + Constants.MEDIA_MUX_SERVER_PROFILE + "/#participantId@" + Constants.MEDIA_MUX_SERVER_IP + ":" + Constants.MEDIA_MUX_SERVER_PORT + (Constants.MEDIA_MUX_SERVER_TRANSPORT.isEmpty() ? "" : ";transport=" + Constants.MEDIA_MUX_SERVER_TRANSPORT);
        Constants.PPDR_SESSION_CONTROL_FILE = Boolean.TRUE.equals(Constants.ENABLE_INVITE_FROM_SERVER) ? "renegotiatemedia.lua" : "renegotiatemedia_without_invite.lua";
    }

    private static void logProperties() {
        logger.info("EventId={} Starting PPDR Conference Server", (Object)Constants.EVENT.APP_SERVER_CONFIG);
        logger.info("============================ Starting with Properties ============================");
        logger.info("EventId={} ConfigurationHead={} => DOMAIN={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)"CLUSTER", (Object)Constants.DOMAIN);
        logger.info("EventId={} ConfigurationHead={} => ENABLE-LOCALHOST={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)"CLUSTER", (Object)Constants.ENABLE_LOCALHOST);
        logger.info("EventId={} System => Library Path={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)System.getProperty("java.library.path"));
        logger.info("EventId={} ConfigurationHead={} => LISTEN-IP={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.LISTENER_IP);
        logger.info("EventId={} ConfigurationHead={} => WAN-LISTEN-IP={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.WAN_RTCP_LISTEN_IP);
        logger.info("EventId={} ConfigurationHead={} => LISTEN-PORT={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.LISTENER_PORT);
        logger.info("EventId={} ConfigurationHead={} => LISTEN-SSL-PORT={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.LISTENER_SSL_PORT);
        logger.info("EventId={} ConfigurationHead={} => SIP-LOG-LEVEL={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.SIP_LOG_LEVEL);
        logger.info("EventId={} ConfigurationHead={} => RTCP-LISTEN-IP={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.LAN_RTCP_LISTEN_IP);
        logger.info("EventId={} ConfigurationHead={} => RTCP-LISTEN-PORT={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.RTCP_LISTEN_PORT);
        logger.info("EventId={} ConfigurationHead={} => CONFERENCE-PROVIDER={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.CONFERENCE_PROVIDER);
        logger.info("EventId={} ConfigurationHead={} => CLUSTER-KEY={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.CLUSTER_KEY);
        logger.info("EventId={} ConfigurationHead={} => ENABLE-SIMULATION={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.ENABLE_SIMULATION);
        logger.info("EventId={} ConfigurationHead={} => DISCONNECT-DURATION={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.DISCONNECT_DURATION);
        logger.info("EventId={} ConfigurationHead={} => MAX-PTT-DURATION={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.MAX_PTT_DURATION);
        logger.info("EventId={} ConfigurationHead={} => CONFERENCE-THREADS={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.CONFERENCE_THREADS);
        logger.info("EventId={} ConfigurationHead={} => MAX-CALLS={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.MAX_CALLS);
        logger.info("EventId={} ConfigurationHead={} => MAX-WAIT-HEALTH-PACKET={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.MAX_WAIT_HEALTH_PACKET);
        logger.info("EventId={} ConfigurationHead={} => ENFORCE-HEALTH-PACKET-TIMER={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.ENFORCE_HEALTH_PACKET_TIMER);
        logger.info("EventId={} ConfigurationHead={} => MEDIA-MUX-SERVER-IP={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.MEDIA_MUX_SERVER_IP);
        logger.info("EventId={} ConfigurationHead={} => MEDIA-MUX-SERVER-PORT={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.MEDIA_MUX_SERVER_PORT);
        logger.info("EventId={} ConfigurationHead={} => MEDIA-MUX-SERVER-CODEC={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.MEDIA_MUX_SERVER_CODEC);
        logger.info("EventId={} ConfigurationHead={} => MEDIA-MUX-SERVER-PROFILE={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.MEDIA_MUX_SERVER_PROFILE);
        logger.info("EventId={} ConfigurationHead={} => MEDIA-MUX-SERVER-TRANSPORT={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.MEDIA_MUX_SERVER_TRANSPORT);
        logger.info("EventId={} ConfigurationHead={} => MEDIA-MUX-SERVER-CONFERENCE-PROFILE={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.MEDIA_MUX_SERVER_CONFERENCE_PROFILE);
        logger.info("EventId={} ConfigurationHead={} => DIAL-STRING={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.DIAL_STRING);
        logger.info("EventId={} ConfigurationHead={} => ENABLE-MUTE-CONTROL={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.ENABLE_MUTE_CONTROL);
        logger.info("EventId={} ConfigurationHead={} => DISCONNECT-WHEN-IDLE={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.DISCONNECT_WHEN_IDLE);
        logger.info("EventId={} ConfigurationHead={} => ENABLE-MCX-SIGNALING={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.ENABLE_MCX_SIGNALING);
        logger.info("EventId={} ConfigurationHead={} => ENABLE-INVITE-FROM-SERVER={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.ENABLE_INVITE_FROM_SERVER);
        logger.info("EventId={} ConfigurationHead={} => PPDR-SESSION-CONTROL-FILE={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.PPDR_SESSION_CONTROL_FILE);
        logger.info("EventId={} ConfigurationHead={} => RECORDING-SERVER-URL={}", (Object)Constants.EVENT.APP_SERVER_CONFIG, (Object)configurationHead, (Object)Constants.RECORDING_SERVER_URL_STRING);
        logger.info("=================================================================================");
    }

    private static Properties loadPropertiesForProfile(String profile) {
        Properties properties = new Properties();
        String fileName = StringUtils.hasText((String)profile) ? "application-" + profile + ".properties" : "application.properties";
        try {
            properties.load(new ClassPathResource(fileName).getInputStream());
        }
        catch (IOException e) {
            logger.error("Could not load properties file: {}", (Object)fileName, (Object)e);
        }
        return properties;
    }
}

