/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import com.coraltele.entities.CSCF;
import com.coraltele.entities.ISP;
import com.coraltele.entities.Node;
import com.coraltele.entities.ProfileMapping;
import com.coraltele.entities.Route;
import com.coraltele.entities.WAN;
import com.coraltele.repositories.CSCFRepository;
import com.coraltele.repositories.ISPRepository;
import com.coraltele.repositories.NodeRepository;
import com.coraltele.repositories.ProfileMappingRepository;
import com.coraltele.repositories.RouteRepository;
import com.coraltele.repositories.WANRepository;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ConfigureNodeV2 {
    @Autowired
    BuildProperties buildProperties;
    @Autowired
    NodeRepository nodeRepository;
    @Autowired
    CSCFRepository cscfRepository;
    @Autowired
    RouteRepository routeRepository;
    @Autowired
    WANRepository wanRepository;
    @Autowired
    ISPRepository ispRepository;
    @Autowired
    ProfileMappingRepository profileMappingRepository;
    private final Logger logger = LogManager.getLogger(ConfigureNodeV2.class);
    private final DriverManagerDataSource dataSource = new DriverManagerDataSource();
    private String DEFAULT_HEP_VERSION = "3";
    private String DEFAULT_CALL_CENTER_VERSION = "1";
    private String DEFAULT_MAX_SESSIONS = "1000";
    private String DEFAULT_SESSIONS_PER_SECOND = "30";
    private String ENABLE_MCX = "N";
    private String CLUSTER_RLU_CALL = "N";
    private String domainName = "";
    private String usersSBCPort = "";
    private String usersSBCPortTLS = "";
    private String usersSBCPPDRPort = "";
    private String usersSBCPPDRPortTLS = "";
    private String usersFeaturePort = "";
    private String usersFeaturePortTLS = "";
    private String usersFeatureHuntingPort = "";
    private String usersFeatureHuntingPortTLS = "";
    private String usersTrunkPort = "";
    private String usersTrunkPortTLS = "";
    private String hepVersion = this.DEFAULT_HEP_VERSION;
    private JdbcTemplate dbCommands;
    private String callCenterVersion = "";
    private String maxSessions = "";
    private String sessionsPerSecond = "";
    private String mobilityMCC = "";
    private String mobilityMNC = "";
    private String mobilityMME_MNC = "";
    private String mobilityTAC = "";
    private String mobilityPassType = "";
    private String mobilityAMF = "";
    private String mobilitySD = "";
    private String mobilitySST = "";
    private String mobilityMode = "";
    private boolean isEnableMCX = false;
    private boolean isEnableClusterRluCall = false;
    private String ntpClientIP = "";
    private String ntpServerIP = "";
    private String ntpAllowedNetworkIP = "";
    private String ipPPDRServer = "";
    private String ipMapServer = "";
    private String modeMapServer = "";
    private String nodeMode = "";
    private String virtualizationType = "";
    private boolean serviceSegregation = false;
    private String serviceSegregationStartingIp = "";
    private String serviceSegregationServiceCidr = "";
    private String serviceSegregationServiceGateway = "";
    private String serviceStartingIpNetwork = "";
    private String serviceSegregationNetworkStartingIp = "";
    private String serviceSegregationNetworkCidr = "";
    private String serviceNetworkStartingIpNetwork = "";
    private String serviceSegregationAmfNetworkIp = "";
    private String serviceSegregationUpfNetworkIp = "";
    private String serviceSegregationMmeNetworkIp = "";
    private String serviceSegregationSgwuNetworkIp = "";
    private String serviceSegregationNetworkIpCidr = "";
    private String serviceSegregationAmfIp = "";
    private String serviceSegregationAusfIp = "";
    private String serviceSegregationBsfIp = "";
    private String serviceSegregationHssIp = "";
    private String serviceSegregationMmeIp = "";
    private String serviceSegregationNrfIp = "";
    private String serviceSegregationNssfIp = "";
    private String serviceSegregationPcfIp = "";
    private String serviceSegregationPcrfIp = "";
    private String serviceSegregationScpIp = "";
    private String serviceSegregationSgwcIp = "";
    private String serviceSegregationSgwuIp = "";
    private String serviceSegregationSmfIp = "";
    private String serviceSegregationUdmIp = "";
    private String serviceSegregationUdrIp = "";
    private String serviceSegregationUpfIp = "";
    private String currentNodeHostName = "";
    private String currentNodeServerCode = "";

    public void main(String[] args) throws BackingStoreException {
        String hostName;
        String manageDocker = "";
        String hostIP = "";
        String isMultiSubnet = "";
        this.dataSource.setDriverClassName("org.postgresql.Driver");
        this.dataSource.setUrl("jdbc:postgresql://127.0.0.1:5432/switch");
        this.dataSource.setUsername("postgres");
        this.dataSource.setPassword("");
        this.dbCommands = new JdbcTemplate((DataSource)this.dataSource);
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
        String message = String.format("Started %s  ================ %s ==================", this.buildProperties == null ? "Debug" : this.buildProperties.getVersion(), LocalDateTime.now().format(dateFormat));
        this.logger.info(message);
        String clusterConfiguration = args.length >= 1 ? args[0] : "/etc/default/coral";
        hostIP = args.length >= 2 ? args[1] : "127.0.0.1";
        String rootFolder = args.length >= 3 ? args[2] : "";
        manageDocker = args.length >= 4 ? args[3] : "Y";
        this.currentNodeHostName = hostName = this.getHostName();
        if (args.length >= 5) {
            hostName = args[4];
            rootFolder = rootFolder + "/" + hostName;
        }
        if (hostName == null || hostName.isEmpty()) {
            this.logger.error("Unable to retrieve hostname, exiting the application");
            return;
        }
        message = String.format("Reading configuration from %s", clusterConfiguration);
        this.logger.info(message);
        message = String.format("Root folder for configuration %s", rootFolder);
        this.logger.info(message);
        message = String.format("Begin configuration for Node %s", hostName);
        this.logger.info(message);
        try {
            Object networkCidr;
            Ini ini = new Ini(new File(clusterConfiguration));
            IniPreferences configuration = new IniPreferences(ini);
            isMultiSubnet = configuration.node("CLUSTER").get("MULTI-SUBNET", "N");
            this.domainName = configuration.node("CLUSTER").get("DOMAIN", "sbc.coraltele.com");
            this.usersSBCPort = configuration.node("CLUSTER").get("SBC_USERS_PORT", "5060");
            this.usersSBCPortTLS = configuration.node("CLUSTER").get("SBC_USERS_PORT_TLS", "5061");
            this.usersSBCPPDRPort = configuration.node("CLUSTER").get("SBC_USERS_PPDR_PORT", "9410");
            this.usersSBCPPDRPortTLS = configuration.node("CLUSTER").get("SBC_USERS_PPDR_PORT_TLS", "9411");
            this.usersFeaturePort = configuration.node("CLUSTER").get("FEATURE_USERS_PORT", "5060");
            this.usersFeaturePortTLS = configuration.node("CLUSTER").get("FEATURE_USERS_PORT_TLS", "5061");
            this.usersFeatureHuntingPort = configuration.node("CLUSTER").get("FEATURE_USERS_HUNTING_PORT", "5080");
            this.usersFeatureHuntingPortTLS = configuration.node("CLUSTER").get("FEATURE_USERS_HUNTING_PORT", "5081");
            this.usersTrunkPort = configuration.node("CLUSTER").get("TRUNK_GATEWAY_PORT", "5060");
            this.usersTrunkPortTLS = configuration.node("CLUSTER").get("TRUNK_GATEWAY_PORT_TLS", "5061");
            this.hepVersion = configuration.node("CLUSTER").get("HEP_VERSION", this.DEFAULT_HEP_VERSION);
            this.callCenterVersion = configuration.node("CLUSTER").get("CALL_CENTER_VERSION", this.DEFAULT_CALL_CENTER_VERSION);
            this.maxSessions = configuration.node("CLUSTER").get("MAX_SESSIONS", this.DEFAULT_MAX_SESSIONS);
            this.sessionsPerSecond = configuration.node("CLUSTER").get("SESSIONS_PER_SECOND", this.DEFAULT_SESSIONS_PER_SECOND);
            this.isEnableMCX = configuration.node("CLUSTER").get("ENABLE-MCX", this.ENABLE_MCX).equals("Y");
            this.isEnableClusterRluCall = configuration.node("CLUSTER").get("CLUSTER-RLU-CALL", this.CLUSTER_RLU_CALL).equals("Y");
            this.ntpServerIP = configuration.node("CLUSTER").get("NTP-SERVER-IP", "");
            this.ntpAllowedNetworkIP = configuration.node("CLUSTER").get("NTP-ALLOWED-NETWORK-IP", "");
            this.nodeMode = configuration.node("CLUSTER").get("NODE-MODE", "");
            this.virtualizationType = configuration.node("CLUSTER").get("VIRTUALIZATION", "");
            this.mobilityMCC = configuration.node("MOBILITY").get("MCC", "");
            this.mobilityMNC = configuration.node("MOBILITY").get("MNC", "");
            this.mobilityMME_MNC = configuration.node("MOBILITY").get("MME-MNC", "");
            this.mobilityTAC = configuration.node("MOBILITY").get("TAC", "");
            this.mobilityPassType = configuration.node("MOBILITY").get("PASS-TYPE", "");
            this.mobilityAMF = configuration.node("MOBILITY").get("AMF", "");
            this.mobilitySD = configuration.node("MOBILITY").get("SD", "");
            this.mobilitySST = configuration.node("MOBILITY").get("SST", "");
            this.mobilityMode = configuration.node("MOBILITY").get("MODE", "");
            this.ipPPDRServer = configuration.node("PPDR-CONFERENCE").get("LISTEN-IP", "");
            this.ipMapServer = configuration.node("MAP").get("IP", "127.0.0.1");
            this.modeMapServer = configuration.node("MAP").get("MODE", "");
            if (configuration.node("SERVICE-SEGREGATION") != null) {
                this.logger.info("Service Segregation Tag found in configuration, enabling service segregation");
                this.serviceSegregation = true;
            }
            if (this.serviceSegregation) {
                this.serviceSegregationStartingIp = configuration.node("SERVICE-SEGREGATION").get("SERVICE-STARTING-IP", "");
                this.serviceSegregationServiceCidr = configuration.node("SERVICE-SEGREGATION").get("SERVICE-SUBNET", "");
                this.serviceSegregationServiceGateway = configuration.node("SERVICE-SEGREGATION").get("SERVICE-GATEWAY", "");
                this.serviceSegregationNetworkStartingIp = configuration.node("SERVICE-SEGREGATION").get("NETWORK-STARTING-IP", "");
                this.serviceSegregationNetworkCidr = configuration.node("SERVICE-SEGREGATION").get("NETWORK-SUBNET", "24");
                if (this.serviceSegregationStartingIp.isEmpty() || this.serviceSegregationServiceCidr.isEmpty() || this.serviceSegregationServiceGateway.isEmpty() || this.serviceSegregationNetworkStartingIp.isEmpty()) {
                    this.logger.info("Service Segregation configuration is incomplete, please check the configuration file.");
                    this.logger.info("Service Segregation Starting IP: {}", (Object)this.serviceSegregationStartingIp);
                    this.logger.info("Service Segregation Service CIDR: {}", (Object)this.serviceSegregationServiceCidr);
                    this.logger.info("Service Segregation Service Gateway: {}", (Object)this.serviceSegregationServiceGateway);
                    this.logger.info("Service Segregation Network Starting IP: {}", (Object)this.serviceSegregationNetworkStartingIp);
                    this.serviceSegregation = false;
                } else {
                    this.logger.info("Service Segregation Starting IP: {}", (Object)this.serviceSegregationStartingIp);
                    this.logger.info("Service Segregation Service CIDR: {}", (Object)this.serviceSegregationServiceCidr);
                    this.logger.info("Service Segregation Service Gateway: {}", (Object)this.serviceSegregationServiceGateway);
                    this.logger.info("Service Segregation Network Starting IP: {}", (Object)this.serviceSegregationNetworkStartingIp);
                    String[] networkModules = new String[]{"upf", "amf", "mme", "sgwu"};
                    String[] modules = new String[]{"upf", "ausf", "bsf", "hss", "mme", "nrf", "nssf", "pcf", "pcrf", "scp", "sgwc", "sgwu", "smf", "udm", "udr", "amf"};
                    byte[] ipBytes = InetAddress.getByName(this.serviceSegregationStartingIp).getAddress();
                    int ipInt = (ipBytes[0] & 0xFF) << 24 | (ipBytes[1] & 0xFF) << 16 | (ipBytes[2] & 0xFF) << 8 | ipBytes[3] & 0xFF;
                    for (int i = 0; i < modules.length; ++i) {
                        int currentIp = ipInt + i;
                        byte[] addr = new byte[]{(byte)(currentIp >> 24 & 0xFF), (byte)(currentIp >> 16 & 0xFF), (byte)(currentIp >> 8 & 0xFF), (byte)(currentIp & 0xFF)};
                        String ipStr = InetAddress.getByAddress(addr).getHostAddress();
                        String fieldName = "serviceSegregation" + ConfigureNodeV2.capitalize((String)modules[i]) + "Ip";
                        try {
                            Field field = this.getClass().getDeclaredField(fieldName);
                            field.setAccessible(true);
                            field.set(this, ipStr);
                            this.logger.info("Set {} = {}", (Object)fieldName, (Object)ipStr);
                            continue;
                        }
                        catch (IllegalAccessException | NoSuchFieldException e) {
                            this.logger.info("Unable to assign IP to field: {}", (Object)fieldName, (Object)e);
                        }
                    }
                    byte[] networkIpBytes = InetAddress.getByName(this.serviceSegregationNetworkStartingIp).getAddress();
                    int networkIpInt = (networkIpBytes[0] & 0xFF) << 24 | (networkIpBytes[1] & 0xFF) << 16 | (networkIpBytes[2] & 0xFF) << 8 | networkIpBytes[3] & 0xFF;
                    for (int i = 0; i < networkModules.length; ++i) {
                        String module = networkModules[i];
                        int currentIp = networkIpInt + i;
                        byte[] addr = new byte[]{(byte)(currentIp >> 24 & 0xFF), (byte)(currentIp >> 16 & 0xFF), (byte)(currentIp >> 8 & 0xFF), (byte)(currentIp & 0xFF)};
                        String ipStr = InetAddress.getByAddress(addr).getHostAddress();
                        String fieldName = "serviceSegregation" + ConfigureNodeV2.capitalize((String)module) + "NetworkIp";
                        try {
                            Field field = this.getClass().getDeclaredField(fieldName);
                            field.setAccessible(true);
                            field.set(this, ipStr);
                            this.logger.info("Set {} = {}", (Object)fieldName, (Object)ipStr);
                            continue;
                        }
                        catch (IllegalAccessException | NoSuchFieldException e) {
                            this.logger.info("Unable to assign network IP to field: {}", (Object)fieldName, (Object)e);
                        }
                    }
                    try {
                        String serviceCidr = this.serviceSegregationStartingIp + "/" + this.serviceSegregationServiceCidr;
                        networkCidr = this.serviceSegregationNetworkStartingIp + "/" + this.serviceSegregationNetworkCidr;
                        this.serviceStartingIpNetwork = ConfigureNodeV2.calculateNetworkAddress((String)serviceCidr);
                        this.serviceNetworkStartingIpNetwork = ConfigureNodeV2.calculateNetworkAddress((String)networkCidr);
                        this.logger.info("Calculated Service IP Network : {}", (Object)this.serviceStartingIpNetwork);
                        this.logger.info("Calculated Network IP Network : {}", (Object)this.serviceNetworkStartingIpNetwork);
                    }
                    catch (Exception e) {
                        this.logger.info("Failed to calculate network addresses", (Throwable)e);
                    }
                }
            }
            this.usersSBCPort = this.usersSBCPort.isEmpty() ? "5060" : this.usersSBCPort;
            this.usersSBCPortTLS = this.usersSBCPortTLS.isEmpty() ? "5061" : this.usersSBCPortTLS;
            this.usersSBCPPDRPort = this.usersSBCPPDRPort.isEmpty() ? "9410" : this.usersSBCPPDRPort;
            this.usersSBCPPDRPortTLS = this.usersSBCPPDRPortTLS.isEmpty() ? "9411" : this.usersSBCPPDRPortTLS;
            this.usersFeaturePort = this.usersFeaturePort.isEmpty() ? "5060" : this.usersFeaturePort;
            this.usersFeaturePortTLS = this.usersFeaturePortTLS.isEmpty() ? "5061" : this.usersFeaturePortTLS;
            this.usersFeatureHuntingPort = this.usersFeatureHuntingPort.isEmpty() ? "5080" : this.usersFeatureHuntingPort;
            this.usersFeatureHuntingPortTLS = this.usersFeatureHuntingPortTLS.isEmpty() ? "5081" : this.usersFeatureHuntingPortTLS;
            this.usersTrunkPort = this.usersTrunkPort.isEmpty() ? "5060" : this.usersTrunkPort;
            this.usersTrunkPortTLS = this.usersTrunkPortTLS.isEmpty() ? "5061" : this.usersTrunkPortTLS;
            this.maxSessions = this.maxSessions.isEmpty() ? this.DEFAULT_MAX_SESSIONS : this.maxSessions;
            this.sessionsPerSecond = this.sessionsPerSecond.isEmpty() ? this.DEFAULT_SESSIONS_PER_SECOND : this.sessionsPerSecond;
            this.hepVersion = this.hepVersion.isEmpty() ? this.DEFAULT_HEP_VERSION : this.hepVersion;
            this.callCenterVersion = this.callCenterVersion.isEmpty() ? this.DEFAULT_CALL_CENTER_VERSION : this.callCenterVersion;
            Long nodeCount = Long.parseLong(configuration.node("CLUSTER").get("Nodes", "0"));
            String[] ipBilling = new String[]{"", "127.0.0.1", "127.0.0.1"};
            Long i = 1L;
            while (i <= nodeCount) {
                Object node = new Node();
                Object key = String.format("NODE-%d", i);
                String billingEnabled = configuration.node((String)key).get("ENABLE-BILLING", "Y");
                if (billingEnabled.isEmpty()) {
                    billingEnabled = "Y";
                }
                node.setId(Long.valueOf(i * 10L));
                node.setServerCode(String.format("s%d", node.getId()));
                node.setName(configuration.node((String)key).get("NAME", ""));
                node.setInterfaceAddress(configuration.node((String)key).get("HOSTIP0", ""));
                node.setInterfaceGateway(configuration.node((String)key).get("GATEWAY", ""));
                node.setManagementIP(configuration.node((String)key).get("HOSTIP1", ""));
                node.setCIDR(Integer.parseInt(configuration.node((String)key).get("CIDR", "")));
                node.setIpBilling(configuration.node((String)key).get("IP-BILLING", ""));
                node.setIsBillingEnabled(Boolean.valueOf(billingEnabled.equals("Y")));
                node.setRemoteRecordingServerIP(configuration.node((String)key).get("IP-RECORDING-SERVER", ""));
                if (node.getIpBilling().isEmpty()) {
                    node.setIpBilling("127.0.0.1");
                }
                this.nodeRepository.save(node);
                if (nodeCount == 2L && i == 2L) {
                    ipBilling[1] = node.getInterfaceAddress();
                }
                if (nodeCount == 2L && i == 1L) {
                    ipBilling[2] = node.getInterfaceAddress();
                }
                node = i;
                i = i + 1L;
                key = i;
            }
            if (nodeCount == 2L) {
                List nodes = this.nodeRepository.findAll();
                Integer i2 = 0;
                for (Node node : nodes) {
                    Integer e = i2;
                    i2 = i2 + 1;
                    networkCidr = i2;
                    if (i2 == 1 && node.getId() == 10L && node.getIpBilling().equals("127.0.0.1")) {
                        node.setIpBilling(ipBilling[1]);
                    }
                    if (i2 == 2 && node.getId() == 20L && node.getIpBilling().equals("127.0.0.1")) {
                        node.setIpBilling(ipBilling[2]);
                    }
                    this.nodeRepository.save((Object)node);
                }
            }
            Long cscfCount = Long.parseLong(configuration.node("CLUSTER").get("CSCF", "0"));
            Long i3 = 1L;
            while (i3 <= cscfCount) {
                Object cscf = new CSCF();
                Object key = String.format("CSCF-%d", i3);
                cscf.setName(configuration.node((String)key).get("NAME", "").toLowerCase());
                cscf.setRouterId(Integer.parseInt(configuration.node((String)key).get("ROUTER-ID", "")));
                cscf.setGroupCode(configuration.node((String)key).get("GROUP-CODE", ""));
                cscf.setEnableServicingCSCF(Boolean.valueOf(configuration.node((String)key).get("ENABLE-SERVICING-CSCF", "").equalsIgnoreCase("Y")));
                cscf.setEnableProxyCSCF(Boolean.valueOf(configuration.node((String)key).get("ENABLE-PROXY-CSCF", "").equalsIgnoreCase("Y")));
                cscf.setEnableFeatureServer(Boolean.valueOf(configuration.node((String)key).get("ENABLE-FEATURE-SERVER", "").equalsIgnoreCase("Y")));
                cscf.setEnableTrunkGateway(Boolean.valueOf(configuration.node((String)key).get("ENABLE-TRUNK-GATEWAY", "").equalsIgnoreCase("Y")));
                cscf.setEnableTrunkGatewayProxy(Boolean.valueOf(configuration.node((String)key).get("ENABLE-TRUNK-GATEWAY-PROXY", "").equalsIgnoreCase("Y")));
                cscf.setEnableTrunkGatewayInService(Boolean.valueOf(configuration.node((String)key).get("ENABLE-TRUNK-GATEWAY-IN-SERVICE", "").equalsIgnoreCase("Y")));
                cscf.setEnableMediaProxy(Boolean.valueOf(configuration.node((String)key).get("ENABLE-MEDIA-PROXY", "").equalsIgnoreCase("Y")));
                cscf.setIP(configuration.node((String)key).get("IP", ""));
                cscf.setIpServicingCSCF(configuration.node((String)key).get("IP-SERVICING-CSCF", ""));
                cscf.setIpProxyCSCF(configuration.node((String)key).get("IP-PROXY-CSCF", ""));
                cscf.setIpFeature(configuration.node((String)key).get("IP-FEATURE-SERVER", ""));
                cscf.setIpTrunkGateway(configuration.node((String)key).get("IP-TRUNK-GATEWAY", ""));
                cscf.setIpTrunkGatewayProxy(configuration.node((String)key).get("IP-TRUNK-GATEWAY-PROXY", ""));
                cscf.setIpMediaProxy(configuration.node((String)key).get("IP-MEDIA-PROXY", ""));
                cscf.setIpAdditional(configuration.node((String)key).get("IP-ADDITIONAL", ""));
                cscf.setIpStateMachine(configuration.node((String)key).get("IP-STATE-MACHINE", ""));
                cscf.setIpMME(configuration.node((String)key).get("IP-MME", ""));
                cscf.setIpAMF(configuration.node((String)key).get("IP-AMF", ""));
                cscf.setIpDNS(configuration.node((String)key).get("IP-DNS", ""));
                cscf.setIpPCSCF(configuration.node((String)key).get("IP-PCSCF", ""));
                cscf.setCIDR(Integer.parseInt(configuration.node((String)key).get("CIDR", "")));
                cscf.setGateway(configuration.node((String)key).get("GATEWAY", ""));
                cscf.setCscfGateway(configuration.node((String)key).get("CSCF-GATEWAY", ""));
                cscf.setStickyIP(Boolean.valueOf(configuration.node((String)key).get("STICKY-IP", "").equalsIgnoreCase("Y")));
                cscf.setMediaProxyPortsStart(Integer.parseInt(configuration.node((String)key).get("MEDIA-PROXY-PORTS", "").split("-")[0]));
                cscf.setMediaProxyPortsEnd(Integer.parseInt(configuration.node((String)key).get("MEDIA-PROXY-PORTS", "").split("-")[1]));
                cscf.setFeatureMediaPortsStart(Integer.parseInt(configuration.node((String)key).get("FEATURE-MEDIA-PORTS", "").split("-")[0]));
                cscf.setFeatureMediaPortsEnd(Integer.parseInt(configuration.node((String)key).get("FEATURE-MEDIA-PORTS", "").split("-")[1]));
                cscf.setTrunkMediaPortsStart(Integer.parseInt(configuration.node((String)key).get("TRUNK-MEDIA-PORTS", "").split("-")[0]));
                cscf.setTrunkMediaPortsEnd(Integer.parseInt(configuration.node((String)key).get("TRUNK-MEDIA-PORTS", "").split("-")[1]));
                cscf.setNodes(configuration.node((String)key).get("NODES", ""));
                this.cscfRepository.save(cscf);
                String[] nodes = cscf.getNodes().split(",");
                int nodePriority = 210;
                for (String node : nodes) {
                    ProfileMapping profileMapping = new ProfileMapping();
                    profileMapping.setNameCSCF(cscf.getName());
                    profileMapping.setNameNode(node);
                    profileMapping.setPriority(nodePriority -= 10);
                    this.profileMappingRepository.save((Object)profileMapping);
                }
                cscf = i3;
                i3 = i3 + 1L;
                key = i3;
            }
            Long routeCount = Long.parseLong(configuration.node("CLUSTER").get("ROUTES", "0"));
            Long i4 = 1L;
            while (i4 <= routeCount) {
                Object route = new Route();
                Object key = String.format("ROUTE-%d", i4);
                if (configuration.node((String)key).get("NODES", "").contains(hostName)) {
                    route.setIP(configuration.node((String)key).get("IP", ""));
                    route.setGateway(configuration.node((String)key).get("GW", ""));
                    route.setNetworkInterface(configuration.node((String)key).get("INTERFACE", ""));
                    route.setCIDR(Integer.parseInt(configuration.node((String)key).get("CIDR", "")));
                    route.setNodes(configuration.node((String)key).get("NODES", ""));
                    this.routeRepository.save(route);
                }
                route = i4;
                i4 = i4 + 1L;
                key = i4;
            }
            Long wanCount = Long.parseLong(configuration.node("CLUSTER").get("WANS", "0"));
            Long i5 = 1L;
            while (i5 <= wanCount) {
                Object wan = new WAN();
                Object key = String.format("WAN-%d", i5);
                wan.setId(i5);
                wan.setKey((String)key);
                wan.setName(configuration.node((String)key).get("NAME", ""));
                wan.setIpLocal(configuration.node((String)key).get("IP-LOCAL", ""));
                wan.setIpPublic(configuration.node((String)key).get("IP-PUBLIC", ""));
                wan.setIpRemote(configuration.node((String)key).get("IP-REMOTE", ""));
                this.wanRepository.save(wan);
                wan = i5;
                i5 = i5 + 1L;
                key = i5;
            }
            Long ispCount = Long.parseLong(configuration.node("CLUSTER").get("ISP", "0"));
            Long i6 = 1L;
            while (i6 <= ispCount) {
                Object isp;
                Object key = String.format("ISP-%d", i6);
                if (configuration.node((String)key).get("NODES", "").contains(hostName)) {
                    isp = new ISP();
                    isp.setOnMultipleNodes(configuration.node((String)key).get("NODES", "").split(",").length > 1);
                    StringBuilder params = new StringBuilder();
                    isp.setId(i6);
                    for (String param : configuration.node((String)key).keys()) {
                        if (param.equals("NAME")) {
                            isp.setName(configuration.node((String)key).get(param, ""));
                            continue;
                        }
                        if (param.equals("TRUNK-NAME")) {
                            isp.setTrunkName(configuration.node((String)key).get(param, ""));
                            continue;
                        }
                        if (param.equals("LOCAL-IP")) {
                            isp.setLocalIP(configuration.node((String)key).get(param, ""));
                            continue;
                        }
                        if (param.equals("PROXY-IP")) {
                            isp.setProxyIP(configuration.node((String)key).get(param, ""));
                            continue;
                        }
                        if (param.equals("LOCAL-PORT")) {
                            isp.setLocalPort(Integer.valueOf(Integer.parseInt(configuration.node((String)key).get(param, "5060"))));
                            continue;
                        }
                        if (param.equals("CIDR")) {
                            isp.setCIDR(Integer.valueOf(Integer.parseInt(configuration.node((String)key).get(param, "24"))));
                            continue;
                        }
                        if (param.equals("GATEWAY")) {
                            isp.setGateway(configuration.node((String)key).get(param, ""));
                            continue;
                        }
                        if (param.equals("CODECS")) {
                            isp.setCodecs(configuration.node((String)key).get(param, ""));
                            continue;
                        }
                        if (param.equals("INTERFACE")) {
                            isp.setNetworkInterface(configuration.node((String)key).get(param, ""));
                            continue;
                        }
                        if (param.equals("NODES")) continue;
                        params.append(String.format("      <param name=\"%s\" value=\"%s\" />%s", param, configuration.node((String)key).get(param, ""), System.lineSeparator()));
                    }
                    isp.setParams(params.toString());
                    this.ispRepository.save(isp);
                    Route route = new Route();
                    route.setId(Long.valueOf(isp.getId() + 1000L));
                    route.setIP(isp.getLocalIP());
                    route.setGateway(isp.getGateway());
                    route.setNetworkInterface(isp.getNetworkInterface());
                    route.setCIDR(isp.getCIDR().intValue());
                    route.setNodes(hostName);
                    this.routeRepository.save((Object)route);
                    route = new Route();
                    route.setId(Long.valueOf(isp.getId() + 2000L));
                    route.setIP(isp.getProxyIP());
                    route.setGateway(isp.getGateway());
                    route.setNetworkInterface(isp.getNetworkInterface());
                    route.setCIDR(32);
                    route.setNodes(hostName);
                    this.routeRepository.save((Object)route);
                }
                key = i6;
                i6 = i6 + 1L;
                isp = i6;
            }
            if (manageDocker.equals("Y")) {
                this.logger.debug("Create NMS Docker");
            }
            if (!hostIP.isEmpty()) {
                this.logger.debug("Host IP");
            }
            this.generateNodes();
            this.generateProfileMappings();
            this.generateProfiles();
            this.checkDatabaseStatus();
            Optional node = this.nodeRepository.findByName(hostName);
            Boolean isSingleServerDeployment = false;
            Boolean isSingleRLU = false;
            if (node.isPresent()) {
                List profileMappings = this.profileMappingRepository.findByNameNodeOrderByPriorityDesc(((Node)node.get()).getName());
                Optional cscf = this.cscfRepository.findByName(((ProfileMapping)profileMappings.get(0)).getNameCSCF());
                isSingleServerDeployment = profileMappings.size() == 1;
                isSingleRLU = profileMappings.size() == 1;
                this.dbCommands.execute(String.format("update pbx.m_systemconfigs set billing_server_ip = '%s'", ((Node)node.get()).getIpBilling()));
                if (cscf.isPresent()) {
                    List cscfNodes = this.profileMappingRepository.findByNameCSCF(((CSCF)cscf.get()).getName());
                    if (cscfNodes.size() > 1) {
                        isSingleServerDeployment = false;
                    }
                    if (this.domainName.isEmpty()) {
                        this.domainName = ((CSCF)cscf.get()).getIpServicingCSCF().isEmpty() ? ((CSCF)cscf.get()).getIpProxyCSCF() : ((CSCF)cscf.get()).getIpServicingCSCF();
                    }
                    this.executeCommand("rm " + rootFolder + "/etc/keepalived/keepalived.conf");
                    if (!configuration.node("CLUSTER").get("WRITE_NETWORK_SETTINGS", "").equals("N")) {
                        this.writeNetworkInterface(rootFolder, (Node)node.get(), (CSCF)cscf.get(), Boolean.valueOf(isSingleServerDeployment != false || isMultiSubnet.equals("Y")));
                    }
                    if (!isSingleServerDeployment.booleanValue()) {
                        if (!isMultiSubnet.equals("Y")) {
                            this.writeHAConfiguration(rootFolder, (Node)node.get());
                        }
                        this.writeHANodes(rootFolder, (Node)node.get(), profileMappings);
                    }
                    this.writeDBConfiguration(rootFolder, (Node)node.get());
                    this.writeHostConfiguration(rootFolder, (Node)node.get(), (CSCF)cscf.get());
                    this.writeApacheConfiguration(rootFolder, (Node)node.get());
                    this.writePropertyFiles((Node)node.get(), (CSCF)cscf.get(), ini);
                    this.writeSBCConfiguration(rootFolder, (Node)node.get(), (CSCF)cscf.get(), profileMappings, (Preferences)configuration, isMultiSubnet.equals("Y"));
                    this.executeCommand("rm " + rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles/*.xml");
                    this.executeCommand("rm " + rootFolder + "/etc/coraltele/trunkgateway/conf/sip_profiles/*.xml");
                    this.writeSIPServerAutoLoads(rootFolder, ((CSCF)cscf.get()).getIpFeatureServer(), (Node)node.get(), (CSCF)cscf.get());
                    this.writeTrunkAutoLoads(rootFolder, (Node)node.get(), (CSCF)cscf.get());
                    if (isSingleRLU.booleanValue() && !this.isEnableClusterRluCall) {
                        this.writeSIPServerConfiguration(rootFolder, ((CSCF)cscf.get()).getIpFeatureServer(), "", (CSCF)cscf.get(), this.ipPPDRServer);
                        this.writeTrunkConfiguration(rootFolder, ((CSCF)cscf.get()).getIpTrunkGateway(), "", (CSCF)cscf.get());
                        String serviceManagementFilePath = "/var/log/coralswitch/configuration/service-management";
                        File serviceManagementFile = new File(serviceManagementFilePath);
                        if (serviceManagementFile.exists()) {
                            this.logger.info("Service management already performed. Skipping configuration steps.");
                        } else {
                            this.logger.info("Running service management For the first time.");
                            if (this.nodeMode.equals("CNPN")) {
                                if (this.serviceSegregation) {
                                    this.manageCoreServiceSegregatedServices(true);
                                } else {
                                    this.managecnpnServices(true);
                                }
                                this.managebaseServices(true);
                                this.manageHsbServices(false);
                                this.managePbxServices(false);
                                this.writeNodeModeAutoLoads(rootFolder, this.nodeMode);
                            } else if (this.nodeMode.equals("PBX-HSB")) {
                                this.logger.info("Node mode is PBX-HSB, Disabling 4G/5G,Core IMS and Enabling PBX-HSB services");
                                this.managecnpnServices(false);
                                this.managebaseServices(true);
                                this.manageHsbServices(true);
                                this.managePbxServices(true);
                                this.writeNodeModeAutoLoads(rootFolder, this.nodeMode);
                            } else if (this.nodeMode.equals("PBX")) {
                                this.logger.info("Node mode is PBX, Disabling 4G/5G,Core IMS, enabling PBX services");
                                this.managecnpnServices(false);
                                this.managebaseServices(true);
                                this.manageHsbServices(false);
                                this.managePbxServices(true);
                                this.writeNodeModeAutoLoads(rootFolder, this.nodeMode);
                            } else {
                                this.logger.info("Node mode is Node Found, Not Performing any service management");
                            }
                            try {
                                File parentDir = new File(serviceManagementFile.getParent());
                                if (!parentDir.exists()) {
                                    parentDir.mkdirs();
                                }
                                if (serviceManagementFile.createNewFile()) {
                                    this.logger.info("Service Management File created: " + serviceManagementFilePath);
                                } else {
                                    this.logger.warn("Service Management File already exists, but was expected to be new.");
                                }
                            }
                            catch (IOException e) {
                                this.logger.error("Failed to create Service Management File: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        if (this.mobilityMode.equals("volte") || this.mobilityMode.equals("vonr") || this.mobilityMode.equals("nsa")) {
                            if (this.serviceSegregation) {
                                List<String> modules = Arrays.asList("amf", "ausf", "bsf", "hss", "mme", "nrf", "nssf", "pcf", "pcrf", "scp", "sgwc", "sgwu", "smf", "udm", "udr");
                                List<String> networkModules = Arrays.asList("amf", "mme", "sgwu");
                                this.writeServiceSegregationMME((CSCF)cscf.get(), rootFolder);
                                this.generateAssignIpScripts(rootFolder);
                                this.generateAssignIpSystemdScripts(rootFolder);
                                this.start5gsContainersWithDockerRun(modules);
                                this.linkCoreServicesInContainers(modules);
                                this.linkAssignIpServicesInsideContainers(networkModules);
                            } else {
                                this.writeMME((CSCF)cscf.get(), rootFolder);
                            }
                            this.writeDNS((CSCF)cscf.get(), rootFolder);
                            this.writeCoreIMS((CSCF)cscf.get(), rootFolder);
                            this.writeMYSQL(rootFolder);
                            this.writeHSS((CSCF)cscf.get(), rootFolder);
                        }
                    } else {
                        for (ProfileMapping profileMapping : profileMappings) {
                            Optional profile = this.cscfRepository.findByName(profileMapping.getNameCSCF());
                            if (!profile.isPresent()) continue;
                            this.writeSIPServerConfiguration(rootFolder, ((CSCF)profile.get()).getIpFeatureServer(), ((CSCF)profile.get()).getName(), (CSCF)profile.get(), this.ipPPDRServer);
                            this.writeTrunkConfiguration(rootFolder, ((CSCF)profile.get()).getIpTrunkGateway(), ((CSCF)profile.get()).getName(), (CSCF)cscf.get());
                        }
                    }
                    this.writeSIPTrunk(rootFolder, (CSCF)cscf.get());
                    this.writeRoutes(rootFolder);
                    this.writeIPTables(rootFolder, (Node)node.get());
                    this.writeNtpServer(rootFolder);
                }
            } else {
                message = String.format("No node found by the name of %s", hostName);
                this.logger.debug(message);
            }
            this.manageServices(nodeCount);
        }
        catch (IOException e) {
            this.logger.error("Unable to read/write configuration", (Throwable)e);
        }
        message = String.format("Finished %s ================ %s ==================", this.buildProperties == null ? "Debug" : this.buildProperties.getVersion(), LocalDateTime.now().format(dateFormat));
        this.logger.info(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIPTables(String rootFolder, Node node) throws IOException {
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/iptables.up.rules");
             BufferedWriter out = new BufferedWriter(fileWriter);){
            ClassPathResource resourceTemplate = new ClassPathResource("/network/iptables.up.rules");
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String writeContent = writer.toString();
            writeContent = writeContent.replace("$$private_network", String.format("%s/%s", node.getInterfaceAddress(), node.getCIDR()));
            out.write(writeContent);
            this.logger.info("SIP Server External configuration populated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNtpServer(String rootFolder) throws IOException {
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/ntp.conf");
             BufferedWriter out = new BufferedWriter(fileWriter);){
            String[] allowIP;
            ClassPathResource resourceTemplate = new ClassPathResource("/ntpserver/ntp.conf");
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String writeContent = writer.toString();
            if (!this.ntpServerIP.isEmpty()) {
                writeContent = writeContent.replace("#$$SERVER", "").replace("$$SERVERIP", this.ntpServerIP);
            }
            if (!this.ntpAllowedNetworkIP.isEmpty() && (allowIP = this.ntpAllowedNetworkIP.split(",", -1)).length > 0) {
                for (int i = 0; i < allowIP.length; ++i) {
                    String allownetworks = "#$$ALLOWNETWORK" + i;
                    String allownetworksip = "$$ALLOWNETWORKIP" + i;
                    writeContent = writeContent.replace(allownetworks, "").replace(allownetworksip, allowIP[i]);
                }
            }
            out.write(writeContent);
            this.logger.info("SYSTEM NTPSERVER configuration populated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRoutes(String rootFolder) throws IOException {
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/network/if-up.d/configRoutes");
             BufferedWriter out = new BufferedWriter(fileWriter);){
            ClassPathResource resourceTemplate = new ClassPathResource("/network/routes");
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String writeContent = writer.toString();
            StringBuilder routes = new StringBuilder();
            for (Route route : this.routeRepository.findAll()) {
                String subnet = route.getIP() + "/" + Integer.toString(route.getCIDR());
                SubnetUtils utils = new SubnetUtils(subnet);
                routes.append(String.format("route add -net %s netmask %s gw %s dev %s %s", utils.getInfo().getNetworkAddress(), utils.getInfo().getNetmask(), route.getGateway(), route.getNetworkInterface().toLowerCase(), System.lineSeparator()));
            }
            writeContent = writeContent.replace("$$ROUTES", routes.toString());
            out.write(writeContent);
        }
        String command = "chmod +x " + rootFolder + "/etc/network/if-up.d/configRoutes";
        this.logger.info(command);
        this.executeCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSIPTrunk(String rootFolder, CSCF cscf) throws IOException {
        List sipTrunks = this.ispRepository.findAll();
        for (ISP sipTrunk : sipTrunks) {
            try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/coraltele/" + (cscf.getEnableTrunkGatewayInService() != false ? "trunkgateway" : "sipserver") + "/conf/sip_profiles/external_" + sipTrunk.getTrunkName() + ".xml");){
                BufferedWriter out = new BufferedWriter(fileWriter);
                Throwable throwable = null;
                try {
                    ClassPathResource resourceTemplate = new ClassPathResource("/sipserver/siptrunk.xml");
                    InputStream initialStream = resourceTemplate.getInputStream();
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                    String writeContent = writer.toString();
                    writeContent = writeContent.replace("$$trunkName", sipTrunk.getTrunkName());
                    writeContent = writeContent.replace("$$PARAMS", sipTrunk.getParams());
                    writeContent = writeContent.replace("$$trunkIP", sipTrunk.getLocalIP());
                    writeContent = writeContent.replace("$$trunkPort", Integer.toString(sipTrunk.getLocalPort()));
                    writeContent = writeContent.replace("$$trunkCodecs", sipTrunk.getCodecs());
                    out.write(writeContent);
                    this.logger.info("SIP Server External configuration populated");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
    }

    private void writeHANodes(String rootFolder, Node node, List<ProfileMapping> profileMappings) throws IOException {
        FileWriter fileWriter = new FileWriter(rootFolder + "/etc/keepalived/nodes", false);
        try (BufferedWriter out = new BufferedWriter(fileWriter);){
            if (profileMappings.size() > 1) {
                out.append(String.format("enable_media_server:no%s", System.lineSeparator()));
            } else {
                out.append(String.format("enable_media_server:yes%s", System.lineSeparator()));
            }
            for (Node currentNode : this.nodeRepository.findAll()) {
                out.append(String.format("%s:%s%s", currentNode.getName(), currentNode.getInterfaceAddress(), System.lineSeparator()));
            }
            for (ProfileMapping profileMapping : profileMappings) {
                Optional cscf = this.cscfRepository.findByName(profileMapping.getNameCSCF());
                if (!cscf.isPresent()) continue;
                if (!node.getRemoteRecordingServerIP().isEmpty()) {
                    out.append(String.format("enable_recording_server_%s:yes%s", ((CSCF)cscf.get()).getName(), System.lineSeparator()));
                    out.append(String.format("recording_server_ip_%s:%s%s", ((CSCF)cscf.get()).getName(), node.getRemoteRecordingServerIP(), System.lineSeparator()));
                    out.append(String.format("recording_server_interface_%s:vrrp.%d%s", ((CSCF)cscf.get()).getName(), ((CSCF)cscf.get()).getRouterId(), System.lineSeparator()));
                }
                out.append(String.format("virtualip_%s:%s%s", ((CSCF)cscf.get()).getName(), ((CSCF)cscf.get()).getIP(), System.lineSeparator()));
                if (((CSCF)cscf.get()).getCscfGateway().isEmpty()) continue;
                out.append(String.format("rlu_status_ip_%s:%s%s", ((CSCF)cscf.get()).getName(), ((CSCF)cscf.get()).getCscfGateway(), System.lineSeparator()));
            }
            this.logger.info("Virtual IP Added to the nodes");
        }
        catch (Exception E) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)E);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeSBCConfiguration(String rootFolder, Node node, CSCF cscf, List<ProfileMapping> profileMappings, Preferences configuration, boolean isMultiSubnet) throws IOException {
        BufferedWriter out;
        InputStream initialStream;
        String writeContent;
        StringWriter writer;
        Object clusterNode22;
        Optional profile;
        List nodes = this.nodeRepository.findAll();
        String sbcIP = "";
        StringBuilder haConfig = new StringBuilder();
        StringBuilder ipList = new StringBuilder();
        StringBuilder ips = new StringBuilder();
        StringBuilder mediaInterface = new StringBuilder();
        Boolean hasPublicIP = false;
        StringBuilder mediaServer = new StringBuilder();
        StringBuilder rluSIPServer = new StringBuilder();
        StringBuilder rtpEngineInterface = new StringBuilder();
        String string = sbcIP = cscf.getIpServicingCSCF().isEmpty() ? cscf.getIpProxyCSCF() : cscf.getIpServicingCSCF();
        if (isMultiSubnet) {
            ipList.append(sbcIP);
            for (ProfileMapping profileMapping : profileMappings) {
                if (!profileMapping.getNameNode().equals(node.getName()) || !(profile = this.cscfRepository.findByName(profileMapping.getNameCSCF())).isPresent()) continue;
                mediaServer.append(System.lineSeparator());
                mediaServer.append(String.format("modparam(\"rtpengine\", \"rtpengine_sock\",\"%d == udp:%s:2223\")", ((CSCF)profile.get()).getRouterId(), ((CSCF)profile.get()).getIpMediaProxy().isEmpty() ? "127.0.0.1" : ((CSCF)profile.get()).getIpMediaProxy()));
                rluSIPServer.append(System.lineSeparator());
                rluSIPServer.append(String.format("$sht(ri=>%d)=\"%s\";", ((CSCF)profile.get()).getRouterId(), ((CSCF)profile.get()).getIpFeatureServer()));
            }
        } else {
            for (ProfileMapping profileMapping : profileMappings) {
                profile = this.cscfRepository.findByName(profileMapping.getNameCSCF());
                if (!profile.isPresent()) continue;
                ipList.append(((CSCF)profile.get()).getIpServicingCSCF().isEmpty() ? ((CSCF)profile.get()).getIpProxyCSCF() : ((CSCF)profile.get()).getIpServicingCSCF());
                for (String ip : ((CSCF)profile.get()).getIpAdditional().split(",")) {
                    ipList.append(",");
                    ipList.append(ip);
                }
                mediaServer.append(System.lineSeparator());
                mediaServer.append(String.format("modparam(\"rtpengine\", \"rtpengine_sock\",\"%d == udp:%s:2223\")", ((CSCF)profile.get()).getRouterId(), ((CSCF)profile.get()).getIpMediaProxy().isEmpty() ? "127.0.0.1" : ((CSCF)profile.get()).getIpMediaProxy()));
                rluSIPServer.append(System.lineSeparator());
                rluSIPServer.append(String.format("$sht(ri=>%d)=\"%s\";", ((CSCF)profile.get()).getRouterId(), ((CSCF)profile.get()).getIpFeatureServer()));
            }
        }
        String[] sbcIPS = ipList.toString().split(",");
        FileWriter fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/dmq.cfg");
        for (Object clusterNode22 : nodes) {
            if (clusterNode22.getId().equals(node.getId())) {
                this.logger.debug("including self node in DMQ Configuration ");
                if (!haConfig.toString().isEmpty()) {
                    haConfig.append(System.lineSeparator());
                }
                haConfig.append(String.format("modparam(\"dmq\", \"notification_address\", \"sip:%s:5065\")", clusterNode22.getInterfaceAddress()));
                continue;
            }
            if (!haConfig.toString().isEmpty()) {
                haConfig.append(System.lineSeparator());
            }
            haConfig.append(String.format("modparam(\"dmq\", \"notification_address\", \"sip:%s:5065\")", clusterNode22.getInterfaceAddress()));
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            clusterNode22 = null;
            try {
                ClassPathResource resourceTemplate22 = new ClassPathResource("/sbc/dmq.cfg");
                InputStream initialStream2 = resourceTemplate22.getInputStream();
                StringWriter writer2 = new StringWriter();
                IOUtils.copy((InputStream)initialStream2, (Writer)writer2, (Charset)Charset.defaultCharset());
                String writeContent2 = writer2.toString();
                writeContent2 = writeContent2.replace("$$NODES", haConfig.toString());
                bufferedWriter.write(writeContent2);
                this.logger.info("SBC nodes configuration populated");
            }
            catch (Throwable resourceTemplate22) {
                clusterNode22 = resourceTemplate22;
                throw resourceTemplate22;
            }
            finally {
                if (bufferedWriter != null) {
                    if (clusterNode22 != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (Throwable resourceTemplate22) {
                            ((Throwable)clusterNode22).addSuppressed(resourceTemplate22);
                        }
                    } else {
                        bufferedWriter.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)exception);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/sbc-listen.cfg");
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            clusterNode22 = null;
            try {
                ClassPathResource resourceTemplate = new ClassPathResource("/sbc/sbc-listen.cfg");
                InputStream initialStream3 = resourceTemplate.getInputStream();
                Boolean isTLS = configuration.node("CLUSTER").get("TLS", "").equals("Y");
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream3, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                int i = 0;
                for (String ip : sbcIPS) {
                    Optional wan = this.wanRepository.findByIpLocal(ip);
                    String publicIP = "";
                    if (wan.isPresent()) {
                        hasPublicIP = true;
                        publicIP = ((WAN)wan.get()).getIpPublic();
                    }
                    if (!rtpEngineInterface.toString().isEmpty()) {
                        rtpEngineInterface.append(";");
                    }
                    if (publicIP.isEmpty()) {
                        ips.append(System.lineSeparator());
                        ips.append(String.format("listen=tcp:%s:%s%s", ip, this.usersSBCPort, System.lineSeparator()));
                        ips.append(String.format("listen=udp:%s:%s%s", ip, this.usersSBCPort, System.lineSeparator()));
                        ips.append(String.format("listen=tcp:%s:%s%s", ip, this.usersSBCPPDRPort, System.lineSeparator()));
                        ips.append(String.format("listen=udp:%s:%s%s", ip, this.usersSBCPPDRPort, System.lineSeparator()));
                        if (!cscf.getIpMME().isEmpty()) {
                            ips.append(String.format("listen=tcp:%s:%s%s", ip, 9090, System.lineSeparator()));
                            ips.append(String.format("listen=udp:%s:%s%s", ip, 9090, System.lineSeparator()));
                        }
                        if (isTLS.booleanValue()) {
                            ips.append(String.format("listen=tls:%s:%s%s", ip, this.usersSBCPortTLS, System.lineSeparator()));
                            ips.append(String.format("listen=tls:%s:%s%s", ip, this.usersSBCPPDRPortTLS, System.lineSeparator()));
                        }
                        rtpEngineInterface.append(ip);
                        continue;
                    }
                    ++i;
                    rtpEngineInterface.append("local/");
                    rtpEngineInterface.append(ip);
                    rtpEngineInterface.append(";");
                    rtpEngineInterface.append("wan");
                    rtpEngineInterface.append(i);
                    rtpEngineInterface.append("/");
                    rtpEngineInterface.append(ip);
                    rtpEngineInterface.append("!");
                    rtpEngineInterface.append(publicIP);
                    mediaInterface.append(String.format("$sht(mi=>wan%d)=\"%s\";%s", i, publicIP, System.lineSeparator()));
                    ips.append(System.lineSeparator());
                    ips.append(String.format("listen=tcp:%s:%s name \"local\" %s", ip, this.usersSBCPort, System.lineSeparator()));
                    ips.append(String.format("listen=udp:%s:%s name \"local\" %s", ip, this.usersSBCPort, System.lineSeparator()));
                    ips.append(System.lineSeparator());
                    ips.append(String.format("listen=tcp:%s:%s advertise %s:%s name \"wan%d\"%s", ip, this.usersSBCPort, publicIP, this.usersSBCPort, i, System.lineSeparator()));
                    ips.append(String.format("listen=udp:%s:%s advertise %s:%s name \"wan%d\"%s", ip, this.usersSBCPort, publicIP, this.usersSBCPort, i, System.lineSeparator()));
                    if (!isTLS.booleanValue()) continue;
                    ips.append(String.format("listen=tls:%s:%s advertise %s:%s name \"wan%d\"%s", ip, this.usersSBCPort, publicIP, this.usersSBCPort, i, System.lineSeparator()));
                }
                writeContent = writeContent.replace("$$IPV4", ips.toString());
                bufferedWriter.write(writeContent);
                this.logger.info("SBC nodes configuration populated");
            }
            catch (Throwable throwable) {
                clusterNode22 = throwable;
                throw throwable;
            }
            finally {
                if (bufferedWriter != null) {
                    if (clusterNode22 != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)clusterNode22).addSuppressed(throwable);
                        }
                    } else {
                        bufferedWriter.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)exception);
        }
        String string2 = "";
        if (hasPublicIP.booleanValue()) {
            String string3 = "-A WITH_MULTIIP";
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/siptrace.cfg");
        BufferedWriter out2 = new BufferedWriter(fileWriter);
        Object object = null;
        try {
            ClassPathResource resourceTemplate3 = new ClassPathResource("/sbc/siptrace.cfg");
            initialStream = resourceTemplate3.getInputStream();
            writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            writeContent = writer.toString();
            writeContent = writeContent.replace("$$IP", cscf.getIpStateMachine().isEmpty() ? node.getInterfaceAddress() : cscf.getIpStateMachine());
            writeContent = writeContent.replace("$$HEP_VERSION", this.hepVersion);
            out2.write(writeContent);
            this.logger.info("SBC configuration populated");
        }
        catch (Throwable resourceTemplate3) {
            object = resourceTemplate3;
            throw resourceTemplate3;
        }
        finally {
            if (out2 != null) {
                if (object != null) {
                    try {
                        out2.close();
                    }
                    catch (Throwable resourceTemplate3) {
                        ((Throwable)object).addSuppressed(resourceTemplate3);
                    }
                } else {
                    out2.close();
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/sbc.default");
        try {
            out = new BufferedWriter(fileWriter);
            object = null;
            try {
                String configDomainName;
                void var19_30;
                ClassPathResource resourceTemplate4 = new ClassPathResource(cscf.getIpMME().isEmpty() && cscf.getIpAMF().isEmpty() ? "/sbc/sbc.default" : "/sbc/sbc-mme.default");
                initialStream = resourceTemplate4.getInputStream();
                Boolean isTLS = configuration.node("CLUSTER").get("TLS", "").equals("Y");
                String sbcDomain = "";
                StringWriter writer3 = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer3, (Charset)Charset.defaultCharset());
                String writeContent3 = writer3.toString();
                writeContent3 = isTLS != false ? writeContent3.replace("$$TLS", "") : writeContent3.replace("$$TLS", "#");
                writeContent3 = nodes.size() > 1 ? writeContent3.replace("$$HA", "") : writeContent3.replace("$$HA", "#");
                writeContent3 = writeContent3.replace("$$MULTIIP", (CharSequence)var19_30);
                writeContent3 = writeContent3.replace("$$HOSTIP0", node.getInterfaceAddress());
                writeContent3 = writeContent3.replace("$$SBC_USERS_PORT_TLS", this.usersSBCPortTLS);
                writeContent3 = writeContent3.replace("$$SBC_USERS_PORT_TLS", this.usersSBCPortTLS);
                writeContent3 = writeContent3.replace("$$SBC_USERS_PORT", this.usersSBCPort);
                writeContent3 = writeContent3.replace("$$SIPSERVER_USERS_PORT", this.usersFeaturePort);
                writeContent3 = writeContent3.replace("$$RLUVIPSIPSERVER", cscf.getIpFeatureServer());
                writeContent3 = writeContent3.replace("$$PRESENCEIP", sbcIP);
                writeContent3 = writeContent3.replace("$$PRESENCEPORT", this.usersSBCPort);
                writeContent3 = writeContent3.replace("$$PUBLISHIP", "127.0.0.1");
                writeContent3 = writeContent3.replace("$$PUBLISHPORT", "5085");
                writeContent3 = writeContent3.replace("$$SUBNETIP", sbcIP);
                writeContent3 = writeContent3.replace("$$SUBNETMASK", Integer.toString(cscf.getCIDR()));
                writeContent3 = writeContent3.replace("$$PPDRSERVER", this.ipPPDRServer);
                if (!this.domainName.isEmpty()) {
                    sbcDomain = String.format("domain='--alias=%s'", this.domainName);
                }
                writeContent3 = (configDomainName = configuration.node("CLUSTER").get("DOMAIN", this.domainName)).isEmpty() ? writeContent3.replace("$$DOMAINANME", sbcIP) : writeContent3.replace("$$DOMAINANME", this.domainName);
                writeContent3 = writeContent3.replace("$$DOMAIN", sbcDomain);
                writeContent3 = writeContent3.replace("$$SIPSERVER_GATEWAY_PORT", this.usersFeatureHuntingPort);
                writeContent3 = writeContent3.replace("$$PCSCF_IP", cscf.getIpPCSCF());
                out.write(writeContent3);
                this.logger.info("SBC configuration populated");
            }
            catch (Throwable resourceTemplate4) {
                object = resourceTemplate4;
                throw resourceTemplate4;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate4) {
                            ((Throwable)object).addSuppressed(resourceTemplate4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while SBC configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/rtpengine/rtpengine.conf");
        try {
            out = new BufferedWriter(fileWriter);
            object = null;
            try {
                ClassPathResource resourceTemplate5 = new ClassPathResource("/sbc/rtpengine.conf");
                initialStream = resourceTemplate5.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$IPV4", rtpEngineInterface.toString());
                writeContent = writeContent.replace("$$LISTEN-IP", cscf.getIpMediaProxy());
                writeContent = writeContent.replace("$$PORT-START", Integer.toString(cscf.getMediaProxyPortsStart()));
                writeContent = writeContent.replace("$$PORT-END", Integer.toString(cscf.getMediaProxyPortsEnd()));
                out.write(writeContent);
                this.logger.info("Media server configuration populated");
            }
            catch (Throwable resourceTemplate5) {
                object = resourceTemplate5;
                throw resourceTemplate5;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate5) {
                            ((Throwable)object).addSuppressed(resourceTemplate5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while Media Server configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/mediainterface.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            object = null;
            try {
                if (!mediaInterface.toString().isEmpty()) {
                    out.write(mediaInterface.toString());
                } else {
                    out.write("");
                }
                this.logger.info("Media Interface file populated");
            }
            catch (Throwable resourceTemplate5) {
                object = resourceTemplate5;
                throw resourceTemplate5;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate5) {
                            ((Throwable)object).addSuppressed(resourceTemplate5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while Media Interface configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/mediaserver.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            object = null;
            try {
                out.write(mediaServer.toString());
                this.logger.info("CSCF Media Server populated");
            }
            catch (Throwable resourceTemplate5) {
                object = resourceTemplate5;
                throw resourceTemplate5;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate5) {
                            ((Throwable)object).addSuppressed(resourceTemplate5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/rlusipserver.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            object = null;
            try {
                out.write(rluSIPServer.toString());
                this.logger.info("CSCF RLU SIP Server configured");
            }
            catch (Throwable resourceTemplate5) {
                object = resourceTemplate5;
                throw resourceTemplate5;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate5) {
                            ((Throwable)object).addSuppressed(resourceTemplate5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/redis/redis.conf");
        try {
            out = new BufferedWriter(fileWriter);
            object = null;
            try {
                ClassPathResource resourceTemplate6 = new ClassPathResource("/sbc/redis.conf");
                initialStream = resourceTemplate6.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$HOSTIP1", node.getInterfaceAddress());
                out.write(writeContent);
                this.logger.info("Redis server configuration populated");
            }
            catch (Throwable resourceTemplate6) {
                object = resourceTemplate6;
                throw resourceTemplate6;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate6) {
                            ((Throwable)object).addSuppressed(resourceTemplate6);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while Redis Server configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/kamailio/kamctlrc");
        try {
            out = new BufferedWriter(fileWriter);
            object = null;
            try {
                ClassPathResource resourceTemplate = new ClassPathResource("/sbc/kamctlrc");
                initialStream = resourceTemplate.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$DOMAIN", this.domainName);
                out.write(writeContent);
                this.logger.info("SBC RC File configured");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while SBC RC File configured", (Throwable)E);
        }
    }

    private Boolean getIMSv2Enabled() {
        return this.nodeMode.equals("PBX") || this.nodeMode.equals("PBX-HSB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertyFiles(Node node, CSCF cscf, Ini ini) throws IOException {
        Throwable throwable;
        FileInputStream in;
        String sbcIP = "";
        String sipserverIP = "";
        sbcIP = cscf.getIpServicingCSCF().isEmpty() ? cscf.getIpProxyCSCF() : cscf.getIpServicingCSCF();
        sipserverIP = cscf.getIpFeatureServer();
        IniPreferences configuration = new IniPreferences(ini);
        int publicIPCount = 0;
        int cscfCount = 0;
        List wans = this.wanRepository.findAll();
        List cscfList = this.cscfRepository.findAll();
        publicIPCount = wans.size();
        cscfCount = cscfList.size();
        String configurationFile = "/etc/coraltelecom/callserver.manager.conf";
        Properties prop = new Properties();
        try (FileOutputStream output = null;){
            in = new FileInputStream(configurationFile);
            throwable = null;
            try {
                prop.load(in);
                in.close();
                output = new FileOutputStream(configurationFile);
                prop.setProperty("servercode", node.getServerCode());
                prop.setProperty("ntpserver", configuration.node("CLUSTER").get("NTP", ""));
                prop.setProperty("billing.jdbc.url", String.format("jdbc:postgresql://%s:5432/switch", "127.0.0.1"));
                prop.setProperty("cdr.amqserverfullurl", String.format("tcp://%s:9890", "127.0.0.1"));
                prop.setProperty("cmd.amqserverfullurl", String.format("tcp://%s:9890", node.getInterfaceAddress()));
                prop.setProperty("pbxdomain", this.domainName);
                prop.store(output, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        configurationFile = "/etc/coraltele/conf/app.config";
        prop = new Properties();
        output = null;
        try {
            in = new FileInputStream(configurationFile);
            throwable = null;
            try {
                prop.load(in);
                in.close();
                output = new FileOutputStream(configurationFile);
                prop.setProperty("servercode", node.getServerCode());
                prop.setProperty("voipgateway", this.getIMSv2Enabled() != false ? "false" : "true");
                prop.setProperty("hasMultipleIP", publicIPCount >= 1 ? "1" : "0");
                if (cscfCount > 0) {
                    prop.setProperty("sbcip", this.getIMSv2Enabled() != false ? "" : String.format("%s:%s", sbcIP, this.usersSBCPort));
                    prop.setProperty("singleprofile", "0");
                } else {
                    prop.setProperty("sbcip", this.getIMSv2Enabled() != false ? "" : String.format("%s:%s", sbcIP, this.usersSBCPort));
                    prop.setProperty("singleprofile", "1");
                }
                prop.setProperty("sipserverinfo", this.getIMSv2Enabled() != false ? "" : String.format("%s:%s", sipserverIP, this.usersTrunkPort));
                prop.setProperty("tunnelport", "5059");
                prop.setProperty("rlumode", "false");
                prop.setProperty("syncSM", "1");
                prop.setProperty("activeamqurlforcdr", String.format("tcp://%s:9890", node.getInterfaceAddress()));
                if (!cscf.getIpMME().isEmpty() || !cscf.getIpAMF().isEmpty()) {
                    prop.setProperty("defaultcodec", "AMR,PCMU,PCMA");
                    prop.setProperty("hssdburl", "jdbc:mysql://127.0.0.1:3306/hss_db");
                    prop.setProperty("hssdbpassword", "hss");
                }
                if (!cscf.getIpAMF().isEmpty() && (this.mobilityMode.equals("vonr") || this.mobilityMode.equals("nsa"))) {
                    prop.setProperty("nrfurl", "http://127.0.0.10:7777/nnrf-nfm/v1/nf-instances/c3dedcd6-0ba8-41ef-86db-cb6174b3657a");
                    prop.setProperty("pcfurl", "http://127.0.0.13:7777/npcf-policyauthorization/v1/app-sessions");
                }
                prop.store(output, null);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("app.config updated", (Throwable)E);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeApacheConfiguration(String rootFolder, Node node) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate2;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/apache2/sites-enabled/000-default.conf");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/apache/000-default.conf");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                if (this.isEnableMCX) {
                    String AccessControlOrigin = "SetEnvIf Origin \"http(s)?://(www\\.)?(example\\.com|another-example\\.com)$\" AccessControlAllowOrigin=$0\n\tHeader set Access-Control-Allow-Origin %{AccessControlAllowOrigin}e env=AccessControlAllowOrigin";
                    String MCXPRoxyPass = "ProxyPass /mcx/ http://127.0.0.1:8999/\n\tProxyPassReverse /mcx/ http://127.0.0.1:8999/";
                    writeContent = writeContent.replace("$$ACCESS-CONTROL-ALLOW-ORIGIN", AccessControlOrigin);
                    writeContent = writeContent.replace("$$MCX-PROXY-PASS", MCXPRoxyPass);
                    if (this.modeMapServer.equals("Local")) {
                        writeContent = writeContent.replace("$$MAP-SERVER-IP", "127.0.0.1");
                    } else if (this.modeMapServer.equals("Remote")) {
                        writeContent = writeContent.replace("$$MAP-SERVER-IP", this.ipMapServer);
                    }
                } else {
                    writeContent = writeContent.replace("$$ACCESS-CONTROL-ALLOW-ORIGIN", "Header set Access-Control-Allow-Origin \"*\"");
                    writeContent = writeContent.replace("$$MCX-PROXY-PASS", "");
                    if (this.modeMapServer.equals("Local")) {
                        writeContent = writeContent.replace("$$MAP-SERVER-IP", "127.0.0.1");
                    } else if (this.modeMapServer.equals("Remote")) {
                        writeContent = writeContent.replace("$$MAP-SERVER-IP", this.ipMapServer);
                    }
                }
                out.write(writeContent);
                this.logger.info("000-default.conf configuration populated");
            }
            catch (Throwable resourceTemplate2) {
                throwable = resourceTemplate2;
                throw resourceTemplate2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate2) {
                            throwable.addSuppressed(resourceTemplate2);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/opt/apache-activemq-5.15.8/conf/activemq.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/apache/activemq.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$IP", node.getInterfaceAddress());
                out.write(writeContent);
                this.logger.info("activemq.xml configuration populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read 000-default.conf", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHostConfiguration(String rootFolder, Node node, CSCF cscf) throws IOException {
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/var/www/html/hostname");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                String writeContent = "";
                writeContent = node.getName();
                out.write(writeContent);
                this.logger.info("hostname file under /var/www/html folder populated");
            }
            catch (Throwable writeContent) {
                throwable = writeContent;
                throw writeContent;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable writeContent) {
                            throwable.addSuppressed(writeContent);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/etc/hosts");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                String IPV4 = cscf.getIpServicingCSCF();
                String VIP = cscf.getIpServicingCSCF();
                ClassPathResource resourceTemplate = new ClassPathResource("/network/hosts");
                InputStream initialStream = resourceTemplate.getInputStream();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                String writeContent = writer.toString();
                writeContent = writeContent.replace("$$DOMAIN", this.domainName);
                writeContent = writeContent.replace("$$ETH0", IPV4);
                writeContent = writeContent.replace("$$HOSTNAME", node.getName());
                writeContent = writeContent.replace("$$VIP", VIP);
                out.write(writeContent);
                this.logger.info("hosts configuration populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read hosts", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDBConfiguration(String rootFolder, Node node) throws IOException {
        String postgresVersion = this.detectPostgresVersion();
        String postgresBasePath = "/etc/postgresql/" + postgresVersion + "/main";
        this.logger.info("Detected PostgreSQL version: " + postgresVersion + ", using path: " + postgresBasePath);
        try (FileWriter fileWriter = new FileWriter(rootFolder + postgresBasePath + "/postgresql.conf");
             BufferedWriter out = new BufferedWriter(fileWriter);){
            ClassPathResource resourceTemplate = new ClassPathResource("/postgres/postgresql_" + postgresVersion + ".config");
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String writeContent = writer.toString();
            writeContent = writeContent.replace("$$ETH1", node.getInterfaceAddress());
            writeContent = writeContent.replace("\r", "");
            out.write(writeContent);
            this.logger.info("postgresql.conf configuration populated");
        }
        String[] peerNodeList = this.generatePeerNodeListForDBAccess();
        fileWriter = new FileWriter(rootFolder + postgresBasePath + "/pg_hba.conf");
        try (BufferedWriter out = new BufferedWriter(fileWriter);){
            ClassPathResource resourceTemplate = new ClassPathResource("/postgres/pg_hba.config");
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String writeContent = writer.toString();
            writeContent = writeContent.replace("$$DB_ACCESS", peerNodeList[0]);
            writeContent = writeContent.replace("$$REPLICATION_ACCESS", peerNodeList[1]);
            writeContent = writeContent.replace("\r", "");
            out.write(writeContent);
            this.logger.info("pg_hba.conf configuration populated");
        }
        catch (Exception E) {
            this.logger.error("Unable to read pg_hba.conf", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    private String[] generatePeerNodeListForDBAccess() {
        String[] peerNodeList = new String[]{"", ""};
        List nodes = this.nodeRepository.findAll();
        for (Node node : nodes) {
            peerNodeList[0] = peerNodeList[0] + String.format("host    all             filesync        %s/32               trust%s", node.getInterfaceAddress(), System.lineSeparator());
            peerNodeList[1] = peerNodeList[1] + String.format("host    replication     coral_replication        %s/32               trust%s", node.getInterfaceAddress(), System.lineSeparator());
        }
        return peerNodeList;
    }

    private String detectPostgresVersion() {
        String[] versionsToCheck;
        for (String version : versionsToCheck = new String[]{"15", "14", "13", "12"}) {
            File versionDir = new File("/etc/postgresql/" + version + "/main");
            if (!versionDir.exists() || !versionDir.isDirectory()) continue;
            return version;
        }
        this.logger.warn("Could not detect PostgreSQL version, defaulting to 15");
        return "15";
    }

    private void generateProfiles() {
        List cscfList = this.cscfRepository.findAll();
        this.dbCommands.update("truncate table pbx.m_control_rluserver;");
        this.logger.info("Node information cleaned");
        for (CSCF cscf : cscfList) {
            String sbcAddress = cscf.getIpServicingCSCF().isEmpty() ? cscf.getIpProxyCSCF() : cscf.getIpServicingCSCF();
            int trunkGatewayInService = 1;
            trunkGatewayInService = cscf.getEnableTrunkGateway() != false ? (cscf.getEnableTrunkGatewayInService() != false ? 2 : 1) : 3;
            if (!cscf.getEnableServicingCSCF().booleanValue()) continue;
            this.dbCommands.update("Insert into pbx.m_control_rluserver(ipaddress,virtualip,rlucode,routerid,preempt,rlutype,sgwip, msf_ip,msf_sgwip,msf_sgwip_port,trunkgatewayinservice,volteip) values (?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{sbcAddress, sbcAddress, cscf.getName(), cscf.getRouterId(), cscf.getStickyIP() == false, "SERVICING", cscf.getIpFeatureServer(), cscf.getIpTrunkGatewayProxy(), cscf.getIpTrunkGateway(), Integer.parseInt(this.usersTrunkPort), trunkGatewayInService, cscf.getIpPCSCF()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHAConfiguration(String rootFolder, Node node) throws IOException {
        List profileMappings = this.profileMappingRepository.findByNameNodeOrderByNameCSCF(node.getName());
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/keepalived/keepalived.conf");
             BufferedWriter out = new BufferedWriter(fileWriter);){
            ClassPathResource resourceTemplateGlobal = new ClassPathResource("/keepalived/keepalivedV2.global");
            InputStream initialStreamGlobal = resourceTemplateGlobal.getInputStream();
            StringWriter writerGlobal = new StringWriter();
            InputStream input = initialStreamGlobal;
            StringWriter writer = writerGlobal;
            IOUtils.copy((InputStream)input, (Writer)writer, (Charset)Charset.defaultCharset());
            StringBuilder writeContent = new StringBuilder();
            writeContent.append(writerGlobal.toString());
            for (ProfileMapping profileMapping : profileMappings) {
                StringBuilder ipAddress = new StringBuilder();
                ClassPathResource resourceTemplateRLU = new ClassPathResource("/keepalived/rlu.conf");
                if (this.virtualizationType.equals("VMWARE")) {
                    resourceTemplateRLU = new ClassPathResource("/keepalived/rlu_vmware.conf");
                }
                InputStream initialStreamRLU = resourceTemplateRLU.getInputStream();
                StringWriter writerRLU = new StringWriter();
                IOUtils.copy((InputStream)initialStreamRLU, (Writer)writerRLU, (Charset)Charset.defaultCharset());
                String rluContent = writerRLU.toString();
                Optional cscf = this.cscfRepository.findByName(profileMapping.getNameCSCF());
                if (cscf.isPresent()) {
                    this.addVirtualIPAddress(ipAddress, ((CSCF)cscf.get()).getEnableServicingCSCF(), ((CSCF)cscf.get()).getIpServicingCSCF(), Integer.valueOf(((CSCF)cscf.get()).getCIDR()), "0");
                    this.addVirtualIPAddress(ipAddress, ((CSCF)cscf.get()).getEnableProxyCSCF(), ((CSCF)cscf.get()).getIpProxyCSCF(), Integer.valueOf(((CSCF)cscf.get()).getCIDR()), "1");
                    this.addVirtualIPAddress(ipAddress, ((CSCF)cscf.get()).getEnableFeatureServer(), ((CSCF)cscf.get()).getIpFeatureServer(), Integer.valueOf(((CSCF)cscf.get()).getCIDR()), "2");
                    this.addVirtualIPAddress(ipAddress, ((CSCF)cscf.get()).getEnableTrunkGateway(), ((CSCF)cscf.get()).getIpTrunkGateway(), Integer.valueOf(((CSCF)cscf.get()).getCIDR()), "3");
                    this.addVirtualIPAddress(ipAddress, ((CSCF)cscf.get()).getEnableTrunkGatewayProxy(), ((CSCF)cscf.get()).getIpTrunkGatewayProxy(), Integer.valueOf(((CSCF)cscf.get()).getCIDR()), "4");
                    this.addVirtualManagementIPAddress(ipAddress, Boolean.valueOf(true), ((CSCF)cscf.get()).getIP(), Integer.valueOf(node.getCIDR()));
                    for (ISP isp : this.ispRepository.findAll()) {
                        if (isp.isOnMultipleNodes()) continue;
                        this.addVirtualISPAddress(ipAddress, Boolean.valueOf(true), isp.getLocalIP(), isp.getCIDR(), isp.getNetworkInterface(), isp.getTrunkName());
                    }
                    rluContent = rluContent.replace("$$IPV4", ipAddress.toString());
                    rluContent = rluContent.replace("$$RLU", ((CSCF)cscf.get()).getName());
                    rluContent = rluContent.replace("$$RouterId", Integer.toString(((CSCF)cscf.get()).getRouterId()));
                    rluContent = rluContent.replace("$$Priority", Integer.toString(profileMapping.getPriority()));
                    rluContent = rluContent.replace("$$GATEWAY", ((CSCF)cscf.get()).getGateway());
                    rluContent = rluContent.replace("$$Preempt", "nopreempt");
                }
                writeContent.append(rluContent);
            }
            out.write(writeContent.toString());
        }
    }

    private void addVirtualIPAddress(StringBuilder interfaces, Boolean isEnabled, String ipAddress, Integer cidr, String label) {
        if (!ipAddress.trim().isEmpty() && isEnabled.booleanValue()) {
            if (!interfaces.toString().isEmpty()) {
                interfaces.append(System.lineSeparator());
            }
            if (this.virtualizationType.equals("VMWARE")) {
                interfaces.append(String.format("        %s/%d dev eth0 label eth0:%s", ipAddress, cidr, label));
            } else {
                interfaces.append(String.format("        %s/%d", ipAddress, cidr));
            }
        }
    }

    private void addVirtualISPAddress(StringBuilder interfaces, Boolean isEnabled, String ipAddress, Integer cidr, String networkInterface, String gatewayCode) {
        if (!ipAddress.trim().isEmpty() && isEnabled.booleanValue()) {
            if (!interfaces.toString().isEmpty()) {
                interfaces.append(System.lineSeparator());
            }
            interfaces.append(String.format("        %s/%d dev %s label %s:%s", ipAddress, cidr, networkInterface, networkInterface, gatewayCode));
        }
    }

    private void addVirtualManagementIPAddress(StringBuilder interfaces, Boolean isEnabled, String ipAddress, Integer cidr) {
        if (!ipAddress.trim().isEmpty() && isEnabled.booleanValue()) {
            if (!interfaces.toString().isEmpty()) {
                interfaces.append(System.lineSeparator());
            }
            interfaces.append(String.format("        %s/%d dev eth0 label eth0:mgmt", ipAddress, cidr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNetworkInterface(String rootFolder, Node node, CSCF cscf, Boolean isSingleNode) throws IOException {
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/network/interfaces");
             BufferedWriter out = new BufferedWriter(fileWriter);){
            ClassPathResource resourceTemplate = new ClassPathResource("/network/interfaceV2");
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            InputStream input = initialStream;
            StringWriter writer1 = writer;
            IOUtils.copy((InputStream)input, (Writer)writer1, (Charset)Charset.defaultCharset());
            String writeContent = writer.toString();
            String subnet = node.getInterfaceAddress() + "/" + Integer.toString(node.getCIDR());
            SubnetUtils utils = new SubnetUtils(subnet);
            writeContent = writeContent.replace("$$IPV4MGMT", node.getManagementIP());
            writeContent = writeContent.replace("$$IPV4", node.getInterfaceAddress());
            writeContent = writeContent.replace("$$CIDR", Integer.toString(node.getCIDR()));
            writeContent = writeContent.replace("$$SUBNET", utils.getInfo().getNetmask());
            StringBuilder routes = new StringBuilder();
            StringBuilder interfaces = new StringBuilder();
            Integer sequence = 0;
            if (isSingleNode.booleanValue()) {
                this.logger.info("Writing interface file for single node");
                String sbcAddress = cscf.getIpServicingCSCF().isEmpty() ? cscf.getIpProxyCSCF() : cscf.getIpServicingCSCF();
                String gateway = String.format("gateway %s", node.getInterfaceGateway());
                writeContent = writeContent.replace("$$GATEWAY-IPV4", gateway);
                String cscfSubnet = sbcAddress + "/" + cscf.getCIDR();
                SubnetUtils cscfUtils = new SubnetUtils(cscfSubnet);
                if (!cscf.getGateway().equals(node.getInterfaceGateway())) {
                    String route = String.format("        up ip route add %s/%d via %s dev eth0%s", cscfUtils.getInfo().getNetworkAddress(), cscf.getCIDR(), cscf.getGateway(), System.lineSeparator());
                    routes.append(route);
                }
                if (!node.getInterfaceAddress().equals(cscf.getIpServicingCSCF()) && cscf.getEnableServicingCSCF().booleanValue()) {
                    sequence = this.addIPAddress(interfaces, cscf.getEnableServicingCSCF(), sequence, cscf.getIpServicingCSCF(), Integer.valueOf(cscf.getCIDR()), "eth0");
                }
                sequence = this.addIPAddress(interfaces, cscf.getEnableProxyCSCF(), sequence, cscf.getIpProxyCSCF(), Integer.valueOf(cscf.getCIDR()), "eth0");
                sequence = this.addIPAddress(interfaces, cscf.getEnableFeatureServer(), sequence, cscf.getIpFeatureServer(), Integer.valueOf(cscf.getCIDR()), "eth0");
                sequence = this.addIPAddress(interfaces, cscf.getEnableTrunkGateway(), sequence, cscf.getIpTrunkGateway(), Integer.valueOf(cscf.getCIDR()), "eth0");
                sequence = this.addIPAddress(interfaces, cscf.getEnableTrunkGatewayProxy(), sequence, cscf.getIpTrunkGatewayProxy(), Integer.valueOf(cscf.getCIDR()), "eth0");
                sequence = this.addIPAddress(interfaces, Boolean.valueOf(!cscf.getIpMME().isEmpty()), sequence, cscf.getIpMME(), Integer.valueOf(cscf.getCIDR()), "eth0");
                sequence = this.addIPAddress(interfaces, Boolean.valueOf(!cscf.getIpAMF().isEmpty()), sequence, cscf.getIpAMF(), Integer.valueOf(cscf.getCIDR()), "eth0");
                if (this.serviceSegregation) {
                    sequence = this.addIPAddress(interfaces, Boolean.valueOf(!this.serviceSegregationNetworkStartingIp.isEmpty()), sequence, this.serviceSegregationNetworkStartingIp, Integer.valueOf(cscf.getCIDR()), "eth0");
                }
                for (ISP isp : this.ispRepository.findAll()) {
                    if (isp.isOnMultipleNodes()) continue;
                    sequence = this.addIPAddress(interfaces, Boolean.valueOf(true), sequence, isp.getLocalIP(), isp.getCIDR(), isp.getNetworkInterface());
                }
            } else {
                if (this.virtualizationType.equals("VMWARE")) {
                    this.logger.info("VMWARE virtualization detected, Setting gateway in eth0");
                    writeContent = writeContent.replace("$$GATEWAY-IPV4", String.format("gateway %s", cscf.getGateway()));
                } else {
                    writeContent = writeContent.replace("$$GATEWAY-IPV4", "");
                }
                this.logger.info("Writing interface file for multiple node");
            }
            writeContent = writeContent.replace("$$ROUTES", routes.toString());
            writeContent = writeContent.replace("$$INTERFACES", interfaces.toString());
            out.write(writeContent);
            this.logger.info("network configuration populated");
        }
    }

    private Integer addIPAddress(StringBuilder interfaces, Boolean isEnabled, Integer sequence, String ipAddress, Integer cidr, String networkInterface) {
        if (!ipAddress.trim().isEmpty() && isEnabled.booleanValue()) {
            Integer n = sequence;
            Integer n2 = sequence = Integer.valueOf(sequence + 1);
            if (networkInterface.isEmpty()) {
                networkInterface = "eth0";
            }
            String subnet = ipAddress + "/" + cidr;
            SubnetUtils utils = new SubnetUtils(subnet);
            interfaces.append(System.lineSeparator());
            interfaces.append(String.format("auto %s:%d%s", networkInterface.toLowerCase(), sequence, System.lineSeparator()));
            interfaces.append(String.format("iface %s:%d inet static%s", networkInterface.toLowerCase(), sequence, System.lineSeparator()));
            interfaces.append(String.format("        address %s%s", ipAddress, System.lineSeparator()));
            interfaces.append(String.format("        netmask %s", utils.getInfo().getNetmask()));
            interfaces.append(System.lineSeparator());
        }
        return sequence;
    }

    private void generateProfileMappings() {
        List profileMappings = this.profileMappingRepository.findByOrderByNameCSCFAscPriorityAsc();
        this.dbCommands.update("truncate table pbx.m_profilemapping;");
        this.logger.info("Profile mapping information cleaned");
        for (ProfileMapping profileMapping : profileMappings) {
            Optional node = this.nodeRepository.findByName(profileMapping.getNameNode());
            if (!node.isPresent()) continue;
            this.dbCommands.update("Insert into pbx.m_profilemapping(profile_name,servercode,priority) values (?,?,?)", new Object[]{profileMapping.getNameCSCF(), ((Node)node.get()).getServerCode(), 210 - profileMapping.getPriority()});
        }
    }

    private void checkDatabaseStatus() {
        String[] databases = new String[]{"switch", "coralapps", "users", "jobs", "telemetry", "billing"};
        this.logger.info("Starting database connectivity checks and enabling connections...");
        for (String database : databases) {
            try {
                String alterCommand = String.format("ALTER DATABASE %s ALLOW_CONNECTIONS true", database);
                this.dbCommands.execute(alterCommand);
                this.logger.info(String.format("\u2713 Database '%s' connections enabled", database));
            }
            catch (Exception e) {
                this.logger.error(String.format("\u2717 Failed to enable connections for database '%s': %s", database, e.getMessage()), (Throwable)e);
            }
        }
        this.logger.info("Database connectivity checks completed.");
    }

    private void generateNodes() {
        List nodes = this.nodeRepository.findByOrderByServerCode();
        this.dbCommands.update("truncate table pbx.m_nodeconfiguration;");
        this.logger.info("Node information cleaned");
        String basePath = "/home/coralswitch";
        for (Node node : nodes) {
            String owner;
            this.dbCommands.update("Insert into pbx.m_nodeconfiguration(nodeid,nodeip,ipaddress,servercode,nodename,hagroup,vertualip, rlucode,isbillingenabled) values (?,?,?,?,?,?,?,?, ?)", new Object[]{node.getId(), node.getInterfaceAddress(), node.getInterfaceAddress(), node.getServerCode(), node.getName(), node.getId(), node.getInterfaceAddress(), node.getServerCode(), node.getIsBillingEnabled() != false ? 1 : 0});
            String folderPath = basePath + "/" + node.getServerCode();
            File nodeFolder = new File(folderPath);
            if (!nodeFolder.exists()) {
                if (nodeFolder.mkdirs()) {
                    this.logger.info("Created folder: " + folderPath);
                } else {
                    this.logger.error("Failed to create folder: " + folderPath);
                }
            }
            if (node.getName().equalsIgnoreCase(this.currentNodeHostName)) {
                owner = "root:root";
                this.currentNodeServerCode = node.getServerCode();
                this.logger.info("Current node detected: " + this.currentNodeHostName + " with server code: " + this.currentNodeServerCode);
            } else {
                owner = "filesync:filesync";
            }
            String chownCommand = "chown -R " + owner + " " + folderPath;
            this.executeSystemCommand(chownCommand);
            this.logger.info("Set ownership of " + folderPath + " to " + owner);
        }
    }

    private void manageServices(Long nodeCount) {
        String message = "In manage Service method.";
        this.logger.info(message);
        String cmd = "";
        if (nodeCount > 1L) {
            message = "Enabling service coral-commandsync.service";
            this.logger.info(message);
            cmd = cmd + "systemctl enable";
            cmd = cmd + " ";
            cmd = cmd + "coral-commandsync.service";
            this.executeSystemCommand(cmd);
        }
    }

    public void executeSystemCommand(String cmd) {
        String str = "";
        StringBuilder output = new StringBuilder();
        String message = "";
        try {
            String[] finalCommand = this.readFullCommand(cmd);
            message = String.format("Final Command -> %s %s %s", finalCommand[0], finalCommand[1], finalCommand[2]);
            this.logger.info(message);
            Process p = Runtime.getRuntime().exec(finalCommand);
            p.waitFor();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((str = buffer.readLine()) != null) {
                output = output.append(str);
            }
            message = String.format("Done. Command %s Result %s", cmd, output.toString());
            this.logger.info(message);
        }
        catch (IOException ex) {
            message = String.format("Error in executeSystemCommand : IOException. %s", ex.getMessage());
            this.logger.info(message);
        }
        catch (InterruptedException ex) {
            message = String.format("Error in executeSystemCommand : InterruptedException. %s", ex.getMessage());
            this.logger.info(message);
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            message = String.format("Error in executeSystemCommand. %s", ex.getMessage());
            this.logger.info(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSIPServerConfiguration(String rootFolder, String serverIP, String rluCode, CSCF cscf, String ipPPDRServer) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate2;
        Throwable throwable;
        BufferedWriter out;
        String fileName = rluCode.isEmpty() ? "" : "_" + rluCode;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles/internal" + fileName + ".xml");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/internal.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$RLU", fileName);
                writeContent = writeContent.replace("$${local_ip_v4_internal}", serverIP);
                out.write(writeContent);
                this.logger.info("SIP Server Internal configuration populated");
            }
            catch (Throwable resourceTemplate2) {
                throwable = resourceTemplate2;
                throw resourceTemplate2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate2) {
                            throwable.addSuppressed(resourceTemplate2);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles/ppdr" + fileName + ".xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/ppdr.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$RLU", fileName);
                writeContent = writeContent.replace("$${local_ip_v4_ppdr}", ipPPDRServer);
                out.write(writeContent);
                this.logger.info("SIP Server PPDR configuration populated");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server PPDR configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles/hunting" + fileName + ".xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/hunting.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$RLU", fileName);
                writeContent = writeContent.replace("$${local_ip_v4_external}", serverIP);
                writeContent = writeContent.replace("$$context", "default");
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate4) {
                throwable = resourceTemplate4;
                throw resourceTemplate4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate4) {
                            throwable.addSuppressed(resourceTemplate4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles/fork" + fileName + ".xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/forkcall.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$RLU", fileName);
                writeContent = writeContent.replace("$${local_ip_v4_internal}", serverIP);
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTrunkConfiguration(String rootFolder, String serverIP, String rluCode, CSCF cscf) throws IOException {
        String fileName = rluCode.isEmpty() ? "" : "_" + rluCode;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/coraltele/" + (cscf.getEnableTrunkGatewayInService() != false ? "trunkgateway" : "sipserver") + "/conf/sip_profiles/external" + fileName + ".xml");
             BufferedWriter out = new BufferedWriter(fileWriter);){
            ClassPathResource resourceTemplate = new ClassPathResource("/sipserver/external.xml");
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String writeContent = writer.toString();
            writeContent = writeContent.replace("$$RLU", fileName);
            writeContent = writeContent.replace("$${local_ip_v4_external}", serverIP);
            writeContent = writeContent.replace("$$context", "trunkgateway");
            writeContent = writeContent.replace("$${external_sip_port}", this.usersTrunkPort);
            writeContent = writeContent.replace("$${external_tls_port}", this.usersTrunkPortTLS);
            writeContent = writeContent.replace("$$SIP_CAPTURE", this.hepVersion.equals("3") ? "yes" : "no");
            out.write(writeContent);
            this.logger.info("SIP Server External configuration populated");
        }
    }

    private void writeNodeModeAutoLoads(String rootFolder, String mode) throws IOException {
        if (mode.equalsIgnoreCase("CNPN")) {
            this.writeGenericFile(rootFolder, "Conference Profile", "/etc/coraltele/sipserver/conf/autoload_configs/conference.conf.xml", "/cnpn/conference.conf.xml");
        } else {
            this.writeGenericFile(rootFolder, "Conference Profile", "/etc/coraltele/sipserver/conf/autoload_configs/conference.conf.xml", "/pbx/conference.conf.xml");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGenericFile(String rootFolder, String fileType, String fileName, String resourcePath) throws IOException {
        try (FileWriter fileWriter = new FileWriter(rootFolder + fileName);
             BufferedWriter out = new BufferedWriter(fileWriter);){
            ClassPathResource resourceTemplate = new ClassPathResource(resourcePath);
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String writeContent = writer.toString();
            out.write(writeContent);
            this.logger.info(fileType + " configuration populated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTrunkAutoLoads(String rootFolder, Node node, CSCF cscf) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate2;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/coraltele/trunkgateway/conf/autoload_configs/cdr_pg_csv.conf.xml");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipgateways/cdr_pg_csv.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate2) {
                throwable = resourceTemplate2;
                throw resourceTemplate2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate2) {
                            throwable.addSuppressed(resourceTemplate2);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/trunkgateway/conf/autoload_configs/modules.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipgateways/modules.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = this.callCenterVersion.equals("0") ? writeContent.replace("$$CDR_PG_CSV", "<load module=\"mod_cdr_pg_csv\"/>") : writeContent.replace("$$CDR_PG_CSV", "");
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/trunkgateway/conf/autoload_configs/event_socket.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipgateways/event_socket.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate4) {
                throwable = resourceTemplate4;
                throw resourceTemplate4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate4) {
                            throwable.addSuppressed(resourceTemplate4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/trunkgateway/conf/autoload_configs/db.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipgateways/db.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate5) {
                throwable = resourceTemplate5;
                throw resourceTemplate5;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate5) {
                            throwable.addSuppressed(resourceTemplate5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/trunkgateway/conf/autoload_configs/sofia.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipgateways/sofia.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$IP", cscf.getIpStateMachine().isEmpty() ? node.getInterfaceAddress() : cscf.getIpStateMachine());
                out.write(writeContent);
                this.logger.info("SIP Server Sofia configuration populated");
            }
            catch (Throwable resourceTemplate6) {
                throwable = resourceTemplate6;
                throw resourceTemplate6;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate6) {
                            throwable.addSuppressed(resourceTemplate6);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server Sofia configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/trunkgateway/conf/autoload_configs/switch.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipgateways/switch.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PORT-START", Integer.toString(cscf.getFeatureMediaPortsStart()));
                writeContent = writeContent.replace("$$PORT-END", Integer.toString(cscf.getFeatureMediaPortsEnd()));
                writeContent = writeContent.replace("$$MAX_SESSIONS", this.maxSessions);
                writeContent = writeContent.replace("$$SESSIONS_PER_SECOND", this.sessionsPerSecond);
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate7) {
                throwable = resourceTemplate7;
                throw resourceTemplate7;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate7) {
                            throwable.addSuppressed(resourceTemplate7);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/trunkgateway/conf/autoload_configs/lua.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipgateways/lua.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server External Lua.conf.xml populated");
            }
            catch (Throwable resourceTemplate8) {
                throwable = resourceTemplate8;
                throw resourceTemplate8;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate8) {
                            throwable.addSuppressed(resourceTemplate8);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read External Lua.conf.xml populated", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/trunkgateway/conf/autoload_configs/logfile.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipgateways/logfile.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server External logfile.conf.xml populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read External logfile.conf.xml populated", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSIPServerAutoLoads(String rootFolder, String serverIP, Node node, CSCF cscf) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate2;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/vars.xml");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/vars.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                String publicIP = "";
                if (publicIP.isEmpty()) {
                    publicIP = serverIP;
                }
                writeContent = writeContent.replace("$$VIP", serverIP);
                writeContent = writeContent.replace("$$PUBLICVIP", publicIP);
                writeContent = writeContent.replace("$$DOMAIN", this.domainName);
                writeContent = writeContent.replace("$$SBC_USERS_PORT_TLS", this.usersSBCPortTLS);
                writeContent = writeContent.replace("$$SBC_USERS_PORT", this.usersSBCPort);
                writeContent = writeContent.replace("$$SIPSERVER_USERS_PORT_TLS", this.usersFeaturePortTLS);
                writeContent = writeContent.replace("$$SIPSERVER_USERS_PORT", this.usersFeaturePort);
                writeContent = writeContent.replace("$$SIPSERVER_GATEWAY_PORT_TLS", this.usersFeatureHuntingPortTLS);
                writeContent = writeContent.replace("$$SIPSERVER_GATEWAY_PORT", this.usersFeatureHuntingPort);
                out.write(writeContent);
                this.logger.info("SIP Server configuration populated");
            }
            catch (Throwable resourceTemplate2) {
                throwable = resourceTemplate2;
                throw resourceTemplate2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate2) {
                            throwable.addSuppressed(resourceTemplate2);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/sofia.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/sofia.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$IP", cscf.getIpStateMachine().isEmpty() ? node.getInterfaceAddress() : cscf.getIpStateMachine());
                out.write(writeContent);
                this.logger.info("SIP Server Sofia configuration populated");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server Sofia configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/xml_rpc.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/xml_rpc.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate4) {
                throwable = resourceTemplate4;
                throw resourceTemplate4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate4) {
                            throwable.addSuppressed(resourceTemplate4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/cdr_pg_csv.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/cdr_pg_csv.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate5) {
                throwable = resourceTemplate5;
                throw resourceTemplate5;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate5) {
                            throwable.addSuppressed(resourceTemplate5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/event_socket.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/event_socket.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate6) {
                throwable = resourceTemplate6;
                throw resourceTemplate6;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate6) {
                            throwable.addSuppressed(resourceTemplate6);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/db.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/db.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate7) {
                throwable = resourceTemplate7;
                throw resourceTemplate7;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate7) {
                            throwable.addSuppressed(resourceTemplate7);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/xml_rpc.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/xml_rpc.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate8) {
                throwable = resourceTemplate8;
                throw resourceTemplate8;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate8) {
                            throwable.addSuppressed(resourceTemplate8);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/modules.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/modules.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = this.callCenterVersion.equals("0") ? writeContent.replace("$$CDR_PG_CSV", "<load module=\"mod_cdr_pg_csv\"/>") : writeContent.replace("$$CDR_PG_CSV", "");
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate9) {
                throwable = resourceTemplate9;
                throw resourceTemplate9;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate9) {
                            throwable.addSuppressed(resourceTemplate9);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/switch.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/switch.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PORT-START", Integer.toString(cscf.getFeatureMediaPortsStart()));
                writeContent = writeContent.replace("$$PORT-END", Integer.toString(cscf.getFeatureMediaPortsEnd()));
                writeContent = writeContent.replace("$$MAX_SESSIONS", this.maxSessions);
                writeContent = writeContent.replace("$$SESSIONS_PER_SECOND", this.sessionsPerSecond);
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate10) {
                throwable = resourceTemplate10;
                throw resourceTemplate10;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate10) {
                            throwable.addSuppressed(resourceTemplate10);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/lua.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/lua.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server Lua.Conf configuration populated");
            }
            catch (Throwable resourceTemplate11) {
                throwable = resourceTemplate11;
                throw resourceTemplate11;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate11) {
                            throwable.addSuppressed(resourceTemplate11);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server Lua.Conf configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/voicemail.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/voicemail.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SERVERCODE", this.currentNodeServerCode);
                writeContent = writeContent.replace("$$HOSTNAME", this.currentNodeHostName);
                out.write(writeContent);
                this.logger.info("SIP Server voicemail.Conf configuration populated");
            }
            catch (Throwable resourceTemplate12) {
                throwable = resourceTemplate12;
                throw resourceTemplate12;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate12) {
                            throwable.addSuppressed(resourceTemplate12);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server voicemail.Conf configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/logfile.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sipserver/logfile.conf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server LogFile.Conf configuration populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server LogFile.Conf configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDNS(CSCF cscf, String rootFolder) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate2;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/bind/epc.mnc" + this.mobilityMNC + ".mcc" + this.mobilityMCC + ".3gppnetwork.org");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/dns/epc.domain");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$DNS-IP", cscf.getIpDNS() == null || cscf.getIpDNS().isEmpty() ? "127.0.0.2" : cscf.getIpDNS());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORALTELE DNS /etc/bind/epc.mnc" + this.mobilityMNC + ".mcc" + this.mobilityMCC + ".3gppnetwork.org Domain configuration populated");
            }
            catch (Throwable resourceTemplate2) {
                throwable = resourceTemplate2;
                throw resourceTemplate2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate2) {
                            throwable.addSuppressed(resourceTemplate2);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/etc/bind/ims.mnc" + this.mobilityMNC + ".mcc" + this.mobilityMCC + ".3gppnetwork.org");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/dns/ims.domain");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$DNS-IP", cscf.getIpDNS() == null || cscf.getIpDNS().isEmpty() ? "127.0.0.2" : cscf.getIpDNS());
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORALTELE DNS /etc/bind/ims.mnc" + this.mobilityMNC + ".mcc" + this.mobilityMCC + ".3gppnetwork.org configuration populated");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORALTELE DNS /etc/bind/ims.mnc" + this.mobilityMNC + ".mcc" + this.mobilityMCC + ".3gppnetwork.org configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/resolv.conf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/dns/resolv.conf");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$DNS-IP", cscf.getIpDNS() == null || cscf.getIpDNS().isEmpty() ? "127.0.0.2" : cscf.getIpDNS());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORALTELE DNS resolv.conf configuration populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORALTELE DNS resolv.conf configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCoreIMS(CSCF cscf, String rootFolder) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate2;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/opt/CoralIMS/etc/coralims_pcscf/coralims_pcscf.cfg");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/imscore/common/coralims_pcscf.cfg");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORE-IMS coralims_pcscf.cfg configuration populated");
            }
            catch (Throwable resourceTemplate2) {
                throwable = resourceTemplate2;
                throw resourceTemplate2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate2) {
                            throwable.addSuppressed(resourceTemplate2);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/opt/CoralIMS/etc/coralims_icscf/coralims_icscf.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/imscore/common/coralims_icscf.cfg");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORE-IMS coralims_icscf.cfg configuration populated");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORE-IMS coralims_icscf.cfg configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/CoralIMS/etc/coralims_scscf/coralims_scscf.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/imscore/common/coralims_scscf.cfg");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORE-IMS coralims_scscf.cfg configuration populated");
            }
            catch (Throwable resourceTemplate4) {
                throwable = resourceTemplate4;
                throw resourceTemplate4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate4) {
                            throwable.addSuppressed(resourceTemplate4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORE-IMS coralims_scscf.cfg configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/CoralIMS/etc/coralims_smsc/coralims_smsc.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/imscore/common/coralims_smsc.cfg");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORE-IMS coralims_smsc.cfg configuration populated");
            }
            catch (Throwable resourceTemplate5) {
                throwable = resourceTemplate5;
                throw resourceTemplate5;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate5) {
                            throwable.addSuppressed(resourceTemplate5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORE-IMS coralims_smsc.cfg configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/CoralIMS/etc/coralims_pcscf/route/rtp.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/imscore/common/rtp.cfg");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORE-IMS rtp.cfg configuration populated");
            }
            catch (Throwable resourceTemplate6) {
                throwable = resourceTemplate6;
                throw resourceTemplate6;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate6) {
                            throwable.addSuppressed(resourceTemplate6);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORE-IMS rtp.cfg configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/CoralIMS/etc/coralims_pcscf/pcscf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/imscore/common/pcscf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORE-IMS pcscf.xml configuration populated");
            }
            catch (Throwable resourceTemplate7) {
                throwable = resourceTemplate7;
                throw resourceTemplate7;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate7) {
                            throwable.addSuppressed(resourceTemplate7);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORE-IMS pcscf.xml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/CoralIMS/etc/coralims_icscf/icscf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/imscore/common/icscf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORE-IMS icscf.xml configuration populated");
            }
            catch (Throwable resourceTemplate8) {
                throwable = resourceTemplate8;
                throw resourceTemplate8;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate8) {
                            throwable.addSuppressed(resourceTemplate8);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORE-IMS icscf.xml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/CoralIMS/etc/coralims_scscf/scscf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/imscore/common/scscf.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORE-IMS scscf.xml configuration populated");
            }
            catch (Throwable resourceTemplate9) {
                throwable = resourceTemplate9;
                throw resourceTemplate9;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate9) {
                            throwable.addSuppressed(resourceTemplate9);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORE-IMS scscf.xml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/CoralIMS/etc/coralims_pcscf/pcscf.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/imscore/" + this.mobilityMode + "/pcscf.cfg");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORE-IMS pcscf.cfg configuration populated");
            }
            catch (Throwable resourceTemplate10) {
                throwable = resourceTemplate10;
                throw resourceTemplate10;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate10) {
                            throwable.addSuppressed(resourceTemplate10);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORE-IMS pcscf.cfg configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/CoralIMS/etc/coralims_icscf/icscf.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/imscore/common/icscf.cfg");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORE-IMS icscf.cfg configuration populated");
            }
            catch (Throwable resourceTemplate11) {
                throwable = resourceTemplate11;
                throw resourceTemplate11;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate11) {
                            throwable.addSuppressed(resourceTemplate11);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORE-IMS icscf.cfg configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/CoralIMS/etc/coralims_scscf/scscf.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/imscore/common/scscf.cfg");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("$$VCSCF-IP", cscf.getIpServicingCSCF());
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORE-IMS scscf.cfg configuration populated");
            }
            catch (Throwable resourceTemplate12) {
                throwable = resourceTemplate12;
                throw resourceTemplate12;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate12) {
                            throwable.addSuppressed(resourceTemplate12);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORE-IMS scscf.cfg configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/CoralIMS/etc/coralims_smsc/smsc.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/imscore/common/smsc.cfg");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("CORE-IMS smsc.cfg configuration populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read CORE-IMS smsc.cfg configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    private Integer addSlice(StringBuilder nssf, String SST, String SD, Integer slicesequence) {
        nssf.append(System.lineSeparator());
        nssf.append("      nsi:").append(System.lineSeparator());
        nssf.append("        - uri: http://127.0.0.10:7777").append(System.lineSeparator());
        nssf.append("          s_nssai:").append(System.lineSeparator());
        nssf.append("            sst: ").append(SST).append(System.lineSeparator());
        nssf.append("            sd: ").append(SD).append(System.lineSeparator());
        return slicesequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMME(CSCF cscf, String rootFolder) throws IOException {
        FileWriter fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/mme.yaml");
        if (!cscf.getIpMME().isEmpty() || !cscf.getIpAMF().isEmpty()) {
            if (this.mobilityMode.equals("volte") || this.mobilityMode.equals("vonr") || this.mobilityMode.equals("nsa")) {
                String writeContent;
                StringWriter writer;
                InputStream initialStream;
                ClassPathResource resourceTemplate2;
                Throwable throwable;
                BufferedWriter out;
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/amf.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/amf.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("$$AMF-IP", cscf.getIpAMF() == null || cscf.getIpAMF().isEmpty() ? "127.0.0.5" : cscf.getIpAMF());
                        writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                        writeContent = writeContent.replace("$$MMEMNC", this.mobilityMME_MNC == null || this.mobilityMME_MNC.isEmpty() ? "01" : this.mobilityMME_MNC);
                        writeContent = writeContent.replace("$$TAC", this.mobilityTAC == null || this.mobilityTAC.isEmpty() ? "1" : this.mobilityTAC);
                        if (!this.mobilitySST.isEmpty() && !this.mobilitySD.isEmpty()) {
                            writeContent = writeContent.replace("$$SST", "- sst: " + this.mobilitySST);
                            writeContent = writeContent.replace("$$SD", "sd: " + this.mobilitySD);
                        } else {
                            writeContent = writeContent.replace("$$SST", "");
                            writeContent = writeContent.replace("$$SD", "");
                            this.logger.info("Please Check SST or SD Value under MOBILITY Section");
                        }
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("AMF amf.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate2) {
                        throwable = resourceTemplate2;
                        throw resourceTemplate2;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate2) {
                                    throwable.addSuppressed(resourceTemplate2);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read AMF amf.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/ausf.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/ausf.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("AUSF ausf.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate3) {
                        throwable = resourceTemplate3;
                        throw resourceTemplate3;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate3) {
                                    throwable.addSuppressed(resourceTemplate3);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read AUSF ausf.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/bsf.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/bsf.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("BSF bsf.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate4) {
                        throwable = resourceTemplate4;
                        throw resourceTemplate4;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate4) {
                                    throwable.addSuppressed(resourceTemplate4);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read BSF bsf.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/hss.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/hss.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("HSS hss.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate5) {
                        throwable = resourceTemplate5;
                        throw resourceTemplate5;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate5) {
                                    throwable.addSuppressed(resourceTemplate5);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read HSS hss.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/hss.conf");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/hss.conf");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                        writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("HSS hss.conf configuration populated");
                    }
                    catch (Throwable resourceTemplate6) {
                        throwable = resourceTemplate6;
                        throw resourceTemplate6;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate6) {
                                    throwable.addSuppressed(resourceTemplate6);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read HSS hss.conf configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/mme.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/mme.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("$$MME-IP", cscf.getIpMME() == null || cscf.getIpMME().isEmpty() ? "127.0.0.2" : cscf.getIpMME());
                        writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                        writeContent = writeContent.replace("$$MMEMNC", this.mobilityMME_MNC == null || this.mobilityMME_MNC.isEmpty() ? "01" : this.mobilityMME_MNC);
                        writeContent = writeContent.replace("$$TAC", this.mobilityTAC == null || this.mobilityTAC.isEmpty() ? "1" : this.mobilityTAC);
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("MME mme.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate7) {
                        throwable = resourceTemplate7;
                        throw resourceTemplate7;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate7) {
                                    throwable.addSuppressed(resourceTemplate7);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read MME mme.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/mme.conf");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/mme.conf");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                        writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("MME mme.conf configuration populated");
                    }
                    catch (Throwable resourceTemplate8) {
                        throwable = resourceTemplate8;
                        throw resourceTemplate8;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate8) {
                                    throwable.addSuppressed(resourceTemplate8);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read MME mme.conf configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/nrf.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/nrf.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                        writeContent = writeContent.replace("$$MMEMNC", this.mobilityMME_MNC == null || this.mobilityMME_MNC.isEmpty() ? "01" : this.mobilityMME_MNC);
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("NRF nrf.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate9) {
                        throwable = resourceTemplate9;
                        throw resourceTemplate9;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate9) {
                                    throwable.addSuppressed(resourceTemplate9);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read NRF nrf.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/nssf.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/nssf.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        StringBuilder nssf = new StringBuilder(writeContent);
                        Integer slicesequence = 0;
                        if (!this.mobilitySST.isEmpty() && !this.mobilitySD.isEmpty()) {
                            slicesequence = this.addSlice(nssf, this.mobilitySST, this.mobilitySD, slicesequence);
                        } else if (this.mobilitySST.isEmpty() && this.mobilitySD.isEmpty()) {
                            this.logger.info("Please Check SST or SD Value under MOBILITY Section");
                        }
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(nssf.toString());
                        this.logger.info("NSSF nssf.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate10) {
                        throwable = resourceTemplate10;
                        throw resourceTemplate10;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate10) {
                                    throwable.addSuppressed(resourceTemplate10);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read NSSF nssf.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/pcf.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/pcf.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("PCF pcf.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate11) {
                        throwable = resourceTemplate11;
                        throw resourceTemplate11;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate11) {
                                    throwable.addSuppressed(resourceTemplate11);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read PCF pcf.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/pcrf.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/pcrf.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("PCRF pcrf.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate12) {
                        throwable = resourceTemplate12;
                        throw resourceTemplate12;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate12) {
                                    throwable.addSuppressed(resourceTemplate12);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read PCRF pcrf.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/pcrf.conf");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/pcrf.conf");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                        writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                        writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("PCRF pcrf.conf configuration populated");
                    }
                    catch (Throwable resourceTemplate13) {
                        throwable = resourceTemplate13;
                        throw resourceTemplate13;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate13) {
                                    throwable.addSuppressed(resourceTemplate13);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read PCRF pcrf.conf configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/scp.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/scp.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("SCP scp.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate14) {
                        throwable = resourceTemplate14;
                        throw resourceTemplate14;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate14) {
                                    throwable.addSuppressed(resourceTemplate14);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read SCP scp.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/sgwc.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/sgwc.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("SGWC sgwc.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate15) {
                        throwable = resourceTemplate15;
                        throw resourceTemplate15;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate15) {
                                    throwable.addSuppressed(resourceTemplate15);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read SGWC sgwc.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/sgwu.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/sgwu.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("$$MME-IP", cscf.getIpMME() == null || cscf.getIpMME().isEmpty() ? "127.0.0.6" : cscf.getIpMME());
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("SGWU sgwu.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate16) {
                        throwable = resourceTemplate16;
                        throw resourceTemplate16;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate16) {
                                    throwable.addSuppressed(resourceTemplate16);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read SGWU sgwu.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/smf.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/smf.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("$$DNS-IP", cscf.getIpDNS() == null || cscf.getIpDNS().isEmpty() ? "127.0.0.4" : cscf.getIpDNS());
                        writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.4" : cscf.getIpPCSCF());
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("SMF smf.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate17) {
                        throwable = resourceTemplate17;
                        throw resourceTemplate17;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate17) {
                                    throwable.addSuppressed(resourceTemplate17);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read SMF smf.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/smf.conf");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/smf.conf");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                        writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("SMF smf.conf configuration populated");
                    }
                    catch (Throwable resourceTemplate18) {
                        throwable = resourceTemplate18;
                        throw resourceTemplate18;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate18) {
                                    throwable.addSuppressed(resourceTemplate18);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read SMF smf.conf configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/udm.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/udm.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("UDM udm.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate19) {
                        throwable = resourceTemplate19;
                        throw resourceTemplate19;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate19) {
                                    throwable.addSuppressed(resourceTemplate19);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read UDM udm.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/udr.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/udr.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("UDR udr.yaml configuration populated");
                    }
                    catch (Throwable resourceTemplate20) {
                        throwable = resourceTemplate20;
                        throw resourceTemplate20;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable resourceTemplate20) {
                                    throwable.addSuppressed(resourceTemplate20);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read UDR udr.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
                fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/upf.yaml");
                try {
                    out = new BufferedWriter(fileWriter);
                    throwable = null;
                    try {
                        resourceTemplate2 = new ClassPathResource("/mobility/" + this.mobilityMode + "/upf.yaml");
                        initialStream = resourceTemplate2.getInputStream();
                        writer = new StringWriter();
                        IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                        writeContent = writer.toString();
                        writeContent = writeContent.replace("$$AMF-IP", cscf.getIpAMF() == null || cscf.getIpAMF().isEmpty() ? "127.0.0.7" : cscf.getIpAMF());
                        writeContent = writeContent.replace("\r\n", "\n");
                        out.write(writeContent);
                        this.logger.info("UPF upf.yaml configuration populated");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Exception E) {
                    this.logger.error("Unable to read UPF upf.yaml configuration", (Throwable)E);
                }
                finally {
                    fileWriter.close();
                }
            } else {
                this.logger.info("Please Define System Mode in which system has to configure From the Options volte/vonr/nsa");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeServiceSegregationMME(CSCF cscf, String rootFolder) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate2;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/amf.yaml");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/amf.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$AMF-NETWORK-IP", this.serviceSegregationAmfNetworkIp == null || this.serviceSegregationAmfNetworkIp.isEmpty() ? "127.0.0.5" : this.serviceSegregationAmfNetworkIp);
                writeContent = writeContent.replace("$$AMF-IP", this.serviceSegregationAmfIp == null || this.serviceSegregationAmfIp.isEmpty() ? "127.0.0.5" : this.serviceSegregationAmfIp);
                writeContent = writeContent.replace("$$SCP-IP", this.serviceSegregationScpIp == null || this.serviceSegregationScpIp.isEmpty() ? "127.0.0.200" : this.serviceSegregationScpIp);
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MMEMNC", this.mobilityMME_MNC == null || this.mobilityMME_MNC.isEmpty() ? "01" : this.mobilityMME_MNC);
                writeContent = writeContent.replace("$$TAC", this.mobilityTAC == null || this.mobilityTAC.isEmpty() ? "1" : this.mobilityTAC);
                if (!this.mobilitySST.isEmpty() && !this.mobilitySD.isEmpty()) {
                    writeContent = writeContent.replace("$$SST", "- sst: " + this.mobilitySST);
                    writeContent = writeContent.replace("$$SD", "sd: " + this.mobilitySD);
                } else {
                    writeContent = writeContent.replace("$$SST", "");
                    writeContent = writeContent.replace("$$SD", "");
                    this.logger.info("Please Check SST or SD Value under MOBILITY Section");
                }
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("AMF amf.yaml configuration populated");
            }
            catch (Throwable resourceTemplate2) {
                throwable = resourceTemplate2;
                throw resourceTemplate2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate2) {
                            throwable.addSuppressed(resourceTemplate2);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/ausf.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/ausf.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$AUSF-IP", this.serviceSegregationAusfIp == null || this.serviceSegregationAusfIp.isEmpty() ? "127.0.0.11" : this.serviceSegregationAusfIp);
                writeContent = writeContent.replace("$$SCP-IP", this.serviceSegregationScpIp == null || this.serviceSegregationScpIp.isEmpty() ? "127.0.0.200" : this.serviceSegregationScpIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("AUSF ausf.yaml configuration populated");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read AUSF ausf.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/bsf.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/bsf.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$BSF-IP", this.serviceSegregationBsfIp == null || this.serviceSegregationBsfIp.isEmpty() ? "127.0.0.15" : this.serviceSegregationBsfIp);
                writeContent = writeContent.replace("$$SCP-IP", this.serviceSegregationScpIp == null || this.serviceSegregationScpIp.isEmpty() ? "127.0.0.200" : this.serviceSegregationScpIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("BSF bsf.yaml configuration populated");
            }
            catch (Throwable resourceTemplate4) {
                throwable = resourceTemplate4;
                throw resourceTemplate4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate4) {
                            throwable.addSuppressed(resourceTemplate4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read BSF bsf.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/hss.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/hss.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$MONGO-IP", this.serviceSegregationUpfIp == null || this.serviceSegregationUpfIp.isEmpty() ? "localhost" : this.serviceSegregationUpfIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("HSS hss.yaml configuration populated");
            }
            catch (Throwable resourceTemplate5) {
                throwable = resourceTemplate5;
                throw resourceTemplate5;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate5) {
                            throwable.addSuppressed(resourceTemplate5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read HSS hss.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/hss.conf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/hss.conf");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("$$HSS-IP", this.serviceSegregationHssIp == null || this.serviceSegregationHssIp.isEmpty() ? "127.0.0.8" : this.serviceSegregationHssIp);
                writeContent = writeContent.replace("$$MME-IP", this.serviceSegregationMmeIp == null || this.serviceSegregationMmeIp.isEmpty() ? "127.0.0.2" : this.serviceSegregationMmeIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("HSS hss.conf configuration populated");
            }
            catch (Throwable resourceTemplate6) {
                throwable = resourceTemplate6;
                throw resourceTemplate6;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate6) {
                            throwable.addSuppressed(resourceTemplate6);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read HSS hss.conf configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/mme.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/mme.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$MME-NETWORK-IP", this.serviceSegregationMmeNetworkIp == null || this.serviceSegregationMmeNetworkIp.isEmpty() ? "127.0.0.2" : this.serviceSegregationMmeNetworkIp);
                writeContent = writeContent.replace("$$MME-IP", this.serviceSegregationMmeIp == null || this.serviceSegregationMmeIp.isEmpty() ? "127.0.0.2" : this.serviceSegregationMmeIp);
                writeContent = writeContent.replace("$$SGWC-IP", this.serviceSegregationSgwcIp == null || this.serviceSegregationSgwcIp.isEmpty() ? "127.0.0.3" : this.serviceSegregationSgwcIp);
                writeContent = writeContent.replace("$$SMF-IP", this.serviceSegregationSmfIp == null || this.serviceSegregationSmfIp.isEmpty() ? "127.0.0.4" : this.serviceSegregationSmfIp);
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MMEMNC", this.mobilityMME_MNC == null || this.mobilityMME_MNC.isEmpty() ? "01" : this.mobilityMME_MNC);
                writeContent = writeContent.replace("$$TAC", this.mobilityTAC == null || this.mobilityTAC.isEmpty() ? "1" : this.mobilityTAC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("MME mme.yaml configuration populated");
            }
            catch (Throwable resourceTemplate7) {
                throwable = resourceTemplate7;
                throw resourceTemplate7;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate7) {
                            throwable.addSuppressed(resourceTemplate7);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read MME mme.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/mme.conf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/mme.conf");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("$$MME-IP", this.serviceSegregationMmeIp == null || this.serviceSegregationMmeIp.isEmpty() ? "127.0.0.2" : this.serviceSegregationMmeIp);
                writeContent = writeContent.replace("$$HSS-IP", this.serviceSegregationHssIp == null || this.serviceSegregationHssIp.isEmpty() ? "127.0.0.8" : this.serviceSegregationHssIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("MME mme.conf configuration populated");
            }
            catch (Throwable resourceTemplate8) {
                throwable = resourceTemplate8;
                throw resourceTemplate8;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate8) {
                            throwable.addSuppressed(resourceTemplate8);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read MME mme.conf configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/nrf.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/nrf.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MMEMNC", this.mobilityMME_MNC == null || this.mobilityMME_MNC.isEmpty() ? "01" : this.mobilityMME_MNC);
                writeContent = writeContent.replace("$$NRF-IP", this.serviceSegregationNrfIp == null || this.serviceSegregationNrfIp.isEmpty() ? "127.0.0.10" : this.serviceSegregationNrfIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("NRF nrf.yaml configuration populated");
            }
            catch (Throwable resourceTemplate9) {
                throwable = resourceTemplate9;
                throw resourceTemplate9;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate9) {
                            throwable.addSuppressed(resourceTemplate9);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read NRF nrf.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/nssf.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/nssf.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$NSSF-IP", this.serviceSegregationNssfIp == null || this.serviceSegregationNssfIp.isEmpty() ? "127.0.0.14" : this.serviceSegregationNssfIp);
                writeContent = writeContent.replace("$$SCP-IP", this.serviceSegregationScpIp == null || this.serviceSegregationScpIp.isEmpty() ? "127.0.0.200" : this.serviceSegregationScpIp);
                writeContent = writeContent.replace("$$NRF-IP", this.serviceSegregationNrfIp == null || this.serviceSegregationNrfIp.isEmpty() ? "127.0.0.10" : this.serviceSegregationNrfIp);
                StringBuilder nssf = new StringBuilder(writeContent);
                Integer slicesequence = 0;
                if (!this.mobilitySST.isEmpty() && !this.mobilitySD.isEmpty()) {
                    slicesequence = this.addSlice(nssf, this.mobilitySST, this.mobilitySD, slicesequence);
                } else if (this.mobilitySST.isEmpty() && this.mobilitySD.isEmpty()) {
                    this.logger.info("Please Check SST or SD Value under MOBILITY Section");
                }
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(nssf.toString());
                this.logger.info("NSSF nssf.yaml configuration populated");
            }
            catch (Throwable resourceTemplate10) {
                throwable = resourceTemplate10;
                throw resourceTemplate10;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate10) {
                            throwable.addSuppressed(resourceTemplate10);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read NSSF nssf.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/pcf.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/pcf.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCF-IP", this.serviceSegregationPcfIp == null || this.serviceSegregationPcfIp.isEmpty() ? "127.0.0.13" : this.serviceSegregationPcfIp);
                writeContent = writeContent.replace("$$SCP-IP", this.serviceSegregationScpIp == null || this.serviceSegregationScpIp.isEmpty() ? "127.0.0.200" : this.serviceSegregationScpIp);
                writeContent = writeContent.replace("$$MONGO-IP", this.serviceSegregationUpfIp == null || this.serviceSegregationUpfIp.isEmpty() ? "localhost" : this.serviceSegregationUpfIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("PCF pcf.yaml configuration populated");
            }
            catch (Throwable resourceTemplate11) {
                throwable = resourceTemplate11;
                throw resourceTemplate11;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate11) {
                            throwable.addSuppressed(resourceTemplate11);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read PCF pcf.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/pcrf.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/pcrf.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$MONGO-IP", this.serviceSegregationUpfIp == null || this.serviceSegregationUpfIp.isEmpty() ? "localhost" : this.serviceSegregationUpfIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("PCRF pcrf.yaml configuration populated");
            }
            catch (Throwable resourceTemplate12) {
                throwable = resourceTemplate12;
                throw resourceTemplate12;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate12) {
                            throwable.addSuppressed(resourceTemplate12);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read PCRF pcrf.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/pcrf.conf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/pcrf.conf");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCRF-IP", this.serviceSegregationPcrfIp == null || this.serviceSegregationPcrfIp.isEmpty() ? "127.0.0.9" : this.serviceSegregationPcrfIp);
                writeContent = writeContent.replace("$$SMF-IP", this.serviceSegregationSmfIp == null || this.serviceSegregationSmfIp.isEmpty() ? "127.0.0.4" : this.serviceSegregationSmfIp);
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("PCRF pcrf.conf configuration populated");
            }
            catch (Throwable resourceTemplate13) {
                throwable = resourceTemplate13;
                throw resourceTemplate13;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate13) {
                            throwable.addSuppressed(resourceTemplate13);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read PCRF pcrf.conf configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/scp.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/scp.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SCP-IP", this.serviceSegregationScpIp == null || this.serviceSegregationScpIp.isEmpty() ? "127.0.0.200" : this.serviceSegregationScpIp);
                writeContent = writeContent.replace("$$NRF-IP", this.serviceSegregationNrfIp == null || this.serviceSegregationNrfIp.isEmpty() ? "127.0.0.10" : this.serviceSegregationNrfIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("SCP scp.yaml configuration populated");
            }
            catch (Throwable resourceTemplate14) {
                throwable = resourceTemplate14;
                throw resourceTemplate14;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate14) {
                            throwable.addSuppressed(resourceTemplate14);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SCP scp.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/sgwc.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/sgwc.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SGWC-IP", this.serviceSegregationSgwcIp == null || this.serviceSegregationSgwcIp.isEmpty() ? "127.0.0.3" : this.serviceSegregationSgwcIp);
                writeContent = writeContent.replace("$$SGWU-IP", this.serviceSegregationSgwuIp == null || this.serviceSegregationSgwuIp.isEmpty() ? "127.0.0.6" : this.serviceSegregationSgwuIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("SGWC sgwc.yaml configuration populated");
            }
            catch (Throwable resourceTemplate15) {
                throwable = resourceTemplate15;
                throw resourceTemplate15;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate15) {
                            throwable.addSuppressed(resourceTemplate15);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SGWC sgwc.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/sgwu.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/sgwu.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SGWU-NETWORK-IP", this.serviceSegregationSgwuNetworkIp == null || this.serviceSegregationSgwuNetworkIp.isEmpty() ? "127.0.0.6" : this.serviceSegregationSgwuNetworkIp);
                writeContent = writeContent.replace("$$SGWU-IP", this.serviceSegregationSgwuIp == null || this.serviceSegregationSgwuIp.isEmpty() ? "127.0.0.6" : this.serviceSegregationSgwuIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("SGWU sgwu.yaml configuration populated");
            }
            catch (Throwable resourceTemplate16) {
                throwable = resourceTemplate16;
                throw resourceTemplate16;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate16) {
                            throwable.addSuppressed(resourceTemplate16);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SGWU sgwu.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/smf.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/smf.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SMF-IP", this.serviceSegregationSmfIp == null || this.serviceSegregationSmfIp.isEmpty() ? "127.0.0.4" : this.serviceSegregationSmfIp);
                writeContent = writeContent.replace("$$SCP-IP", this.serviceSegregationScpIp == null || this.serviceSegregationScpIp.isEmpty() ? "127.0.0.200" : this.serviceSegregationScpIp);
                writeContent = writeContent.replace("$$UPF-IP", this.serviceSegregationUpfIp == null || this.serviceSegregationUpfIp.isEmpty() ? "127.0.0.7" : this.serviceSegregationUpfIp);
                writeContent = writeContent.replace("$$DNS-IP", cscf.getIpDNS() == null || cscf.getIpDNS().isEmpty() ? "127.0.0.4" : cscf.getIpDNS());
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.4" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("SMF smf.yaml configuration populated");
            }
            catch (Throwable resourceTemplate17) {
                throwable = resourceTemplate17;
                throw resourceTemplate17;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate17) {
                            throwable.addSuppressed(resourceTemplate17);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SMF smf.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/smf.conf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/smf.conf");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SMF-IP", this.serviceSegregationSmfIp == null || this.serviceSegregationSmfIp.isEmpty() ? "127.0.0.4" : this.serviceSegregationSmfIp);
                writeContent = writeContent.replace("$$PCRF-IP", this.serviceSegregationPcrfIp == null || this.serviceSegregationPcrfIp.isEmpty() ? "127.0.0.9" : this.serviceSegregationPcrfIp);
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("SMF smf.conf configuration populated");
            }
            catch (Throwable resourceTemplate18) {
                throwable = resourceTemplate18;
                throw resourceTemplate18;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate18) {
                            throwable.addSuppressed(resourceTemplate18);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SMF smf.conf configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/udm.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/udm.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$UDM-IP", this.serviceSegregationUdmIp == null || this.serviceSegregationUdmIp.isEmpty() ? "127.0.0.12" : this.serviceSegregationUdmIp);
                writeContent = writeContent.replace("$$SCP-IP", this.serviceSegregationScpIp == null || this.serviceSegregationScpIp.isEmpty() ? "127.0.0.200" : this.serviceSegregationScpIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("UDM udm.yaml configuration populated");
            }
            catch (Throwable resourceTemplate19) {
                throwable = resourceTemplate19;
                throw resourceTemplate19;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate19) {
                            throwable.addSuppressed(resourceTemplate19);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read UDM udm.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/udr.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/udr.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$UDR-IP", this.serviceSegregationUdrIp == null || this.serviceSegregationUdrIp.isEmpty() ? "127.0.0.20" : this.serviceSegregationUdrIp);
                writeContent = writeContent.replace("$$SCP-IP", this.serviceSegregationScpIp == null || this.serviceSegregationScpIp.isEmpty() ? "127.0.0.200" : this.serviceSegregationScpIp);
                writeContent = writeContent.replace("$$MONGO-IP", this.serviceSegregationUpfIp == null || this.serviceSegregationUpfIp.isEmpty() ? "localhost" : this.serviceSegregationUpfIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("UDR udr.yaml configuration populated");
            }
            catch (Throwable resourceTemplate20) {
                throwable = resourceTemplate20;
                throw resourceTemplate20;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate20) {
                            throwable.addSuppressed(resourceTemplate20);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read UDR udr.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/etc/coral5gs/upf.yaml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/upf.yaml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$UPF-NETWORK-IP", this.serviceSegregationUpfNetworkIp == null || this.serviceSegregationUpfNetworkIp.isEmpty() ? "127.0.0.7" : this.serviceSegregationUpfNetworkIp);
                writeContent = writeContent.replace("$$UPF-IP", this.serviceSegregationUpfIp == null || this.serviceSegregationUpfIp.isEmpty() ? "127.0.0.7" : this.serviceSegregationUpfIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("UPF upf.yaml configuration populated");
            }
            catch (Throwable resourceTemplate21) {
                throwable = resourceTemplate21;
                throw resourceTemplate21;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate21) {
                            throwable.addSuppressed(resourceTemplate21);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read UPF upf.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/mongod.conf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/mongo_file/mongod.conf");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$MONGO-IP", this.serviceSegregationUpfIp == null || this.serviceSegregationUpfIp.isEmpty() ? "localhost" : this.serviceSegregationUpfIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("UPF upf.yaml configuration populated");
            }
            catch (Throwable resourceTemplate22) {
                throwable = resourceTemplate22;
                throw resourceTemplate22;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate22) {
                            throwable.addSuppressed(resourceTemplate22);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read UPF upf.yaml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/scripts/servicesegrationRoute.sh");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/scripts/servicesegrationRoute.sh");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SERVICE-STARTING-IP", this.serviceSegregationStartingIp == null || this.serviceSegregationStartingIp.isEmpty() ? "127.0.0.1" : this.serviceSegregationStartingIp).replace("$$SERVICE-SUBNET", this.serviceSegregationServiceCidr == null || this.serviceSegregationServiceCidr.isEmpty() ? "24" : this.serviceSegregationServiceCidr).replace("$$AMF-IP", this.serviceSegregationAmfIp == null || this.serviceSegregationAmfIp.isEmpty() ? "127.0.0.5" : this.serviceSegregationAmfIp).replace("$$AUSF-IP", this.serviceSegregationAusfIp == null || this.serviceSegregationAusfIp.isEmpty() ? "127.0.0.11" : this.serviceSegregationAusfIp).replace("$$BSF-IP", this.serviceSegregationBsfIp == null || this.serviceSegregationBsfIp.isEmpty() ? "127.0.0.15" : this.serviceSegregationBsfIp).replace("$$HSS-IP", this.serviceSegregationHssIp == null || this.serviceSegregationHssIp.isEmpty() ? "127.0.0.8" : this.serviceSegregationHssIp).replace("$$MME-IP", this.serviceSegregationMmeIp == null || this.serviceSegregationMmeIp.isEmpty() ? "127.0.0.2" : this.serviceSegregationMmeIp).replace("$$NRF-IP", this.serviceSegregationNrfIp == null || this.serviceSegregationNrfIp.isEmpty() ? "127.0.0.10" : this.serviceSegregationNrfIp).replace("$$NSSF-IP", this.serviceSegregationNssfIp == null || this.serviceSegregationNssfIp.isEmpty() ? "127.0.0.14" : this.serviceSegregationNssfIp).replace("$$PCF-IP", this.serviceSegregationPcfIp == null || this.serviceSegregationPcfIp.isEmpty() ? "127.0.0.13" : this.serviceSegregationPcfIp).replace("$$PCRF-IP", this.serviceSegregationPcrfIp == null || this.serviceSegregationPcrfIp.isEmpty() ? "127.0.0.9" : this.serviceSegregationPcrfIp).replace("$$SCP-IP", this.serviceSegregationScpIp == null || this.serviceSegregationScpIp.isEmpty() ? "127.0.0.200" : this.serviceSegregationScpIp).replace("$$SGWC-IP", this.serviceSegregationSgwcIp == null || this.serviceSegregationSgwcIp.isEmpty() ? "127.0.0.3" : this.serviceSegregationSgwcIp).replace("$$SGWU-IP", this.serviceSegregationSgwuIp == null || this.serviceSegregationSgwuIp.isEmpty() ? "127.0.0.6" : this.serviceSegregationSgwuIp).replace("$$SMF-IP", this.serviceSegregationSmfIp == null || this.serviceSegregationSmfIp.isEmpty() ? "127.0.0.4" : this.serviceSegregationSmfIp).replace("$$UDM-IP", this.serviceSegregationUdmIp == null || this.serviceSegregationUdmIp.isEmpty() ? "127.0.0.12" : this.serviceSegregationUdmIp).replace("$$UDR-IP", this.serviceSegregationUdrIp == null || this.serviceSegregationUdrIp.isEmpty() ? "127.0.0.20" : this.serviceSegregationUdrIp).replace("$$AMF-EXTERNAL-IP", this.serviceSegregationAmfNetworkIp == null || this.serviceSegregationAmfNetworkIp.isEmpty() ? "127.0.0.101" : this.serviceSegregationAmfNetworkIp).replace("$$MME-EXTERNAL-IP", this.serviceSegregationMmeNetworkIp == null || this.serviceSegregationMmeNetworkIp.isEmpty() ? "127.0.0.102" : this.serviceSegregationMmeNetworkIp).replace("$$SGWU-EXTERNAL-IP", this.serviceSegregationSgwuNetworkIp == null || this.serviceSegregationSgwuNetworkIp.isEmpty() ? "127.0.0.103" : this.serviceSegregationSgwuNetworkIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("servicesegrationRoute.sh script generated successfully.");
            }
            catch (Throwable resourceTemplate23) {
                throwable = resourceTemplate23;
                throw resourceTemplate23;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate23) {
                            throwable.addSuppressed(resourceTemplate23);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error generating servicesegrationRoute.sh", (Throwable)e);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/systemd/coral5gs-servicesegrationroute.service");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/systemd/coral5gs-servicesegrationroute.service");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("coral5gs-servicesegrationroute.service systemd unit populated from template");
            }
            catch (Throwable resourceTemplate24) {
                throwable = resourceTemplate24;
                throw resourceTemplate24;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate24) {
                            throwable.addSuppressed(resourceTemplate24);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to read coral5gs-servicesegrationroute.service template", (Throwable)e);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/applications/nef/nef");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/5gapplications/nef");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SCP-IP", this.serviceSegregationScpIp == null || this.serviceSegregationScpIp.isEmpty() ? "127.0.0.200" : this.serviceSegregationScpIp);
                writeContent = writeContent.replace("$$PCF-IP", this.serviceSegregationPcfIp == null || this.serviceSegregationPcfIp.isEmpty() ? "127.0.0.13" : this.serviceSegregationPcfIp);
                writeContent = writeContent.replace("$$UPF-NETWORK-IP", this.serviceSegregationUpfNetworkIp == null || this.serviceSegregationUpfNetworkIp.isEmpty() ? "127.0.0.1" : this.serviceSegregationUpfNetworkIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("NEF application configuration populated from template");
            }
            catch (Throwable resourceTemplate25) {
                throwable = resourceTemplate25;
                throw resourceTemplate25;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate25) {
                            throwable.addSuppressed(resourceTemplate25);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to read NEF application configuration template", (Throwable)e);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/coral5gs/applications/nwdaf/nwdaf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/segratedservices/5gapplications/nwdaf");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SCP-IP", this.serviceSegregationScpIp == null || this.serviceSegregationScpIp.isEmpty() ? "127.0.0.200" : this.serviceSegregationScpIp);
                writeContent = writeContent.replace("$$PCF-IP", this.serviceSegregationPcfIp == null || this.serviceSegregationPcfIp.isEmpty() ? "127.0.0.13" : this.serviceSegregationPcfIp);
                writeContent = writeContent.replace("$$AMF-IP", this.serviceSegregationAmfIp == null || this.serviceSegregationAmfIp.isEmpty() ? "127.0.0.5" : this.serviceSegregationAmfIp);
                writeContent = writeContent.replace("$$UPF-IP", this.serviceSegregationUpfIp == null || this.serviceSegregationUpfIp.isEmpty() ? "127.0.0.7" : this.serviceSegregationUpfIp);
                writeContent = writeContent.replace("$$SMF-IP", this.serviceSegregationSmfIp == null || this.serviceSegregationSmfIp.isEmpty() ? "127.0.0.4" : this.serviceSegregationSmfIp);
                writeContent = writeContent.replace("$$UPF-NETWORK-IP", this.serviceSegregationUpfNetworkIp == null || this.serviceSegregationUpfNetworkIp.isEmpty() ? "127.0.0.1" : this.serviceSegregationUpfNetworkIp);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("NWDAF application configuration populated from template");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to read NWDAF application configuration template", (Throwable)e);
        }
        finally {
            fileWriter.close();
        }
        this.executeCommand(rootFolder + "/opt/coral5gs/scripts/servicesegrationRoute.sh");
        this.executeCommand(rootFolder + "ln -sfn /opt/coral5gs/systemd/coral5gs-servicesegrationroute.service /lib/systemd/system/coral5gs-servicesegrationroute.service");
        this.executeCommand(rootFolder + "/bin/systemctl enable coral5gs-servicesegrationroute.service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMYSQL(String rootFolder) throws IOException {
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/mysql/mariadb.conf.d/50-server.cnf");
             BufferedWriter out = new BufferedWriter(fileWriter);){
            ClassPathResource resourceTemplate = new ClassPathResource("/mobility/mysql/50-server.cnf");
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String writeContent = writer.toString();
            writeContent = writeContent.replace("\r\n", "\n");
            out.write(writeContent);
            this.logger.info("MYSQL 50-server.cnf configuration populated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHSS(CSCF cscf, String rootFolder) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate2;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/opt/OpenIMSCore/FHoSS/config/DiameterPeerHSS.xml");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/hss/config_DiameterPeerHSS.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("HSS Config DiameterPeerHSS.xml configuration populated");
            }
            catch (Throwable resourceTemplate2) {
                throwable = resourceTemplate2;
                throw resourceTemplate2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate2) {
                            throwable.addSuppressed(resourceTemplate2);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/opt/OpenIMSCore/FHoSS/config/hss.properties");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/hss/config_hss.properties");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("HSS Config hss.properties configuration populated");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read HSS Config hss.properties configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/OpenIMSCore/FHoSS/deploy/DiameterPeerHSS.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/hss/deploy_DiameterPeerHSS.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("HSS Deploy DiameterPeerHSS.xml configuration populated");
            }
            catch (Throwable resourceTemplate4) {
                throwable = resourceTemplate4;
                throw resourceTemplate4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate4) {
                            throwable.addSuppressed(resourceTemplate4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read HSS Deploy DiameterPeerHSS.xml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/OpenIMSCore/FHoSS/deploy/hss.properties");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/hss/deploy_hss.properties");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("HSS Deploy hss.properties configuration populated");
            }
            catch (Throwable resourceTemplate5) {
                throwable = resourceTemplate5;
                throw resourceTemplate5;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate5) {
                            throwable.addSuppressed(resourceTemplate5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read HSS Deploy hss.properties configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/OpenIMSCore/FHoSS/deploy/webapps/hss.web.console/WEB-INF/web.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/hss/deploy_web.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("HSS Deploy web.xml configuration populated");
            }
            catch (Throwable resourceTemplate6) {
                throwable = resourceTemplate6;
                throw resourceTemplate6;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate6) {
                            throwable.addSuppressed(resourceTemplate6);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read HSS Deploy web.xml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/OpenIMSCore/FHoSS/src-web/WEB-INF/web.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/hss/src_web.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("HSS SRC-WEB web.xml configuration populated");
            }
            catch (Throwable resourceTemplate7) {
                throwable = resourceTemplate7;
                throw resourceTemplate7;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate7) {
                            throwable.addSuppressed(resourceTemplate7);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read HSS SRC-WEB web.xml configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/opt/OpenIMSCore/FHoSS/scripts/userdata.sql");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/hss/scripts_userdata.sql");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("$$PCSCF-IP", cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("HSS SCRIPT userdata.sql configuration populated");
            }
            catch (Throwable resourceTemplate8) {
                throwable = resourceTemplate8;
                throw resourceTemplate8;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate8) {
                            throwable.addSuppressed(resourceTemplate8);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read HSS SCRIPT userdata.sql configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/tmp/core_details.txt");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/mobility/certs/core_details.txt");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$MCC", this.mobilityMCC == null || this.mobilityMCC.isEmpty() ? "001" : this.mobilityMCC);
                writeContent = writeContent.replace("$$MNC", this.mobilityMNC == null || this.mobilityMNC.isEmpty() ? "001" : this.mobilityMNC);
                writeContent = writeContent.replace("\r\n", "\n");
                out.write(writeContent);
                this.logger.info("Writing Temp File For Core Certs Creation configuration populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read Writing Temp File For Core Certs Creation configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        String command = MessageFormat.format("/opt/coral5gs/scripts/configure-HSS-DB {0} {1} {2}", this.mobilityMNC, this.mobilityMCC, cscf.getIpPCSCF() == null || cscf.getIpPCSCF().isEmpty() ? "127.0.0.2" : cscf.getIpPCSCF());
        this.executeCommand(command);
        String commandMakeCerts = MessageFormat.format("/opt/coral5gs/scripts/make_certs.sh /opt/coral5gs/etc/coral5gs/tls", "");
        this.executeCommand(commandMakeCerts);
    }

    public StringBuilder executeCommand(String command) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        String message = String.format("%s : To Execute", command);
        this.logger.info(command);
        StringBuilder output = new StringBuilder();
        processBuilder.command("bash", "-c", command);
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                output.append(line + "\n");
            }
            message = String.format("%s : Executed", command);
            this.logger.info(message);
        }
        catch (Exception e) {
            this.logger.error("Error while executing command", (Throwable)e);
        }
        return output;
    }

    private String[] readFullCommand(String cmd) {
        String[] returnValue = new String[]{"/bin/bash", "-c", cmd};
        return returnValue;
    }

    private String getHostName() {
        String hostName = "";
        try {
            hostName = this.execReadToString("hostname").replaceAll("[^a-zA-Z0-9]", "");
            String message = String.format("Hostname identified %s ", hostName);
            this.logger.info(message);
        }
        catch (IOException e) {
            this.logger.error("Unable to get hostname.");
        }
        return hostName;
    }

    private String execReadToString(String execCommand) throws IOException {
        try (Scanner s = new Scanner(Runtime.getRuntime().exec(execCommand).getInputStream()).useDelimiter("\\A");){
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    public void managecnpnServices(boolean enable) {
        String[] cnpnServices = new String[]{"coral5gs-amfd.service", "coral5gs-nrfd.service", "coral5gs-sgwcd.service", "coral5gs-udrd.service", "coral5gs-ausfd.service", "coral5gs-nssfd.service", "coral5gs-sgwud.service", "coral5gs-upfd.service", "coral5gs-bsfd.service", "coral5gs-pcfd.service", "coral5gs-smfd.service", "coral5gs-webui.service", "coral5gs-hssd.service", "coral5gs-pcrfd.service", "coral5gs-tunnel.service", "coral5gs-mmed.service", "coral5gs-scpd.service", "coral5gs-udmd.service", "CoralIMS-hss.service", "CoralIMS-pcscf.service", "CoralIMS-smsc.service", "CoralIMS-icscf.service", "CoralIMS-scscf.service", "coral-websocketservice.service", "sbc.service", "coral-ppdr-conference.service"};
        String action = enable ? "enable" : "disable";
        for (String service : cnpnServices) {
            String command = "systemctl " + action + " " + service;
            StringBuilder result = this.executeCommand(command);
            this.logger.info(action.substring(0, 1).toUpperCase() + action.substring(1) + " Output for " + service + ":\n" + result.toString());
        }
    }

    public void manageCoreServiceSegregatedServices(boolean enable) {
        StringBuilder result;
        String command;
        String[] cnpnServices = new String[]{"coral5gs-upfd.service", "coral5gs-webui.service", "coral5gs-tunnel.service", "CoralIMS-hss.service", "CoralIMS-pcscf.service", "CoralIMS-smsc.service", "CoralIMS-icscf.service", "CoralIMS-scscf.service", "coral-websocketservice.service", "sbc.service", "coral-ppdr-conference.service", "coral5gs-servicesegrationroute.service", "coral5gs-nwdafd.service", "coral5gs-nefd.service"};
        String[] serviceSegregationServices = new String[]{"coral5gs-amfd.service", "coral5gs-nrfd.service", "coral5gs-sgwcd.service", "coral5gs-udrd.service", "coral5gs-ausfd.service", "coral5gs-nssfd.service", "coral5gs-sgwud.service", "coral5gs-bsfd.service", "coral5gs-pcfd.service", "coral5gs-smfd.service", "coral5gs-hssd.service", "coral5gs-pcrfd.service", "coral5gs-mmed.service", "coral5gs-scpd.service", "coral5gs-udmd.service"};
        String action = enable ? "enable" : "disable";
        for (String service : cnpnServices) {
            command = "systemctl " + action + " " + service;
            result = this.executeCommand(command);
            this.logger.info(action.substring(0, 1).toUpperCase() + action.substring(1) + " Output for " + service + ":\n" + result.toString());
        }
        for (String service : serviceSegregationServices) {
            command = "systemctl disable " + service;
            result = this.executeCommand(command);
            this.logger.info(action.substring(0, 1).toUpperCase() + action.substring(1) + " Output for " + service + ":\n" + result.toString());
        }
    }

    public void managebaseServices(boolean enable) {
        String[] baseServices = new String[]{"coral-manager.service", "coral-cliserver.service", "coral-cliservice.service", "coral-services-v2.service", "callserver.service", "sipserver.service", "fallbackserver.service", "coral-iriscloud.service", "coral-telemetry.service", "bind9.service", "mongod.service"};
        String action = enable ? "enable" : "disable";
        for (String service : baseServices) {
            String command = "systemctl " + action + " " + service;
            StringBuilder result = this.executeCommand(command);
            this.logger.info(action.substring(0, 1).toUpperCase() + action.substring(1) + " Output for " + service + ":\n" + result.toString());
        }
    }

    public void manageHsbServices(boolean enable) {
        String[] hsbServices = new String[]{"keepalived.service"};
        String action = enable ? "enable" : "disable";
        for (String service : hsbServices) {
            String command = "systemctl " + action + " " + service;
            StringBuilder result = this.executeCommand(command);
            this.logger.info(action.substring(0, 1).toUpperCase() + action.substring(1) + " Output for " + service + ":\n" + result.toString());
        }
    }

    public void managePbxServices(boolean enable) {
        String[] pbxServices = new String[]{"coral-ims-v2.service"};
        String action = enable ? "enable" : "disable";
        for (String service : pbxServices) {
            String command = "systemctl " + action + " " + service;
            StringBuilder result = this.executeCommand(command);
            this.logger.info(action.substring(0, 1).toUpperCase() + action.substring(1) + " Output for " + service + ":\n" + result.toString());
        }
    }

    private static String capitalize(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String calculateNetworkAddress(String ipWithCidr) throws UnknownHostException {
        String[] parts = ipWithCidr.split("/");
        String ipStr = parts[0];
        int prefix = Integer.parseInt(parts[1]);
        byte[] ip = InetAddress.getByName(ipStr).getAddress();
        int mask = -1 << 32 - prefix;
        int ipInt = (ip[0] & 0xFF) << 24 | (ip[1] & 0xFF) << 16 | (ip[2] & 0xFF) << 8 | ip[3] & 0xFF;
        int network = ipInt & mask;
        return String.format("%d.%d.%d.%d", network >> 24 & 0xFF, network >> 16 & 0xFF, network >> 8 & 0xFF, network & 0xFF);
    }

    public void start5gsContainersWithDockerRun(List<String> modules) {
        this.logger.info("Starting 5GS containers using docker run...");
        for (String module : modules) {
            String fieldName = "serviceSegregation" + ConfigureNodeV2.capitalize((String)module) + "Ip";
            String ipAddress = "";
            try {
                Field field = this.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                ipAddress = (String)field.get(this);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                this.logger.warn("IP address for {} not found in instance variables.", (Object)module, (Object)e);
                continue;
            }
            if (ipAddress == null || ipAddress.isEmpty()) {
                this.logger.warn("Skipping {}: No IP defined.", (Object)module);
                continue;
            }
            String command = String.format("docker run -d -it --name %s --network service-segregation --ip %s --cap-add=NET_ADMIN --sysctl net.ipv4.ip_forward=1 --privileged --cgroupns=host --tmpfs /run --tmpfs /run/lock --tmpfs /tmp -v /sys/fs/cgroup:/sys/fs/cgroup:rw -v /opt/coral5gs:/opt/coral5gs --restart=always service-segregation:latest /sbin/init", module, ipAddress);
            this.logger.info("Running container for module {} with command:\n{}", (Object)module, (Object)command);
            StringBuilder result = this.executeCommand(command);
            this.logger.info("Output for {}:\n{}", (Object)module, (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateAssignIpScripts(String rootFolder) {
        String[] modules;
        for (String module : modules = new String[]{"amf", "mme", "sgwu"}) {
            String fieldName = "serviceSegregation" + ConfigureNodeV2.capitalize((String)module) + "NetworkIp";
            String ipAddress = "localhost";
            try {
                Field field = this.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                String ip = (String)field.get(this);
                if (ip != null && !ip.isEmpty()) {
                    ipAddress = ip;
                }
            }
            catch (Exception e) {
                this.logger.warn("Could not resolve Network IP for {}. Using localhost as fallback.", (Object)module, (Object)e);
            }
            String outputPath = rootFolder + "/opt/coral5gs/scripts/coral5gs-assign" + module + "ip.sh";
            String resourcePath = "/mobility/segratedservices/scripts/assignip.sh";
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(outputPath);
                try (BufferedWriter out = new BufferedWriter(fileWriter);){
                    ClassPathResource resourceTemplate = new ClassPathResource(resourcePath);
                    InputStream initialStream = resourceTemplate.getInputStream();
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                    String writeContent = writer.toString();
                    writeContent = writeContent.replace("$$MODULENETWORKIP", ipAddress == null || ipAddress.isEmpty() ? "127.0.0.1" : ipAddress);
                    writeContent = writeContent.replace("$$MODULENETWORKSUBNETMASK", "24");
                    writeContent = writeContent.replace("\r\n", "\n");
                    out.write(writeContent);
                    this.logger.info("Generated assignip.sh for {} at {}", (Object)module, (Object)outputPath);
                }
                File scriptFile = new File(outputPath);
                if (scriptFile.setExecutable(true)) continue;
                this.logger.warn("Failed to make script {} executable", (Object)outputPath);
            }
            catch (Exception e) {
                this.logger.error("Failed to generate assignip.sh for module: {}", (Object)module, (Object)e);
            }
            finally {
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException e) {
                    this.logger.warn("Failed to close file writer for module: {}", (Object)module, (Object)e);
                }
            }
        }
    }

    public void generateAssignIpSystemdScripts(String rootFolder) {
        String[] modules = new String[]{"amf", "mme", "sgwu"};
        String resourcePath = "/mobility/segratedservices/systemd/coral5gsassignip.service";
        for (String module : modules) {
            String serviceFilePath = rootFolder + "/opt/coral5gs/systemd/coral5gs-assign" + module + "ip.service";
            try (InputStream inputStream = new ClassPathResource(resourcePath).getInputStream();
                 StringWriter stringWriter = new StringWriter();){
                IOUtils.copy((InputStream)inputStream, (Writer)stringWriter, (Charset)Charset.defaultCharset());
                String serviceContent = stringWriter.toString().replace("$$MODULE", module).replace("\r\n", "\n");
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(serviceFilePath));){
                    writer.write(serviceContent);
                    this.logger.info("Generated systemd service file for module: {} at {}", (Object)module, (Object)serviceFilePath);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to generate systemd service for module: {}", (Object)module, (Object)e);
            }
        }
    }

    public void linkCoreServicesInContainers(List<String> modules) {
        this.logger.info("Linking Core systemd services inside containers using symbolic links...");
        Iterator<String> iterator = modules.iterator();
        while (iterator.hasNext()) {
            String module;
            String containerName = module = iterator.next();
            String srcServiceFile = "/opt/coral5gs/systemd/coral5gs-" + module + "d.service";
            String targetServiceFile = "/lib/systemd/system/coral5gs-" + module + "d.service";
            try {
                String symlinkCommand = String.format("docker exec %s ln -sfn %s %s", containerName, srcServiceFile, targetServiceFile);
                this.executeCommand(symlinkCommand);
                this.logger.info("Linked service in {}: {} \u2192 {}", (Object)containerName, (Object)srcServiceFile, (Object)targetServiceFile);
                String enableCommand = String.format("docker exec %s systemctl enable coral5gs-%sd.service", containerName, module);
                this.executeCommand(enableCommand);
                this.logger.info("Enabled service in {}: coral5gs-{}d.service", (Object)containerName, (Object)module);
            }
            catch (Exception e) {
                this.logger.error("Failed to link systemd service for module: {}", (Object)module, (Object)e);
            }
        }
    }

    public void linkAssignIpServicesInsideContainers(List<String> modules) {
        this.logger.info("Linking assign-ip systemd services inside containers...");
        Iterator<String> iterator = modules.iterator();
        while (iterator.hasNext()) {
            String module;
            String containerName = module = iterator.next();
            String serviceFileName = "coral5gs-assign" + module + "ip.service";
            String sourcePath = "/opt/coral5gs/systemd/" + serviceFileName;
            String targetPath = "/lib/systemd/system/" + serviceFileName;
            try {
                String command = String.format("docker exec %s ln -sfn %s %s", containerName, sourcePath, targetPath);
                this.logger.info("Linking assign-ip service for {}: {} \u2192 {}", (Object)module, (Object)sourcePath, (Object)targetPath);
                this.executeCommand(command);
                String enableAssignIpCommand = String.format("docker exec %s systemctl enable coral5gs-assign%sip.service", containerName, module);
                this.executeCommand(enableAssignIpCommand);
                this.logger.info("Enabled assign-ip service in {}: coral5gs-assign{}ip.service", (Object)containerName, (Object)module);
            }
            catch (Exception e) {
                this.logger.error("Failed to link assign-ip service for {} inside container", (Object)module, (Object)e);
            }
        }
    }
}

