/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.ini4j.Profile;
import org.snmp4j.CommunityTarget;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Component;

@Component
public class ConfigureNodeV1 {
    @Autowired
    BuildProperties buildProperties;
    static final String CLUSTER_STRING = "CLUSTER";
    private final String HOSTIP0_STRING = "HOSTIP0";
    private final String HOSTIP1_STRING = "HOSTIP1";
    private final String RLUVIP_STRING = "RLUVIP";
    private final String ROUTERID_STRING = "ROUTERID";
    private final String DOMAIN_STRING = "DOMAIN";
    private final String BILLING_STRING = "BILLING";
    private final String PLACE_HOLDER_HOST0 = "$$HOST0";
    private final String PLACE_HOLDER_VIP = "$$VIP";
    private final String PLACE_HOLDER_DOMAIN = "$$DOMAIN";
    private final String DEFAULT_DOMAIN = "sbc.coraltele.com";
    private final Logger logger = LogManager.getLogger(ConfigureNodeV1.class);
    private final DriverManagerDataSource dataSource = new DriverManagerDataSource();
    private JdbcTemplate dbCommands;
    private String billingServerIP = "";
    private String hostServerCode = "";
    private String billingServerCode = "";
    private String haConfig = "";
    private String domainName = "";
    private String usersSIPServerPort = "";
    private String usersSIPServerPortTLS = "";
    private String gatewaySIPServerPort = "";
    private String gatewaySIPServerPortTLS = "";
    private String usersSBCPort = "";
    private String usersSBCPortTLS = "";
    private String allNodeIPs = "";
    private String subNet = "";
    private Integer nodeCount = 0;
    private String[] allIPS;
    private Ini ini;
    private String presenceServerIP = "";
    private String presenceServerPort = "";
    private String publishIP = "";
    private String publishPort = "";
    private int CSCF = 0;
    private String sbcListen = "";
    private String mediaServer = "";
    private String rluSIPServer = "";
    private String virtualHost = "";
    private String hostIPETH0 = "";
    private String hostIPETH1 = "";
    private int deploymentMode = 0;
    private String nodeType = "";
    private String myRouterId = "";
    private String mySGWIP = "";
    private String myMsfIP = "";
    private String myMsfSGWIP = "";
    private String myRluCode = "";
    private int isDisabled = 0;

    private void LoadOwnDetails(String hostName, Preferences configuration) {
        try {
            if (hostName.isEmpty()) {
                this.logger.info("Invalid or no host name provided.");
                return;
            }
            this.nodeCount = Integer.parseInt(configuration.node(CLUSTER_STRING).get("Nodes", "0"));
            this.isDisabled = Integer.parseInt(configuration.node(CLUSTER_STRING).get("Disabled", "0"));
            for (int i = 0; i < this.nodeCount; ++i) {
                String nodeName = configuration.node(CLUSTER_STRING).get(MessageFormat.format("Node{0}", i + 1), "");
                if (!nodeName.equals(hostName)) continue;
                this.myRouterId = configuration.node(nodeName).get("ROUTER-ID", "");
                this.mySGWIP = configuration.node(nodeName).get("SGW-IP", "");
                this.myMsfIP = configuration.node(nodeName).get("MSF-IP", "");
                this.myMsfSGWIP = configuration.node(nodeName).get("MSF-SGW-IP", "");
                this.myRluCode = configuration.node(nodeName).get("RLUCODE", "").toLowerCase().trim();
                String message = MessageFormat.format("My myRouterId : {0}, mySGWIP : {1}, myMsfIP : {2}, myMsfSGWIP : {3}", this.myRouterId, this.mySGWIP, this.myMsfIP, this.myMsfSGWIP);
                this.logger.info(message);
            }
        }
        catch (Exception ex) {
            String message = MessageFormat.format("Error in LoadOwnDetails(). {0}", ex.getMessage());
            this.logger.error(message, (Throwable)ex);
        }
    }

    public void main(String[] args) {
        this.dataSource.setDriverClassName("org.postgresql.Driver");
        this.dataSource.setUrl("jdbc:postgresql://127.0.0.1:5432/switch");
        this.dataSource.setUsername("postgres");
        this.dataSource.setPassword("");
        this.dbCommands = new JdbcTemplate((DataSource)this.dataSource);
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
        String message = String.format("Started %s  ================ %s ==================", this.buildProperties == null ? "Debug" : this.buildProperties.getVersion(), LocalDateTime.now().format(dateFormat));
        this.logger.info(message);
        String clusterConfiguration = args.length >= 1 ? args[0] : "/etc/default/coral";
        String hostIP = args.length >= 2 ? args[1] : "127.0.0.1";
        String rootFolder = args.length >= 3 ? args[2] : "";
        String manageDocker = args.length >= 4 ? args[3] : "Y";
        String hostName = this.getHostName(hostIP);
        if (args.length >= 5) {
            hostName = args[4];
            rootFolder = rootFolder + "/" + hostName;
        }
        if (hostName == null || hostName.isEmpty()) {
            this.logger.error("Unable to retrieve hostname, exiting the application");
            return;
        }
        message = String.format("Reading configuration from %s", clusterConfiguration);
        this.logger.info(message);
        message = String.format("Root folder for configuration %s", rootFolder);
        this.logger.info(message);
        message = String.format("Begin configuration for Node %s", hostName);
        this.logger.info(message);
        try {
            this.ini = new Ini(new File(clusterConfiguration));
            IniPreferences configuration = new IniPreferences(this.ini);
            this.LoadOwnDetails(hostName, (Preferences)configuration);
            if (this.isDisabled == 1) {
                this.logger.error("Disable flag is set, So can not proceed & exiting.");
                return;
            }
            if (configuration.node(hostName).get("HOSTIP0", "").isEmpty()) {
                message = String.format("ETH0 IP Not found in configuration file for host %s", hostName);
                this.logger.error(message);
                return;
            }
            this.initDefaults((Preferences)configuration, hostName);
            this.generateNodes((Preferences)configuration, rootFolder, hostName);
            if (this.CSCF > 0 && this.deploymentMode == 2) {
                this.updateNodeConfiguration((Preferences)configuration, rootFolder, hostName);
            }
            if (!configuration.node(CLUSTER_STRING).get("WRITE_NETWORK_SETTINGS", "").equals("N")) {
                this.writeInterfaceConfiguration((Preferences)configuration, rootFolder, hostName);
            }
            this.writeHAConfiguration((Preferences)configuration, rootFolder, hostName);
            if (this.CSCF > 0 && this.deploymentMode == 2) {
                this.updateHAConfiguration((Preferences)configuration, rootFolder, hostName);
            }
            this.writeDBConfiguration((Preferences)configuration, rootFolder, hostName);
            this.writeHostConfiguration((Preferences)configuration, rootFolder, hostName);
            this.writeApacheConfiguration((Preferences)configuration, rootFolder, hostName);
            this.writePropertyFiles((Preferences)configuration, hostName);
            this.writeSBCConfiguration((Preferences)configuration, rootFolder, hostName);
            this.writeSIPServerConfiguration((Preferences)configuration, rootFolder, hostName);
            this.writeSIPGatewayConfigurations((Preferences)configuration, rootFolder, hostName);
            this.writeNMSContainerConfiguration((Preferences)configuration, rootFolder, hostName);
            this.writeBillingConfiguration((Preferences)configuration, rootFolder, hostName);
            this.writeUCConfiguration((Preferences)configuration, rootFolder, hostName);
            if (this.CSCF > 0 && this.deploymentMode == 2) {
                this.updateCSCFConfiguration((Preferences)configuration, rootFolder, hostName);
            }
            if (this.deploymentMode == 6 || this.nodeCount == 1) {
                this.updateSingleIPDeployment((Preferences)configuration, rootFolder, hostName);
            }
            if (manageDocker.equals("Y")) {
                this.createDockerImages((Preferences)configuration, rootFolder, hostName);
            }
            this.ManageServices();
        }
        catch (IOException e) {
            this.logger.error("Unable to read/write configuration", (Throwable)e);
        }
        message = String.format("Finished %s ================ %s ==================", this.buildProperties == null ? "Debug" : this.buildProperties.getVersion(), LocalDateTime.now().format(dateFormat));
        this.logger.info(message);
    }

    private void ManageServices() {
        String message = "In manage Service method.";
        this.logger.info(message);
        String cmd = "";
        if (this.nodeCount > 1) {
            message = "Enabling service coral-commandsync.service";
            this.logger.info(message);
            cmd = cmd + "systemctl enable";
            cmd = cmd + " ";
            cmd = cmd + "coral-commandsync.service";
            this.executeSystemCommand(cmd);
        }
    }

    public void executeSystemCommand(String cmd) {
        String str = "";
        StringBuilder output = new StringBuilder();
        String message = "";
        try {
            String[] finalCommand = this.readFullCommand(cmd);
            message = String.format("Final Command -> %s %s %s", finalCommand[0], finalCommand[1], finalCommand[2]);
            this.logger.info(message);
            Process p = Runtime.getRuntime().exec(finalCommand);
            p.waitFor();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((str = buffer.readLine()) != null) {
                output = output.append(str);
            }
            message = String.format("Done. Command %s Result %s", cmd, output.toString());
            this.logger.info(message);
        }
        catch (IOException ex) {
            message = String.format("Error in executeSystemCommand : IOException. %s", ex.getMessage());
            this.logger.info(message);
        }
        catch (InterruptedException ex) {
            message = String.format("Error in executeSystemCommand : InterruptedException. %s", ex.getMessage());
            this.logger.info(message);
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            message = String.format("Error in executeSystemCommand. %s", ex.getMessage());
            this.logger.info(message);
        }
    }

    private String[] readFullCommand(String cmd) {
        String[] returnValue = new String[]{"/bin/bash", "-c", cmd};
        return returnValue;
    }

    private void overWriteRouterId(String routerId, String SGWIP, String msfIP, String msfSGWIP, String rluCode) {
        try {
            String sql = String.format("update pbx.m_control_rluserver set msf_ip=case when coalesce(msf_ip,'') <> '' then msf_ip else '%s' end,\r\nmsf_sgwip=case when coalesce(msf_sgwip,'') <> '' then msf_sgwip else '%s' end where rlucode='%s'", msfIP, msfSGWIP, rluCode);
            this.dbCommands.update(sql);
        }
        catch (Exception ex) {
            String message = MessageFormat.format("Error in LoadOwnDetails(). {0}", ex.getMessage());
            this.logger.error(message, (Throwable)ex);
        }
    }

    private void initDefaults(Preferences configuration, String hostName) {
        this.usersSBCPort = configuration.node(CLUSTER_STRING).get("SBC_USERS_PORT", "5060");
        this.usersSBCPortTLS = configuration.node(CLUSTER_STRING).get("SBC_USERS_PORT_TLS", "5061");
        this.usersSIPServerPort = configuration.node(CLUSTER_STRING).get("SIPSERVER_USERS_PORT", "5070");
        this.usersSIPServerPortTLS = configuration.node(CLUSTER_STRING).get("SIPSERVER_USERS_PORT_TLS", "5071");
        this.gatewaySIPServerPort = configuration.node(CLUSTER_STRING).get("SIPSERVER_GATEWAY_PORT", "5080");
        this.gatewaySIPServerPortTLS = configuration.node(CLUSTER_STRING).get("SIPSERVER_GATEWAY_PORT_TLS", "5081");
        this.subNet = configuration.node(CLUSTER_STRING).get("ETH0SUBNET", "24");
        this.CSCF = Integer.parseInt(configuration.node(CLUSTER_STRING).get("CSCF", "0"));
        this.deploymentMode = Integer.parseInt(configuration.node(hostName).get("Mode", "2"));
        this.nodeType = configuration.node(hostName).get("Type", "PABX");
        this.presenceServerIP = configuration.node(hostName).get("PRESENCE_IP", "");
        this.presenceServerPort = configuration.node(hostName).get("PRESENCE_PORT", "");
        this.publishIP = configuration.node(hostName).get("PUBLISH_IP", "");
        this.publishPort = configuration.node(hostName).get("PUBLISH_PORT", "");
        this.usersSBCPort = this.usersSBCPort.isEmpty() ? "5060" : this.usersSBCPort;
        this.usersSBCPortTLS = this.usersSBCPortTLS.isEmpty() ? "5061" : this.usersSBCPortTLS;
        this.usersSIPServerPort = this.usersSIPServerPort.isEmpty() ? "5070" : this.usersSIPServerPort;
        this.usersSIPServerPortTLS = this.usersSIPServerPortTLS.isEmpty() ? "5071" : this.usersSIPServerPortTLS;
        this.gatewaySIPServerPort = this.gatewaySIPServerPort.isEmpty() ? "5080" : this.gatewaySIPServerPort;
        this.gatewaySIPServerPortTLS = this.gatewaySIPServerPortTLS.isEmpty() ? "5081" : this.gatewaySIPServerPortTLS;
        this.presenceServerIP = this.presenceServerIP.isEmpty() ? configuration.node(hostName).get("HOSTIP0", "") : this.presenceServerIP;
        this.presenceServerPort = this.presenceServerPort.isEmpty() ? this.usersSBCPort : this.presenceServerPort;
        this.publishIP = this.publishIP.isEmpty() ? "127.0.0.1" : this.publishIP;
        this.publishPort = this.publishPort.isEmpty() ? "5085" : this.publishPort;
        this.subNet = this.subNet.isEmpty() ? "24" : this.subNet;
        this.nodeType = this.nodeType.isEmpty() ? "PABX" : this.nodeType;
        this.hostIPETH0 = configuration.node(hostName).get("HOSTIP0", "");
        this.hostIPETH1 = configuration.node(hostName).get("HOSTIP1", "");
        if (this.deploymentMode == 0) {
            this.deploymentMode = 2;
        }
    }

    private void generateNodes(Preferences configuration, String rootFolder, String hostName) throws IOException {
        this.dbCommands.update("truncate table pbx.m_nodeconfiguration");
        this.logger.info("Node information cleaned");
        String ipList = configuration.node(hostName).get("RLUVIP", "");
        String ipSIPServer = configuration.node(hostName).get("RLUVIPSIPSERVER", "");
        String ipAdditional = configuration.node(hostName).get("EXTRAIP", "");
        if (!ipSIPServer.isEmpty()) {
            ipList = ipList + "," + ipSIPServer;
        }
        if (!ipAdditional.isEmpty()) {
            ipList = ipList + "," + ipAdditional;
        }
        this.allIPS = ipList.split(",");
        Arrays.sort(this.allIPS);
        this.nodeCount = Integer.parseInt(configuration.node(CLUSTER_STRING).get("Nodes", "0"));
        if (this.nodeCount == 0) {
            this.logger.info("Unable to locate Nodes key under CLUSTER group");
        }
        String hostVirtualIP = configuration.node(hostName).get("RLUVIP", "");
        String hostNodeGroup = configuration.node(hostName).get("GROUP", "").toLowerCase();
        for (int i = 0; i < this.nodeCount; ++i) {
            Integer nodeId = (i + 1) * 10;
            String serverCode = String.format("s%d", nodeId);
            String nodeKey = String.format("Node%d", i + 1);
            String nodeName = configuration.node(CLUSTER_STRING).get(nodeKey, "");
            String nodeIPV4 = configuration.node(nodeName).get("HOSTIP0", "");
            String nodeManagementIPV4 = configuration.node(nodeName).get("HOSTIP1", "");
            String virtualIP = configuration.node(nodeName).get("RLUVIP", "");
            Integer routerId = Integer.parseInt(configuration.node("ROUTERID").get(virtualIP, "0"));
            String RLUCode = configuration.node(nodeName).get("RLUCODE", "").toLowerCase().trim();
            String nodeGroup = configuration.node(nodeName).get("GROUP", "").toLowerCase().trim();
            String message = String.format("Creating Node %d %s %s %s %s %s %s", nodeId, nodeKey, nodeId, nodeName, nodeIPV4, nodeManagementIPV4, routerId);
            this.logger.info(message);
            this.dbCommands.update("Insert into pbx.m_nodeconfiguration(nodeid,nodeip,ipaddress,servercode,nodename,hagroup,vertualip, rlucode) values (?,?,?,?,?,?,?,?)", new Object[]{nodeId, nodeManagementIPV4, nodeIPV4, serverCode, nodeName, routerId, virtualIP, RLUCode});
            if (configuration.node(hostName).get("RLUVIP", "").equals(virtualIP) && !nodeName.equals(hostName)) {
                this.allNodeIPs = this.allNodeIPs + nodeIPV4;
                this.allNodeIPs = this.allNodeIPs + "\n";
            }
            if (nodeName.equals(hostName)) {
                this.billingServerIP = configuration.node(nodeName).get("BILLING", "").equals("Y") ? configuration.node(nodeName).get("BILLINGIP1", "") : configuration.node(CLUSTER_STRING).get("VIP", "");
                this.hostServerCode = serverCode;
                if (this.billingServerIP.isEmpty()) {
                    this.logger.error("Billing server not configured");
                } else {
                    message = String.format("Billing server configured to %s", this.billingServerIP);
                    this.logger.info(message);
                }
                this.dbCommands.update("update pbx.m_systemconfigs set servercode = ?, billing_server_ip=?", new Object[]{serverCode, this.billingServerIP});
            } else if (hostNodeGroup.equals(nodeGroup)) {
                this.haConfig = this.haConfig + String.format("modparam(\"dmq\", \"notification_address\", \"sip:%s:5065\")", this.nodeType.equals("MSF") ? nodeManagementIPV4 : nodeIPV4);
                this.haConfig = this.haConfig + "\n";
            }
            nodeId = nodeId + 1;
            if (!configuration.node(nodeName).get("BILLING", "").equals("Y")) continue;
            serverCode = String.format("s%d", nodeId);
            nodeIPV4 = configuration.node(nodeName).get("BILLINGIP0", "");
            nodeManagementIPV4 = configuration.node(nodeName).get("BILLINGIP1", "");
            if (nodeName.equals(hostName)) {
                this.billingServerCode = serverCode;
            }
            nodeName = configuration.node(CLUSTER_STRING).get(nodeKey, "");
            nodeName = String.format("%s-%s", nodeName, "billing");
            message = String.format("Creating Billing Node %d %s %s %s %s %s %s", nodeId, nodeKey, nodeId, nodeName, nodeIPV4, nodeManagementIPV4, routerId);
            this.logger.info(message);
            this.dbCommands.update("Insert into pbx.m_nodeconfiguration(nodeid,nodeip,ipaddress,servercode,nodename,hagroup) values (?,?,?,?,?,?)", new Object[]{nodeId, nodeManagementIPV4, nodeIPV4, serverCode, nodeName, routerId});
        }
        this.dbCommands.update("truncate table pbx.m_profilemapping;");
        this.dbCommands.update("insert into pbx.m_profilemapping(profile_name,servercode) select rlucode as profile_name,servercode from pbx.m_nodeconfiguration where coalesce(rlucode,'') <> '' order by servercode;");
        this.dbCommands.update("Update pbx.m_profilemapping set priority=id");
        this.logger.info("Profile mapping populated");
        this.dbCommands.update("delete from pbx.m_control_rluserver where rlucode not in (select distinct rlucode from pbx.m_nodeconfiguration where coalesce(rlucode,'') <> '');");
        this.dbCommands.update("update  pbx.m_control_rluserver set virtualip=a.virtualip,ipaddress=a.ipaddress from (select distinct rlucode,vertualip as virtualip,vertualip as ipaddress from pbx.m_nodeconfiguration where coalesce(rlucode,'') <> '') a where pbx.m_control_rluserver.rlucode=a.rlucode;");
        this.dbCommands.update("insert into  pbx.m_control_rluserver(rlucode,virtualip,ipaddress) select distinct rlucode,vertualip as virtualip,vertualip as ipaddress from pbx.m_nodeconfiguration where coalesce(rlucode,'') <> '' and rlucode not in (select rlucode from pbx.m_control_rluserver);");
        this.logger.info("RLU Control Server populated");
        this.dbCommands.update("copy (select nodename || ':' || nodeip  from pbx.m_nodeconfiguration) TO '/tmp/nodes';");
        this.executeCommand("pg_dump -U postgres -d switch -h 127.0.0.1 --column-inserts --data-only --table=pbx.m_nodeconfiguration  > /tmp/billing-nodes.sql");
        this.executeCommand("pg_dump -U postgres -d switch -h 127.0.0.1 --column-inserts --data-only --table=pbx.m_profilemapping  > /tmp/billing-profiles.sql");
        this.executeCommand("pg_dump -U postgres -d switch -h 127.0.0.1 --column-inserts --data-only --table=pbx.m_control_rluserver  > /tmp/billing-rlus.sql");
        Path destinationPath = Paths.get(rootFolder + "/etc/keepalived/nodes", new String[0]);
        Path sourcePath = Paths.get("/tmp/nodes", new String[0]);
        Files.deleteIfExists(destinationPath);
        Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        FileWriter fileWriter = new FileWriter(rootFolder + "/etc/keepalived/nodes", true);
        try (BufferedWriter out = new BufferedWriter(fileWriter);){
            out.append(String.format("virtualip:%s%s", hostVirtualIP, System.lineSeparator()));
            out.append(String.format("sipserver_db_ip:%s%s", configuration.node(hostName).get("HOSTIP1", ""), System.lineSeparator()));
            out.append(String.format("sipserver_db_port:5432%s", System.lineSeparator()));
            this.logger.info("Virtual IP Added to the nodes");
        }
        catch (Exception E) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)E);
        }
    }

    private void updateNodeConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        this.dbCommands.update("copy (select nodename || ':' || nodeip  from pbx.m_nodeconfiguration) TO '/tmp/nodes';");
        this.dbCommands.update("truncate table pbx.m_profilemapping;");
        this.dbCommands.update("truncate table pbx.m_control_rluserver;");
        Path destinationPath = Paths.get(rootFolder + "/etc/keepalived/nodes", new String[0]);
        Path sourcePath = Paths.get("/tmp/nodes", new String[0]);
        Files.deleteIfExists(destinationPath);
        Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        FileWriter fileWriter = new FileWriter(rootFolder + "/etc/keepalived/nodes", true);
        try (BufferedWriter out = new BufferedWriter(fileWriter);){
            for (int i = 1; i <= this.CSCF; ++i) {
                String sql = "SELECT count(*) FROM pbx.m_control_rluserver WHERE rlucode = ?";
                String rluCode = configuration.node(String.format("CSCF-%d", i)).get("NAME", "").toLowerCase();
                String rluType = configuration.node(String.format("CSCF-%d", i)).get("TYPE", "");
                String routerId = configuration.node(String.format("CSCF-%d", i)).get("ROUTER-ID", "");
                String virtualIP = configuration.node(String.format("CSCF-%d", i)).get("CSCF-IP", "");
                String SGWIP = configuration.node(String.format("CSCF-%d", i)).get("SGW-IP", "");
                String ExtraIP = configuration.node(String.format("CSCF-%d", i)).get("EXTRA-IP", "");
                String rluSubNet = configuration.node(String.format("CSCF-%d", i)).get("SUBNET", "");
                String rluNodes = configuration.node(String.format("CSCF-%d", i)).get("NODES", "");
                String stickyIP = configuration.node(String.format("CSCF-%d", i)).get("STICKY-IP", "");
                String msfIP = configuration.node(String.format("CSCF-%d", i)).get("MSF-IP", "");
                String msfSGWIP = configuration.node(String.format("CSCF-%d", i)).get("MSF-SGW-IP", "");
                String rluStatusIP = configuration.node(String.format("CSCF-%d", i)).get("RLU-STATUS-IP", "");
                String controlIP = configuration.node(String.format("CSCF-%d", i)).get("MSF-CONTROL-IP", "");
                int count = (Integer)this.dbCommands.queryForObject(sql, Integer.class, new Object[]{rluCode});
                if (count == 0) {
                    this.dbCommands.update(String.format("insert into  pbx.m_control_rluserver(rlucode,virtualip,ipaddress) values('%s','%s','%s')", rluCode, virtualIP, virtualIP));
                }
                if (!rluCode.equalsIgnoreCase(this.myRluCode)) {
                    // empty if block
                }
                msfIP = !msfIP.isEmpty() ? msfIP : this.myMsfIP;
                msfSGWIP = !msfSGWIP.isEmpty() ? msfSGWIP : this.myMsfSGWIP;
                sql = String.format("update pbx.m_control_rluserver set ipaddress='%s', virtualip='%s', rlutype='%s',routerid=%s,sgwip='%s',extraip='%s',subnet='%s',preempt=%s,updateflag=true,msf_ip='%s',msf_sgwip='%s',rlu_status_ip='%s' where rlucode='%s'", virtualIP, virtualIP, rluType, routerId, SGWIP, ExtraIP, rluSubNet, stickyIP.equals("N"), msfIP, msfSGWIP, rluStatusIP, rluCode);
                this.dbCommands.update(sql);
                int priorityCode = 202;
                for (String hostNode : rluNodes.split(",")) {
                    String nodeSQL = "SELECT servercode FROM pbx.m_nodeconfiguration WHERE nodename = ?";
                    String serverCode = (String)this.dbCommands.queryForObject(nodeSQL, String.class, new Object[]{hostNode.trim()});
                    this.dbCommands.update(String.format("insert into pbx.m_profilemapping(profile_name,servercode,priority) values ('%s','%s',%d)", rluCode, serverCode, priorityCode -= 2));
                }
                if (!controlIP.isEmpty()) {
                    virtualIP = controlIP;
                }
                out.append(String.format("virtualip_%s:%s%n", rluCode, virtualIP));
                out.append(String.format("rlu_status_ip_%s:%s%n", rluCode, rluStatusIP));
            }
        }
        catch (Exception E) {
            this.logger.info(String.format("Error while writing sbc nodes configuration %s", hostName), (Throwable)E);
        }
        this.dbCommands.update("delete from  pbx.m_control_rluserver where updateflag=false");
    }

    private void writeSBCConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        String writeContent;
        InputStream initialStream;
        BufferedWriter out;
        String publicIP;
        InputStream initialStream2;
        ClassPathResource resourceTemplate2;
        Throwable throwable;
        BufferedWriter out2;
        FileWriter fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/dmq.cfg");
        try {
            out2 = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sbc/dmq.cfg");
                initialStream2 = resourceTemplate2.getInputStream();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream2, (Writer)writer, (Charset)Charset.defaultCharset());
                String writeContent2 = writer.toString();
                writeContent2 = writeContent2.replace("$$NODES", this.haConfig);
                out2.write(writeContent2);
                this.logger.info("SBC nodes configuration populated");
            }
            catch (Throwable resourceTemplate2) {
                throwable = resourceTemplate2;
                throw resourceTemplate2;
            }
            finally {
                if (out2 != null) {
                    if (throwable != null) {
                        try {
                            out2.close();
                        }
                        catch (Throwable resourceTemplate2) {
                            throwable.addSuppressed(resourceTemplate2);
                        }
                    } else {
                        out2.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/sbc-listen.cfg");
        try {
            out2 = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/sbc/sbc-listen.cfg");
                initialStream2 = resourceTemplate2.getInputStream();
                String ipSIPServer = configuration.node(hostName).get("RLUVIPSIPSERVER", "");
                Boolean isTLS = configuration.node(CLUSTER_STRING).get("TLS", "").equals("Y");
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream2, (Writer)writer, (Charset)Charset.defaultCharset());
                String writeContent3 = writer.toString();
                String ips = "";
                int i = 0;
                for (String ip : this.allIPS) {
                    if (ip.equals(ipSIPServer)) continue;
                    publicIP = this.getPublicIP(configuration, ip);
                    ips = ips + "\n";
                    ++i;
                    if (publicIP.isEmpty()) {
                        ips = ips + "\n" + String.format("listen=tcp:%s:%s", ip, this.usersSBCPort);
                        ips = ips + "\n" + String.format("listen=udp:%s:%s", ip, this.usersSBCPort);
                        if (!isTLS.booleanValue()) continue;
                        ips = ips + "\n" + String.format("listen=tls:%s:%s", ip, this.usersSBCPortTLS);
                        continue;
                    }
                    ips = ips + "\n" + String.format("listen=tcp:%s:%s advertise %s:%s name \"voip%d\"", ip, this.usersSBCPort, publicIP, this.usersSBCPort, i);
                    ips = ips + "\n" + String.format("listen=udp:%s:%s advertise %s:%s name \"voip%d\"", ip, this.usersSBCPort, publicIP, this.usersSBCPort, i);
                    if (!isTLS.booleanValue()) continue;
                    ips = ips + "\n" + String.format("listen=tls:%s:%s advertise %s:%s name \"voip%d\"", ip, this.usersSBCPortTLS, publicIP, this.usersSBCPortTLS, i);
                }
                writeContent3 = writeContent3.replace("$$IPV4", ips);
                out2.write(writeContent3);
                this.logger.info("SBC nodes configuration populated");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out2 != null) {
                    if (throwable != null) {
                        try {
                            out2.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out2.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)E);
        }
        String withMultiIP = "";
        String ipSIPServer = configuration.node(hostName).get("RLUVIPSIPSERVER", "");
        int i = 0;
        String voipStrings = "";
        String ips = "";
        for (String ip : this.allIPS) {
            if (ip.equals(ipSIPServer)) continue;
            if (!ips.isEmpty()) {
                ips = ips + ";";
            }
            String publicIP2 = this.getPublicIP(configuration, ip);
            ++i;
            if (publicIP2.isEmpty()) {
                ips = ips + ip;
                continue;
            }
            ips = ips + "voip" + i + "/" + ip + "!" + publicIP2;
            voipStrings = voipStrings + String.format("$sht(mi=>voip%d)=\"%s\";%s", i, publicIP2, System.lineSeparator());
        }
        if (i > 1) {
            withMultiIP = "-A WITH_MULTIIP";
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/sbc.default");
        try {
            out = new BufferedWriter(fileWriter);
            Throwable throwable2 = null;
            try {
                String configDomainName;
                ClassPathResource resourceTemplate4 = new ClassPathResource("/sbc/sbc.default");
                if (this.CSCF > 0 && this.deploymentMode == 2) {
                    resourceTemplate4 = new ClassPathResource("/sbc/sbc-mode-2.default");
                }
                if (this.nodeType.equals("MSF")) {
                    resourceTemplate4 = new ClassPathResource("/sbc/sbc-msf.default");
                }
                initialStream = resourceTemplate4.getInputStream();
                Boolean isTLS = configuration.node(CLUSTER_STRING).get("TLS", "").equals("Y");
                String sbcDomain = "";
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                String writeContent4 = writer.toString();
                writeContent4 = isTLS != false ? writeContent4.replace("$$TLS", "") : writeContent4.replace("$$TLS", "#");
                writeContent4 = this.nodeCount > 1 ? writeContent4.replace("$$HA", "") : writeContent4.replace("$$HA", "#");
                writeContent4 = writeContent4.replace("$$MULTIIP", withMultiIP);
                writeContent4 = writeContent4.replace("$$VIP", configuration.node(hostName).get("RLUVIP", ""));
                writeContent4 = writeContent4.replace("$$HOSTIP0", configuration.node(hostName).get("HOSTIP0", ""));
                writeContent4 = writeContent4.replace("$$HOSTIP1", configuration.node(hostName).get("HOSTIP1", ""));
                writeContent4 = writeContent4.replace("$$SBC_USERS_PORT_TLS", this.usersSBCPortTLS);
                writeContent4 = writeContent4.replace("$$SBC_USERS_PORT_TLS", this.usersSBCPortTLS);
                writeContent4 = writeContent4.replace("$$SBC_USERS_PORT", this.usersSBCPort);
                writeContent4 = writeContent4.replace("$$SIPSERVER_USERS_PORT", this.usersSIPServerPort);
                writeContent4 = this.CSCF > 0 ? (this.nodeType.equals("MSF") ? writeContent4.replace("$$RLUVIPSIPSERVER", configuration.node(hostName).get("RLUVIPSIPSERVER", "")) : writeContent4.replace("$$RLUVIPSIPSERVER", configuration.node(hostName).get("HOSTIP1", ""))) : writeContent4.replace("$$RLUVIPSIPSERVER", configuration.node(hostName).get("RLUVIPSIPSERVER", ""));
                writeContent4 = writeContent4.replace("$$PRESENCEIP", this.presenceServerIP);
                writeContent4 = writeContent4.replace("$$PRESENCEPORT", this.presenceServerPort);
                writeContent4 = writeContent4.replace("$$PUBLISHIP", this.publishIP);
                writeContent4 = writeContent4.replace("$$PUBLISHPORT", this.publishPort);
                writeContent4 = writeContent4.replace("$$SUBNETIP", configuration.node(hostName).get("HOSTIP0", ""));
                writeContent4 = writeContent4.replace("$$SUBNETMASK", this.subNet);
                if (!this.domainName.isEmpty()) {
                    sbcDomain = String.format("domain='--alias=%s'", this.domainName);
                }
                writeContent4 = (configDomainName = configuration.node(CLUSTER_STRING).get("DOMAIN", this.domainName)).isEmpty() ? writeContent4.replace("$$DOMAINANME", configuration.node(hostName).get("RLUVIP", "")) : writeContent4.replace("$$DOMAINANME", this.domainName);
                writeContent4 = writeContent4.replace("$$DOMAIN", sbcDomain);
                publicIP = configuration.node(CLUSTER_STRING).get("PUBLICIP", "");
                if (publicIP.isEmpty()) {
                    writeContent4 = writeContent4.replace("$$PUBLICIPT", "");
                    writeContent4 = writeContent4.replace("$$PUBLICIPU", "");
                    writeContent4 = writeContent4.replace("$$PUBLICIPS", "");
                } else {
                    writeContent4 = writeContent4.replace("$$PUBLICIPT", String.format("/%s:%s", publicIP, this.usersSBCPort));
                    writeContent4 = writeContent4.replace("$$PUBLICIPU", String.format("/%s:%s", publicIP, this.usersSBCPort));
                    writeContent4 = writeContent4.replace("$$PUBLICIPS", String.format("/%s:%s", publicIP, this.usersSBCPortTLS));
                }
                writeContent4 = writeContent4.replace("$$SIPSERVER_GATEWAY_PORT", this.gatewaySIPServerPort);
                out.write(writeContent4);
                this.logger.info("SBC configuration populated");
            }
            catch (Throwable resourceTemplate4) {
                throwable2 = resourceTemplate4;
                throw resourceTemplate4;
            }
            finally {
                if (out != null) {
                    if (throwable2 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate4) {
                            throwable2.addSuppressed(resourceTemplate4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while SBC configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/rtpengine/rtpengine.conf");
        try {
            out = new BufferedWriter(fileWriter);
            Throwable throwable3 = null;
            try {
                ClassPathResource resourceTemplate5 = new ClassPathResource("/sbc/rtpengine.conf");
                initialStream = resourceTemplate5.getInputStream();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$IPV4", ips);
                writeContent = writeContent.replace("$$LISTEN-IP", "127.0.0.1");
                out.write(writeContent);
                this.logger.info("Media server configuration populated");
            }
            catch (Throwable resourceTemplate5) {
                throwable3 = resourceTemplate5;
                throw resourceTemplate5;
            }
            finally {
                if (out != null) {
                    if (throwable3 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate5) {
                            throwable3.addSuppressed(resourceTemplate5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while Media Server configuration", (Throwable)E);
        }
        if (!voipStrings.isEmpty()) {
            fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/mediainterface.cfg");
            try {
                out = new BufferedWriter(fileWriter);
                Throwable throwable4 = null;
                try {
                    out.write(voipStrings);
                    this.logger.info("Media Interface file populated");
                }
                catch (Throwable resourceTemplate5) {
                    throwable4 = resourceTemplate5;
                    throw resourceTemplate5;
                }
                finally {
                    if (out != null) {
                        if (throwable4 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable resourceTemplate5) {
                                throwable4.addSuppressed(resourceTemplate5);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (Exception E) {
                this.logger.info("Error while Media Interface configuration", (Throwable)E);
            }
        }
        fileWriter = new FileWriter(rootFolder + "/etc/redis/redis.conf");
        try {
            out = new BufferedWriter(fileWriter);
            Throwable throwable5 = null;
            try {
                ClassPathResource resourceTemplate6 = new ClassPathResource("/sbc/redis.conf");
                initialStream = resourceTemplate6.getInputStream();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$HOSTIP1", configuration.node(hostName).get("HOSTIP1", ""));
                out.write(writeContent);
                this.logger.info("Redis server configuration populated");
            }
            catch (Throwable resourceTemplate6) {
                throwable5 = resourceTemplate6;
                throw resourceTemplate6;
            }
            finally {
                if (out != null) {
                    if (throwable5 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate6) {
                            throwable5.addSuppressed(resourceTemplate6);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while Redis Server configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/kamailio/kamctlrc");
        try {
            out = new BufferedWriter(fileWriter);
            Throwable throwable6 = null;
            try {
                ClassPathResource resourceTemplate7 = new ClassPathResource("/sbc/kamctlrc");
                initialStream = resourceTemplate7.getInputStream();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$VIP", configuration.node(hostName).get("RLUVIP", ""));
                writeContent = writeContent.replace("$$DOMAIN", this.domainName);
                out.write(writeContent);
                this.logger.info("SBC RC File configured");
            }
            catch (Throwable throwable7) {
                throwable6 = throwable7;
                throw throwable7;
            }
            finally {
                if (out != null) {
                    if (throwable6 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable8) {
                            throwable6.addSuppressed(throwable8);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while SBC RC File configured", (Throwable)E);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInterfaceConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/network/interfaces");
             BufferedWriter out = new BufferedWriter(fileWriter);){
            String IPV4 = configuration.node(hostName).get("HOSTIP0", "");
            String gateway = configuration.node(hostName).get("GATEWAY", "");
            String managementIPV4 = configuration.node(hostName).get("HOSTIP1", "");
            ClassPathResource resourceTemplate = this.nodeType.equals("MSF") ? new ClassPathResource("/network/interfaces-msf") : new ClassPathResource("/network/interfaces");
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String writeContent = writer.toString();
            writeContent = writeContent.replace("$$IPV4MGMT", managementIPV4);
            writeContent = writeContent.replace("$$IPV4GATEWAY", gateway);
            writeContent = writeContent.replace("$$IPV4", IPV4);
            writeContent = writeContent.replace("$$SUBNET", this.subNet);
            out.write(writeContent);
            this.logger.info("network configuration populated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHAConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/keepalived/keepalived.conf");
             BufferedWriter out = new BufferedWriter(fileWriter);){
            String virtualIP = configuration.node(hostName).get("RLUVIP", "");
            String routerId = configuration.node("ROUTERID").get(virtualIP, "");
            Integer priority = 200 - Integer.parseInt(configuration.node(hostName).get("Priority", "0"));
            String ips = "";
            if (virtualIP.isEmpty()) {
                this.logger.error("Virtual IP Not Found exiting the process");
            } else if (routerId.isEmpty()) {
                this.logger.error("Router Id not found");
            } else {
                ClassPathResource resourceTemplate = new ClassPathResource("/keepalived/keepalived.conf");
                InputStream initialStream = resourceTemplate.getInputStream();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                String writeContent = writer.toString();
                writeContent = writeContent.replace("$$RouterId", routerId);
                writeContent = writeContent.replace("$$Priority", Integer.toString(priority));
                int i = 0;
                for (String ip : this.allIPS) {
                    ips = ips + "\n" + String.format("%s/%s dev eth0 label eth0:%s", ip, this.subNet, Integer.toString(i));
                    ++i;
                }
                writeContent = writeContent.replace("$$IPV4", ips);
                writeContent = writeContent.replace("$$HOSTIP0", configuration.node(hostName).get("HOSTIP0", ""));
                writeContent = writeContent.replace("$$ALLNODES", this.allNodeIPs);
                out.write(writeContent);
                this.logger.info("Keepalived configuration populated");
            }
        }
    }

    private void updateCSCFConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        Throwable throwable;
        BufferedWriter out;
        FileWriter fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/sbc-listen.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                out.write(this.sbcListen);
                this.logger.info("CSCF Listen populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/mediaserver.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                out.write(this.mediaServer);
                this.logger.info("CSCF Media Server populated");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/rlusipserver.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                out.write(this.rluSIPServer);
                this.logger.info("CSCF RLU SIP Server configured");
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/rtpengine/rtpengine.conf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                ClassPathResource resourceTemplate = new ClassPathResource("/sbc/rtpengine.conf");
                InputStream initialStream = resourceTemplate.getInputStream();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                String writeContent = writer.toString();
                if (this.nodeType.equals("MSF")) {
                    String vip = configuration.node(hostName).get("RLUVIP", "");
                    writeContent = writeContent.replace("$$IPV4", vip);
                    writeContent = writeContent.replace("$$LISTEN-IP", vip);
                } else {
                    writeContent = writeContent.replace("$$IPV4", this.hostIPETH0);
                    writeContent = writeContent.replace("$$LISTEN-IP", "127.0.0.1");
                }
                out.write(writeContent);
                this.logger.info("Media server configuration populated");
            }
            catch (Throwable resourceTemplate) {
                throwable = resourceTemplate;
                throw resourceTemplate;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate) {
                            throwable.addSuppressed(resourceTemplate);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while Media Server configuration", (Throwable)E);
        }
        for (int i = 1; i <= this.CSCF; ++i) {
            String rluCode = configuration.node(String.format("CSCF-%d", i)).get("NAME", "").toLowerCase();
            String SGWIP = configuration.node(String.format("CSCF-%d", i)).get("SGW-IP", "");
            String CSCFIP = configuration.node(String.format("CSCF-%d", i)).get("CSCF-IP", "");
            Boolean isServicingCSCF = configuration.node(hostName).get("S-CSCF", "").equals("Y");
            Boolean isMSF = configuration.node(hostName).get("MSF", "").equals("Y");
            String type = configuration.node(String.format("CSCF-%d", i)).get("TYPE", "");
            String nodes = "," + configuration.node(String.format("CSCF-%d", i)).get("NODES", "") + ",";
            String remoteCSCFIP = configuration.node(String.format("CSCF-%d", i)).get("REMOTE-CSCF-IP", "");
            if (!nodes.contains("," + hostName + ",")) continue;
            if (isServicingCSCF.booleanValue() && type.equals("SERVICING")) {
                this.updateSIPServerConfiguration(rootFolder, SGWIP, rluCode, type, CSCFIP, remoteCSCFIP);
            }
            if (!isMSF.booleanValue() || !type.equals("MSF")) continue;
            this.executeCommand("rm " + rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles/*.xml");
            this.updateSIPServerConfiguration(rootFolder, SGWIP, rluCode, type, CSCFIP, remoteCSCFIP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHAConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        FileWriter fileWriter = new FileWriter(rootFolder + "/etc/keepalived/keepalived.conf");
        Boolean isTLS = configuration.node(CLUSTER_STRING).get("TLS", "").equals("Y");
        Boolean isServicingCSCF = configuration.node(hostName).get("S-CSCF", "").equals("Y");
        Boolean isMSF = configuration.node(hostName).get("MSF", "").equals("Y");
        String gateWayIP = configuration.node(hostName).get("GATEWAY", "");
        String msfVIP = configuration.node(hostName).get("MSF-CONTROL-IP", "");
        String servicingTypes = "'---'";
        try (BufferedWriter out = new BufferedWriter(fileWriter);){
            ClassPathResource resourceTemplateGlobal = new ClassPathResource(this.nodeType.equals("MSF") ? "/keepalived/msf.global" : "/keepalived/keepalived.global");
            InputStream initialStreamGlobal = resourceTemplateGlobal.getInputStream();
            StringWriter writerGlobal = new StringWriter();
            IOUtils.copy((InputStream)initialStreamGlobal, (Writer)writerGlobal, (Charset)Charset.defaultCharset());
            String writeContent = writerGlobal.toString();
            out.write(writeContent);
            ClassPathResource resourceTemplate = new ClassPathResource(this.nodeType.equals("MSF") ? "/keepalived/msf.conf" : "/keepalived/cscf-mode-2.conf");
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String baseWriteContent = writer.toString();
            int dbCount = (Integer)this.dbCommands.queryForObject("SELECT count(*) FROM pg_catalog.pg_database WHERE lower(datname) = lower('nodes');", Integer.class);
            if (dbCount == 0) {
                this.dbCommands.update("CREATE DATABASE nodes;");
                this.logger.info("Nodes Database created");
            } else {
                this.logger.info("Nodes Database already exist");
            }
            if (isServicingCSCF.booleanValue()) {
                servicingTypes = servicingTypes + ",'SERVICING'";
            }
            if (isMSF.booleanValue()) {
                servicingTypes = servicingTypes + ",'MSF'";
            }
            String sql = String.format("select b.*,a.priority from pbx.m_profilemapping a inner join pbx.m_control_rluserver b on a.profile_name = b.rlucode where servercode = '%s' and b.rlutype in (%s) order by b.rlucode;", this.hostServerCode, servicingTypes);
            List rows = this.dbCommands.queryForList(sql);
            int currentRow = 0;
            Boolean addedHostIP = false;
            String hostIP = this.nodeType.equals("MSF") ? this.hostIPETH1 : this.hostIPETH0;
            for (Map row : rows) {
                writeContent = baseWriteContent;
                ++currentRow;
                Long routerId = ((Integer)row.get("routerid")).longValue();
                Long priority = ((Integer)row.get("priority")).longValue();
                String rluCode = (String)row.get("rlucode");
                String allRLUIPS = (String)row.get("virtualip") + "," + (String)row.get("sgwip") + "," + (String)row.get("extraip");
                String virtualIP = (String)row.get("virtualip");
                if (!allRLUIPS.contains(hostIP) && !addedHostIP.booleanValue()) {
                    allRLUIPS = hostIP + "," + allRLUIPS;
                    addedHostIP = true;
                }
                String[] rluIPS = allRLUIPS.split(",");
                String ips = "";
                String preempt = "nopreempt";
                String swgIP = ((String)row.get("sgwip")).trim();
                String msf_ip = ((String)row.get("msf_ip")).trim();
                writeContent = writeContent.replace("$$RouterId", routerId.toString());
                writeContent = writeContent.replace("$$Priority", priority.toString());
                writeContent = writeContent.replace("$$RLU", rluCode);
                writeContent = writeContent.replace("$$Preempt", preempt);
                writeContent = writeContent.replace("$$GATEWAY-IP", gateWayIP);
                writeContent = writeContent.replace("$$MSF-VIP", msfVIP);
                if (currentRow == 1) {
                    this.mediaServer = this.nodeType.equals("MSF") ? this.mediaServer + "\n" + String.format("modparam(\"rtpengine\", \"rtpengine_sock\",\"%d == udp:%s:2223\")", 1, virtualIP.isEmpty() ? "127.0.0.1" : virtualIP) : this.mediaServer + "\n" + String.format("modparam(\"rtpengine\", \"rtpengine_sock\",\"%d == udp:127.0.0.1:2223\")", 1);
                    this.rluSIPServer = this.rluSIPServer + "\n" + String.format("$sht(ri=>%d)=\"%s\";", 1, swgIP);
                }
                this.mediaServer = this.nodeType.equals("MSF") ? this.mediaServer + "\n" + String.format("modparam(\"rtpengine\", \"rtpengine_sock\",\"%d == udp:%s:2223\")", routerId, virtualIP.isEmpty() ? "127.0.0.1" : virtualIP) : this.mediaServer + "\n" + String.format("modparam(\"rtpengine\", \"rtpengine_sock\",\"%d == udp:%s:2223\")", routerId, msf_ip.isEmpty() ? "127.0.0.1" : msf_ip);
                this.rluSIPServer = this.rluSIPServer + "\n" + String.format("$sht(ri=>%d)=\"%s\";", routerId, swgIP);
                for (String ip : rluIPS) {
                    if ((ip = ip.trim()).isEmpty()) continue;
                    if (!ip.equals(hostIP)) {
                        ips = ips + "\n" + String.format("%s/%s", ip, this.subNet);
                    }
                    if (ip.equals(swgIP)) continue;
                    this.sbcListen = this.sbcListen + "\n\n";
                    this.sbcListen = this.sbcListen + "\n" + String.format("listen=tcp:%s:%s", ip, this.usersSBCPort);
                    this.sbcListen = this.sbcListen + "\n" + String.format("listen=udp:%s:%s", ip, this.usersSBCPort);
                    if (isTLS.booleanValue()) {
                        this.sbcListen = this.sbcListen + "\n" + String.format("listen=tls:%s:%s", ip, this.usersSBCPortTLS);
                    }
                    this.virtualHost = this.virtualHost + "\n\n\n";
                    this.virtualHost = this.virtualHost + String.format("<VirtualHost %s:80>%s Redirect permanent / https://%s/  %s</VirtualHost>", ip, System.lineSeparator(), ip, System.lineSeparator());
                }
                writeContent = writeContent.replace("$$IPV4", ips);
                out.write(writeContent);
            }
            this.logger.info("Keepalived configuration populated");
        }
        catch (Exception E) {
            this.logger.error("Unable to read keepalived", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDBConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate;
        String managementIPV42;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/postgresql/12/main/postgresql.conf");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                managementIPV42 = configuration.node(hostName).get("HOSTIP1", "");
                resourceTemplate = new ClassPathResource("/postgres/postgresql.config");
                initialStream = resourceTemplate.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$ETH1", managementIPV42);
                out.write(writeContent);
                this.logger.info("postgresql.conf configuration populated");
            }
            catch (Throwable managementIPV42) {
                throwable = managementIPV42;
                throw managementIPV42;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable managementIPV42) {
                            throwable.addSuppressed(managementIPV42);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/etc/postgresql/12/main/pg_hba.conf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                managementIPV42 = configuration.node(hostName).get("HOSTIP1", "");
                resourceTemplate = new ClassPathResource("/postgres/pg_hba.config");
                initialStream = resourceTemplate.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$ETH1", managementIPV42);
                out.write(writeContent);
                this.logger.info("pg_hba.conf configuration populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read pg_hba.conf", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNMSContainerConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate;
        String managementIPV42;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/mnt/conf/container/coralnms//etc/postgresql/12/coralnms/postgresql.conf");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                managementIPV42 = configuration.node(hostName).get("NMSIP1", "");
                resourceTemplate = new ClassPathResource("/nms/postgresql.config");
                initialStream = resourceTemplate.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$ETH1", managementIPV42);
                out.write(writeContent);
                this.logger.info("NMS postgresql.conf configuration populated");
            }
            catch (Throwable managementIPV42) {
                throwable = managementIPV42;
                throw managementIPV42;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable managementIPV42) {
                            throwable.addSuppressed(managementIPV42);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/mnt/conf/container/coralnms//etc/postgresql/12/coralnms/pg_hba.conf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                managementIPV42 = configuration.node(hostName).get("NMSIP1", "");
                resourceTemplate = new ClassPathResource("/nms/pg_hba.config");
                initialStream = resourceTemplate.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$ETH0", configuration.node(hostName).get("HOSTIP0", ""));
                writeContent = writeContent.replace("$$ETH1", managementIPV42);
                out.write(writeContent);
                this.logger.info("NMS pg_hba.conf configuration populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("NMS Unable to read pg_hba.conf", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBillingConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate3;
        String writeContent2;
        StringWriter writer2;
        InputStream initialStream2;
        ClassPathResource resourceTemplate2;
        String managementIPV42;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/mnt/conf/container/billing//etc/postgresql/12/billing_service/postgresql.conf");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                managementIPV42 = configuration.node(hostName).get("BILLINGIP1", "");
                resourceTemplate2 = new ClassPathResource("/billing/postgresql.config");
                initialStream2 = resourceTemplate2.getInputStream();
                writer2 = new StringWriter();
                IOUtils.copy((InputStream)initialStream2, (Writer)writer2, (Charset)Charset.defaultCharset());
                writeContent2 = writer2.toString();
                writeContent2 = writeContent2.replace("$$ETH1", managementIPV42);
                out.write(writeContent2);
                this.logger.info("Billing postgresql.conf configuration populated");
            }
            catch (Throwable managementIPV42) {
                throwable = managementIPV42;
                throw managementIPV42;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable managementIPV42) {
                            throwable.addSuppressed(managementIPV42);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/mnt/conf/container/billing//etc/postgresql/12/billing_service/pg_hba.conf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                managementIPV42 = configuration.node(hostName).get("BILLINGIP1", "");
                resourceTemplate2 = new ClassPathResource("/billing/pg_hba.config");
                initialStream2 = resourceTemplate2.getInputStream();
                writer2 = new StringWriter();
                IOUtils.copy((InputStream)initialStream2, (Writer)writer2, (Charset)Charset.defaultCharset());
                writeContent2 = writer2.toString();
                writeContent2 = writeContent2.replace("$$ETH0", configuration.node(hostName).get("HOSTIP0", ""));
                writeContent2 = writeContent2.replace("$$ETH1", managementIPV42);
                out.write(writeContent2);
                this.logger.info("Billing pg_hba.conf configuration populated");
            }
            catch (Throwable managementIPV43) {
                throwable = managementIPV43;
                throw managementIPV43;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable managementIPV43) {
                            throwable.addSuppressed(managementIPV43);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Billing Unable to read pg_hba.conf", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/mnt/conf/container/billing//etc/coraltele/conf/app.config");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate3 = new ClassPathResource("/billing/app.config");
                initialStream = resourceTemplate3.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SERVERCODE", this.billingServerCode);
                out.write(writeContent);
                this.logger.info("Billing app.config configuration populated");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Billing Unable to Billing app.config", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/mnt/conf/container/billing//etc/coraltelecom/callserver.manager.conf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate3 = new ClassPathResource("/billing/callserver.manager.conf");
                initialStream = resourceTemplate3.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SERVERCODE", this.billingServerCode);
                writeContent = writeContent.replace("$$HOSTIP0", configuration.node(hostName).get("HOSTIP0", ""));
                writeContent = writeContent.replace("$$HOST1", configuration.node(hostName).get("HOSTIP1", ""));
                writeContent = writeContent.replace("$$NMSIP0", configuration.node(hostName).get("NMSIP0", ""));
                writeContent = writeContent.replace("$$NMSIP1", configuration.node(hostName).get("NMSIP1", ""));
                writeContent = writeContent.replace("$$BILLING1", configuration.node(hostName).get("BILLINGIP1", ""));
                out.write(writeContent);
                this.logger.info("Billing callserver.manager.conf configuration populated");
            }
            catch (Throwable resourceTemplate4) {
                throwable = resourceTemplate4;
                throw resourceTemplate4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate4) {
                            throwable.addSuppressed(resourceTemplate4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Billing Unable to read callserver.manager.conf", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/mnt/conf/container/billing//etc/coraltelecom/nmsapp.config");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate3 = new ClassPathResource("/billing/nmsapp.config");
                initialStream = resourceTemplate3.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$NMSIP1", configuration.node(hostName).get("NMSIP1", ""));
                writeContent = writeContent.replace("$$BILLING1", configuration.node(hostName).get("BILLINGIP1", ""));
                out.write(writeContent);
                this.logger.info("Billing nmsapp.config configuration populated");
            }
            catch (Throwable resourceTemplate5) {
                throwable = resourceTemplate5;
                throw resourceTemplate5;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate5) {
                            throwable.addSuppressed(resourceTemplate5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Billing Unable to nmsapp.config ", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/mnt/conf/container/billing//opt/activemq/conf/jetty.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate3 = new ClassPathResource("/billing/jetty.xml");
                initialStream = resourceTemplate3.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$BILLINGIP1", configuration.node(hostName).get("BILLINGIP1", ""));
                out.write(writeContent);
                this.logger.info("Billing jetty.xml configuration populated");
            }
            catch (Throwable resourceTemplate6) {
                throwable = resourceTemplate6;
                throw resourceTemplate6;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate6) {
                            throwable.addSuppressed(resourceTemplate6);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Billing Unable to read jetty.xml", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/mnt/conf/container/billing//opt/activemq/conf/activemq.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate3 = new ClassPathResource("/billing/activemq.xml");
                initialStream = resourceTemplate3.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$BILLINGIP1", configuration.node(hostName).get("BILLINGIP1", ""));
                out.write(writeContent);
                this.logger.info("Billing activemq.xml configuration populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Billing Unable to read activemq.xml", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUCConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate2;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/mnt/conf/container/clouduc//etc/coraltele/conf/app.config");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/uc/app.config.coraltele");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$HOSTIP0", configuration.node(hostName).get("HOSTIP0", ""));
                out.write(writeContent);
                this.logger.info("Billing app.config.coraltele configuration populated");
            }
            catch (Throwable resourceTemplate2) {
                throwable = resourceTemplate2;
                throw resourceTemplate2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate2) {
                            throwable.addSuppressed(resourceTemplate2);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/mnt/conf/container/clouduc//etc/coraltelecom/app.config");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/uc/app.config");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SERVERCODE", this.billingServerCode);
                writeContent = writeContent.replace("$$DOMAIN", this.domainName);
                writeContent = writeContent.replace("$$BILLINGIP1", configuration.node(hostName).get("BILLINGIP1", ""));
                writeContent = writeContent.replace("$$HOSTIP1", configuration.node(hostName).get("HOSTIP1", ""));
                writeContent = writeContent.replace("$$HOSTIP0", configuration.node(hostName).get("HOSTIP0", ""));
                out.write(writeContent);
                this.logger.info("Billing app.config configuration populated");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Billing Unable to Billing app.config", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/mnt/conf/container/clouduc//etc/coraltelecom/callserver.manager.conf");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource("/uc/callserver.manager.conf");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$SERVERCODE", this.billingServerCode);
                writeContent = writeContent.replace("$$HOST1", configuration.node(hostName).get("HOSTIP1", ""));
                writeContent = writeContent.replace("$$BILLINGIP1", configuration.node(hostName).get("BILLINGIP1", ""));
                out.write(writeContent);
                this.logger.info("Billing callserver.manager.conf configuration populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Billing Unable to read callserver.manager.conf", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeApacheConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/apache2/sites-enabled/000-default.conf");
             BufferedWriter out = new BufferedWriter(fileWriter);){
            ClassPathResource resourceTemplate = new ClassPathResource("/apache/000-default.conf");
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String writeContent = writer.toString();
            writeContent = this.nodeCount == 1 && !this.domainName.equals("sbc.coraltele.com") ? writeContent.replace("$$IP", this.domainName) : writeContent.replace("$$VirtualHost", this.virtualHost);
            writeContent = writeContent.replace("$$BILLINGIP1", configuration.node(hostName).get("BILLINGIP1", ""));
            writeContent = writeContent.replace("$$UCIP1", configuration.node(hostName).get("UCIP1", ""));
            out.write(writeContent);
            this.logger.info("000-default.conf configuration populated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHostConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/hosts");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                String IPV4 = configuration.node(hostName).get("HOSTIP0", "");
                String VIP = configuration.node(hostName).get("RLUVIP", "");
                this.domainName = configuration.node(CLUSTER_STRING).get("DOMAIN", "");
                this.domainName = this.domainName.isEmpty() ? "sbc.coraltele.com" : this.domainName;
                ClassPathResource resourceTemplate = new ClassPathResource("/network/hosts");
                InputStream initialStream = resourceTemplate.getInputStream();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                String writeContent = writer.toString();
                writeContent = writeContent.replace("$$DOMAIN", this.domainName);
                writeContent = writeContent.replace("$$ETH0", IPV4);
                writeContent = writeContent.replace("$$HOSTNAME", hostName);
                writeContent = writeContent.replace("$$VIP", VIP);
                out.write(writeContent);
                this.logger.info("hosts configuration populated");
            }
            catch (Throwable IPV4) {
                throwable = IPV4;
                throw IPV4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable IPV4) {
                            throwable.addSuppressed(IPV4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/var/www/html/hostname");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                String writeContent = "";
                writeContent = hostName;
                out.write(writeContent);
                this.logger.info("hostname file under /var/www/html folder populated");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to create /var/www/html", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertyFiles(Preferences configuration, String hostName) throws IOException {
        Throwable throwable;
        FileInputStream in;
        int publicIPCount = 0;
        Profile.Section section = (Profile.Section)this.ini.get((Object)"PUBLICIP");
        if (section != null) {
            publicIPCount = section.size();
        }
        String configurationFile = "/etc/coraltelecom/callserver.manager.conf";
        Properties prop = new Properties();
        try (FileOutputStream output = null;){
            in = new FileInputStream(configurationFile);
            throwable = null;
            try {
                prop.load(in);
                in.close();
                output = new FileOutputStream(configurationFile);
                prop.setProperty("servercode", this.hostServerCode);
                prop.setProperty("ntpserver", configuration.node(CLUSTER_STRING).get("NTP", ""));
                if (configuration.node(hostName).get("BILLING", "N").equals("Y")) {
                    prop.setProperty("billing.jdbc.url", String.format("jdbc:postgresql://%s:5432/switch", this.billingServerIP));
                    prop.setProperty("cdr.amqserverfullurl", String.format("tcp://%s:9890", this.billingServerIP));
                }
                prop.setProperty("pbxdomain", this.domainName);
                prop.setProperty("cmd.amqserverfullurl", String.format("tcp://%s:9890", configuration.node(hostName).get("HOSTIP1", "")));
                prop.store(output, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        configurationFile = "/etc/coraltele/conf/app.config";
        prop = new Properties();
        output = null;
        try {
            in = new FileInputStream(configurationFile);
            throwable = null;
            try {
                prop.load(in);
                in.close();
                output = new FileOutputStream(configurationFile);
                prop.setProperty("servercode", this.hostServerCode);
                prop.setProperty("voipgateway", "true");
                prop.setProperty("hasMultipleIP", publicIPCount > 1 ? "1" : "0");
                if (this.CSCF > 0) {
                    prop.setProperty("sbcip", String.format("%s:%s", configuration.node(hostName).get("HOSTIP0", ""), this.usersSBCPort));
                    prop.setProperty("singleprofile", "0");
                } else {
                    prop.setProperty("sbcip", String.format("%s:%s", configuration.node(hostName).get("RLUVIP", ""), this.usersSBCPort));
                    prop.setProperty("singleprofile", "1");
                }
                prop.setProperty("sipserverinfo", String.format("%s:5080", configuration.node(hostName).get("RLUVIPSIPSERVER", "")));
                prop.setProperty("tunnelport", "5059");
                prop.setProperty("rlumode", "false");
                prop.setProperty("syncSM", "1");
                prop.store(output, null);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("app.config updated", (Throwable)E);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSIPServerConfiguration(Preferences configuration, String rootFolder, String hostName) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate3;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/vars.xml");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                String serverIP = configuration.node(hostName).get("RLUVIPSIPSERVER", "");
                ClassPathResource resourceTemplate2 = new ClassPathResource(this.nodeType.equals("MSF") ? "/sipserver/vars-msf.xml" : "/sipserver/vars.xml");
                InputStream initialStream2 = resourceTemplate2.getInputStream();
                StringWriter writer2 = new StringWriter();
                IOUtils.copy((InputStream)initialStream2, (Writer)writer2, (Charset)Charset.defaultCharset());
                String writeContent2 = writer2.toString();
                String publicIP = configuration.node("PUBLICIP").get(serverIP, "");
                if (publicIP.isEmpty()) {
                    publicIP = serverIP;
                }
                writeContent2 = writeContent2.replace("$$VIP", serverIP);
                writeContent2 = writeContent2.replace("$$PUBLICVIP", publicIP);
                writeContent2 = writeContent2.replace("$$DOMAIN", this.domainName);
                writeContent2 = writeContent2.replace("$$SBC_USERS_PORT_TLS", this.usersSBCPortTLS);
                writeContent2 = writeContent2.replace("$$SBC_USERS_PORT", this.usersSBCPort);
                writeContent2 = writeContent2.replace("$$SIPSERVER_USERS_PORT_TLS", this.usersSIPServerPortTLS);
                writeContent2 = writeContent2.replace("$$SIPSERVER_USERS_PORT", this.usersSIPServerPort);
                writeContent2 = writeContent2.replace("$$SIPSERVER_GATEWAY_PORT_TLS", this.gatewaySIPServerPortTLS);
                writeContent2 = writeContent2.replace("$$SIPSERVER_GATEWAY_PORT", this.gatewaySIPServerPort);
                out.write(writeContent2);
                this.logger.info("SIP Server configuration populated");
            }
            catch (Throwable serverIP) {
                throwable = serverIP;
                throw serverIP;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable serverIP) {
                            throwable.addSuppressed(serverIP);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/sofia.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate3 = new ClassPathResource("/sipserver/sofia.conf.xml");
                initialStream = resourceTemplate3.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server Sofia configuration populated");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server Sofia configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        if (!this.nodeType.equals("MSF")) {
            fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles/internal.xml");
            try {
                out = new BufferedWriter(fileWriter);
                throwable = null;
                try {
                    resourceTemplate3 = new ClassPathResource("/sipserver/internal.xml");
                    initialStream = resourceTemplate3.getInputStream();
                    writer = new StringWriter();
                    IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                    writeContent = writer.toString();
                    writeContent = writeContent.replace("$$RLU", "");
                    out.write(writeContent);
                    this.logger.info("SIP Server Internal configuration populated");
                }
                catch (Throwable resourceTemplate4) {
                    throwable = resourceTemplate4;
                    throw resourceTemplate4;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable resourceTemplate4) {
                                throwable.addSuppressed(resourceTemplate4);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (Exception E) {
                this.logger.error("Unable to read SIP Server Internal configuration", (Throwable)E);
            }
            finally {
                fileWriter.close();
            }
        }
        if (!this.nodeType.equals("MSF")) {
            fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles/external.xml");
            try {
                out = new BufferedWriter(fileWriter);
                throwable = null;
                try {
                    resourceTemplate3 = new ClassPathResource("/sipserver/external.xml");
                    initialStream = resourceTemplate3.getInputStream();
                    writer = new StringWriter();
                    IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                    writeContent = writer.toString();
                    writeContent = writeContent.replace("$$RLU", "");
                    out.write(writeContent);
                    this.logger.info("SIP Server External configuration populated");
                }
                catch (Throwable resourceTemplate5) {
                    throwable = resourceTemplate5;
                    throw resourceTemplate5;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable resourceTemplate5) {
                                throwable.addSuppressed(resourceTemplate5);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (Exception E) {
                this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
            }
            finally {
                fileWriter.close();
            }
        }
        if (!this.nodeType.equals("MSF")) {
            fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles/forkcall.xml");
            try {
                out = new BufferedWriter(fileWriter);
                throwable = null;
                try {
                    resourceTemplate3 = new ClassPathResource("/sipserver/forkcall.xml");
                    initialStream = resourceTemplate3.getInputStream();
                    writer = new StringWriter();
                    IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                    writeContent = writer.toString();
                    writeContent = writeContent.replace("$$RLU", "");
                    out.write(writeContent);
                    this.logger.info("SIP Server External configuration populated");
                }
                catch (Throwable resourceTemplate6) {
                    throwable = resourceTemplate6;
                    throw resourceTemplate6;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable resourceTemplate6) {
                                throwable.addSuppressed(resourceTemplate6);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (Exception E) {
                this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
            }
            finally {
                fileWriter.close();
            }
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/xml_rpc.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate3 = new ClassPathResource("/sipserver/xml_rpc.conf.xml");
                initialStream = resourceTemplate3.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate7) {
                throwable = resourceTemplate7;
                throw resourceTemplate7;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate7) {
                            throwable.addSuppressed(resourceTemplate7);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        if (this.nodeType.equals("MSF")) {
            fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/xml_curl.conf.xml");
            try {
                out = new BufferedWriter(fileWriter);
                throwable = null;
                try {
                    resourceTemplate3 = new ClassPathResource("/sipserver/xml_curl.conf-msf.xml");
                    initialStream = resourceTemplate3.getInputStream();
                    writer = new StringWriter();
                    IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                    writeContent = writer.toString();
                    out.write(writeContent);
                    this.logger.info("SIP Server External configuration populated");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (Exception E) {
                this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
            }
            finally {
                fileWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSIPServerConfiguration(String rootFolder, String serverIP, String rluCode, String type, String CSCFIP, String remoteCSCFIP) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate2;
        Throwable throwable;
        BufferedWriter out;
        FileWriter fileWriter;
        if (!type.equals("MSF")) {
            fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles/internal_" + rluCode + ".xml");
            try {
                out = new BufferedWriter(fileWriter);
                throwable = null;
                try {
                    resourceTemplate2 = new ClassPathResource(type.equals("MSF") ? "/sipserver/internal-msf.xml" : "/sipserver/internal.xml");
                    initialStream = resourceTemplate2.getInputStream();
                    writer = new StringWriter();
                    IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                    writeContent = writer.toString();
                    writeContent = writeContent.replace("$$RLU", "_" + rluCode);
                    writeContent = writeContent.replace("$${local_ip_v4_internal}", serverIP);
                    out.write(writeContent);
                    this.logger.info("SIP Server Internal configuration populated");
                }
                catch (Throwable resourceTemplate2) {
                    throwable = resourceTemplate2;
                    throw resourceTemplate2;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable resourceTemplate2) {
                                throwable.addSuppressed(resourceTemplate2);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (Exception E) {
                this.logger.error("Unable to read SIP Server Internal configuration", (Throwable)E);
            }
            finally {
                fileWriter.close();
            }
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles/external_" + rluCode + ".xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate2 = new ClassPathResource(type.equals("MSF") ? "/sipserver/external-msf.xml" : "/sipserver/external.xml");
                initialStream = resourceTemplate2.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$RLU", "_" + rluCode);
                writeContent = writeContent.replace("$${local_ip_v4_external}", serverIP);
                out.write(writeContent);
                this.logger.info("SIP Server External configuration populated");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        if (!type.equals("MSF")) {
            fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/sip_profiles/fork_" + rluCode + ".xml");
            try {
                out = new BufferedWriter(fileWriter);
                throwable = null;
                try {
                    resourceTemplate2 = new ClassPathResource("/sipserver/forkcall.xml");
                    initialStream = resourceTemplate2.getInputStream();
                    writer = new StringWriter();
                    IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                    writeContent = writer.toString();
                    writeContent = writeContent.replace("$$RLU", "_" + rluCode);
                    writeContent = writeContent.replace("$${local_ip_v4_internal}", serverIP);
                    out.write(writeContent);
                    this.logger.info("SIP Server External configuration populated");
                }
                catch (Throwable resourceTemplate4) {
                    throwable = resourceTemplate4;
                    throw resourceTemplate4;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable resourceTemplate4) {
                                throwable.addSuppressed(resourceTemplate4);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (Exception E) {
                this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
            }
            finally {
                fileWriter.close();
            }
        }
        if (type.equals("MSF")) {
            fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/dialplan/default.xml");
            try {
                out = new BufferedWriter(fileWriter);
                throwable = null;
                try {
                    resourceTemplate2 = new ClassPathResource("/sipserver/dialplan-msf.xml");
                    initialStream = resourceTemplate2.getInputStream();
                    writer = new StringWriter();
                    IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                    writeContent = writer.toString();
                    writeContent = writeContent.replace("$$RLU", rluCode);
                    writeContent = writeContent.replace("$$MSF_IP", CSCFIP);
                    writeContent = writeContent.replace("$$REMOTE_CSCF_IP_REGEX", remoteCSCFIP.replace(".", "\\."));
                    writeContent = writeContent.replace("$$REMOTE_CSCF_IP", remoteCSCFIP);
                    out.write(writeContent);
                    this.logger.info("SIP MSF Dialplan populated");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (Exception E) {
                this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
            }
            finally {
                fileWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSIPGatewayConfigurations(Preferences configuration, String rootFolder, String hostName) throws IOException {
        String writeContent;
        StringWriter writer;
        InputStream initialStream;
        ClassPathResource resourceTemplate3;
        String writeContent2;
        StringWriter writer2;
        InputStream initialStream2;
        ClassPathResource resourceTemplate2;
        String serverIP2;
        Throwable throwable;
        BufferedWriter out;
        try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/coraltele/trunkgateway/conf/vars.xml");){
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                serverIP2 = configuration.node(hostName).get("HOSTIP0", "");
                this.domainName = configuration.node(CLUSTER_STRING).get("DOMAIN", "");
                this.domainName = this.domainName.isEmpty() ? "sbc.coraltele.com" : this.domainName;
                resourceTemplate2 = new ClassPathResource("/sipgateways/trunkgateway_vars.xml");
                initialStream2 = resourceTemplate2.getInputStream();
                writer2 = new StringWriter();
                IOUtils.copy((InputStream)initialStream2, (Writer)writer2, (Charset)Charset.defaultCharset());
                writeContent2 = writer2.toString();
                writeContent2 = writeContent2.replace("$$HOST0", serverIP2);
                writeContent2 = writeContent2.replace("$$DOMAIN", this.domainName);
                out.write(writeContent2);
                this.logger.info("Trunk gateway configuration populated");
            }
            catch (Throwable serverIP2) {
                throwable = serverIP2;
                throw serverIP2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable serverIP2) {
                            throwable.addSuppressed(serverIP2);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/conferencegateway/conf/vars.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                serverIP2 = configuration.node(hostName).get("HOSTIP0", "");
                this.domainName = configuration.node(CLUSTER_STRING).get("DOMAIN", "");
                this.domainName = this.domainName.isEmpty() ? "sbc.coraltele.com" : this.domainName;
                resourceTemplate2 = new ClassPathResource("/sipgateways/conferencegateway_vars.xml");
                initialStream2 = resourceTemplate2.getInputStream();
                writer2 = new StringWriter();
                IOUtils.copy((InputStream)initialStream2, (Writer)writer2, (Charset)Charset.defaultCharset());
                writeContent2 = writer2.toString();
                writeContent2 = writeContent2.replace("$$HOST0", serverIP2);
                writeContent2 = writeContent2.replace("$$DOMAIN", this.domainName);
                out.write(writeContent2);
                this.logger.info("Conference gateway configuration populated");
            }
            catch (Throwable serverIP3) {
                throwable = serverIP3;
                throw serverIP3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable serverIP3) {
                            throwable.addSuppressed(serverIP3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read Conference gateway configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/featuregateway/conf/vars.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                serverIP2 = configuration.node(hostName).get("HOSTIP0", "");
                this.domainName = configuration.node(CLUSTER_STRING).get("DOMAIN", "");
                this.domainName = this.domainName.isEmpty() ? "sbc.coraltele.com" : this.domainName;
                resourceTemplate2 = new ClassPathResource("/sipgateways/featuregateway_vars.xml");
                initialStream2 = resourceTemplate2.getInputStream();
                writer2 = new StringWriter();
                IOUtils.copy((InputStream)initialStream2, (Writer)writer2, (Charset)Charset.defaultCharset());
                writeContent2 = writer2.toString();
                writeContent2 = writeContent2.replace("$$HOST0", serverIP2);
                writeContent2 = writeContent2.replace("$$DOMAIN", this.domainName);
                out.write(writeContent2);
                this.logger.info("Feature gateway configuration populated");
            }
            catch (Throwable serverIP4) {
                throwable = serverIP4;
                throw serverIP4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable serverIP4) {
                            throwable.addSuppressed(serverIP4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read Feature gateway configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/event_socket.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate3 = new ClassPathResource("/sipserver/event_socket.conf.xml");
                initialStream = resourceTemplate3.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$IP", "127.0.0.1");
                out.write(writeContent);
                this.logger.info("SIP Server XML Curl");
            }
            catch (Throwable resourceTemplate3) {
                throwable = resourceTemplate3;
                throw resourceTemplate3;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate3) {
                            throwable.addSuppressed(resourceTemplate3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/modules.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate3 = new ClassPathResource("/sipserver/modules.conf.xml");
                initialStream = resourceTemplate3.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                writeContent = writeContent.replace("$$IP", "127.0.0.1");
                out.write(writeContent);
                this.logger.info("SIP Server XML Curl");
            }
            catch (Throwable resourceTemplate4) {
                throwable = resourceTemplate4;
                throw resourceTemplate4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate4) {
                            throwable.addSuppressed(resourceTemplate4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read SIP Server External configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/cdr_pg_csv.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate3 = new ClassPathResource("/sipserver/cdr_pg_csv.conf.xml");
                initialStream = resourceTemplate3.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server PG CSV.");
            }
            catch (Throwable resourceTemplate5) {
                throwable = resourceTemplate5;
                throw resourceTemplate5;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate5) {
                            throwable.addSuppressed(resourceTemplate5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read PG CSV configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/lua.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate3 = new ClassPathResource("/sipserver/lua.conf.xml");
                initialStream = resourceTemplate3.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server Lua Conf.");
            }
            catch (Throwable resourceTemplate6) {
                throwable = resourceTemplate6;
                throw resourceTemplate6;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable resourceTemplate6) {
                            throwable.addSuppressed(resourceTemplate6);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read lua conf configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltele/sipserver/conf/autoload_configs/logfile.conf.xml");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                resourceTemplate3 = new ClassPathResource("/sipserver/logfile.conf.xml");
                initialStream = resourceTemplate3.getInputStream();
                writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("SIP Server LogFile Conf.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.error("Unable to read logfile conf configuration", (Throwable)E);
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDockerImages(Preferences configuration, String rootFolder, String hostName) throws IOException {
        String message = "";
        String command = "";
        String response = "";
        Boolean dockerCreated = false;
        Boolean createBillingContainer = false;
        Boolean createNMSContainer = false;
        Boolean createUCContainer = false;
        if (configuration.node(hostName).get("BILLING", "N").equals("Y")) {
            if (Files.exists(Paths.get("/mnt/virtual-machines/billing.tar", new String[0]), new LinkOption[0])) {
                createBillingContainer = true;
                dockerCreated = true;
                this.logger.info("Billing Docker to be imported");
                response = this.executeCommand("docker images | grep -i billing").toString();
                if (response.contains("billing")) {
                    this.logger.info("Billing Image already imported");
                } else {
                    this.logger.info("Importing billing image");
                    command = "cat /mnt/virtual-machines/billing.tar | docker import - billing:v1";
                    this.logger.info(command);
                    message = this.executeCommand(command).toString();
                    this.logger.info(message);
                }
            } else {
                this.logger.info("======================================================================");
                this.logger.info("Billing Container image not found at /mnt/virtual-machines/billing.tar");
                this.logger.info("======================================================================");
            }
        }
        if (configuration.node(hostName).get("NMS", "N").equals("Y")) {
            if (Files.exists(Paths.get("/mnt/virtual-machines/coralnms.tar", new String[0]), new LinkOption[0])) {
                createNMSContainer = true;
                dockerCreated = true;
                this.logger.info("NMS Docker to be imported");
                response = this.executeCommand("docker images | grep -i coralnms").toString();
                if (response.contains("nms")) {
                    this.logger.info("NMS Image already imported");
                } else {
                    this.logger.info("Importing NMS image");
                    command = "cat /mnt/virtual-machines/coralnms.tar | docker import - coralnms:v1";
                    this.logger.info(command);
                    message = this.executeCommand(command).toString();
                    this.logger.info(message);
                }
            } else {
                this.logger.info("======================================================================");
                this.logger.info("NMS Container image not found at /mnt/virtual-machines/coralnms.tar");
                this.logger.info("======================================================================");
            }
        }
        if (configuration.node(hostName).get("UC", "N").equals("Y")) {
            if (Files.exists(Paths.get("/mnt/virtual-machines/clouduc.tar", new String[0]), new LinkOption[0])) {
                createUCContainer = true;
                dockerCreated = true;
                this.logger.info("UC Docker to be imported");
                response = this.executeCommand("docker images | grep -i clouduc").toString();
                if (response.contains("clouduc")) {
                    this.logger.info("UC Image already imported");
                } else {
                    this.logger.info("Importing UC image");
                    command = "cat /mnt/virtual-machines/clouduc.tar | docker import - clouduc:v1";
                    this.logger.info(command);
                    message = this.executeCommand(command).toString();
                    this.logger.info(message);
                }
            } else {
                this.logger.info("======================================================================");
                this.logger.info("UC Container image not found at /mnt/virtual-machines/clouduc.tar");
                this.logger.info("======================================================================");
            }
        }
        if (dockerCreated.booleanValue()) {
            this.logger.info("Dockers created. Creating mac vlan");
            response = this.executeCommand("docker network ls | grep -i localnet").toString();
            if (response.contains("localnet")) {
                this.logger.info("localnet vlan already created");
            } else {
                this.logger.info("Creating localnet mac vlan");
                command = String.format("docker network create --driver macvlan --subnet %s/%s --gateway  %s -o parent=eth0  localnet", configuration.node(hostName).get("HOSTIP0", ""), this.subNet, configuration.node(hostName).get("GATEWAY", ""));
                this.logger.info(command);
                message = this.executeCommand(command).toString();
                this.logger.info(message);
            }
            response = this.executeCommand("docker network ls | grep -i management").toString();
            if (response.contains("management")) {
                this.logger.info("management mac vlan already created");
            } else {
                this.logger.info("Creating management mac vlan");
                command = String.format("docker network create --driver macvlan --subnet %s/24 --gateway  %s -o parent=eth1  management", configuration.node(hostName).get("HOSTIP1", ""), "192.168.254.254");
                this.logger.info(command);
                message = this.executeCommand(command).toString();
                this.logger.info(message);
            }
        }
        if (configuration.node(hostName).get("BILLING", "N").equals("Y") && createBillingContainer.booleanValue()) {
            this.logger.info("Billing Container to be created");
            response = this.executeCommand("docker ps | grep -i billing").toString();
            if (response.contains("billing")) {
                this.logger.info("Billing container already created");
            } else {
                this.logger.info("Creating billing container");
                command = String.format("docker container run -d --name billing --hostname %s-billing --network localnet --ip %s --restart always --privileged=true --publish-all=true -v /sys/fs/cgroup:/sys/fs/cgroup:ro -v /mnt/:/mnt/ -v /home/coralswitch/:/home/coralswitch/ billing:v1 /sbin/init", hostName, configuration.node(hostName).get("BILLINGIP0", ""));
                this.logger.info(command);
                message = this.executeCommand(command).toString();
                this.logger.info(message);
                command = String.format("docker network connect management billing --ip %s ", configuration.node(hostName).get("BILLINGIP1", ""));
                this.logger.info(command);
                message = this.executeCommand(command).toString();
                this.logger.info(message);
            }
        }
        if (configuration.node(hostName).get("NMS", "N").equals("Y") && createNMSContainer.booleanValue()) {
            this.logger.info("NMS Container to be created");
            response = this.executeCommand("docker ps | grep -i coralnms").toString();
            if (response.contains("coralnms")) {
                this.logger.info("NMS container already created");
            } else {
                this.logger.info("Creating NMS container");
                command = String.format("docker container run -d --name coralnms --hostname %s-coralnms --network localnet --ip %s --restart always --privileged=true --publish-all=true -v /sys/fs/cgroup:/sys/fs/cgroup:ro -v /mnt/:/mnt/ coralnms:v1 /sbin/init", hostName, configuration.node(hostName).get("NMSIP0", ""));
                this.logger.info(command);
                message = this.executeCommand(command).toString();
                this.logger.info(message);
                command = String.format("docker network connect management coralnms --ip %s ", configuration.node(hostName).get("NMSIP1", ""));
                this.logger.info(command);
                message = this.executeCommand(command).toString();
                this.logger.info(message);
            }
        }
        if (configuration.node(hostName).get("UC", "N").equals("Y") && createUCContainer.booleanValue()) {
            this.logger.info("UC Container to be created");
            response = this.executeCommand("docker ps | grep -i clouduc").toString();
            if (response.contains("clouduc")) {
                this.logger.info("UC container already created");
            } else {
                this.logger.info("Creating UC container");
                command = String.format("docker container run -d --name clouduc --hostname %s-clouduc --network localnet --ip %s --restart always --privileged=true --publish-all=true -v /sys/fs/cgroup:/sys/fs/cgroup:ro -v /mnt/:/mnt/ clouduc:v1 /sbin/init", hostName, configuration.node(hostName).get("UCIP0", ""));
                this.logger.info(command);
                message = this.executeCommand(command).toString();
                this.logger.info(message);
                command = String.format("docker network connect management clouduc --ip %s ", configuration.node(hostName).get("UCIP1", ""));
                this.logger.info(command);
                message = this.executeCommand(command).toString();
                this.logger.info(message);
            }
        }
        if (dockerCreated.booleanValue()) {
            try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/network/if-up.d/routes");
                 BufferedWriter out = new BufferedWriter(fileWriter);){
                ClassPathResource resourceTemplate = new ClassPathResource("/network/routes");
                InputStream initialStream = resourceTemplate.getInputStream();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                String writeContent = writer.toString();
                if (configuration.node(hostName).get("BILLING", "N").equals("Y")) {
                    this.logger.info("Adding routes for billing");
                    writeContent = writeContent.replace("$$BILLING0", String.format("ip route add %s  dev veth0", configuration.node(hostName).get("BILLINGIP0", "")));
                    writeContent = writeContent.replace("$$BILLING1", String.format("ip route add %s  dev veth1", configuration.node(hostName).get("BILLINGIP1", "")));
                    this.executeCommand("docker container exec -i billing cp -r /mnt/conf/container/billing/etc /");
                    this.executeCommand("docker container exec -i billing cp -r /mnt/conf/container/billing/opt /");
                    this.executeCommand("docker container exec -i billing  /etc/init.d/postgresql stop");
                    this.executeCommand("docker container exec -i billing  /etc/init.d/postgresql start");
                    this.executeCommand("psql -U postgres -d switch -h " + configuration.node(hostName).get("BILLINGIP1", "") + " -c 'truncate table pbx.m_nodeconfiguration'");
                    this.executeCommand("psql -U postgres -d switch -h " + configuration.node(hostName).get("BILLINGIP1", "") + " -f /tmp/billing-nodes.sql");
                    this.executeCommand("psql -U postgres -d switch -h " + configuration.node(hostName).get("BILLINGIP1", "") + " -c 'truncate table pbx.m_profilemapping'");
                    this.executeCommand("psql -U postgres -d switch -h " + configuration.node(hostName).get("BILLINGIP1", "") + " -f /tmp/billing-profiles.sql");
                    this.executeCommand("psql -U postgres -d switch -h " + configuration.node(hostName).get("BILLINGIP1", "") + " -c 'truncate table pbx.m_control_rluserver'");
                    this.executeCommand("psql -U postgres -d switch -h " + configuration.node(hostName).get("BILLINGIP1", "") + " -f /tmp/billing-rlus.sql");
                    this.executeCommand("psql -U postgres -d switch -h " + configuration.node(hostName).get("BILLINGIP1", "") + " -c \"update pbx.m_systemconfigs set servercode='" + this.billingServerCode + "' \"");
                } else {
                    this.logger.info("Removing routes for billing");
                    writeContent = writeContent.replace("$$BILLING0", "");
                    writeContent = writeContent.replace("$$BILLING1", "");
                }
                if (configuration.node(hostName).get("NMS", "N").equals("Y")) {
                    this.logger.info("Adding routes for NMS");
                    writeContent = writeContent.replace("$$NMS0", String.format("ip route add %s  dev veth0", configuration.node(hostName).get("NMSIP0", "")));
                    writeContent = writeContent.replace("$$NMS1", String.format("ip route add %s  dev veth1", configuration.node(hostName).get("NMSIP1", "")));
                    this.executeCommand("docker container exec -i coralnms cp -r /mnt/conf/container/coralnms/etc /");
                    this.executeCommand("docker container exec -i coralnms  /etc/init.d/postgresql stop");
                    this.executeCommand("docker container exec -i coralnms  /etc/init.d/postgresql start");
                } else {
                    this.logger.info("Removing routes for NMS");
                    writeContent = writeContent.replace("$$NMS0", "");
                    writeContent = writeContent.replace("$$NMS1", "");
                }
                if (configuration.node(hostName).get("UC", "N").equals("Y")) {
                    this.logger.info("Adding routes for UC");
                    writeContent = writeContent.replace("$$UC0", String.format("ip route add %s  dev veth0", configuration.node(hostName).get("UCIP0", "")));
                    writeContent = writeContent.replace("$$UC1", String.format("ip route add %s  dev veth1", configuration.node(hostName).get("UCIP1", "")));
                    this.executeCommand("docker container exec -i clouduc cp -r /mnt/conf/container/clouduc/etc /");
                } else {
                    this.logger.info("Removing routes for NMS");
                    writeContent = writeContent.replace("$$UC0", "");
                    writeContent = writeContent.replace("$$UC1", "");
                }
                command = "chmod +x " + rootFolder + "/etc/network/if-up.d/routes";
                this.logger.info(command);
                this.executeCommand(command);
                out.write(writeContent);
                this.logger.info("Route configuration populated");
            }
        } else {
            try (FileWriter fileWriter = new FileWriter(rootFolder + "/etc/network/if-up.d/routes");
                 BufferedWriter out = new BufferedWriter(fileWriter);){
                ClassPathResource resourceTemplate = new ClassPathResource("/network/blank-routes");
                InputStream initialStream = resourceTemplate.getInputStream();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                String writeContent = writer.toString();
                out.write(writeContent);
                this.logger.info("Route configuration populated");
                command = "chmod +x " + rootFolder + "/etc/network/if-up.d/routes";
                this.logger.info(command);
                this.executeCommand(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSingleIPDeployment(Preferences configuration, String rootFolder, String hostName) throws IOException {
        Throwable throwable;
        BufferedWriter out;
        String ipSIPServer = configuration.node(hostName).get("RLUVIPSIPSERVER", "");
        this.dbCommands.update("update pbx.m_control_rluserver set routerid = 1");
        FileWriter fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/mediaserver.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                out.write("modparam(\"rtpengine\", \"rtpengine_sock\",\"1 == udp:127.0.0.1:2223\")");
                this.logger.info("Single IP Media Server - SBC Link Setup");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)E);
        }
        fileWriter = new FileWriter(rootFolder + "/etc/coraltelecom/rlusipserver.cfg");
        try {
            out = new BufferedWriter(fileWriter);
            throwable = null;
            try {
                out.write("$sht(ri=>1)=\"" + ipSIPServer + "\";");
                this.logger.info("Single IP Media Server - SBC Link Setup");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Exception E) {
            this.logger.info("Error while writing sbc nodes configuration", (Throwable)E);
        }
        if (!configuration.node(CLUSTER_STRING).get("WRITE_NETWORK_SETTINGS", "").equals("N")) {
            fileWriter = new FileWriter(rootFolder + "/etc/network/interfaces");
            try {
                out = new BufferedWriter(fileWriter);
                throwable = null;
                try {
                    String IPV4 = configuration.node(hostName).get("HOSTIP0", "");
                    String gateway = configuration.node(hostName).get("GATEWAY", "");
                    String managementIPV4 = configuration.node(hostName).get("HOSTIP1", "");
                    ClassPathResource resourceTemplate = new ClassPathResource("/network/interfaces-6");
                    InputStream initialStream = resourceTemplate.getInputStream();
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
                    String writeContent = writer.toString();
                    writeContent = writeContent.replace("$$IPV4MGMT", managementIPV4);
                    writeContent = writeContent.replace("$$IPV4GATEWAY", gateway);
                    writeContent = writeContent.replace("$$SIPSERVER", ipSIPServer);
                    writeContent = writeContent.replace("$$IPV4", IPV4);
                    writeContent = writeContent.replace("$$SUBNET", this.subNet);
                    out.write(writeContent);
                    this.logger.info("network configuration populated");
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (Exception E) {
                this.logger.error("Unable to read network", (Throwable)E);
            }
            finally {
                fileWriter.close();
            }
        }
        this.executeCommand("rm " + rootFolder + "/etc/keepalived/keepalived.conf");
    }

    private StringBuilder executeCommand(String command) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        StringBuilder output = new StringBuilder();
        processBuilder.command("bash", "-c", command);
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                output.append(line + "\n");
            }
            String message = String.format("%s : Executed", command);
            this.logger.info(message);
        }
        catch (Exception e) {
            this.logger.error("Error while executing command", (Throwable)e);
            e.printStackTrace();
        }
        return output;
    }

    private String getHostName(String hostIP) {
        String hostName = "";
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("public"));
        target.setAddress(GenericAddress.parse((String)String.format("udp:%s/161", hostIP)));
        target.setRetries(2);
        target.setTimeout(1500L);
        target.setVersion(1);
        try {
            Map result = this.doWalk("1.3.6.1.2.1.1", (Target)target);
            hostName = (String)result.get(".1.3.6.1.2.1.1.5.0");
        }
        catch (IOException e) {
            this.logger.info(String.format("Unable to fetch hostname for : %s", hostIP), (Throwable)e);
        }
        return hostName;
    }

    private String getPublicIP(Preferences configuration, String ip) {
        return configuration.node("PUBLICIP").get(ip, "");
    }

    public Map<String, String> doWalk(String tableOid, Target target) throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        Snmp snmp = new Snmp((TransportMapping)transport);
        transport.listen();
        TreeUtils treeUtils = new TreeUtils((Session)snmp, (PDUFactory)new DefaultPDUFactory());
        List events = treeUtils.getSubtree(target, new OID(tableOid));
        if (events == null || events.isEmpty()) {
            this.logger.info("Unable to read data from SNMP Table");
            return result;
        }
        for (TreeEvent event : events) {
            if (event == null) continue;
            if (event.isError()) {
                String message = String.format("Error: table OID [%s] ", event.getErrorMessage());
                this.logger.info(message);
                continue;
            }
            VariableBinding[] varBindings = event.getVariableBindings();
            if (varBindings == null || varBindings.length == 0) continue;
            for (VariableBinding varBinding : varBindings) {
                if (varBinding == null) continue;
                result.put("." + varBinding.getOid().toString(), varBinding.getVariable().toString());
            }
        }
        snmp.close();
        return result;
    }
}

