/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service;

import com.coraltele.condition.EnableSUBSCRIBER_SERVER;
import com.coraltele.db.telephony.pbx.entity.V2_Subscription;
import com.coraltele.db.telephony.pbx.repository.V2_SubscriptionRepository;
import com.coraltele.helper.Constants;
import com.coraltele.ims.SubscribeIMS;
import com.coraltele.model.SubscriberUser;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Conditional(value={EnableSUBSCRIBER_SERVER.class})
public class SubscribeIMSService {
    String className = "SubscribeIMSService";
    private static final Logger logger = LogManager.getLogger(SubscribeIMSService.class);
    @Autowired
    V2_SubscriptionRepository v2_SubscriptionRepository;
    @Autowired
    SubscribeIMS subscribeIMS;
    public static List<DatagramPacket> packets = new ArrayList();
    public static final long SUBSCRIBER_SAVE_TIMER_IN_MILLISECONDS = Constants.SUBSCRIBER_SAVE_TIMER_IN_MINUTES * 60 * 1000;
    @Autowired
    private TaskScheduler taskScheduler;
    private ScheduledFuture<?> scheduledTask;

    public void scheduleSubscriptionSave() {
        try {
            if (SUBSCRIBER_SAVE_TIMER_IN_MILLISECONDS > 0L) {
                logger.info("Initializing subscription save with timer : {} ms", (Object)SUBSCRIBER_SAVE_TIMER_IN_MILLISECONDS);
                this.scheduledTask = this.taskScheduler.scheduleAtFixedRate(() -> this.saveSubscribePacketInDatabase(), SUBSCRIBER_SAVE_TIMER_IN_MILLISECONDS);
            } else {
                logger.info("scheduleSubscriptionSave will not work due to : {} ms ", (Object)SUBSCRIBER_SAVE_TIMER_IN_MILLISECONDS);
            }
        }
        catch (Exception e) {
            logger.error("Error in scheduledSubscriptionSave method {}", (Throwable)e);
        }
    }

    public void stopScheduledSubscriptionSave() {
        if (this.scheduledTask != null && !this.scheduledTask.isCancelled()) {
            this.scheduledTask.cancel(true);
            logger.info("scheduleSubscriptionSave task stopped");
        }
        logger.info("SubscriptionSaveBeforeShutdown in stopScheduledSubscriptionSave method executed");
        this.saveSubscribePacketInDatabase();
    }

    private boolean isDatabaseConnected() {
        try {
            this.v2_SubscriptionRepository.count();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(transactionManager="switchTransactionManager")
    private void saveSubscribePacketInDatabase() {
        String functionName = "saveSubscribe";
        try {
            if (!this.isDatabaseConnected()) {
                logger.info("Database connection is down. Skipping save operation in saveSubscribePacketInDatabase Method.");
                return;
            }
            Map serviceSubscriptions = this.subscribeIMS.getSubscriptions();
            if (serviceSubscriptions == null || serviceSubscriptions.isEmpty()) {
                logger.info("SubscriptionsHashmap is empty or null.Skipping save operation in saveSubscribePacketInDatabase Method.");
                return;
            }
            ArrayList<V2_Subscription> subscribeEntities = new ArrayList<V2_Subscription>();
            for (Map.Entry entry : serviceSubscriptions.entrySet()) {
                List subscribedByUsersList = (List)entry.getValue();
                for (SubscriberUser subscribedByUser : subscribedByUsersList) {
                    if (!subscribedByUser.getLock().tryLock(2L, TimeUnit.SECONDS)) continue;
                    try {
                        if (!subscribedByUser.isActive() || subscribedByUser.getExpirationTime() < System.currentTimeMillis()) continue;
                        V2_Subscription subscribeEntity = new V2_Subscription();
                        subscribeEntity.setFromUser(subscribedByUser.getSubscriber());
                        subscribeEntity.setToUser(subscribedByUser.getSubscribedTo());
                        subscribeEntity.setHostAddress(subscribedByUser.getHostAddress());
                        subscribeEntity.setHostPort(subscribedByUser.getHostPort());
                        subscribeEntity.setExpire(subscribedByUser.getExpirationTime());
                        subscribeEntity.setDialog(subscribedByUser.getRequest());
                        subscribeEntities.add(subscribeEntity);
                    }
                    catch (Exception e) {
                        logger.error(" Error in saveSubscribePacketInDatabase Method while adding Subscribe packet in database  {}. Error: {}", (Object)subscribedByUser.getRequest().toString(), (Object)e.getMessage());
                    }
                    finally {
                        subscribedByUser.getLock().unlock();
                    }
                }
            }
            if (!subscribeEntities.isEmpty()) {
                this.v2_SubscriptionRepository.deleteAllSubscriptionsDirect();
                this.v2_SubscriptionRepository.saveAll(subscribeEntities);
                logger.info("Saved {} subscription entities to the database.", (Object)subscribeEntities.size());
            } else {
                logger.info("No valid subscriptions to save.");
            }
        }
        catch (Exception e) {
            logger.error(" Error in processing  saveSubscribePacketInDatabase Method  Error: {}", (Object)e.getMessage());
        }
    }

    public void loadSubscribePacketFromDatabase() {
        try {
            List subscribeRepoList = this.v2_SubscriptionRepository.findAll();
            if (subscribeRepoList != null && !subscribeRepoList.isEmpty()) {
                for (V2_Subscription subscribeEntity : subscribeRepoList) {
                    if (subscribeEntity != null) {
                        String subscribePacket = subscribeEntity.getDialog();
                        this.loadUDPPacketInV2_SubscriptionService(subscribePacket);
                        continue;
                    }
                    logger.info("In loadSubscribePacketFromDatabase Method subscribeEntity is null ");
                }
            } else {
                logger.info("In loadSubscribePacketFromDatabase Method  subscribeRepository is null or empty");
            }
        }
        catch (Exception e) {
            logger.error("Error while loading SubscribePacket in loadSubscribePacketFromDatabase  {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void loadUDPPacketInV2_SubscriptionService(String subscribePackeString) {
        logger.debug(" loadUDPPacketInV2_SubscriptionService method executed - subscribePacket - {} ", (Object)subscribePackeString);
        String dummyPacketString = subscribePackeString;
        byte[] dummyPacketArray = dummyPacketString.getBytes();
        DatagramPacket dummyPacket = new DatagramPacket(dummyPacketArray, dummyPacketArray.length);
        try {
            InetAddress inetAddress = InetAddress.getByName(Constants.FORWARDING_IP_ADDRESS);
            dummyPacket.setAddress(inetAddress);
            dummyPacket.setPort(Constants.FORWARDING_PORT);
            packets.add(dummyPacket);
        }
        catch (UnknownHostException e) {
            logger.error("Error while setting InetAddress error -{}", (Object)e.getLocalizedMessage());
            e.printStackTrace();
        }
    }
}

