/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service;

import com.coraltele.condition.EnableIMSV2_SERVER;
import com.coraltele.db.telephony.main.repository.SipRegistrationRepositoryV2;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableIMSV2_SERVER.class})
public class RegistrationCleanupService
implements Runnable {
    private static final Logger logger = LogManager.getLogger(RegistrationCleanupService.class);
    @Autowired
    SipRegistrationRepositoryV2 sipRegistrationRepositoryV2;
    private volatile boolean running = true;
    private Thread cleanupThread;

    public void startThread() {
        try {
            this.cleanupThread = new Thread((Runnable)this, "RegistrationCleanupThread");
            this.cleanupThread.setDaemon(true);
            this.cleanupThread.start();
            logger.info("RegistrationCleanupService thread started");
        }
        catch (Exception e) {
            logger.error("Error in startThread method {}", (Throwable)e);
        }
    }

    public void stopThread() {
        this.running = false;
        if (this.cleanupThread != null) {
            this.cleanupThread.interrupt();
            logger.info("RegistrationCleanupService thread stopped");
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                logger.debug("Registration clean up service is running in background");
                long now = System.currentTimeMillis();
                int deleted = this.sipRegistrationRepositoryV2.deleteExpired(Long.valueOf(now));
                if (deleted > 0) {
                    logger.info("Cleaned up " + deleted + " expired registrations");
                }
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("RegistrationCleanupService thread interrupted");
            }
            catch (Exception e) {
                logger.error("Error in RegistrationCleanupService: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

