/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service;

import com.coraltele.db.telephony.main.entity.SipRegistrations;
import com.coraltele.db.telephony.main.repository.SipRegistrationRepository;
import com.coraltele.db.telephony.pbx.entity.ControlRluServer;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.InboundGateway;
import com.coraltele.db.telephony.pbx.entity.SystemConfig;
import com.coraltele.db.telephony.pbx.repository.ControlRluServerRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.InboundGatewayRepository;
import com.coraltele.db.telephony.pbx.repository.SystemConfigRepository;
import com.coraltele.ims.FeatureIMS;
import com.coraltele.ims.HelperIMS;
import com.coraltele.service.FeatureIMSService;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@DependsOn(value={"helperIMS"})
public class LoadDatabaseService {
    private static final Logger logger = LogManager.getLogger(LoadDatabaseService.class);
    private static final ZoneId systemZone = ZoneId.systemDefault();
    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss a");
    private ConcurrentHashMap<String, List<String>> extensionMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, List<Object>> rluMap = new ConcurrentHashMap();
    private Set<String> rluVirtualIpSet = ConcurrentHashMap.newKeySet();
    private ArrayList<String> inboundGatewayEnableIpList = new ArrayList();
    private Lock loadLock = new ReentrantLock();
    @Autowired
    private ExtensionsRepository extensionsRepository;
    @Autowired
    private ControlRluServerRepository controlRluServerRepository;
    @Autowired
    private InboundGatewayRepository inboundGatewayRepository;
    @Autowired(required=false)
    private SipRegistrationRepository sipRegistrationRepository;
    @Autowired
    private HelperIMS helperIMS;
    @Autowired
    private Optional<FeatureIMS> featureIMS;
    @Autowired
    private Optional<FeatureIMSService> featureIMSService;
    @Autowired(required=false)
    private SystemConfigRepository systemConfigRepository;

    public void loadDataFromDatabase() {
        block9: {
            try {
                if (this.loadLock.tryLock(2L, TimeUnit.SECONDS)) {
                    try {
                        this.getExtensionData();
                        this.getInboundGatewayIp();
                        this.getRluServer();
                        this.savetoHelperIMS();
                        if (this.featureIMS.isPresent() && this.featureIMSService.isPresent()) {
                            this.getRegistrationData();
                        }
                        this.loadSystemConfig();
                        break block9;
                    }
                    catch (Exception e) {
                        logger.error("Error while loading loadDataFromDatabase {}", (Object)e.getMessage(), (Object)e);
                        break block9;
                    }
                    finally {
                        this.loadLock.unlock();
                    }
                }
                logger.warn("Could not acquire lock for loadDataFromDatabase within 2 seconds. Skipping update.");
            }
            catch (Exception e) {
                logger.error("Thread interrupted while trying to acquire lock for savetoHelperIMS.", (Throwable)e);
            }
        }
    }

    private void savetoHelperIMS() {
        try {
            try {
                this.helperIMS.setExtensionMap(this.extensionMap);
            }
            catch (Exception e) {
                logger.error("Error while setting extension map after loading from database");
            }
            try {
                this.helperIMS.setInboundGatewayIpwithSubnet(this.inboundGatewayEnableIpList);
            }
            catch (Exception e) {
                logger.error("Error while setting InboundgatewayIP map after loading from database");
            }
            try {
                this.helperIMS.setRluMap(this.rluMap);
                this.helperIMS.setRluVirtualIpSet(this.rluVirtualIpSet);
            }
            catch (Exception e) {
                logger.error("Error while setting RLU map after loading from database");
            }
        }
        catch (Exception e) {
            logger.error("Thread interrupted while trying to acquire lock for savetoHelperIMS.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reloadDataFromDatabase() {
        if (!this.isDatabaseConnected()) {
            logger.info("Database connection is down. Skipping reload operation in reloadDataFromDatabase Method.");
            return;
        }
        ConcurrentHashMap oldExtensionMap = this.extensionMap;
        ConcurrentHashMap oldRluMap = this.rluMap;
        Set oldrluVirtualIpSet = this.rluVirtualIpSet;
        ArrayList oldInboundGatewayEnableIpList = this.inboundGatewayEnableIpList;
        try {
            this.extensionMap = new ConcurrentHashMap();
            this.rluMap = new ConcurrentHashMap();
            this.rluVirtualIpSet = ConcurrentHashMap.newKeySet();
            this.inboundGatewayEnableIpList = new ArrayList();
            this.loadDataFromDatabase();
            logger.info("Database reloaded successfully for reloadDataFromDatabase.");
        }
        catch (Exception e) {
            this.extensionMap = oldExtensionMap;
            this.rluMap = oldRluMap;
            this.rluVirtualIpSet = oldrluVirtualIpSet;
            this.inboundGatewayEnableIpList = oldInboundGatewayEnableIpList;
            this.savetoHelperIMS();
            logger.error("Error during database reload, rolling back to previous state for reloadDataFromDatabase.", (Throwable)e);
        }
        finally {
            if (this.featureIMS.isPresent() && this.featureIMSService.isPresent()) {
                ((FeatureIMSService)this.featureIMSService.get()).setSipServerProfileName();
            }
        }
    }

    private void getExtensionData() {
        List extensionsList = this.extensionsRepository.findAll();
        try {
            if (extensionsList != null) {
                for (Extension data : extensionsList) {
                    String extension;
                    if (data == null || (extension = data.getExtension()) == null || this.extensionMap.containsKey(extension)) continue;
                    ArrayList<String> extensionData = new ArrayList<String>();
                    extensionData.add(0, data.getName());
                    extensionData.add(1, String.valueOf(data.getRluCode()));
                    extensionData.add(2, LoadDatabaseService.decryptContains((String)data.getSipPassword(), (String)extension));
                    extensionData.add(3, data.getExtensionType());
                    extensionData.add(4, data.getExtensionSubtype());
                    extensionData.add(5, String.valueOf(data.getSgwUser()));
                    extensionData.add(6, data.getConnectedip());
                    extensionData.add(7, String.valueOf(data.getConnectedPort()));
                    this.extensionMap.put(extension, extensionData);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while loading Extensions {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void getRluServer() {
        List rluList = this.controlRluServerRepository.findAll();
        try {
            if (rluList != null) {
                for (ControlRluServer data : rluList) {
                    String rluCodeString;
                    if (data == null || (rluCodeString = data.getRluCode() == null || data.getRluCode().isEmpty() ? null : data.getRluCode().trim().toLowerCase()) == null || this.rluMap.containsKey(rluCodeString)) continue;
                    ArrayList<Object> rluData = new ArrayList<Object>();
                    rluData.add(0, data.getVirtualIp());
                    rluData.add(1, data.getCtrlWithCurrentServer());
                    rluData.add(2, data.getCurrentStatus());
                    rluData.add(3, data.getRluStatus());
                    this.rluMap.put(rluCodeString, rluData);
                    this.rluVirtualIpSet.add(data.getVirtualIp());
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while loading RLU {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void getRegistrationData() {
        try {
            if (this.sipRegistrationRepository == null) {
                logger.info("SipRegistration repository is not present. Skipping operations");
                return;
            }
            List registrations = this.sipRegistrationRepository.findAll();
            int loaded = 0;
            long now = System.currentTimeMillis() / 1000L;
            for (SipRegistrations entity : registrations) {
                if (entity.getExpires() == null || entity.getExpires() <= now) continue;
                String status = entity.getStatus();
                status = status.toUpperCase();
                String transport = "UDP";
                transport = status.contains("TCP") ? "TCP" : (status.contains("TLS") ? "TLS" : "UDP");
                FeatureIMSService.RegisterObject registerObject = new FeatureIMSService.RegisterObject();
                registerObject.setCallId(entity.getCallId());
                registerObject.setSipUser(entity.getSipUser());
                registerObject.setContact(entity.getContact());
                registerObject.setContactWithPath(entity.getContact());
                registerObject.setNetworkIp(entity.getNetworkIp());
                registerObject.setNetworkPort(entity.getNetworkPort());
                registerObject.setNetworkTransport(transport);
                registerObject.setExpireAtInSecondsEpoch(entity.getExpires());
                registerObject.setRegisterTimeInSecondsEpoch(Long.valueOf(entity.getPingExpires().intValue()));
                registerObject.setExpireHeaderInSeconds(Long.valueOf(registerObject.getExpireAtInSecondsEpoch() - registerObject.getRegisterTimeInSecondsEpoch()));
                registerObject.setExpireAtDateTime(Instant.ofEpochSecond(registerObject.getExpireAtInSecondsEpoch()).atZone(systemZone).toLocalDateTime().format(this.dateTimeFormatter).toString());
                registerObject.setRegisterDateTime(Instant.ofEpochSecond(registerObject.getRegisterTimeInSecondsEpoch()).atZone(systemZone).toLocalDateTime().format(this.dateTimeFormatter).toString());
                registerObject.setUserAgent(entity.getUserAgent());
                registerObject.setDomainName(entity.getSipRealm());
                registerObject.setSipServerProfileName(entity.getProfileName());
                registerObject.setSipServerDomainName(entity.getSipHost());
                String parsedContact = this.helperIMS.extractSipURIfromContact(entity.getContact());
                if (parsedContact != null) {
                    registerObject.setContact(parsedContact);
                }
                ((FeatureIMS)this.featureIMS.get()).insertOrUpdateinUserRegisterMap(entity.getSipUser(), entity.getCallId(), registerObject);
                ++loaded;
            }
            logger.info("Successfully loaded {} SIP registrations into memory.", (Object)loaded);
        }
        catch (Exception e) {
            logger.error("Failed to load SIP registrations from database", (Throwable)e);
        }
    }

    private void getInboundGatewayIp() {
        List inboundGatewayIpList = this.inboundGatewayRepository.findAll();
        try {
            if (inboundGatewayIpList != null) {
                for (InboundGateway data : inboundGatewayIpList) {
                    if (data == null || data.getGwparam() == null || !data.getIsenable().equals(Boolean.TRUE)) continue;
                    this.inboundGatewayEnableIpList.add(this.convertToCIDR(data.getGwparam()));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while loading getInboundGatewayIp {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static String decryptContains(String encryptValue, String extensionName) {
        String privatekey;
        MessageDigest sha = null;
        String rtrVal = "";
        String passwordkey = privatekey = "9221375a0cd0-5adb3f6d--f6ea-4d1e-81ed-a719175d-1e40-dd24b91a7c87-c5600ed3";
        try {
            if (encryptValue == null) {
                return null;
            }
            encryptValue = encryptValue.trim();
            byte[] key = passwordkey.getBytes("UTF-8");
            sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(2, secretKey);
            rtrVal = new String(cipher.doFinal(Base64.getDecoder().decode(encryptValue)));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("NoSuchAlgorithmexception in decryptcontains() :" + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("unsupportedexception at decryptcontains() :" + e.getMessage());
        }
        catch (Exception e) {
            logger.error("exception at decryptcontains () :" + e.getMessage() + "   ----- " + extensionName);
        }
        return rtrVal;
    }

    public String convertToCIDR(String ipAddress) {
        if (ipAddress.endsWith(".0.0.0")) {
            return ipAddress + "/8";
        }
        if (ipAddress.endsWith(".0.0")) {
            return ipAddress + "/16";
        }
        if (ipAddress.endsWith(".0")) {
            return ipAddress + "/24";
        }
        return ipAddress + "/32";
    }

    public void setSgwUserOff(String extension) {
        try {
            if (!this.isDatabaseConnected()) {
                logger.info("Database connection is down. Skipping setsgwUser OFF operation in setSgwUserOff Method.");
                return;
            }
            Optional optionalExtension = this.extensionsRepository.findByExtension(extension);
            if (optionalExtension.isPresent()) {
                Extension extensionEntity = (Extension)optionalExtension.get();
                extensionEntity.setSgwUser(Boolean.valueOf(false));
                this.extensionsRepository.save((Object)extensionEntity);
                logger.info("Set sgwUser to 'off' for extension {} in database.", (Object)extension);
            } else {
                logger.warn("Extension {} not found in database. Skipping update.", (Object)extension);
            }
        }
        catch (Exception e) {
            logger.error("Error while setting sgwuser off in database of extension {} -{} {}", (Object)extension, (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean isDatabaseConnected() {
        try {
            this.extensionsRepository.count();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void loadSystemConfig() {
        try {
            int noOfOldDaysCallBack = 1;
            if (this.systemConfigRepository == null) {
                logger.info("systemConfig repository is not present. Skipping operations");
                return;
            }
            List data = this.systemConfigRepository.findAll();
            for (SystemConfig entity : data) {
                if (entity == null) continue;
                noOfOldDaysCallBack = entity.getNoofoldday_callback();
            }
            this.helperIMS.setNoOfOldDaysCallBack(noOfOldDaysCallBack);
        }
        catch (Exception e) {
            logger.error("Error in loadSystemConfig method while fetching noOfOldDaysCallback value {}", (Object)e.getMessage());
        }
    }
}

