/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service;

import com.coraltele.condition.EnableIMSV2_SERVER;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableIMSV2_SERVER.class})
public class JWTAuthenticationService {
    private String secret;
    private static final Logger logger = LogManager.getLogger(JWTAuthenticationService.class);

    @Value(value="${jwt.secret}")
    public void setSecret(String secret) {
        this.secret = secret + "-3be8dd5f-c66b-4b3c-88f5-b2d36c9238dd";
        this.secret = Base64.getEncoder().encodeToString(this.secret.getBytes());
    }

    public boolean validateToken(String authToken) {
        try {
            Jws claims = Jwts.parser().setSigningKey(this.secret).parseClaimsJws(authToken);
            return true;
        }
        catch (MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException ex) {
            throw new BadCredentialsException("INVALID_CREDENTIALS", ex);
        }
        catch (ExpiredJwtException ex) {
            throw ex;
        }
    }

    public boolean isValid(String headerValue) {
        try {
            if (!headerValue.isEmpty()) {
                if (headerValue.startsWith("Bearer")) {
                    headerValue = headerValue.replace("Bearer", "").trim();
                    logger.info("going token for Validation: {}", (Object)headerValue);
                    return this.validateToken(headerValue);
                }
                logger.error("Invalid authorization header format. Expected Bearer token, received: {}", (Object)headerValue);
            } else {
                logger.error("Error in isValid method while processing authorization header: {}", (Object)headerValue);
            }
        }
        catch (Exception e) {
            logger.error("Error in isValid method while processing authorization header: {}. Error: {}", (Object)headerValue, (Object)e.getMessage());
        }
        return false;
    }

    public boolean isValidToken(String headerValue) {
        try {
            if (!headerValue.isEmpty()) {
                if (headerValue.startsWith("Bearer-Token:")) {
                    headerValue = headerValue.replace("Bearer-Token:", "").trim();
                    logger.info("going token for Validation: {}", (Object)headerValue);
                    return this.validateToken(headerValue);
                }
                logger.error("Invalid authorization header format. Expected Bearer token, received: {}", (Object)headerValue);
            } else {
                logger.error("Error in isValid method while processing authorization header: {}", (Object)headerValue);
            }
        }
        catch (Exception e) {
            logger.error("Error in isValid method while processing authorization header: {}. Error: {}", (Object)headerValue, (Object)e.getMessage());
        }
        return false;
    }
}

