/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service;

import com.coraltele.condition.EnableIMSV2_SERVER;
import com.coraltele.condition.EnableRedisPubSub;
import com.coraltele.db.telephony.main.entity.SipRegistrations_v2;
import com.coraltele.db.telephony.main.repository.SipRegistrationRepositoryV2;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.ims.FeatureIMSStateMachine;
import com.coraltele.ims.HelperIMS;
import com.coraltele.ims.ImsV2ServerIMS;
import com.coraltele.ims.ImsV2Subscriptions;
import com.coraltele.model.RegisterUser;
import com.coraltele.model.SubscriberUser;
import com.coraltele.service.IMSV2ServerService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Conditional(value={EnableRedisPubSub.class, EnableIMSV2_SERVER.class})
public class IMSV2ServerService {
    String className = "IMSV2ServerService";
    private static final String CALLBACKMAPKEY = "v2CallbackMap";
    private static final String CALLBACKWITHTIMEKEY = "v2CallbackWithTimeMap";
    private static final Logger logger = LogManager.getLogger(IMSV2ServerService.class);
    @Autowired(required=false)
    private Optional<FeatureIMSStateMachine> featureIMSStateMachine;
    @Autowired
    private ImsV2ServerIMS imsV2ServerIMS;
    @Autowired
    private Optional<ImsV2Subscriptions> imsV2Subscriptions;
    @Autowired
    private RedisTemplate<String, String> dbRedisTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private HelperIMS helperIMS;
    @Autowired
    @Qualifier(value="localRedisTemplate")
    private Optional<RedisTemplate<String, Object>> redisTemplate;
    @Autowired
    SipRegistrationRepositoryV2 sipRegistrationRepositoryV2;
    @Autowired
    private ExtensionsRepository extensionsRepository;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final String REGISTERCHANNEL = "imsv2register";
    private static final String DEREGISTERCHANNEL = "imsv2deregister";
    public static List<DatagramPacket> UDPSubscriptionPackets = new ArrayList();
    public static List<DatagramPacket> TCPSubscriptionPackets = new ArrayList();
    public static List<DatagramPacket> TLSSubscriptionPackets = new ArrayList();
    private static final String REGISTERATIONKEY = "registerMap";

    public void setSgwUserOff(String extension, int expireTime) {
        String functionName = "setSqwUserOff";
        try {
            if (!this.isDatabaseConnected2()) {
                this.helperIMS.printCustomLogs(this.className, functionName, "warn", extension, extension, "Database connection is down. Skipping setsgwUser OFF operation for extension: " + extension);
                return;
            }
            if (expireTime <= 0) {
                this.helperIMS.printCustomLogs(this.className, functionName, "info", extension, extension, "Due to expireTime is 0 .Skipping setsgwUser OFF operation for extension: " + extension);
                return;
            }
            Optional optionalExtension = this.extensionsRepository.findByExtension(extension);
            if (optionalExtension.isPresent()) {
                Extension extensionEntity = (Extension)optionalExtension.get();
                extensionEntity.setSgwUser(Boolean.valueOf(false));
                this.extensionsRepository.save((Object)extensionEntity);
                this.helperIMS.printCustomLogs(this.className, functionName, "info", extension, extension, "Set SgwUser column to false for extension: " + extension + " in database");
            } else {
                this.helperIMS.printCustomLogs(this.className, functionName, "warn", extension, extension, "Extension:" + extension + " not found in table. Skipping setsgwUser OFF operation.");
            }
        }
        catch (Exception e) {
            logger.error("Error while setting sgwuser off in database of extension {} -{} {}", (Object)extension, (Object)e.getMessage(), (Object)e);
        }
    }

    public void startRedisScheduler() {
        try {
            if (Constants.REGISTRATION_SAVE_TIMER_IN_MINUTES > 0) {
                this.scheduler.scheduleAtFixedRate(() -> {
                    try {
                        this.storeRegisterMap();
                        this.saveSubscribePacketInRedis();
                        this.saveCallbackOnRedis();
                    }
                    catch (Exception e) {
                        logger.error("Error during store check in startRedisScheduler method: {}", (Object)e.getMessage(), (Object)e);
                    }
                }, Constants.REGISTRATION_SAVE_TIMER_IN_MINUTES.intValue(), Constants.REGISTRATION_SAVE_TIMER_IN_MINUTES.intValue(), TimeUnit.MINUTES);
            } else {
                logger.info("Scheduler will not start because REGISTRATION_SAVE_TIMER_IN_MINUTES is set to 0.");
            }
        }
        catch (Exception e) {
            logger.error("Error in startRedisScheduler method {}", (Throwable)e);
        }
    }

    public void stopScheduledRegistrationAndSubscriptionSave() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(30L, TimeUnit.SECONDS)) {
                logger.warn("Forcing stopScheduledRegistrationSave shutdown...");
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            logger.error("Error in  stopScheduledRegistrationAndSubscriptionSave method: {}", (Object)e.getMessage(), (Object)e);
            this.scheduler.shutdownNow();
        }
        finally {
            this.storeRegisterMap();
            this.saveSubscribePacketInRedis();
            this.saveCallbackOnRedis();
            logger.info("Scheduler stopped and registerMap & subscription saved before shutdown.");
        }
    }

    private void saveCallbackOnRedis() {
        String functionName = "saveCallbackOnRedis";
        if (!(this.featureIMSStateMachine.isPresent() && Constants.IMS_MODE.equals("IMSV2-SERVER") && Constants.IMSV2_ROUTETO_SIPSERVER.booleanValue())) {
            return;
        }
        if (!this.isRedisConnectionUp()) {
            logger.info("RedisConnection is down for saveCallbackOnRedis. Skipping save operation");
            return;
        }
        try {
            ConcurrentHashMap callbackMap = ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).mergeAllCallbackMaps();
            ConcurrentHashMap callbackWithTimeMap = ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getCallBackMap();
            ((RedisTemplate)this.redisTemplate.get()).delete((Object)CALLBACKMAPKEY);
            ((RedisTemplate)this.redisTemplate.get()).opsForValue().set((Object)CALLBACKMAPKEY, (Object)callbackMap);
            ((RedisTemplate)this.redisTemplate.get()).delete((Object)CALLBACKWITHTIMEKEY);
            ((RedisTemplate)this.redisTemplate.get()).opsForValue().set((Object)CALLBACKWITHTIMEKEY, (Object)callbackWithTimeMap);
            this.helperIMS.printCustomLogs(this.className, functionName, "info", null, null, "Saved callbackMap (" + callbackMap.size() + " entries) to Redis Database");
        }
        catch (Exception e) {
            logger.error("Error in saveCallbackOnRedis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void loadCallbackFromRedis() {
        if (!this.featureIMSStateMachine.isPresent()) {
            return;
        }
        if (!this.isRedisConnectionUp()) {
            logger.warn("Redis connection down. Skipping callback load.");
            return;
        }
        try {
            Object result = ((RedisTemplate)this.redisTemplate.get()).opsForValue().get((Object)CALLBACKMAPKEY);
            Object callbackWithTime = ((RedisTemplate)this.redisTemplate.get()).opsForValue().get((Object)CALLBACKWITHTIMEKEY);
            if (result != null && result instanceof Map) {
                ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getBackwardcallbackMap().putAll((Map)result);
                logger.info("loaded callback entries from Redis into StateMachine");
            } else {
                logger.warn("No callback found in Redis.");
            }
            if (callbackWithTime != null && callbackWithTime instanceof Map) {
                ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getCallBackMap().putAll((Map)callbackWithTime);
                logger.info("loaded callbackWithTime entries from Redis into featureIMSStateMachine");
            } else {
                logger.warn("No callbackWithTime found in Redis.");
            }
        }
        catch (Exception e) {
            logger.error("Error loading callback and callbackWithTime from Redis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void storeRegisterMap() {
        String functionName = "storeRegisterMap";
        if (!this.isRedisConnectionUp()) {
            return;
        }
        try {
            if (this.imsV2ServerIMS.registerMap.isEmpty()) {
                logger.info("No registrations available in Map to save in Redis.Skipping save operation");
                return;
            }
            ((RedisTemplate)this.redisTemplate.get()).delete((Object)REGISTERATIONKEY);
            ((RedisTemplate)this.redisTemplate.get()).opsForValue().set((Object)REGISTERATIONKEY, (Object)this.imsV2ServerIMS.registerMap);
            this.helperIMS.printCustomLogs(this.className, functionName, "info", null, null, "Saved RegisterMap to Redis Database");
        }
        catch (Exception e) {
            logger.error("Error loading in storeRegisterMap from Redis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void loadRegisterMap() throws JsonProcessingException {
        if (!this.isRedisConnectionUp()) {
            return;
        }
        try {
            Object result = ((RedisTemplate)this.redisTemplate.get()).opsForValue().get((Object)REGISTERATIONKEY);
            if (result != null && result instanceof Map) {
                this.imsV2ServerIMS.registerMap.putAll((Map)result);
                logger.info("Loaded {} registrations from Redis.Stored in RegisterMap", (Object)this.imsV2ServerIMS.registerMap.size());
            } else {
                logger.warn("No registerMap found in Redis.");
            }
        }
        catch (Exception e) {
            logger.error("Error loading registerMap from Redis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void loadSubscribePacketFromRedis() {
        try {
            if (!this.imsV2Subscriptions.isPresent()) {
                return;
            }
            if (!this.isRedisConnectionUp()) {
                return;
            }
            String jsonSubscriptions = (String)this.dbRedisTemplate.opsForValue().get((Object)"subscriptions");
            if (jsonSubscriptions == null) {
                logger.info("No subscription data found in Redis.");
                return;
            }
            Map redisMap = (Map)this.objectMapper.readValue(jsonSubscriptions, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (redisMap == null || redisMap.isEmpty()) {
                logger.info("No subscriptions found in Redis.");
                return;
            }
            ConcurrentHashMap filteredMap = new ConcurrentHashMap();
            long currentTime = System.currentTimeMillis();
            int count = 0;
            for (Map.Entry entry : redisMap.entrySet()) {
                List users = (List)entry.getValue();
                if (users == null || users.isEmpty()) continue;
                ArrayList<SubscriberUser> validUdpUsers = new ArrayList<SubscriberUser>();
                for (SubscriberUser subscribeEntity : users) {
                    if (subscribeEntity == null) continue;
                    boolean notExpired = subscribeEntity.getExpirationTime() > currentTime;
                    boolean isUdp = "UDP".equalsIgnoreCase(subscribeEntity.getTransport());
                    if (!notExpired || !isUdp) continue;
                    validUdpUsers.add(subscribeEntity);
                    this.loadUDPSubscribePacket(subscribeEntity.getRequest(), subscribeEntity.getHostAddress(), subscribeEntity.getHostPort());
                    ++count;
                }
                if (validUdpUsers.isEmpty()) continue;
                filteredMap.put((String)entry.getKey(), validUdpUsers);
            }
            ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).subscriptionsMap.clear();
            ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).subscriptionsMap.putAll(filteredMap);
            logger.info("Loaded {} active subscriptions from Redis.", (Object)count);
        }
        catch (JsonProcessingException e) {
            logger.error("Error while parsing subscriptions from Redis: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Error in loadSubscribePacketFromRedis Method: {}", (Object)e.getMessage());
        }
    }

    public void loadUDPSubscribePacket(String subscribePacketString, String hostIp, int hostPort) {
        String dummyPacketString = subscribePacketString;
        byte[] dummyPacketArray = dummyPacketString.getBytes();
        DatagramPacket dummyPacket = new DatagramPacket(dummyPacketArray, dummyPacketArray.length);
        try {
            InetAddress inetAddress = InetAddress.getByName(hostIp);
            dummyPacket.setAddress(inetAddress);
            dummyPacket.setPort(hostPort);
            UDPSubscriptionPackets.add(dummyPacket);
        }
        catch (Exception e) {
            logger.error("Error while setting InetAddress error -{}", (Object)e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSubscribePacketInRedis() {
        try {
            if (!this.imsV2Subscriptions.isPresent()) {
                return;
            }
            Map serviceSubscriptions = ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).getSubscriptions();
            if (serviceSubscriptions == null || serviceSubscriptions.isEmpty()) {
                logger.info("No subscriptions found. Skipping save operation to Redis.");
                return;
            }
            HashMap filteredSubscriptions = new HashMap();
            ArrayList<SubscriberUser> expiredSubscriptions = new ArrayList<SubscriberUser>();
            for (Map.Entry entry : serviceSubscriptions.entrySet()) {
                List users = (List)entry.getValue();
                if (users == null || users.isEmpty()) continue;
                ArrayList<SubscriberUser> validUsersForService = new ArrayList<SubscriberUser>();
                for (SubscriberUser subscribedByUser : users) {
                    if (!subscribedByUser.getLock().tryLock(2L, TimeUnit.SECONDS)) continue;
                    try {
                        if (subscribedByUser.getExpirationTime() > System.currentTimeMillis()) {
                            validUsersForService.add(subscribedByUser);
                            continue;
                        }
                        expiredSubscriptions.add(subscribedByUser);
                    }
                    catch (Exception e) {
                        logger.error("Error while processing subscription: {}. Error: {}", (Object)subscribedByUser.getRequest(), (Object)e.getMessage());
                    }
                    finally {
                        subscribedByUser.getLock().unlock();
                    }
                }
                if (validUsersForService.isEmpty()) continue;
                filteredSubscriptions.put((String)entry.getKey(), validUsersForService);
            }
            String jsonSubscriptions = this.objectMapper.writeValueAsString(filteredSubscriptions);
            this.dbRedisTemplate.delete((Object)"subscriptions");
            this.dbRedisTemplate.opsForValue().set((Object)"subscriptions", (Object)jsonSubscriptions);
            logger.info("Saved subscription entities to Redis Database");
            for (SubscriberUser expiredSub : expiredSubscriptions) {
                ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).removeV2Subscription(expiredSub.getSubscribedTo(), expiredSub.getSubscriber(), expiredSub.getCallId());
            }
        }
        catch (JsonProcessingException e) {
            logger.error("Error converting subscriptions to JSON: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            logger.error("Error in processing saveSubscribePacketInRedis Method: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void publishRegisterationEventonRedis(String extension, String IpAddress, int port, int expireTime) {
        String functionName = "publishRegisterationEventonRedis";
        if (!this.isRedisConnectionUp()) {
            return;
        }
        try {
            RegisterUserEvent event = new RegisterUserEvent(extension, IpAddress, port, expireTime);
            String channel = expireTime > 0 ? REGISTERCHANNEL : DEREGISTERCHANNEL;
            ((RedisTemplate)this.redisTemplate.get()).convertAndSend(channel, (Object)event);
            this.helperIMS.printCustomLogs(this.className, functionName, "info", extension, extension, "Extension: " + extension + " published on redis channel : " + channel + " data  : " + event);
        }
        catch (Exception e) {
            logger.error("Error in publishRegisterationEventonRedis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public ConcurrentHashMap<String, RegisterUser> showRegistrationData() {
        try {
            if (this.imsV2ServerIMS.registerMap == null || this.imsV2ServerIMS.registerMap.isEmpty()) {
                return null;
            }
            return this.imsV2ServerIMS.registerMap;
        }
        catch (Exception e) {
            logger.error("Error while fetching registration data", (Throwable)e);
            return null;
        }
    }

    private boolean isRedisConnectionUp() {
        try {
            if (!this.redisTemplate.isPresent()) {
                return false;
            }
            RedisTemplate template = (RedisTemplate)this.redisTemplate.get();
            RedisConnectionFactory connectionFactory = template.getConnectionFactory();
            return connectionFactory != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void releaseblf(String callId) {
        this.imsV2ServerIMS.releaseblf(callId);
    }

    public Map<String, List<SubscriberUser>> getSubscriptionMapData(String search) {
        LinkedHashMap<String, List<SubscriberUser>> resultMap = new LinkedHashMap<String, List<SubscriberUser>>();
        ConcurrentHashMap subMap = ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).subscriptionsMap;
        long currentEpoch = System.currentTimeMillis() / 1000L;
        for (Map.Entry entry : subMap.entrySet()) {
            List validSubscribers;
            String extension = (String)entry.getKey();
            if (search != null && !extension.contains(search) || (validSubscribers = ((List)entry.getValue()).stream().filter(sub -> sub.getExpires() > currentEpoch).collect(Collectors.toList())).isEmpty()) continue;
            resultMap.put(extension, validSubscribers);
        }
        return resultMap;
    }

    public List<Object> getPhoneExtensionData(String search) {
        LinkedHashMap<String, PhoneExtensionDTO> phonesMap = new LinkedHashMap<String, PhoneExtensionDTO>();
        ConcurrentHashMap phoneExtensionMap = this.helperIMS.getExtensionMap();
        ConcurrentHashMap phoneRegisterMap = this.imsV2ServerIMS.registerMap;
        int registered = 0;
        int unregistered = 0;
        for (Map.Entry entry : phoneExtensionMap.entrySet()) {
            List data;
            String extension = (String)entry.getKey();
            if (search != null && !extension.contains(search) || (data = (List)entry.getValue()).size() <= 3 || !"phone".equalsIgnoreCase((String)data.get(3))) continue;
            PhoneExtensionDTO dto = new PhoneExtensionDTO(this);
            dto.setExtension(extension);
            RegisterUser user = (RegisterUser)phoneRegisterMap.get(extension);
            if (user != null) {
                dto.setRemoteIpAddress(user.getRemoteIpAddress());
                dto.setExpireToken(user.getExpireToken());
                dto.setLastRegisterTime(user.getLastRegistrationTime());
                dto.setExpiresAt(user.getExpiresAt());
                dto.setRegisterIp(user.getRegisterDomain());
                dto.setRegisterTransport(user.getListeningTransport());
                String status = user.getExpireToken() == 0 || System.currentTimeMillis() >= user.getExpireTime() ? "unregistered" : "registered";
                dto.setStatus(status);
                if ("registered".equals(status)) {
                    ++registered;
                } else {
                    ++unregistered;
                }
            } else {
                dto.setStatus("unregistered");
                ++unregistered;
            }
            phonesMap.put(extension, dto);
        }
        LinkedHashMap<String, Integer> summary = new LinkedHashMap<String, Integer>();
        summary.put("totalPhones", phonesMap.size());
        summary.put("registeredPhones", registered);
        summary.put("unregisteredPhones", unregistered);
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(summary);
        result.add(phonesMap);
        return result;
    }

    private boolean isDatabaseConnected() {
        try {
            this.sipRegistrationRepositoryV2.count();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isDatabaseConnected2() {
        try {
            this.extensionsRepository.count();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Transactional(transactionManager="switchTransactionManager")
    public void saveRegisterationsInDatabase(RegisterUser userObj, String user, String userAgent) {
        String functionName = "saveRegisterationsInDatabase";
        try {
            if (!this.isDatabaseConnected()) {
                this.helperIMS.printCustomLogs(this.className, functionName, "warn", user, user, "Database connection is down. Skipping DB operation for user: " + user);
                return;
            }
            if (userObj == null) {
                this.helperIMS.printCustomLogs(this.className, functionName, "warn", user, user, "RegisterUser Object is null. Skipping DB operation for user: " + user);
                return;
            }
            String callId = userObj.getCallId();
            if (userObj.getExpireToken() == 0) {
                if (this.sipRegistrationRepositoryV2.existsById((Object)callId)) {
                    this.sipRegistrationRepositoryV2.deleteById((Object)callId);
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", user, user, "Due to expireTime is 0. Removed Entry from DB for user: " + user + " and callId: " + callId);
                } else {
                    int deleted = this.sipRegistrationRepositoryV2.deleteBySipUserAndContact(user, userObj.getContact());
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", user, user, "Due to expireTime is 0. Removed Entry from DB for user: " + user + " and contact: " + userObj.getContact());
                }
                return;
            }
            if (this.sipRegistrationRepositoryV2.existsById((Object)callId)) {
                this.sipRegistrationRepositoryV2.deleteById((Object)callId);
                this.helperIMS.printCustomLogs(this.className, functionName, "info", user, user, "Removed existing entry from DB for user: " + user + " and callId: " + callId + " before inserting new entry");
            } else {
                int deleted = this.sipRegistrationRepositoryV2.deleteBySipUser(user);
                if (deleted > 0) {
                    this.helperIMS.printCustomLogs(this.className, functionName, "info", user, user, "Removed duplicate entry from DB for user: " + user + " and callId: " + callId + " before inserting new entry");
                }
            }
            SipRegistrations_v2 entity = new SipRegistrations_v2();
            entity.setCallId(callId);
            entity.setSipUser(user);
            entity.setSipHost(userObj.getRegisterDomain());
            entity.setPresenceHosts(userObj.getRegisterDomain());
            entity.setContact(userObj.getContact());
            entity.setStatus("Registered(" + userObj.getListeningTransport() + ")");
            entity.setPingExpires(Integer.valueOf((int)(System.currentTimeMillis() / 1000L)));
            entity.setPingStatus("Reachable");
            entity.setExpires(userObj.getExpireTime());
            entity.setServerUser(user);
            entity.setNetworkIp(userObj.getRemoteIpAddress());
            entity.setNetworkPort(String.valueOf(userObj.getRemotePort()));
            entity.setSipUsername(user);
            entity.setSipRealm(Constants.LISTEN_IP_ADDRESS);
            entity.setMwiUser(user);
            entity.setMwiHost(userObj.getRegisterDomain());
            entity.setOrigServerHost(Constants.LISTEN_IP_ADDRESS);
            entity.setOrigHostname("sipserver");
            entity.setUserAgent(userAgent != null ? userAgent : "");
            entity.setSubHost(userObj.getRegisterDomain());
            this.sipRegistrationRepositoryV2.save((Object)entity);
            this.helperIMS.printCustomLogs(this.className, functionName, "info", user, user, "Inserted new entry to DB for user: " + user + " and callId: " + callId + " successfully");
        }
        catch (Exception e) {
            logger.error("Error while saving/deleting registration for {}: {}", (Object)user, (Object)e.getMessage(), (Object)e);
        }
    }

    public Map<String, List<SubscriberUser>> getSubsMap() {
        return ((ImsV2Subscriptions)this.imsV2Subscriptions.get()).getSubscriptions();
    }
}

