/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class HealthService {
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private final java.lang.management.OperatingSystemMXBean osMx = ManagementFactory.getOperatingSystemMXBean();
    @Autowired(required=false)
    private JdbcTemplate jdbcTemplate;
    @Autowired(required=false)
    private RedisConnectionFactory redisConnectionFactory;
    @Autowired(required=false)
    private TaskExecutor taskExecutor;

    public Map<String, Object> fullHealthSnapshot() {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        out.put("timestamp", Instant.now().toString());
        out.put("threads", this.threadHealth());
        out.put("memory", this.memoryHealth());
        out.put("cpu_and_os", this.osAndProcess());
        out.put("db", this.dbHealth());
        out.put("redis", this.redisHealth());
        out.put("executor", this.executorHealth());
        return out;
    }

    public Map<String, Object> threadHealth() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("threadCount", this.threadMXBean.getThreadCount());
        m.put("peakThreadCount", this.threadMXBean.getPeakThreadCount());
        m.put("totalStartedThreadCount", this.threadMXBean.getTotalStartedThreadCount());
        m.put("daemonThreadCount", this.threadMXBean.getDaemonThreadCount());
        long[] deadlocked = this.threadMXBean.findDeadlockedThreads();
        long[] monitorDeadlocked = this.threadMXBean.findMonitorDeadlockedThreads();
        HashSet problematic = new HashSet();
        if (deadlocked != null) {
            problematic.addAll(Arrays.stream(deadlocked).boxed().collect(Collectors.toList()));
        }
        if (monitorDeadlocked != null) {
            problematic.addAll(Arrays.stream(monitorDeadlocked).boxed().collect(Collectors.toList()));
        }
        m.put("deadlockedThreadCount", problematic.size());
        if (!problematic.isEmpty()) {
            ThreadInfo[] infos;
            LinkedHashMap blockedDetails = new LinkedHashMap();
            for (ThreadInfo ti : infos = this.threadMXBean.getThreadInfo(problematic.stream().mapToLong(Long::longValue).toArray(), 100)) {
                if (ti == null) continue;
                LinkedHashMap<String, Object> trace = new LinkedHashMap<String, Object>();
                trace.put("name", ti.getThreadName());
                trace.put("state", ti.getThreadState().toString());
                trace.put("lockInfo", ti.getLockInfo() == null ? "none" : ti.getLockInfo().toString());
                trace.put("blockedCount", ti.getBlockedCount());
                trace.put("blockedTimeMs", ti.getBlockedTime());
                trace.put("waitedCount", ti.getWaitedCount());
                trace.put("waitedTimeMs", ti.getWaitedTime());
                List stack = Arrays.stream(ti.getStackTrace()).map(StackTraceElement::toString).limit(20L).collect(Collectors.toList());
                trace.put("stack", stack);
                blockedDetails.put(ti.getThreadName(), trace);
            }
            m.put("blockedThreads", blockedDetails);
        }
        Map<Thread.State, Long> counts = Arrays.stream(this.threadMXBean.dumpAllThreads(false, false)).map(ThreadInfo::getThreadState).collect(Collectors.groupingBy(s -> s, Collectors.counting()));
        m.put("stateCounts", counts);
        return m;
    }

    public Map<String, Object> memoryHealth() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        MemoryUsage heap = this.memoryMXBean.getHeapMemoryUsage();
        m.put("heapUsed", heap.getUsed());
        m.put("heapCommitted", heap.getCommitted());
        m.put("heapMax", heap.getMax());
        return m;
    }

    public Map<String, Object> osAndProcess() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("osName", this.osMx.getName());
        m.put("osArch", this.osMx.getArch());
        m.put("availableProcessors", this.osMx.getAvailableProcessors());
        m.put("systemLoadAverage", this.osMx.getSystemLoadAverage());
        if (this.osMx instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sun = (OperatingSystemMXBean)this.osMx;
            m.put("systemCpuLoad", sun.getSystemCpuLoad());
            m.put("processCpuLoad", sun.getProcessCpuLoad());
        }
        return m;
    }

    public Map<String, Object> dbHealth() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        if (this.jdbcTemplate == null) {
            m.put("db", "not-configured");
            return m;
        }
        try {
            Integer one = (Integer)this.jdbcTemplate.queryForObject("SELECT 1", Integer.class);
            m.put("jdbcTestQuery", Objects.equals(one, 1) ? "ok" : "unexpected:" + one);
        }
        catch (Throwable t) {
            m.put("dbError", t.getMessage());
        }
        return m;
    }

    public Map<String, Object> redisHealth() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        if (this.redisConnectionFactory == null) {
            m.put("redis", "not-configured");
            return m;
        }
        try (RedisConnection conn = this.redisConnectionFactory.getConnection();){
            m.put("ping", conn.ping());
        }
        catch (Throwable t) {
            m.put("redisError", t.toString());
        }
        return m;
    }

    public Map<String, Object> executorHealth() {
        ThreadPoolExecutor exec;
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        if (this.taskExecutor == null) {
            m.put("taskExecutor", "not-configured");
            return m;
        }
        m.put("taskExecutorClass", this.taskExecutor.getClass().getName());
        if (this.taskExecutor instanceof ThreadPoolTaskExecutor && (exec = ((ThreadPoolTaskExecutor)this.taskExecutor).getThreadPoolExecutor()) != null) {
            m.put("activeCount", exec.getActiveCount());
            m.put("queueSize", exec.getQueue().size());
        }
        return m;
    }
}

