/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service;

import com.coraltele.helper.Constants;
import com.coraltele.ims.HelperIMS;
import com.coraltele.interfaces.sip.Dialog;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.service.LoadDatabaseService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class GeneralApiService {
    private static final Logger logger = LogManager.getLogger(GeneralApiService.class);
    @Autowired
    private LoadDatabaseService loadDatabaseService;
    @Autowired
    private HelperIMS helperIMS;

    public String reloadDatabase() {
        try {
            this.loadDatabaseService.reloadDataFromDatabase();
            return Constants.USER_AGENT + " ==> reload Database successfully.\n";
        }
        catch (Exception e) {
            logger.error("Error occured while reloading v2 database");
            return Constants.USER_AGENT + " ==> reload Database is Unsuccessfull.\n";
        }
    }

    public String setRootLogLevel(String level) {
        try {
            Level newLevel = Level.toLevel((String)level.toUpperCase());
            Configurator.setRootLevel((Level)newLevel);
            return "Successfully Set log level of Root level to " + newLevel + "\n";
        }
        catch (Exception e) {
            return "Failed to set log level: " + e.getMessage() + "\n";
        }
    }

    public ResponseEntity<?> viewAllLogFilter() {
        try {
            logger.info("Received in viewAllLogFilter");
            HashSet logFilterUserSet = this.helperIMS.getLogFilterUserSet();
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("All Log Filter user is shown below -:" + System.lineSeparator() + logFilterUserSet));
        }
        catch (Exception e) {
            logger.error("Error in removeAllLogFilter");
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"Cannot view All Log Filtered User");
        }
    }

    public ResponseEntity<?> setLogFilterForUser(String user) {
        try {
            logger.info("Received in setLogFilterForUser {}", (Object)user);
            if (user.equalsIgnoreCase("{user}")) {
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("Cannot set Log Filter for this user " + user));
            }
            HashSet logFilterUserSet = this.helperIMS.setLogFilterForUser(user);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("Log Filter set successfully for user " + user + System.lineSeparator() + logFilterUserSet));
        }
        catch (Exception e) {
            logger.error("Error in setLogFilterForUser {}", (Object)user);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("Cannot set Log Filter for this user " + user));
        }
    }

    public ResponseEntity<?> removeLogFilter(String user, boolean isRemoveAll) {
        try {
            if (isRemoveAll) {
                logger.info("Received in removeLogFilter for all users");
                HashSet logFilterUserSet = this.helperIMS.removeLogFilterForUser(null, true);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("Removed All users from Log Filter" + System.lineSeparator() + logFilterUserSet));
            }
            logger.info("Received in removeLogFilter for user: {}", (Object)user);
            HashSet logFilterUserSet = this.helperIMS.removeLogFilterForUser(user, false);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("Removed Log Filter for user " + user + System.lineSeparator() + logFilterUserSet));
        }
        catch (Exception e) {
            logger.error("Error in removeAllLogFilter {} ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("Cannot remove from Log Filter for user: " + user + " isRemoveAll: " + isRemoveAll));
        }
    }

    public ResponseEntity<?> viewAllValidUserAgent() {
        try {
            logger.info("Received in viewAllValidUserAgent");
            HashSet validUserAgentSet = this.helperIMS.getValidUserAgentSet();
            if (validUserAgentSet.isEmpty() || validUserAgentSet.size() == 2) {
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)"No userAgent is set to show");
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("All valid UserAgents are shown below -:" + System.lineSeparator() + validUserAgentSet));
        }
        catch (Exception e) {
            logger.error("Error in viewAllValidUserAgent {}", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"Cannot view All valid UserAgents");
        }
    }

    public ResponseEntity<?> viewAllBlockedUserAgent() {
        try {
            logger.info("Received in viewAllBlockedUserAgent");
            HashSet blockedUserAgentSet = this.helperIMS.getBlockedUserAgentSet();
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("All Blocked UserAgents is shown below -:" + System.lineSeparator() + blockedUserAgentSet));
        }
        catch (Exception e) {
            logger.error("Error in viewAllBlockedUserAgent {}", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"Cannot view All blocked UserAgents");
        }
    }

    public ResponseEntity<?> addBlockUserAgentForUser(String user) {
        try {
            logger.info("Received in addBlockUserAgentForUser {}", (Object)user);
            if (user.equalsIgnoreCase("{user}")) {
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("Cannot block UserAgent for this user " + user));
            }
            HashSet blockedUserAgentSet = this.helperIMS.addBlockUserAgentForUser(user);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("Successfully blocked UserAgent " + user + System.lineSeparator() + blockedUserAgentSet));
        }
        catch (Exception e) {
            logger.error("Error in addBlockUserAgentForUser {}", (Object)user);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("Cannot block UserAgent for this user " + user));
        }
    }

    public ResponseEntity<?> removeBlockUserAgent(String user, boolean isRemoveAll) {
        try {
            if (isRemoveAll) {
                logger.info("Received in removeBlockUserAgent for all users");
                HashSet blockedUserAgentSet = this.helperIMS.removeBlockUserAgentForUser(null, true);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("Removed All Blocked UserAgents" + System.lineSeparator() + blockedUserAgentSet));
            }
            logger.info("Received in removeBlockUserAgentForUser {}", (Object)user);
            HashSet blockedUserAgentSet = this.helperIMS.removeBlockUserAgentForUser(user, false);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)("Removed from BlockUserAgent for user " + user + System.lineSeparator() + blockedUserAgentSet));
        }
        catch (Exception e) {
            logger.error("Error in removeAllBlockUserAgent {}", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("Cannot remove Blocked User: " + user + " isRemoveAll: " + isRemoveAll));
        }
    }

    public ResponseEntity<?> showDialogs() {
        try {
            Collection dialogCollection;
            SipStackImpl sipStackImpl = (SipStackImpl)this.helperIMS.getSipStack();
            Collection collection = dialogCollection = sipStackImpl != null ? sipStackImpl.getDialogs() : null;
            if (dialogCollection == null || dialogCollection.isEmpty()) {
                logger.info("No active dialogs found for showDialogs API.");
                return ResponseEntity.ok(Collections.emptyList());
            }
            ArrayList<String> dialogIds = new ArrayList<String>();
            for (Dialog dialog : dialogCollection) {
                if (dialog.getDialogId() != null) {
                    dialogIds.add(dialog.getDialogId());
                    continue;
                }
                dialogIds.add(dialog.getCallId().getCallId());
            }
            return ResponseEntity.ok(dialogIds);
        }
        catch (Exception e) {
            logger.error("Error while fetching dialogs: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Failed to fetch dialogs.");
        }
    }

    public ResponseEntity<Map<String, Object>> getAPIlist() {
        try {
            String mode = Constants.IMS_MODE.equals("IMSV2-SERVER") ? "IMSV2-SERVER" : (Constants.IMS_MODE.equals("IMSV2-SBC") ? "IMSV2-SBC" : (Constants.IMS_MODE.equals("SUBSCRIBER-SERVER") ? "SUBSCRIBER-SERVER" : "FEATUREIMS-SERVER"));
            LinkedHashMap<String, String> generalApis = new LinkedHashMap<String, String>();
            generalApis.put("Post api to reload database", "/app/v2/reloadDatabase");
            generalApis.put("Get api for configurations view", "/imsv2/configuration");
            generalApis.put("Get api for IMSV2 health", "/imsv2/health");
            generalApis.put("Get api for SIP dialogs view", "/imsv2/showDialogs");
            generalApis.put("Get api for showextension", "/imsv2/showExtension/{extension}");
            generalApis.put("Get api for valid user agents", "/imsv2/viewValidUserAgent");
            generalApis.put("Get api for block User agent by user", "/imsv2/blockUserAgent/{user}");
            generalApis.put("Get api for view blocked user agents", "/imsv2/viewBlockedUserAgent");
            generalApis.put("Get api for remove all blocked user agents", "/imsv2/removeBlockUserAgent");
            generalApis.put("Get api for remove blocked user agent", "/imsv2/removeBlockUserAgent/{user}");
            generalApis.put("Post api to set log level", "/imsv2/loglevel");
            generalApis.put("Get api for view log filters", "/imsv2/viewLogFilter");
            generalApis.put("Get api for set log filter for user", "/imsv2/setLogFilter/{user}");
            generalApis.put("Get api for remove all log filters", "/imsv2/removeLogFilter");
            generalApis.put("Get api for remove log filter for user", "/imsv2/removeLogFilter/{user}");
            LinkedHashMap<String, String> modeApis = new LinkedHashMap<String, String>();
            if ("FEATUREIMS-SERVER".equals(mode)) {
                modeApis.put("Get api for stateMachine", "/app/v2/channel");
                modeApis.put("Get api for release stateMachine dialog by callId", "/app/v2/releaseDialog/{callId}");
                modeApis.put("Get api for callback map", "/app/v2/getCallback");
                modeApis.put("Get api to set callback (Default Audio)", "/app/v2/callBack/{from}/{to}");
                modeApis.put("Get api to set callback (Media Type)", "/app/v2/callBack/{from}/{to}/{mediaType}");
                modeApis.put("Get api for busy users map", "/app/v2/relations");
                modeApis.put("Get api for registration state", "/imsv2/registrationState");
                modeApis.put("Get api for registration state by extension", "/imsv2/registrationState/{extension}");
                modeApis.put("Get api for FSUUid list", "/imsv2/showuuid");
                modeApis.put("Post api for recovery sync", "/imsv2/recovery?status={status}&uuid={uuid}");
                modeApis.put("Get api for show recovery UUID list", "/imsv2/showrecoveryuuidlist");
                modeApis.put("Get api for profile name", "/imsv2/showprofilename");
                modeApis.put("Get api for profile by user", "/imsv2/showprofilename/{user}");
                modeApis.put("Get api for virtualIp by user", "/imsv2/virtualIp/{user}");
                modeApis.put("Get api for registration map", "/imsv2/showregistrations");
            } else if ("IMSV2-SERVER".equals(mode)) {
                modeApis.put("Get api for Channel", "/app/v2/channel");
                modeApis.put("Get api for state machine dialog release by callId", "/app/v2/releaseDialog/{callId}");
                modeApis.put("Get api for channel by callId", "/imsv2/dialogs/{callId}");
                modeApis.put("Get api for registration state", "/imsv2/registrationState");
                modeApis.put("Get api for registration state by extension", "/imsv2/registrationState/{extension}");
                modeApis.put("Get api for IMSV2 subscriptions", "/imsv2/v2Subscriptions");
                modeApis.put("Get api for subscription by extension", "/imsv2/v2Subscriptions/{extension}");
                modeApis.put("Get api for release BLF by callId", "/imsv2/releaseblf/{callId}");
                modeApis.put("Get api for registration map", "/imsv2/showregistrations");
                modeApis.put("Get api for channel by user extension", "/imsv2/dialogs/user/{user}");
            } else if ("SUBSCRIBER-SERVER".equals(mode)) {
                modeApis.put("Get api for subscription list", "/imsv2/subscriptions");
                modeApis.put("Get api for subscription by extension", "/imsv2/subscriptions/{extension}");
            }
            LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
            response.put("mode", mode);
            response.put("modeSpecificApis", modeApis);
            response.put("generalApis", generalApis);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            logger.error("Error while fetching dialogs: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.singletonMap("error", "Failed to fetch API list."));
        }
    }
}

