/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service;

import com.coraltele.condition.EnableFEATUREIMS_SERVER;
import com.coraltele.db.telephony.main.entity.Recovery;
import com.coraltele.db.telephony.main.repository.RecoveryRepository;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.ims.FeatureIMS;
import com.coraltele.ims.FeatureIMSStateMachine;
import com.coraltele.ims.HelperIMS;
import com.coraltele.model.CallbackObject;
import com.coraltele.model.RedisMessageWrapper;
import com.coraltele.service.FeatureIMSService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableFEATUREIMS_SERVER.class})
public class FeatureIMSService {
    String className = "FeatureIMSService";
    private static final Logger logger = LogManager.getLogger(FeatureIMSService.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final AtomicBoolean schedulerRunning = new AtomicBoolean(false);
    private volatile ScheduledFuture<?> redisSchedulerFuture;
    public HashSet<String> recoveryUuidList = new HashSet();
    ScheduledThreadPoolExecutor featureIMSServiceScheduler = new ScheduledThreadPoolExecutor(Constants.MAX_POOL_SIZE);
    BlockingQueue<Runnable> featureIMSServiceQueue = new LinkedBlockingQueue(100);
    ThreadPoolExecutor featureIMSServiceExecutor = new ThreadPoolExecutor(Constants.CORE_POOL_SIZE, Constants.MAX_POOL_SIZE, Constants.KEEP_ALIVE_TIME, Constants.THREAD_TIME_UNIT, this.featureIMSServiceQueue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    public static String SIPSERVER_PROFILENAME = "internal";
    public static String SIPSERVER_DOMAINNAME = Constants.LISTEN_IP_ADDRESS;
    public static String CURRENT_RLUCODENAME = null;
    @Autowired
    private FeatureIMS featureIMS;
    @Autowired
    private Optional<FeatureIMSStateMachine> featureIMSStateMachine;
    @Autowired
    private HelperIMS helperIMS;
    @Autowired
    private Optional<RecoveryRepository> recoveryRepository;
    @Autowired
    private ExtensionsRepository extensionsRepository;
    @Autowired
    @Qualifier(value="redisTemplate")
    private Optional<RedisTemplate<String, Object>> publishRedisTemplate;
    private static final String CALLBACKMAPKEY = "callbackMap";
    private static final String CALLBACKWITHTIMEKEY = "callbackWithTimeMap";
    @Value(value="${redis.recoveryAddHASyncChannel}")
    private String recoveryAddHASyncChannel;
    @Value(value="${redis.recoveryRemoveHASyncChannel}")
    private String recoveryRemoveHASyncChannel;
    @Value(value="${redis.registrationHASyncChannel}")
    private String registrationHASyncChannel;
    @Value(value="${redis.callbackHASyncChannel}")
    private String callbackHASyncChannel;
    @Value(value="${redis.callbackWithTimeAddHASyncChannel}")
    private String callbackWithTimeAddHASyncChannel;
    @Value(value="${redis.callbackWithTimeRemoveHASyncChannel}")
    private String callbackWithTimeRemoveHASyncChannel;
    @Value(value="${redis.subscriptionHASyncChannel}")
    private String subscriptionHASyncChannel;
    @Value(value="${redis.controlHASyncChannel}")
    private String controlHASyncChannel;

    public FeatureIMSService() {
        logger.info("Initialized featureIMSExecutor with core: {}, max: {}", (Object)Constants.CORE_POOL_SIZE, (Object)Constants.MAX_POOL_SIZE);
    }

    public void startRedisScheduler() {
        if (!this.schedulerRunning.compareAndSet(false, true)) {
            logger.info("Redis scheduler already running. Skipping restart.");
            return;
        }
        try {
            ScheduledFuture<?> future;
            if (Constants.REGISTRATION_SAVE_TIMER_IN_MINUTES <= 0) {
                logger.info("Scheduler not started because REGISTRATION_SAVE_TIMER_IN_MINUTES = 0");
                this.schedulerRunning.set(false);
                return;
            }
            this.redisSchedulerFuture = future = this.scheduler.scheduleAtFixedRate(() -> {
                try {
                    this.saveCallbackOnRedis();
                }
                catch (Exception e) {
                    logger.error("Error during saveCallbackOnRedis execution {}", (Throwable)e);
                }
            }, Constants.REGISTRATION_SAVE_TIMER_IN_MINUTES.intValue(), Constants.REGISTRATION_SAVE_TIMER_IN_MINUTES.intValue(), TimeUnit.MINUTES);
            logger.info("In startRedisScheduler method .Started redis scheduler for persistence.");
        }
        catch (Exception e) {
            this.schedulerRunning.set(false);
            this.redisSchedulerFuture = null;
            logger.error("Error starting Redis scheduler {}", (Throwable)e);
        }
    }

    public void stopSchedulerSaveAfterControlShift() {
        HelperIMS.controlIsHere.set(false);
        if (!this.schedulerRunning.compareAndSet(true, false)) {
            logger.info("Redis scheduler already stopped. Skipping restop.");
            return;
        }
        try {
            ScheduledFuture future = this.redisSchedulerFuture;
            if (future != null) {
                future.cancel(false);
            }
        }
        catch (Exception e) {
            logger.error("Error while stopping Redis scheduler in stopSchedulerSaveAfterControlShift  {}", (Throwable)e);
        }
        finally {
            this.redisSchedulerFuture = null;
            logger.info("In stopSchedulerSaveAfterControlShift method .Stopped redis scheduler for persistence.");
        }
    }

    public void stopSchedulerSave() {
        try {
            this.scheduler.shutdown();
            if (!this.scheduler.awaitTermination(30L, TimeUnit.SECONDS)) {
                logger.warn("Forcing scheduler shutdown...");
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        finally {
            this.schedulerRunning.set(false);
        }
    }

    public void saveCallbackOnRedis() {
        String functionName = "saveCallbackOnRedis";
        if (!this.featureIMSStateMachine.isPresent()) {
            return;
        }
        if (!this.isRedisConnectionUp("localRedisTemplate")) {
            logger.info("RedisConnection is down for saveCallbackOnRedis. Skipping save operation");
            return;
        }
        try {
            ConcurrentHashMap callbackMap = ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).mergeAllCallbackMaps();
            ConcurrentHashMap callbackWithTimeMap = ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getCallBackMap();
            ((RedisTemplate)this.publishRedisTemplate.get()).delete((Object)CALLBACKMAPKEY);
            ((RedisTemplate)this.publishRedisTemplate.get()).opsForValue().set((Object)CALLBACKMAPKEY, (Object)callbackMap);
            ((RedisTemplate)this.publishRedisTemplate.get()).delete((Object)CALLBACKWITHTIMEKEY);
            ((RedisTemplate)this.publishRedisTemplate.get()).opsForValue().set((Object)CALLBACKWITHTIMEKEY, (Object)callbackWithTimeMap);
            this.helperIMS.printCustomLogs(this.className, functionName, "info", null, null, "Saved callbackMap (" + callbackMap.size() + " entries) to Redis Database");
        }
        catch (Exception e) {
            logger.error("Error in saveCallbackOnRedis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void loadCallbackFromRedis() {
        if (!this.featureIMSStateMachine.isPresent()) {
            return;
        }
        if (!this.isRedisConnectionUp("localRedisTemplate")) {
            logger.warn("Redis connection down. Skipping callback load.");
            return;
        }
        try {
            Object result = ((RedisTemplate)this.publishRedisTemplate.get()).opsForValue().get((Object)CALLBACKMAPKEY);
            Object callbackWithTime = ((RedisTemplate)this.publishRedisTemplate.get()).opsForValue().get((Object)CALLBACKWITHTIMEKEY);
            if (result != null && result instanceof Map) {
                ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getBackwardcallbackMap().putAll((Map)result);
                logger.info("loaded callback entries from Redis into featureIMSStateMachine");
            } else {
                logger.warn("No callback found in Redis.");
            }
            if (callbackWithTime != null && callbackWithTime instanceof Map) {
                ((FeatureIMSStateMachine)this.featureIMSStateMachine.get()).getCallBackMap().putAll((Map)callbackWithTime);
                logger.info("loaded callbackWithTime entries from Redis into featureIMSStateMachine");
            } else {
                logger.warn("No callbackWithTime found in Redis.");
            }
        }
        catch (Exception e) {
            logger.error("Error loading callback and callbackWithTime from Redis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void publishCallbackOnRedis(String fromUser, String toUser, String mapType, String operation, String mediaType) {
        String functionName = "publishCallbackOnRedis";
        try {
            if (!this.isRedisConnectionUp()) {
                this.helperIMS.printCustomLogs(this.className, functionName, "warn", fromUser, toUser, "Redis connection is down. Skipping callback publish operation for user: " + fromUser + ":" + toUser);
                return;
            }
            CallbackUpdate update = new CallbackUpdate(fromUser, toUser, mapType, operation, mediaType);
            this.publishWrapped(this.callbackHASyncChannel, (Object)update);
            this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Extension: " + fromUser + ":" + toUser + " callback published on redis channel : " + this.callbackHASyncChannel + " data : " + fromUser + ":" + toUser + ":" + mapType + ":" + operation);
        }
        catch (Exception e) {
            logger.error("Error in publishCallbackOnRedis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void publishCallbackWithTimeOnRedis(String fromUser, String toUser, String mediaType, long epochTime, String operation) {
        String functionName = "publishCallbackWithTimeOnRedis";
        try {
            if (!this.isRedisConnectionUp()) {
                this.helperIMS.printCustomLogs(this.className, functionName, "warn", fromUser, toUser, "Redis connection is down. Skipping CallbackWithTime publish operation for user: " + fromUser + ":" + toUser);
                return;
            }
            CallbackObject updateObj = new CallbackObject(fromUser, toUser, mediaType, epochTime, this.helperIMS.getISTfromEpoch(Long.valueOf(epochTime), TimeUnit.MILLISECONDS));
            if ("add".equals(operation)) {
                this.publishWrapped(this.callbackWithTimeAddHASyncChannel, (Object)updateObj);
                this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Extension: " + fromUser + ":" + toUser + " callbackWithTime published on redis channel : " + this.callbackWithTimeAddHASyncChannel + " data : " + fromUser + ":" + toUser);
            } else {
                this.publishWrapped(this.callbackWithTimeRemoveHASyncChannel, (Object)updateObj);
                this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Extension: " + fromUser + ":" + toUser + " callbackWithTime published on redis channel : " + this.callbackWithTimeRemoveHASyncChannel + " data : " + fromUser + ":" + toUser);
            }
        }
        catch (Exception e) {
            logger.error("Error in publishCallbackWithTimeOnRedis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void publishRegistrationOnRedis(RegisterObject registerObject) {
        String functionName = "publishRegistrationOnRedis";
        try {
            if (!this.isRedisConnectionUp()) {
                if (this.helperIMS.isValidLogUser(registerObject.getSipUser())) {
                    logger.warn("Redis Connection is down. Skipping  publish in publishRegistrationOnRedis method for{}", (Object)registerObject.getSipUser());
                }
                return;
            }
            this.publishWrapped(this.registrationHASyncChannel, (Object)registerObject);
            if (this.helperIMS.isValidLogUser(registerObject.getSipUser())) {
                logger.info("registerObject published on redis channel : " + this.registrationHASyncChannel + " data : " + registerObject.getSipUser() + ":" + registerObject.getCallId());
            }
        }
        catch (Exception e) {
            logger.error("Error in publishRegistrationOnRedis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void publishSubscriptionOnRedis(SubscribeObject subscribeObject) {
        String functionName = "publishSubscriptionOnRedis";
        if (!this.isRedisConnectionUp()) {
            if (this.helperIMS.isValidLogUser(subscribeObject.getSipUser())) {
                logger.warn("Redis Connection is down. Skipping  publish in publishSubscriptionOnRedis method for user {}", (Object)subscribeObject.getSipUser());
            }
            return;
        }
        try {
            this.publishWrapped(this.subscriptionHASyncChannel, (Object)subscribeObject);
            if (this.helperIMS.isValidLogUser(subscribeObject.getSipUser())) {
                logger.info("subscribeObject published on redis channel : " + this.subscriptionHASyncChannel + " data  : " + subscribeObject.getSipUser() + ":" + subscribeObject.getSubToUser() + ":" + subscribeObject.getCallId());
            }
        }
        catch (Exception e) {
            logger.error("Error in publishSubscriptionOnRedis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void publishToRemoveRecoveryData(String uuid) {
        String functionName = "publishToRemoveRecoveryData";
        if (!this.isRedisConnectionUp()) {
            logger.warn("Redis Connection is down. Skipping  publish to remove operation in publishToRemoveRecoveryData method for uuid {}", (Object)uuid);
            return;
        }
        try {
            this.publishWrapped(this.recoveryRemoveHASyncChannel, (Object)uuid);
            logger.debug("uuid {} published on redis channel to remove for recoverysync ", (Object)uuid);
        }
        catch (Exception e) {
            logger.error("Error in publishToRemoveRecoveryData: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void fetchAndPublishRecoveryData(String uuid) {
        if (!this.isDatabaseConnected()) {
            logger.warn("Database connection is down. Skipping fetch operation in fetchAndPublishRecoveryData Method for uuid {}", (Object)uuid);
            return;
        }
        if (!this.isRedisConnectionUp()) {
            logger.warn("Redis Connection is down. Skipping publish operation in fetchAndPublishRecoveryData method for uuid {}", (Object)uuid);
            return;
        }
        logger.debug("Received uuid {} : {} in fetchAndPublishRecoveryData method", (Object)"INVITE", (Object)uuid);
        Recovery recoveryData = this.fetchRecoveryDataByUuid(uuid);
        if (recoveryData != null) {
            this.publishRecoveryDataToRedis(recoveryData);
        }
    }

    private Recovery fetchRecoveryDataByUuid(String uuid) {
        try {
            Optional optionalRecovery = ((RecoveryRepository)this.recoveryRepository.get()).findByUuid(uuid);
            if (optionalRecovery.isPresent()) {
                logger.debug("Fetched Recovery data for UUID {}", (Object)uuid);
                return (Recovery)optionalRecovery.get();
            }
            logger.info("No Recovery record found for UUID: {}", (Object)uuid);
        }
        catch (Exception e) {
            logger.error("Error while fetching Recovery data for UUID {}: {}", (Object)uuid, (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private void publishRecoveryDataToRedis(Recovery recoveryData) {
        try {
            this.publishWrapped(this.recoveryAddHASyncChannel, (Object)recoveryData);
            logger.debug("For RecoverySync uuid " + recoveryData.getUuid() + " published on redis channel : " + this.recoveryAddHASyncChannel);
        }
        catch (Exception e) {
            logger.error("Error in publishRecoveryDataToRedis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public List<Object> getPhoneExtensionData(String search) {
        LinkedHashMap phonesMap = new LinkedHashMap();
        ConcurrentHashMap phoneExtensionMap = this.helperIMS.getExtensionMap();
        ConcurrentHashMap multiPhoneRegisterMap = this.featureIMS.userRegisterMap;
        int registered = 0;
        int unregistered = 0;
        for (Map.Entry entry : phoneExtensionMap.entrySet()) {
            List data;
            String extension = (String)entry.getKey();
            if (search != null && !extension.contains(search) || (data = (List)entry.getValue()).size() <= 3 || !"phone".equalsIgnoreCase((String)data.get(3))) continue;
            ConcurrentHashMap registrations = (ConcurrentHashMap)multiPhoneRegisterMap.get(extension);
            LinkedHashMap<String, PhoneExtensionDTO> registrationMap = new LinkedHashMap<String, PhoneExtensionDTO>();
            if (registrations != null && !registrations.isEmpty()) {
                for (Map.Entry regEntry : registrations.entrySet()) {
                    String callId = (String)regEntry.getKey();
                    RegisterObject user = (RegisterObject)regEntry.getValue();
                    PhoneExtensionDTO dto = new PhoneExtensionDTO(this);
                    dto.setExtension(extension);
                    dto.setRemoteIpAddress(user.getContact());
                    dto.setExpireToken(user.getExpireHeaderInSeconds());
                    dto.setLastRegisterTime(user.getRegisterDateTime());
                    dto.setExpiresAt(user.getExpireAtDateTime());
                    dto.setRegisterIp(user.getDomainName());
                    dto.setRegisterTransport(user.getNetworkTransport());
                    String status = user.getExpireHeaderInSeconds() == 0L || System.currentTimeMillis() >= user.getExpireAtInSecondsEpoch() * 1000L ? "unregistered" : "registered";
                    dto.setStatus(status);
                    if ("registered".equals(status)) {
                        ++registered;
                    } else {
                        ++unregistered;
                    }
                    registrationMap.put(callId, dto);
                }
            } else {
                PhoneExtensionDTO dto = new PhoneExtensionDTO(this);
                dto.setExtension(extension);
                dto.setStatus("unregistered");
                ++unregistered;
                registrationMap.put("", dto);
            }
            phonesMap.put(extension, registrationMap);
        }
        LinkedHashMap<String, Integer> summary = new LinkedHashMap<String, Integer>();
        summary.put("totalPhones", phonesMap.size());
        summary.put("registeredPhones", registered);
        summary.put("unregisteredPhones", unregistered);
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(summary);
        result.add(phonesMap);
        return result;
    }

    private boolean isDatabaseConnected() {
        try {
            if (this.recoveryRepository.isPresent()) {
                ((RecoveryRepository)this.recoveryRepository.get()).count();
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean isRedisConnectionUp() {
        try {
            if (!this.publishRedisTemplate.isPresent()) {
                return false;
            }
            RedisTemplate template = (RedisTemplate)this.publishRedisTemplate.get();
            RedisConnectionFactory connectionFactory = template.getConnectionFactory();
            if (connectionFactory == null) {
                return false;
            }
            try (RedisConnection connection = connectionFactory.getConnection();){
                connection.ping();
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isRedisConnectionUp(String templateName) {
        try {
            if (!this.publishRedisTemplate.isPresent()) {
                return false;
            }
            RedisTemplate template = (RedisTemplate)this.publishRedisTemplate.get();
            RedisConnectionFactory connectionFactory = template.getConnectionFactory();
            return connectionFactory != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public RegisterObject makeRegisterObject(String callId, String sipUser, String contactWithPath, String networkIp, String networkPort, String transport, int expire, String domainName, String contact) {
        Long currentEpochSeconds = System.currentTimeMillis() / 1000L;
        RegisterObject registerObject = new RegisterObject();
        registerObject.setCallId(callId != null ? callId : "");
        registerObject.setSipUser(sipUser != null ? sipUser : "");
        registerObject.setNetworkIp(networkIp != null ? networkIp : "0.0.0.0");
        registerObject.setNetworkPort(networkPort);
        registerObject.setNetworkTransport(transport);
        registerObject.setContactWithPath(contactWithPath);
        registerObject.setContact(contact);
        registerObject.setExpireHeaderInSeconds(Long.valueOf(expire));
        registerObject.setRegisterTimeInSecondsEpoch(currentEpochSeconds);
        if (expire != 0) {
            registerObject.setRegisterDateTime(this.helperIMS.getISTfromEpoch(currentEpochSeconds, TimeUnit.SECONDS));
        }
        registerObject.setExpireAtInSecondsEpoch(Long.valueOf(currentEpochSeconds + (long)expire));
        registerObject.setExpireAtDateTime(this.helperIMS.getISTfromEpoch(registerObject.getExpireAtInSecondsEpoch(), TimeUnit.SECONDS));
        registerObject.setUserAgent(Constants.USER_AGENT);
        registerObject.setDomainName(domainName);
        registerObject.setSipServerDomainName(SIPSERVER_DOMAINNAME);
        registerObject.setSipServerProfileName(SIPSERVER_PROFILENAME);
        return registerObject;
    }

    public SubscribeObject makeSubscribeObject(String sipUser, String subToUser, String event, String contactwithPath, String callId, String fromHeader, String viaHeader, int expire, String userAgent, String accept, String networkIp, String networkPort, String fullTo, String domainName, String actualContact) {
        Long currentEpochSeconds = System.currentTimeMillis() / 1000L;
        SubscribeObject subscribeObject = new SubscribeObject();
        subscribeObject.setSipUser(sipUser != null ? sipUser : "");
        subscribeObject.setSubToUser(subToUser != null ? subToUser : "");
        subscribeObject.setEvent(event != null ? event : "");
        subscribeObject.setContactWithPath(contactwithPath != null ? contactwithPath : "");
        subscribeObject.setContact(actualContact);
        subscribeObject.setCallId(callId != null ? callId : "");
        subscribeObject.setFullFrom(fromHeader != null ? fromHeader : "");
        subscribeObject.setFullVia(viaHeader != null ? viaHeader : "");
        subscribeObject.setExpireHeaderInSeconds(Long.valueOf(expire));
        subscribeObject.setRegisterTimeInSecondsEpoch(currentEpochSeconds);
        subscribeObject.setRegisterDateTime(this.helperIMS.getISTfromEpoch(currentEpochSeconds, TimeUnit.SECONDS));
        subscribeObject.setExpireAtInSecondsEpoch(Long.valueOf(currentEpochSeconds + (long)expire));
        subscribeObject.setExpireAtDateTime(this.helperIMS.getISTfromEpoch(subscribeObject.getExpireAtInSecondsEpoch(), TimeUnit.SECONDS));
        subscribeObject.setUserAgent(userAgent != null ? userAgent : "");
        subscribeObject.setAccept(accept != null ? accept : "");
        subscribeObject.setNetworkIp(networkIp != null ? networkIp : "");
        subscribeObject.setNetworkPort(networkPort != null ? networkPort : "");
        subscribeObject.setFullTo(fullTo);
        subscribeObject.setDomainName(domainName);
        subscribeObject.setSipServerDomainName(SIPSERVER_DOMAINNAME);
        subscribeObject.setSipServerProfileName(SIPSERVER_PROFILENAME);
        return subscribeObject;
    }

    public Map<String, String> getCallUuidMap() {
        return this.featureIMS.getCallUuidMap();
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<String, RegisterObject>> getRegisterMap() {
        return this.featureIMS.getUserRegisterMap();
    }

    public void addUser_in_UserRegisterMap(RegisterObject registerObject) {
        try {
            String callId = registerObject.getCallId();
            String user = registerObject.getSipUser();
            this.featureIMS.insertOrUpdateinUserRegisterMap(user, callId, registerObject);
        }
        catch (Exception e) {
            logger.error("Error while adding/updating user {} in UserRegisterMap of FeatureIMS in addUser_in_UserRegisterMap method {}", (Object)registerObject.getCallId(), (Object)e);
        }
    }

    public void removeUser_from_UserRegisterMap(RegisterObject registerObject) {
        try {
            String callId = registerObject.getCallId();
            String user = registerObject.getSipUser();
            this.featureIMS.removeFromUserRegisterMap(user, callId);
        }
        catch (Exception e) {
            logger.error("Error while removing user {} in UserRegisterMap of FeatureIMS in removeUser_from_UserRegisterMap method {}", (Object)registerObject.getCallId(), (Object)e);
        }
    }

    public void setSipServerProfileName() {
        block4: {
            block5: {
                if (!Constants.DEBIAN_VERSION.equals("10") && !Constants.DEBIAN_VERSION.equals("12")) break block5;
                if (this.helperIMS.getRluMap() == null || this.helperIMS.getRluMap().size() <= 1) {
                    SIPSERVER_PROFILENAME = "internal";
                    SIPSERVER_DOMAINNAME = Constants.LISTEN_IP_ADDRESS;
                    CURRENT_RLUCODENAME = null;
                    return;
                }
                ConcurrentHashMap rluMap = this.helperIMS.getRluMap();
                for (Map.Entry entry : rluMap.entrySet()) {
                    boolean ctrlWithCurrentServer;
                    String key = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    if (values.size() <= 1 || !(values.get(1) instanceof Boolean) || !(ctrlWithCurrentServer = ((Boolean)values.get(1)).booleanValue())) continue;
                    CURRENT_RLUCODENAME = key;
                    SIPSERVER_PROFILENAME = "internal_" + CURRENT_RLUCODENAME;
                    break block4;
                }
                break block4;
            }
            if (!Constants.DEBIAN_VERSION.equalsIgnoreCase("9")) break block4;
            SIPSERVER_PROFILENAME = "main";
            if (this.helperIMS.getRluMap() == null || this.helperIMS.getRluMap().size() <= 1) {
                SIPSERVER_PROFILENAME = "main";
                SIPSERVER_DOMAINNAME = Constants.LISTEN_IP_ADDRESS;
                CURRENT_RLUCODENAME = null;
                return;
            }
            ConcurrentHashMap rluMap = this.helperIMS.getRluMap();
            for (Map.Entry entry : rluMap.entrySet()) {
                boolean ctrlWithCurrentServer;
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                if (values.size() <= 1 || !(values.get(1) instanceof Boolean) || !(ctrlWithCurrentServer = ((Boolean)values.get(1)).booleanValue())) continue;
                SIPSERVER_PROFILENAME = CURRENT_RLUCODENAME = key;
                break;
            }
        }
    }

    public String getSipServerProfileName(String user) {
        return SIPSERVER_PROFILENAME;
    }

    public String getVirtualIP(String user) {
        return this.helperIMS.getVirtualIP(user);
    }

    public void syncRecovery(String status, String uuid) {
        try {
            if (uuid == null || uuid.length() <= 0) {
                logger.info("Uuid is null or Empty. Skipping sync Operation");
                return;
            }
            if (status == null || status.equalsIgnoreCase("bye")) {
                this.featureIMSServiceScheduler.schedule(() -> {
                    this.recoveryUuidList.remove(uuid);
                    this.publishToRemoveRecoveryData(uuid);
                }, (long)Constants.THREADDELAY_RECOVERYSYNC_MILLISECONDS.intValue(), TimeUnit.MILLISECONDS);
            } else if (status.equalsIgnoreCase("answer")) {
                this.featureIMSServiceScheduler.schedule(() -> {
                    this.recoveryUuidList.add(uuid);
                    this.fetchAndPublishRecoveryData(uuid);
                }, (long)Constants.THREADDELAY_RECOVERYSYNC_MILLISECONDS.intValue(), TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            logger.error("Error in syncRecovery method {} ", (Throwable)e);
        }
    }

    public void setSgwUserOn(String extension, Long expireTime) {
        String functionName = "setSqwUserOn";
        try {
            if (!this.isDatabaseConnected2()) {
                this.helperIMS.printCustomLogs(this.className, functionName, "warn", extension, extension, "Database connection is down. Skipping setsgwUser OFF operation for extension: " + extension);
                return;
            }
            if (expireTime <= 0L) {
                this.helperIMS.printCustomLogs(this.className, functionName, "info", extension, extension, "Due to expireTime is 0 .Skipping setsgwUser ON operation for extension: " + extension);
                return;
            }
            Optional optionalExtension = this.extensionsRepository.findByExtension(extension);
            if (optionalExtension.isPresent()) {
                Extension extensionEntity = (Extension)optionalExtension.get();
                extensionEntity.setSgwUser(Boolean.valueOf(true));
                this.extensionsRepository.save((Object)extensionEntity);
                this.helperIMS.printCustomLogs(this.className, functionName, "info", extension, extension, "Set SgwUser column to true for extension: " + extension + " in database");
            } else {
                this.helperIMS.printCustomLogs(this.className, functionName, "warn", extension, extension, "Extension:" + extension + " not found in table. Skipping setsgwUser ON operation.");
            }
        }
        catch (Exception e) {
            logger.error("Error while setting sgwuser On in database of extension {} -{} {}", (Object)extension, (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean isDatabaseConnected2() {
        try {
            this.extensionsRepository.count();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void processCallbackOperation(CallbackUpdate update) {
        String functionName = "processCallbackOperation";
        try {
            ConcurrentHashMap map;
            String fromUser = update.getFromUser();
            String toUser = update.getToUser();
            String mapType = update.getMapType();
            String operation = update.getOperation();
            String mediaType = update.getMediaType();
            FeatureIMSStateMachine stateMachine = (FeatureIMSStateMachine)this.featureIMSStateMachine.get();
            if (stateMachine == null) {
                logger.warn("FeatureIMSStateMachine not initialized. Skipping callback processing for {} -> {}", (Object)fromUser, (Object)toUser);
                return;
            }
            if ("backward".equalsIgnoreCase(mapType)) {
                map = stateMachine.getBackwardcallbackMap();
            } else if ("forward".equalsIgnoreCase(mapType)) {
                map = stateMachine.getForwardcallbackMap();
            } else {
                logger.warn("Unknown mapType '{}' received for callback. Skipping.", (Object)mapType);
                return;
            }
            map.compute(toUser, (key, deque) -> {
                if (deque == null) {
                    deque = new ConcurrentLinkedDeque<String>();
                }
                if ("add".equalsIgnoreCase(operation)) {
                    if (!deque.contains(fromUser)) {
                        deque.add(fromUser);
                        if (!mediaType.isEmpty()) {
                            stateMachine.getMediaTypeMap().put(fromUser + ":" + toUser, mediaType);
                        }
                        this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Added callback between " + fromUser + " & " + toUser + " in " + mapType + mediaType);
                    }
                } else if ("remove".equalsIgnoreCase(operation)) {
                    boolean removed = deque.remove(fromUser);
                    if (removed) {
                        stateMachine.getMediaTypeMap().remove(fromUser + ":" + toUser);
                        this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Removed callback from " + fromUser + " & " + toUser + " in " + mapType);
                    }
                    if (deque.isEmpty()) {
                        return null;
                    }
                } else {
                    logger.warn("Unknown operation '{}' for {} -> {}", (Object)operation, (Object)toUser, (Object)fromUser);
                }
                return deque;
            });
        }
        catch (Exception e) {
            logger.error("Error in processCallbackOperation: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void processCallbackWithTimeOperation(CallbackObject updateObj, String opt) {
        String functionName = "processCallbackWithTimeOperation";
        try {
            String fromUser = updateObj.getFromUser();
            String toUser = updateObj.getToUser();
            FeatureIMSStateMachine stateMachine = (FeatureIMSStateMachine)this.featureIMSStateMachine.get();
            if (stateMachine == null) {
                logger.warn("FeatureIMSStateMachine not initialized. Skipping callbackWithTime processing for {} -> {}", (Object)fromUser, (Object)toUser);
                return;
            }
            ConcurrentHashMap map = stateMachine.getCallBackMap();
            if (map == null) {
                logger.warn("Callback map is null. Skipping operation for {} -> {}", (Object)fromUser, (Object)toUser);
                return;
            }
            if ("add".equalsIgnoreCase(opt)) {
                ConcurrentSkipListSet skipList = map.computeIfAbsent(toUser, k -> new ConcurrentSkipListSet());
                skipList.removeIf(cb -> cb.getFromUser().equals(fromUser));
                skipList.add(updateObj);
                this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Added callbackWithTime between " + fromUser + " & " + toUser + " at: " + updateObj.getScheduledAt());
            } else {
                map.computeIfPresent(toUser, (key, set) -> {
                    set.removeIf(cb -> cb.getFromUser().equals(fromUser) && cb.getToUser().equals(toUser) || cb.getFromUser().equals(toUser) && cb.getToUser().equals(fromUser));
                    return set.isEmpty() ? null : set;
                });
                map.computeIfPresent(fromUser, (key, set) -> {
                    set.removeIf(cb -> cb.getFromUser().equals(fromUser) && cb.getToUser().equals(toUser) || cb.getFromUser().equals(toUser) && cb.getToUser().equals(fromUser));
                    return set.isEmpty() ? null : set;
                });
                this.helperIMS.printCustomLogs(this.className, functionName, "info", fromUser, toUser, "Removed callbackWithTime between " + fromUser + " & " + toUser);
            }
        }
        catch (Exception e) {
            logger.error("Error in processCallbackWithTimeOperation: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void publishControlShiftOnRedis() {
        String functionName = "publishControlShiftOnRedis";
        try {
            if (!this.isRedisConnectionUp()) {
                this.helperIMS.printCustomLogs(this.className, functionName, "warn", null, null, "Redis connection is down. Skipping control message publish operation.");
                return;
            }
            this.publishWrapped(this.controlHASyncChannel, (Object)Constants.HOSTNAME);
            this.helperIMS.printCustomLogs(this.className, functionName, "info", null, null, "ControlShift message published on redis channel : " + this.controlHASyncChannel + " data : " + Constants.HOSTNAME);
        }
        catch (Exception e) {
            logger.error("Error in publishControlShiftOnRedis: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private <T> void publishWrapped(String channel, T payload) {
        try {
            RedisMessageWrapper wrapper = new RedisMessageWrapper(payload, Constants.HOSTNAME);
            ((RedisTemplate)this.publishRedisTemplate.get()).convertAndSend(channel, (Object)wrapper);
        }
        catch (Exception e) {
            logger.error("Error publishing wrapped message to {}: {}", (Object)channel, (Object)e.getMessage(), (Object)e);
        }
    }
}

