/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service;

import com.coraltele.condition.EnableBackgroundTaskClass;
import com.coraltele.helper.Constants;
import com.coraltele.ims.HelperIMS;
import com.coraltele.ims.V2StateMachine;
import com.coraltele.interfaces.sip.ClientTransaction;
import com.coraltele.interfaces.sip.Dialog;
import com.coraltele.interfaces.sip.DialogState;
import com.coraltele.interfaces.sip.address.SipURI;
import com.coraltele.interfaces.sip.header.RouteHeader;
import com.coraltele.interfaces.sip.message.Request;
import com.coraltele.javax.sip.SipStackImpl;
import com.coraltele.javax.sip.stack.SIPDialog;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableBackgroundTaskClass.class})
public class BackgroundTaskService {
    private static final Logger logger = LogManager.getLogger(BackgroundTaskService.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    public final Map<String, Boolean> dialogResponseMap = new ConcurrentHashMap();
    @Autowired
    HelperIMS helperIMS;
    @Autowired
    private Optional<V2StateMachine> v2StateMachine;

    public void startLivenessScheduler() {
        try {
            if (Constants.BACKGROUND_TASK_TIMER_IN_MINUTES > 0) {
                this.scheduler.scheduleAtFixedRate(() -> {
                    try {
                        this.livenessInfo();
                    }
                    catch (Exception e) {
                        logger.error("Error during liveness check in startLivenessScheduler method: {}", (Object)e.getMessage(), (Object)e);
                    }
                }, Constants.BACKGROUND_TASK_TIMER_IN_MINUTES.intValue(), Constants.BACKGROUND_TASK_TIMER_IN_MINUTES.intValue(), TimeUnit.MINUTES);
            } else {
                logger.info("Scheduler will not start because BACKGROUND_TASK_TIMER_IN_MINUTES is set to 0.");
            }
        }
        catch (Exception e) {
            logger.error("Error in startLivenessScheduler method {}", (Throwable)e);
        }
    }

    private void livenessInfo() {
        try {
            Collection dialogCollection;
            SipStackImpl sipStackImpl = (SipStackImpl)this.helperIMS.getSipStack();
            Collection collection = dialogCollection = sipStackImpl != null ? sipStackImpl.getDialogs() : null;
            if (dialogCollection == null || dialogCollection.isEmpty()) {
                logger.info("No active dialogs found for liveness check in livenessInfo method.");
                return;
            }
            for (Dialog dialog : dialogCollection) {
                try {
                    SipURI uri;
                    if (dialog.getState() == DialogState.TERMINATED || dialog.getState() == DialogState.EARLY && dialog.getDialogId() == null) {
                        return;
                    }
                    String dialogId = dialog.getDialogId();
                    this.dialogResponseMap.put(dialogId, false);
                    Request updateRequest = dialog.createRequest("UPDATE");
                    updateRequest.removeHeader("Contact");
                    dialog.incrementLocalSequenceNumber();
                    RouteHeader routeHeader = (RouteHeader)updateRequest.getHeader("Route");
                    if (routeHeader != null && (uri = (SipURI)routeHeader.getAddress().getURI()).getHost().equalsIgnoreCase(Constants.LISTEN_IP_ADDRESS)) {
                        updateRequest.removeFirst("Route");
                    }
                    ClientTransaction ct = this.helperIMS.getSipProvider().getNewClientTransaction(updateRequest);
                    ct.setApplicationData((Object)dialog);
                    dialog.sendRequest(ct);
                    logger.info("In livenessInfo method sent UPDATE request for dialog with Dialog-ID: {}", (Object)dialogId);
                    this.scheduler.schedule(() -> this.checkResponse(dialogId), (long)(Constants.BACKGROUND_TASK_TIMER_IN_MINUTES * 60 - 30), TimeUnit.SECONDS);
                }
                catch (Exception ex) {
                    logger.error("In livenessInfo method error sending UPDATE for dialog: {}", (Object)dialog.getDialogId(), (Object)ex);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in livenessInfo method: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void checkResponse(String dialogId) {
        Boolean isAlive = (Boolean)this.dialogResponseMap.get(dialogId);
        SipStackImpl sipStackImpl = (SipStackImpl)this.helperIMS.getSipStack();
        Boolean dialogPresent = sipStackImpl.getDialog(dialogId) != null;
        logger.info("CheckResponse Method is executed for Dialog-ID: : {} and isAlive: {}", (Object)dialogId, (Object)isAlive);
        if (isAlive != null && !isAlive.booleanValue() && dialogPresent.booleanValue()) {
            try {
                if ((Constants.IMS_MODE.equals("IMSV2-SERVER") || Constants.IMS_MODE.equals("IMSV2-SBC")) && this.v2StateMachine.get() != null) {
                    ((V2StateMachine)this.v2StateMachine.get()).releaseDialog(sipStackImpl.getDialog(dialogId).getCallId().getCallId());
                }
                this.releaseAssociatedDialog(dialogId);
                this.dialogResponseMap.remove(dialogId);
                sipStackImpl.getDialog(dialogId).delete();
                logger.info("In checkResponse Method releasing Dialog for Dialog-ID: {}", (Object)dialogId);
            }
            catch (Exception e) {
                logger.error("In checkResponse Method Error while Releasing Dialog for Dialog-ID: {} \r\n {}", (Object)dialogId, (Object)e);
            }
        }
    }

    public void releaseAssociatedDialog(String dialogId) {
        try {
            SIPDialog newDialog;
            SipStackImpl sipStackImpl = (SipStackImpl)this.helperIMS.getSipStack();
            String newDialogId = this.swapDialogId(dialogId);
            SIPDialog sIPDialog = newDialog = newDialogId != null && sipStackImpl.getDialog(newDialogId) != null ? sipStackImpl.getDialog(newDialogId) : null;
            if (newDialog != null && newDialog.getState() != DialogState.TERMINATED) {
                SipURI uri;
                Request byeRequest = newDialog.createRequest("BYE");
                RouteHeader routeHeader = (RouteHeader)byeRequest.getHeader("Route");
                if (routeHeader != null && (uri = (SipURI)routeHeader.getAddress().getURI()).getHost().equalsIgnoreCase(Constants.LISTEN_IP_ADDRESS)) {
                    byeRequest.removeFirst("Route");
                }
                logger.info("In releaseAssociatedDialog method Send byeRequest {}", (Object)byeRequest.toString());
                newDialog.sendRequest(this.helperIMS.getSipProvider().getNewClientTransaction(byeRequest));
            }
        }
        catch (Exception e) {
            logger.error("Error while handling releaseAssociatedDialog method for dialog-ID: {} , \r\n {}", (Object)dialogId, (Object)e.getMessage(), (Object)e);
        }
    }

    public void shutdownScheduler() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                logger.warn("Forcing ScheduledExecutorService shutdown...");
                this.scheduler.shutdownNow();
            }
        }
        catch (Exception e) {
            logger.error("Error while shutting down ScheduledExecutorService: {}", (Object)e.getMessage(), (Object)e);
            this.scheduler.shutdownNow();
        }
    }

    private String swapDialogId(String dialogId) {
        String newDialogId = null;
        try {
            if (dialogId == null || dialogId.isEmpty()) {
                return newDialogId;
            }
            String[] parts = dialogId.split(":");
            if (parts.length == 3) {
                newDialogId = parts[0] + ":" + parts[2] + ":" + parts[1];
            }
        }
        catch (Exception e) {
            logger.error("Error in swapDialogId method : {}", (Object)e.getMessage(), (Object)e);
        }
        return newDialogId;
    }
}

